/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbLog;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbParser;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbReaderOptions;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.pdb.PdbLocator;
import ghidra.app.util.pdb.PdbProgramAttributes;
import ghidra.app.util.pdb.pdbapplicator.ObjectOrientedClassLayout;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicatorOptions;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicatorRestrictions;
import ghidra.framework.Application;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.Options;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class PdbUniversalAnalyzer
extends AbstractAnalyzer {
    private static final boolean developerMode = false;
    static final String NAME = "PDB Universal";
    static final boolean DEFAULT_ENABLEMENT = true;
    private static final String DESCRIPTION = "Platform-independent PDB analyzer (No XML support).\nNOTE: still undergoing development, so options may change.";
    private static final String OPTION_NAME_DO_FORCELOAD = "Do Force-Load";
    private static final String OPTION_DESCRIPTION_DO_FORCELOAD = "If checked, uses the 'Force Load' file without validation.";
    private boolean doForceLoad = false;
    private static final String OPTION_NAME_FORCELOAD_FILE = "Force-Load FilePath";
    private static final String OPTION_DESCRIPTION_FORCELOAD_FILE = "This file is force-loaded if the 'Do Force-Load' option is checked";
    private File DEFAULT_FORCE_LOAD_FILE = new File(PdbLocator.DEFAULT_SYMBOLS_DIR, "sample.pdb");
    private File forceLoadFile;
    private static final String OPTION_NAME_SYMBOLPATH = "Symbol Repository Path";
    private static final String OPTION_DESCRIPTION_SYMBOLPATH = "Directory path to root of Microsoft Symbol Repository Directory";
    private File symbolsRepositoryDir;
    private static final String OPTION_NAME_INCLUDE_PE_PDB_PATH = "Unsafe: Include PE PDB Path in PDB Search";
    private static final String OPTION_DESCRIPTION_INCLUDE_PE_PDB_PATH = "If checked, specifically searching for PDB in PE-Header-Specified Location.";
    private boolean includePeSpecifiedPdbPath = false;
    private static final String OPTION_NAME_PDB_READER_ANALYZER_LOGGING = "[PDB Reader/Analyzer Debug Logging]";
    private static final String OPTION_DESCRIPTION_PDB_READER_ANALYZER_LOGGING = "If checked, logs information to the pdb.analyzer.log file for debug/development.";
    private boolean pdbLogging = false;
    private static final String OPTION_NAME_ONE_BYTE_CHARSET_NAME = "PDB One-Byte Charset Name";
    private static final String OPTION_DESCRIPTION_ONE_BYTE_CHARSET_NAME = "Charset used for processing of one-byte (or multi) encoded Strings: " + PdbReaderOptions.getOneByteCharsetNames();
    private String oneByteCharsetName = "UTF-8";
    private static final String OPTION_NAME_WCHAR_CHARSET_NAME = "PDB Wchar_t Charset Name";
    private static final String OPTION_DESCRIPTION_WCHAR_CHARSET_NAME = "Charset used for processing of wchar_t encoded Strings: " + PdbReaderOptions.getTwoByteCharsetNames();
    private String wideCharCharsetName = "UTF-16";
    private static final String OPTION_NAME_PROCESSING_RESTRICTIONS = "Processing Restrictions";
    private static final String OPTION_DESCRIPTION_PROCESSING_RESTRICTIONS = "Restrictions on applicator processing.";
    private static PdbApplicatorRestrictions restrictions;
    private static final String OPTION_NAME_APPLY_CODE_SCOPE_BLOCK_COMMENTS = "Apply Code Scope Block Comments";
    private static final String OPTION_DESCRIPTION_APPLY_CODE_SCOPE_BLOCK_COMMENTS = "If checked, pre/post-comments will be applied when code scope blocks are specified.";
    private boolean applyCodeScopeBlockComments;
    private static final String OPTION_NAME_APPLY_INSTRUCTION_LABELS = "Apply Instruction Labels";
    private static final String OPTION_DESCRIPTION_APPLY_INSTRUCTION_LABELS = "If checked, labels associated with instructions will be applied.";
    private boolean applyInstructionLabels;
    private static final String OPTION_NAME_ADDRESS_REMAP = "Address Remap Using Existing Symbols";
    private static final String OPTION_DESCRIPTION_ADDRESS_REMAP = "If checked, attempts to remap address to those matching existing public symbols.";
    private boolean remapAddressUsingExistingPublicMangledSymbols;
    private static final String OPTION_NAME_ALLOW_DEMOTE_MANGLED_PRIMARY = "Allow demote mangled symbol from primary";
    private static final String OPTION_DESCRIPTION_ALLOW_DEMOTE_MANGLED_PRIMARY = "If checked, allows a mangled symbol to be demoted from primary if a possibly better data type can be laid down with a nonmangled symbol.";
    private boolean allowDemotePrimaryMangledSymbol;
    private static final String OPTION_NAME_APPLY_FUNCTION_VARIABLES = "Apply Function Variables";
    private static final String OPTION_DESCRIPTION_APPLY_FUNCTION_VARIABLES = "If checked, attempts to apply function parameters and local variables for program functions.";
    private boolean applyFunctionVariables;
    private static final String OPTION_NAME_COMPOSITE_LAYOUT = "Composite Layout Choice";
    private static final String OPTION_DESCRIPTION_COMPOSITE_LAYOUT = "Legacy layout like original PDB Analyzer. Warning: other choices have no compatibility guarantee with future Ghidra releases or minor PDB Analyzer changes";
    private ObjectOrientedClassLayout compositeLayout;
    private PdbReaderOptions pdbReaderOptions;
    private PdbApplicatorOptions pdbApplicatorOptions;
    private long lastTransactionId = -1L;

    public PdbUniversalAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setDefaultEnablement(true);
        this.setPriority(AnalysisPriority.FORMAT_ANALYSIS.after());
        this.setSupportsOneTimeAnalysis();
        this.pdbReaderOptions = new PdbReaderOptions();
        this.pdbApplicatorOptions = new PdbApplicatorOptions();
    }

    static boolean isEnabled(Program program) {
        Options analysisOptions = program.getOptions("Analyzers");
        return analysisOptions.getBoolean(NAME, true);
    }

    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        String pdbFilename;
        long txId = program.getCurrentTransaction().getID();
        if (txId == this.lastTransactionId) {
            return false;
        }
        this.lastTransactionId = txId;
        if (!set.contains((AddressSetView)program.getMemory())) {
            return false;
        }
        PdbProgramAttributes programAttributes = new PdbProgramAttributes(program);
        if (programAttributes.isPdbLoaded()) {
            Msg.info((Object)((Object)this), (Object)"Skipping PDB analysis since it has previouslu run.");
            Msg.info((Object)((Object)this), (Object)">> Clear 'PDB Loaded' program property or use Load PDB action if additional PDB processing required.");
            return true;
        }
        if (this.failMissingFilename(programAttributes, log) || this.failMissingAttributes(programAttributes, log)) {
            return true;
        }
        this.setPdbLogging(log);
        if (this.doForceLoad) {
            if (!this.confirmFile(this.forceLoadFile)) {
                this.logFailure("Force-load PDB file does not exist: " + this.forceLoadFile, log);
                return false;
            }
            pdbFilename = this.forceLoadFile.getAbsolutePath();
        } else {
            PdbLocator locator = new PdbLocator(this.symbolsRepositoryDir);
            pdbFilename = locator.findPdb(program, programAttributes, !SystemUtilities.isInHeadlessMode(), this.includePeSpecifiedPdbPath, monitor, log, this.getName());
            if (pdbFilename == null) {
                if (!this.confirmDirectory(this.symbolsRepositoryDir)) {
                    this.logFailure("PDB symbol repository directory not found: " + this.symbolsRepositoryDir, log);
                }
                Msg.info((Object)((Object)this), (Object)"PDB analyzer failed to locate PDB file");
                return false;
            }
        }
        Msg.info((Object)((Object)this), (Object)("PDB analyzer parsing file: " + pdbFilename));
        PdbLog.message("================================================================================");
        PdbLog.message(new Date(System.currentTimeMillis()).toString() + "\n");
        PdbLog.message("Ghidra Version: " + Application.getApplicationVersion());
        PdbLog.message(NAME);
        PdbLog.message(DESCRIPTION);
        PdbLog.message("PDB Filename: " + pdbFilename + "\n");
        try (AbstractPdb pdb = PdbParser.parse(pdbFilename, this.pdbReaderOptions, monitor);){
            monitor.setMessage("PDB: Parsing " + pdbFilename + "...");
            pdb.deserialize(monitor);
            PdbApplicator applicator = new PdbApplicator(pdbFilename, pdb);
            applicator.applyTo(program, (DataTypeManager)program.getDataTypeManager(), program.getImageBase(), this.pdbApplicatorOptions, monitor, log);
        }
        catch (PdbException | IOException e) {
            log.appendMsg(this.getName(), "Issue processing PDB file:  " + pdbFilename + ":\n   " + e.toString());
            return false;
        }
        return true;
    }

    public boolean canAnalyze(Program program) {
        String executableFormat = program.getExecutableFormat();
        return executableFormat != null && executableFormat.indexOf("Portable Executable (PE)") != -1;
    }

    public void registerOptions(Options options, Program program) {
        this.symbolsRepositoryDir = PdbLocator.getDefaultPdbSymbolsDir();
        options.registerOption(OPTION_NAME_SYMBOLPATH, OptionType.FILE_TYPE, (Object)this.symbolsRepositoryDir, null, OPTION_DESCRIPTION_SYMBOLPATH);
        options.registerOption(OPTION_NAME_INCLUDE_PE_PDB_PATH, (Object)this.includePeSpecifiedPdbPath, null, OPTION_DESCRIPTION_INCLUDE_PE_PDB_PATH);
        this.getPdbReaderOptions();
        options.registerOption(OPTION_NAME_PDB_READER_ANALYZER_LOGGING, (Object)this.pdbLogging, null, OPTION_DESCRIPTION_PDB_READER_ANALYZER_LOGGING);
        this.getPdbApplicatorOptions();
    }

    public void optionsChanged(Options options, Program program) {
        File symbolsDir = options.getFile(OPTION_NAME_SYMBOLPATH, this.symbolsRepositoryDir);
        if (!symbolsDir.equals(this.symbolsRepositoryDir)) {
            this.symbolsRepositoryDir = symbolsDir;
            PdbLocator.setDefaultPdbSymbolsDir(symbolsDir);
        }
        this.includePeSpecifiedPdbPath = options.getBoolean(OPTION_NAME_INCLUDE_PE_PDB_PATH, this.includePeSpecifiedPdbPath);
        this.pdbLogging = options.getBoolean(OPTION_NAME_PDB_READER_ANALYZER_LOGGING, this.pdbLogging);
        this.setPdbReaderOptions();
        this.setPdbApplicatorOptions();
    }

    private boolean failMissingFilename(PdbProgramAttributes attributes, MessageLog log) {
        if (this.doForceLoad) {
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)attributes.getPdbFile())) {
            this.logFailure("Missing 'PDB File' program property, unable to locate PDB", log);
            return true;
        }
        return false;
    }

    private void logFailure(String msg, MessageLog log) {
        log.appendMsg(this.getName(), msg);
        log.appendMsg(this.getName(), "Skipping PDB processing");
        log.setStatus(msg);
    }

    private boolean failMissingAttributes(PdbProgramAttributes attributes, MessageLog log) {
        String error;
        if (this.doForceLoad) {
            return false;
        }
        if ("RSDS".equals(attributes.getPdbVersion())) {
            if (!StringUtils.isEmpty((CharSequence)attributes.getPdbGuid())) {
                return false;
            }
            error = "Missing 'PDB GUID' program property, unable to locate PDB.";
        } else {
            if (!StringUtils.isEmpty((CharSequence)attributes.getPdbSignature())) {
                return false;
            }
            error = "Missing 'PDB Signature' program property, unable to locate PDB.";
        }
        this.logFailure(error, log);
        return true;
    }

    private void setPdbLogging(MessageLog log) {
        block2: {
            try {
                PdbLog.setEnabled(this.pdbLogging);
            }
            catch (IOException e) {
                if (log == null) break block2;
                log.appendMsg(this.getName(), "IOException when trying to open PDB log file: ");
                log.appendException((Throwable)e);
            }
        }
    }

    private void getPdbReaderOptions() {
        this.oneByteCharsetName = this.pdbReaderOptions.getOneByteCharsetName();
        this.wideCharCharsetName = this.pdbReaderOptions.getTwoByteCharsetName();
    }

    private void setPdbReaderOptions() {
        this.pdbReaderOptions.setOneByteCharsetForName(this.oneByteCharsetName);
        this.pdbReaderOptions.setWideCharCharsetForName(this.wideCharCharsetName);
    }

    private void getPdbApplicatorOptions() {
        this.applyCodeScopeBlockComments = false;
        restrictions = PdbApplicatorOptions.DEFAULT_RESTRICTIONS;
        this.applyInstructionLabels = false;
        this.remapAddressUsingExistingPublicMangledSymbols = false;
        this.allowDemotePrimaryMangledSymbol = true;
        this.applyFunctionVariables = false;
        this.compositeLayout = PdbApplicatorOptions.DEFAULT_CLASS_LAYOUT;
    }

    private void setPdbApplicatorOptions() {
        this.pdbApplicatorOptions.setRestrictions(restrictions);
        this.pdbApplicatorOptions.setApplyCodeScopeBlockComments(this.applyCodeScopeBlockComments);
        this.pdbApplicatorOptions.setApplyInstructionLabels(this.applyInstructionLabels);
        this.pdbApplicatorOptions.setRemapAddressUsingExistingPublicSymbols(this.remapAddressUsingExistingPublicMangledSymbols);
        this.pdbApplicatorOptions.setAllowDemotePrimaryMangledSymbols(this.allowDemotePrimaryMangledSymbol);
        this.pdbApplicatorOptions.setApplyFunctionVariables(this.applyFunctionVariables);
        this.pdbApplicatorOptions.setClassLayout(this.compositeLayout);
    }

    private boolean confirmDirectory(File path) {
        return path.isDirectory();
    }

    private boolean confirmFile(File path) {
        return path.isFile();
    }
}

