/*
 * Decompiled with CFR 0.152.
 */
package help.screenshot;

import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.DockableComponent;
import docking.DockingWindowManager;
import docking.DockingWindowManagerTestUtils;
import docking.SplitPanel;
import docking.Tool;
import docking.WindowPosition;
import docking.action.DockingActionIf;
import docking.action.ToolBarData;
import docking.framework.ApplicationInformationDisplayFactory;
import docking.options.editor.OptionsDialog;
import docking.widgets.dialogs.SettingsDialog;
import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.table.ConfigurableColumnTableModel;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableColumnModel;
import docking.widgets.table.threaded.ThreadedTableModel;
import docking.widgets.tree.GTree;
import generic.jar.ResourceFile;
import generic.test.AbstractGenericTest;
import generic.util.image.ImageUtils;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.plugin.core.analysis.AnalysisOptionsDialog;
import ghidra.app.plugin.core.bookmark.CreateBookmarkDialog;
import ghidra.app.plugin.core.codebrowser.CodeBrowserPlugin;
import ghidra.app.plugin.core.codebrowser.CodeViewerProvider;
import ghidra.app.plugin.core.comments.CommentsDialog;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.services.ProgramManager;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.format.FormatManager;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.app.util.viewer.listingpanel.MarginProvider;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.framework.ToolUtils;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginException;
import ghidra.program.database.data.ProgramDataTypeManager;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.BuiltInDataTypeManager;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramSelection;
import ghidra.test.AbstractGhidraHeadedIntegrationTest;
import ghidra.test.TestEnv;
import ghidra.util.exception.AssertException;
import java.awt.AWTException;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Taskbar;
import java.awt.Window;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import resources.ResourceManager;

public abstract class AbstractScreenShotGenerator
extends AbstractGhidraHeadedIntegrationTest {
    protected static final String SAVE_CREATED_IMAGE_FILE_KEY = "ScreenShotGenerator.save.created.image";
    protected static final boolean SAVE_CREATED_IMAGE_FILE;
    protected static final String NEW_FILENAME_SUFFIX_KEY = "ScreenShotGenerator.filename.suffix";
    protected static final String DEFAULT_FILENAME_SUFFIX = "";
    protected static final String NEW_FILENAME_SUFFIX;
    protected static final int DIALOG_HEADER_HEIGHT = 22;
    public PluginTool tool;
    public TestEnv env;
    public Program program;
    public Image image;

    public AbstractScreenShotGenerator() {
        AbstractScreenShotGenerator.setInstanceField((String)"allowTestTools", ToolUtils.class, (Object)Boolean.FALSE);
        this.setDockIcon();
    }

    @Before
    public void setUp() throws Exception {
        this.env = new TestEnv();
        this.prepareTool();
        AbstractScreenShotGenerator.runSwing(() -> this.tool.getToolFrame().setBounds(new Rectangle(400, 400, 1200, 600)));
        AbstractScreenShotGenerator.waitForPostedSwingRunnables();
        this.loadProgram();
    }

    @After
    public void tearDown() throws Exception {
        this.env.dispose();
    }

    public void prepareTool() {
        this.tool = this.env.launchDefaultTool();
    }

    public void loadProgram() throws Exception {
        this.loadProgram("WinHelloCPP.exe");
        ResourceFile file = TestEnv.findProvidedDataTypeArchive("windows_vs12_32.gdt");
        DataTypeManagerService dtm = (DataTypeManagerService)this.tool.getService(DataTypeManagerService.class);
        dtm.openArchive(file.getFile(false), false);
    }

    public void closeNonProgramArchives() {
        DataTypeManager[] dtms;
        DataTypeManagerService service = (DataTypeManagerService)this.tool.getService(DataTypeManagerService.class);
        for (DataTypeManager dtm : dtms = service.getDataTypeManagers()) {
            if (dtm instanceof BuiltInDataTypeManager || dtm instanceof ProgramDataTypeManager) continue;
            service.closeArchive(dtm);
        }
    }

    public Program loadProgram(String programName) {
        AbstractScreenShotGenerator.runSwing(() -> {
            this.program = this.env.getProgram(programName);
            ProgramManager pm = (ProgramManager)this.tool.getService(ProgramManager.class);
            pm.openProgram(this.program.getDomainFile());
        });
        return this.program;
    }

    public void exit() {
        System.exit(0);
    }

    public void setUser(String userName) {
        System.setProperty("user.name", userName);
    }

    protected void setDockIcon() {
        Taskbar taskbar;
        if (Taskbar.isTaskbarSupported() && (taskbar = Taskbar.getTaskbar()).isSupported(Taskbar.Feature.ICON_IMAGE)) {
            taskbar.setIconImage(ApplicationInformationDisplayFactory.getLargestWindowIcon());
        }
    }

    public Address addr(long value) {
        return this.program.getAddressFactory().getDefaultAddressSpace().getAddress(value);
    }

    public void setToolSize(int width, int height) {
        AbstractScreenShotGenerator.runSwing(() -> this.tool.getToolFrame().setSize(width, height));
        AbstractScreenShotGenerator.waitForSwing();
        AbstractScreenShotGenerator.sleep((long)250L);
        AbstractScreenShotGenerator.waitForSwing();
    }

    public void setWindowSize(Window window, int width, int height) {
        AbstractScreenShotGenerator.runSwing(() -> window.setSize(width, height));
        AbstractScreenShotGenerator.waitForSwing();
    }

    public void performAction(String actionName, String owner, boolean wait) {
        CodeViewerProvider componentProvider = this.getProvider(CodeViewerProvider.class);
        this.performAction(actionName, owner, (ComponentProvider)componentProvider, wait);
    }

    public void performDialogAction(String actionName, boolean wait) {
        DialogComponentProvider dialog = this.getDialog();
        Set actions = dialog.getActions();
        for (DockingActionIf action : actions) {
            if (!action.getName().equals(actionName)) continue;
            AbstractScreenShotGenerator.performDialogAction((DockingActionIf)action, (DialogComponentProvider)dialog, (boolean)wait);
            return;
        }
    }

    public void performAction(String actionName, String owner, ComponentProvider contextProvider, boolean wait) {
        DockingActionIf action = AbstractScreenShotGenerator.getAction((Tool)this.tool, (String)owner, (String)actionName);
        AbstractScreenShotGenerator.performAction((DockingActionIf)action, (ComponentProvider)contextProvider, (boolean)wait);
    }

    public void showOptions(String optionsCategoryName) {
        this.performAction("Edit Options", "Tool", false);
        OptionsDialog dialog = (OptionsDialog)this.getDialog();
        AbstractScreenShotGenerator.runSwing(() -> dialog.displayCategory(optionsCategoryName, null));
        Object optionsPanel = AbstractScreenShotGenerator.getInstanceField((String)"panel", (Object)dialog);
        GTree tree = (GTree)AbstractScreenShotGenerator.getInstanceField((String)"gTree", (Object)optionsPanel);
        AbstractScreenShotGenerator.waitForTree((GTree)tree);
        AbstractScreenShotGenerator.waitForSwing();
    }

    public void showProgramOptions(String optionsCategoryName) {
        this.performAction("Program Options", "ProgramManagerPlugin", false);
        OptionsDialog dialog = (OptionsDialog)this.getDialog();
        AbstractScreenShotGenerator.runSwing(() -> dialog.displayCategory(optionsCategoryName, null));
        Object optionsPanel = AbstractScreenShotGenerator.getInstanceField((String)"panel", (Object)dialog);
        GTree tree = (GTree)AbstractScreenShotGenerator.getInstanceField((String)"gTree", (Object)optionsPanel);
        AbstractScreenShotGenerator.waitForTree((GTree)tree);
        AbstractScreenShotGenerator.waitForSwing();
    }

    public Rectangle getCursorBounds() {
        CodeBrowserPlugin plugin = AbstractScreenShotGenerator.getPlugin(this.tool, CodeBrowserPlugin.class);
        FieldPanel fieldPanel = plugin.getFieldPanel();
        return fieldPanel.getCursorBounds();
    }

    public void pressOkOnDialog() {
        this.pressButtonOnDialog("OK");
    }

    public void pressButtonOnDialog(String buttonText) {
        AbstractScreenShotGenerator.waitForPostedSwingRunnables();
        DialogComponentProvider dialog = this.getDialog();
        AbstractScreenShotGenerator.pressButtonByText((DialogComponentProvider)dialog, (String)buttonText);
    }

    public void captureIsolatedComponent(JComponent component, int width, int height) {
        AbstractScreenShotGenerator.waitForPostedSwingRunnables();
        AbstractScreenShotGenerator.runSwing(() -> {
            JDialog dialog = new JDialog();
            dialog.getContentPane().setLayout(new BorderLayout());
            dialog.getContentPane().add((Component)component, "Center");
            dialog.setSize(width, height + 22);
            dialog.setVisible(true);
        });
        AbstractScreenShotGenerator.waitForSwing();
        AbstractScreenShotGenerator.runSwing(() -> this.generateImage(component));
    }

    public Image captureComponent(Component component) {
        AbstractScreenShotGenerator.waitForSwing();
        AbstractScreenShotGenerator.runSwing(() -> {
            this.paintFix(this.tool.getToolFrame());
            this.generateImage(component);
        });
        return this.image;
    }

    public void captureIsolatedProviderWindow(Class<? extends ComponentProvider> clazz, int width, int height) {
        AbstractScreenShotGenerator.waitForSwing();
        ComponentProvider provider = this.tool.getWindowManager().getComponentProvider(clazz);
        if (provider == null) {
            Assert.fail((String)("Could not find provider--is it installed?: " + clazz.getSimpleName()));
        }
        this.moveProviderToItsOwnWindow(provider);
        AtomicReference ref = new AtomicReference();
        AbstractScreenShotGenerator.runSwing(() -> {
            Window window = this.tool.getWindowManager().getProviderWindow(provider);
            if (window == null) {
                throw new AssertException("Could not find window for provider--is it showing?: " + provider.getName());
            }
            window.setSize(new Dimension(width, height));
            ref.set(window);
        });
        AbstractScreenShotGenerator.waitForSwing();
        this.captureWindow((Window)ref.get());
    }

    public void captureIsolatedProvider(Class<? extends ComponentProvider> clazz, int width, int height) {
        AbstractScreenShotGenerator.waitForSwing();
        ComponentProvider provider = this.tool.getWindowManager().getComponentProvider(clazz);
        if (provider == null) {
            Assert.fail((String)("Could not find provider--is it installed?: " + clazz.getSimpleName()));
        }
        this.captureIsolatedProvider(provider, width, height);
    }

    public void captureIsolatedProvider(ComponentProvider provider, int width, int height) {
        AbstractScreenShotGenerator.waitForSwing();
        this.moveProviderToItsOwnWindow(provider);
        AbstractScreenShotGenerator.runSwing(() -> {
            Window window = this.tool.getWindowManager().getProviderWindow(provider);
            if (window == null) {
                throw new AssertException("Could not find window for provider--is it showing?: " + provider.getName());
            }
            window.setSize(new Dimension(width, height));
            window.toFront();
            provider.getComponent().requestFocus();
            this.paintFix(window);
        });
        AbstractScreenShotGenerator.waitForSwing();
        this.captureProvider(provider);
    }

    public void moveProviderToFront(ComponentProvider provider, int width, int height) {
        this.moveProviderToItsOwnWindow(provider, width, height);
        AbstractScreenShotGenerator.waitForSwing();
        AbstractScreenShotGenerator.runSwing(() -> {
            Window window = AbstractScreenShotGenerator.windowForComponent((Component)provider.getComponent());
            window.toFront();
        });
    }

    public void moveProviderToFront(ComponentProvider provider) {
        this.moveProviderToItsOwnWindow(provider);
        AbstractScreenShotGenerator.waitForSwing();
        AbstractScreenShotGenerator.runSwing(() -> {
            Window window = AbstractScreenShotGenerator.windowForComponent((Component)provider.getComponent());
            window.toFront();
        });
    }

    public void moveWindowUp(Window window, int yOffset) {
        AbstractScreenShotGenerator.runSwing(() -> {
            Point loc = window.getLocation();
            loc.y -= yOffset;
            window.setLocation(loc);
        });
    }

    public Window moveProviderToItsOwnWindow(ComponentProvider provider) {
        DockingWindowManager dwm = this.tool.getWindowManager();
        Window w = DockingWindowManagerTestUtils.moveProviderToWindow((DockingWindowManager)dwm, (ComponentProvider)provider);
        AbstractScreenShotGenerator.waitForSwing();
        return w;
    }

    public Window moveProviderToItsOwnWindow(ComponentProvider provider, int width, int height) {
        Window window = this.moveProviderToItsOwnWindow(provider);
        Assert.assertNotNull((Object)window);
        AbstractScreenShotGenerator.runSwing(() -> window.setSize(new Dimension(width, height)));
        return window;
    }

    public DockableComponent getDockableComponent(ComponentProvider provider) {
        return DockingWindowManagerTestUtils.getDockableComponent((DockingWindowManager)this.tool.getWindowManager(), (ComponentProvider)provider);
    }

    public void moveProvider(ComponentProvider movee, ComponentProvider relativeTo, WindowPosition position) {
        DockingWindowManagerTestUtils.moveProvider((DockingWindowManager)this.tool.getWindowManager(), (ComponentProvider)movee, (ComponentProvider)relativeTo, (WindowPosition)position);
    }

    public void captureMenu() {
        Set allWindows = AbstractScreenShotGenerator.getAllWindows();
        for (Window window : allWindows) {
            if (!window.getClass().getSimpleName().equals("HeavyWeightWindow")) continue;
            this.captureComponent(window);
        }
        this.drawBorder(Color.BLACK);
    }

    public JPopupMenu getPopupMenu() {
        Set allWindows = AbstractScreenShotGenerator.getAllWindows();
        for (Window window : allWindows) {
            if (!window.getClass().getSimpleName().equals("HeavyWeightWindow")) continue;
            return (JPopupMenu)AbstractScreenShotGenerator.findComponent((Container)window, JPopupMenu.class);
        }
        return null;
    }

    public void captureProvider(Class<? extends ComponentProvider> clazz) {
        AbstractScreenShotGenerator.waitForPostedSwingRunnables();
        AbstractScreenShotGenerator.runSwing(() -> {
            ComponentProvider provider = this.tool.getWindowManager().getComponentProvider(clazz);
            DockableComponent dc = this.getDockableComponent(provider);
            this.generateImage((Component)dc);
        });
        AbstractScreenShotGenerator.waitForPostedSwingRunnables();
    }

    public void captureProvider(ComponentProvider provider) {
        AbstractScreenShotGenerator.waitForPostedSwingRunnables();
        AbstractScreenShotGenerator.runSwing(() -> {
            DockableComponent dc = this.getDockableComponent(provider);
            this.generateImage((Component)dc);
        });
        AbstractScreenShotGenerator.waitForPostedSwingRunnables();
    }

    public void captureProvider(String name) {
        AbstractScreenShotGenerator.waitForPostedSwingRunnables();
        AbstractScreenShotGenerator.runSwing(() -> {
            ComponentProvider provider = this.tool.getWindowManager().getComponentProvider(name);
            DockableComponent dc = this.getDockableComponent(provider);
            this.generateImage((Component)dc);
        });
        AbstractScreenShotGenerator.waitForPostedSwingRunnables();
    }

    public void captureProviderWithScreenShot(ComponentProvider provider) {
        this.captureProviderWindow(provider);
        DockableComponent dockableComponent = this.getDockableComponent(provider);
        Rectangle bounds = dockableComponent.getBounds();
        Point p = bounds.getLocation();
        Window window = SwingUtilities.windowForComponent((Component)dockableComponent);
        Point newPoint = SwingUtilities.convertPoint(dockableComponent.getParent(), p, window);
        bounds.setLocation(newPoint);
        this.crop(bounds);
    }

    public void captureProviderWindow(String name) {
        AbstractScreenShotGenerator.waitForPostedSwingRunnables();
        ComponentProvider provider = this.tool.getWindowManager().getComponentProvider(name);
        this.captureProviderWindow(provider);
    }

    public void captureProviderWindow(Class<? extends ComponentProvider> clazz) {
        ComponentProvider provider = AbstractScreenShotGenerator.waitForComponentProvider(clazz);
        this.captureProviderWindow(provider);
    }

    public void captureProviderWindow(ComponentProvider provider) {
        Window window = AbstractScreenShotGenerator.windowForComponent((Component)provider.getComponent());
        this.captureWindow(window);
    }

    public void captureProviderWindow(String name, int width, int height) {
        AbstractScreenShotGenerator.waitForPostedSwingRunnables();
        ComponentProvider provider = this.tool.getWindowManager().getComponentProvider(name);
        Assert.assertNotNull((String)("Unable to find provider in tool: " + name), (Object)provider);
        this.captureProviderWindow(provider, width, height);
    }

    public void captureProviderWindow(ComponentProvider provider, int width, int height) {
        AbstractScreenShotGenerator.waitForPostedSwingRunnables();
        Window window = AbstractScreenShotGenerator.windowForComponent((Component)provider.getComponent());
        this.captureWindow(window, width, height);
    }

    public <T extends ComponentProvider> T showProvider(Class<T> clazz) {
        T componentProvider = this.getProvider(clazz);
        if (componentProvider != null) {
            componentProvider.setVisible(true);
        }
        AbstractScreenShotGenerator.waitForPostedSwingRunnables();
        return (T)((ComponentProvider)clazz.cast(componentProvider));
    }

    public void closeProvider(Class<? extends ComponentProvider> clazz) {
        ComponentProvider componentProvider = this.getProvider(clazz);
        if (componentProvider != null) {
            componentProvider.setVisible(false);
        }
        AbstractScreenShotGenerator.waitForPostedSwingRunnables();
    }

    public void captureActionIcon(String actionName) {
        AbstractScreenShotGenerator.waitForSwing();
        DockingActionIf action = AbstractScreenShotGenerator.getAction((Tool)this.tool, (String)actionName);
        ToolBarData tbData = action.getToolBarData();
        Icon icon = tbData.getIcon();
        this.captureIcon(icon);
    }

    public void captureIcon(Icon icon) {
        AbstractScreenShotGenerator.runSwing(() -> {
            ImageIcon imageIcon = ResourceManager.getImageIcon((Icon)icon);
            this.image = imageIcon.getImage();
            this.image = ImageUtils.getBufferedImage((Image)this.image);
        });
    }

    public void captureDialog() {
        this.captureDialog(DialogComponentProvider.class);
    }

    public DialogComponentProvider getDialog() {
        return this.getDialog(DialogComponentProvider.class);
    }

    public DialogComponentProvider getDialog(Class<? extends DialogComponentProvider> clazz) {
        return AbstractScreenShotGenerator.waitForDialogComponent(clazz);
    }

    public void captureDialog(int width, int height) {
        this.captureDialog(DialogComponentProvider.class, width, height);
    }

    protected void paintFix(Window window) {
        AbstractScreenShotGenerator.sleep((long)250L);
    }

    public void captureDialog(String title) {
        DialogComponentProvider dialogProvider = AbstractScreenShotGenerator.waitForDialogComponent((String)title);
        JDialog dialog = (JDialog)AbstractScreenShotGenerator.getInstanceField((String)"dialog", (Object)dialogProvider);
        AbstractScreenShotGenerator.waitForSwing();
        this.paintFix(dialog);
        AbstractScreenShotGenerator.runSwing(() -> this.generateImage(dialog));
    }

    public void captureDialog(Class<? extends DialogComponentProvider> clazz) {
        DialogComponentProvider dialogProvider = AbstractScreenShotGenerator.waitForDialogComponent(clazz);
        Assert.assertNotNull((String)("Did not find a dialog to capture for class: " + clazz), (Object)dialogProvider);
        JDialog dialog = (JDialog)AbstractScreenShotGenerator.getInstanceField((String)"dialog", (Object)dialogProvider);
        AbstractScreenShotGenerator.waitForSwing();
        this.paintFix(dialog);
        AbstractScreenShotGenerator.runSwing(() -> this.generateImage(dialog));
    }

    public void captureDialog(DialogComponentProvider provider) {
        Assert.assertNotNull((String)"Dialog cannot be null", (Object)provider);
        JDialog dialog = (JDialog)AbstractScreenShotGenerator.getInstanceField((String)"dialog", (Object)provider);
        this.paintFix(dialog);
        AbstractScreenShotGenerator.runSwing(() -> this.generateImage(dialog));
    }

    public void captureDialog(Class<? extends DialogComponentProvider> clazz, int width, int height) {
        DialogComponentProvider dialogProvider = AbstractScreenShotGenerator.waitForDialogComponent(clazz);
        JDialog dialog = (JDialog)AbstractScreenShotGenerator.getInstanceField((String)"dialog", (Object)dialogProvider);
        AbstractScreenShotGenerator.waitForPostedSwingRunnables();
        this.paintFix(dialog);
        if (width >= 0) {
            AbstractScreenShotGenerator.runSwing(() -> dialog.setSize(width, height));
        }
        AbstractScreenShotGenerator.waitForSwing();
        this.paintFix(dialog);
        AbstractScreenShotGenerator.runSwing(() -> this.generateImage(dialog));
    }

    public void captureWindow() {
        AbstractScreenShotGenerator.waitForPostedSwingRunnables();
        JFrame toolFrame = this.tool.getToolFrame();
        this.paintFix(toolFrame);
        AbstractScreenShotGenerator.runSwing(() -> this.generateImage(toolFrame));
    }

    public void captureWindow(Window window) {
        AbstractScreenShotGenerator.waitForPostedSwingRunnables();
        this.paintFix(window);
        AbstractScreenShotGenerator.runSwing(() -> this.generateImage(window));
    }

    public void captureWindow(Window window, int width, int height) {
        AbstractScreenShotGenerator.waitForPostedSwingRunnables();
        AbstractScreenShotGenerator.runSwing(() -> window.setSize(width, height));
        AbstractScreenShotGenerator.waitForSwing();
        this.paintFix(window);
        AbstractScreenShotGenerator.runSwing(() -> this.generateImage(window));
    }

    public void captureToolWindow(int width, int height) {
        AbstractScreenShotGenerator.waitForPostedSwingRunnables();
        AbstractScreenShotGenerator.runSwing(() -> {
            JFrame toolFrame = this.tool.getToolFrame();
            toolFrame.setSize(width, height);
        });
        AbstractScreenShotGenerator.waitForSwing();
        this.paintFix(this.tool.getToolFrame());
        AbstractScreenShotGenerator.runSwing(() -> this.generateImage(this.tool.getToolFrame()));
    }

    public void captureDialog(Dialog dialog) {
        AbstractScreenShotGenerator.waitForPostedSwingRunnables();
        this.paintFix(dialog);
        AbstractScreenShotGenerator.runSwing(() -> this.generateImage(dialog));
    }

    public void captureDialog(Dialog dialog, int width, int height) {
        AbstractScreenShotGenerator.waitForPostedSwingRunnables();
        AbstractScreenShotGenerator.runSwing(() -> dialog.setSize(width, height));
        AbstractScreenShotGenerator.waitForSwing();
        this.paintFix(dialog);
        AbstractScreenShotGenerator.runSwing(() -> this.generateImage(dialog));
    }

    public void captureListingField(long address, String fieldName, int padding) {
        CodeBrowserPlugin plugin = AbstractScreenShotGenerator.getPlugin(this.tool, CodeBrowserPlugin.class);
        plugin.goToField(this.addr(address), fieldName, 0, 0);
        FieldPanel fieldPanel = plugin.getFieldPanel();
        Rectangle cursorBounds = fieldPanel.getCursorBounds();
        ListingPanel listingPanel = plugin.getListingPanel();
        cursorBounds.setLocation(SwingUtilities.convertPoint((Component)fieldPanel, cursorBounds.getLocation(), listingPanel));
        this.captureIsolatedComponent(listingPanel, 1300, 600);
        Field field = this.getField(cursorBounds.getLocation());
        int fieldWidth = field.getPreferredWidth();
        int fieldHeight = field.getHeight();
        int x = cursorBounds.x - padding;
        int y = cursorBounds.y - padding;
        this.crop(new Rectangle(x, y, fieldWidth + 2 * padding, fieldHeight + 2 * padding));
    }

    public void generateImage(Component c) {
        if (!(c instanceof Window)) {
            this.image = AbstractScreenShotGenerator.createRenderedImage((Component)c);
            return;
        }
        try {
            this.image = AbstractScreenShotGenerator.createScreenImage((Component)c);
        }
        catch (AWTException e) {
            this.error(e);
        }
    }

    public void captureComponents(List<Component> comps) {
        Point p;
        int pad;
        Rectangle rect = this.computeBounds(comps);
        BufferedImage combinedImage = new BufferedImage(rect.width, rect.height, 2);
        Graphics g = combinedImage.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, rect.width, rect.height);
        for (Component component : comps) {
            pad = 6;
            p = component.getLocationOnScreen();
            g.setColor(new Color(250, 250, 250));
            g.fillRoundRect(p.x - rect.x - pad, p.y - rect.y - pad, component.getWidth() + pad * 2, component.getHeight() + pad * 2, pad * 2, pad * 2);
        }
        for (Component component : comps) {
            pad = 3;
            p = component.getLocationOnScreen();
            g.setColor(new Color(240, 240, 240));
            g.fillRoundRect(p.x - rect.x - pad, p.y - rect.y - pad, component.getWidth() + pad * 2, component.getHeight() + pad * 2, pad * 2, pad * 2);
        }
        for (Component component : comps) {
            this.image = this.captureComponent(component);
            Point p2 = component.getLocationOnScreen();
            g.drawImage(this.image, p2.x - rect.x, p2.y - rect.y, null);
        }
        ImageUtils.waitForImage(null, (Image)combinedImage);
        this.image = combinedImage;
    }

    public void captureMenuBarMenu(String menuName, String ... subMenuNames) {
        this.showMenuBarMenu(menuName, subMenuNames);
        this.captureMenu();
    }

    public void captureMenuBarMenuHierachy(String menuName, String ... subMenuNames) {
        List<Component> comps = this.showMenuBarMenu(menuName, subMenuNames);
        this.captureComponents(comps);
    }

    public void captureListingRange(long start, long end, int width) {
        AbstractScreenShotGenerator.waitForSwing();
        CodeBrowserPlugin plugin = AbstractScreenShotGenerator.getPlugin(this.tool, CodeBrowserPlugin.class);
        FieldPanel fieldPanel = plugin.getFieldPanel();
        ListingPanel listingPanel = plugin.getListingPanel();
        plugin.goToField(this.addr(start), "Address", 0, 0);
        fieldPanel.positionCursor(0);
        Rectangle startCursorBounds = fieldPanel.getCursorBounds();
        startCursorBounds.setLocation(SwingUtilities.convertPoint((Component)fieldPanel, startCursorBounds.getLocation(), listingPanel));
        plugin.goToField(this.addr(end), "Address", 0, 0, 0, false);
        Rectangle endCursorBounds = fieldPanel.getCursorBounds();
        endCursorBounds.setLocation(SwingUtilities.convertPoint((Component)fieldPanel, endCursorBounds.getLocation(), listingPanel));
        int height = endCursorBounds.y + endCursorBounds.height;
        int extraHeight = height * 2;
        this.captureIsolatedComponent(plugin.getListingPanel(), width, extraHeight);
        int y = startCursorBounds.y;
        this.crop(new Rectangle(0, y, width - 40, height - y));
    }

    public void error(Exception e) {
        e.printStackTrace();
        System.exit(1);
    }

    public void setListingFieldWidth(String fieldName, int width) {
        AbstractScreenShotGenerator.runSwing(() -> {
            FormatManager newMinimizedFormatManager = this.getFormatManager();
            for (int i = 0; i < newMinimizedFormatManager.getNumModels(); ++i) {
                FieldFormatModel formatModel = newMinimizedFormatManager.getModel(i);
                int numRows = formatModel.getNumRows();
                for (int row = 0; row < numRows; ++row) {
                    FieldFactory[] allRowFactories = formatModel.getFactorys(row);
                    for (int col = allRowFactories.length - 1; col >= 0; --col) {
                        FieldFactory fieldFactory = allRowFactories[col];
                        if (!fieldFactory.getFieldName().equals(fieldName)) continue;
                        fieldFactory.setWidth(width);
                        formatModel.updateRow(row);
                        return;
                    }
                }
            }
        });
    }

    public Field getField(Point point) {
        CodeBrowserPlugin plugin = AbstractScreenShotGenerator.getPlugin(this.tool, CodeBrowserPlugin.class);
        ListingPanel listingPanel = plugin.getListingPanel();
        FieldLocation loc = new FieldLocation();
        return listingPanel.getFieldPanel().getFieldAt(point.x, point.y, loc);
    }

    private FormatManager getFormatManager() {
        CodeBrowserPlugin cbp = AbstractScreenShotGenerator.getPlugin(this.tool, CodeBrowserPlugin.class);
        return cbp.getFormatManager();
    }

    public void leftClickCursor() {
        Rectangle cursor = this.getCursorBounds();
        CodeBrowserPlugin plugin = AbstractScreenShotGenerator.getPlugin(this.tool, CodeBrowserPlugin.class);
        FieldPanel fieldPanel = plugin.getFieldPanel();
        AbstractScreenShotGenerator.leftClick((JComponent)fieldPanel, (int)cursor.x, (int)cursor.y);
        AbstractScreenShotGenerator.waitForPostedSwingRunnables();
    }

    public void rightClickCursor() {
        Rectangle cursor = this.getCursorBounds();
        CodeBrowserPlugin plugin = AbstractScreenShotGenerator.getPlugin(this.tool, CodeBrowserPlugin.class);
        FieldPanel fieldPanel = plugin.getFieldPanel();
        AbstractScreenShotGenerator.rightClick((JComponent)fieldPanel, (int)cursor.x, (int)cursor.y);
        AbstractScreenShotGenerator.waitForPostedSwingRunnables();
    }

    public void middleClickCursor() {
        Rectangle cursor = this.getCursorBounds();
        CodeBrowserPlugin plugin = AbstractScreenShotGenerator.getPlugin(this.tool, CodeBrowserPlugin.class);
        FieldPanel fieldPanel = plugin.getFieldPanel();
        AbstractScreenShotGenerator.middleClick((JComponent)fieldPanel, (int)cursor.x, (int)cursor.y);
        AbstractScreenShotGenerator.waitForPostedSwingRunnables();
    }

    public void doubleClickCursor() {
        Rectangle cursor = this.getCursorBounds();
        CodeBrowserPlugin plugin = AbstractScreenShotGenerator.getPlugin(this.tool, CodeBrowserPlugin.class);
        FieldPanel fieldPanel = plugin.getFieldPanel();
        AbstractScreenShotGenerator.doubleClick((JComponent)fieldPanel, (int)cursor.x, (int)cursor.y);
        AbstractScreenShotGenerator.waitForPostedSwingRunnables();
    }

    private Rectangle computeBounds(List<Component> comps) {
        Point upperLeft = null;
        Point lowerRight = null;
        for (Component component : comps) {
            Point p1 = component.getLocationOnScreen();
            Dimension size = component.getSize();
            Point p2 = new Point(p1.x + size.width, p1.y + size.height);
            if (upperLeft == null) {
                upperLeft = p1;
                lowerRight = p2;
                continue;
            }
            upperLeft.x = Math.min(upperLeft.x, p1.x);
            upperLeft.y = Math.min(upperLeft.y, p1.y);
            lowerRight.x = Math.max(lowerRight.x, p2.x);
            lowerRight.y = Math.max(lowerRight.y, p2.y);
        }
        return new Rectangle(upperLeft.x, upperLeft.y, lowerRight.x - upperLeft.x, lowerRight.y - upperLeft.y);
    }

    private JMenuItem findMenu(JMenuBar menuBar, String name) {
        for (MenuElement subElement : menuBar.getSubElements()) {
            JMenuItem item = (JMenuItem)subElement;
            if (!name.equals(item.getText())) continue;
            return item;
        }
        Assert.fail((String)("Could not find menu element: " + name));
        return null;
    }

    private JMenuItem findMenuElement(JMenu menu, String name) {
        int itemCount = menu.getItemCount();
        for (int i = 0; i < itemCount; ++i) {
            JMenuItem item = menu.getItem(i);
            if (!name.equals(item.getText())) continue;
            return item;
        }
        Assert.fail((String)("Could not find menu element: " + name));
        return null;
    }

    public void selectRow(JTable table, int rowIndex) {
        this.waitForTable(table);
        AbstractScreenShotGenerator.runSwing(() -> table.setRowSelectionInterval(rowIndex, rowIndex));
        this.waitForTable(table);
    }

    public void setSelected(JToggleButton button, boolean select) {
        AbstractScreenShotGenerator.runSwing(() -> button.setSelected(select));
    }

    private void waitForTable(JTable table) {
        if (!(table instanceof GTable)) {
            return;
        }
        GTable gTable = (GTable)table;
        TableModel model = gTable.getModel();
        if (!(model instanceof ThreadedTableModel)) {
            return;
        }
        ThreadedTableModel threadedModel = (ThreadedTableModel)model;
        AbstractScreenShotGenerator.waitForTableModel((ThreadedTableModel)threadedModel);
    }

    public void hideTableColumn(GTable table, String columnName) {
        AbstractScreenShotGenerator.runSwing(() -> {
            GTableColumnModel columnModel = (GTableColumnModel)table.getColumnModel();
            List allColumns = columnModel.getAllColumns();
            for (TableColumn column : allColumns) {
                if (!columnName.equals(column.getHeaderValue())) continue;
                columnModel.setVisible(column, false);
            }
        });
    }

    public List<Component> showMenuBarMenu(String menuName, String ... submenuNames) {
        AbstractScreenShotGenerator.waitForSwing();
        ArrayList<Component> list = new ArrayList<Component>();
        AbstractScreenShotGenerator.runSwing(() -> {
            JMenuBar menuBar = this.tool.getToolFrame().getJMenuBar();
            list.add(menuBar);
            JMenuItem item = this.findMenu(menuBar, menuName);
            JMenu menu = (JMenu)item;
            JPopupMenu popupMenu = menu.getPopupMenu();
            Rectangle bounds = item.getBounds();
            popupMenu.show(menu.getParent(), bounds.x, bounds.y + bounds.height);
            list.add(popupMenu);
            for (String string : submenuNames) {
                menu = (JMenu)this.findMenuElement(menu, string);
                popupMenu = menu.getPopupMenu();
                bounds = menu.getBounds();
                popupMenu.show(menu, bounds.x + bounds.width, 0);
                list.add(popupMenu);
            }
        });
        AbstractScreenShotGenerator.waitForSwing();
        return list;
    }

    public void showColumnSettings(GTable table, String colName) {
        AbstractScreenShotGenerator.runSwing(() -> {
            ConfigurableColumnTableModel model = table.getConfigurableColumnTableModel();
            for (int i = 0; i < model.getColumnCount(); ++i) {
                if (!colName.equals(model.getColumnName(i))) continue;
                SettingsDefinition[] settings = model.getColumnSettingsDefinitions(i);
                SettingsDialog dialog = new SettingsDialog(null);
                dialog.show((Component)table, model.getColumnName(i) + " Settings", settings, model.getColumnSettings(i));
            }
        }, (boolean)false);
        AbstractScreenShotGenerator.waitForSwing();
    }

    public void showTableColumn(GTable table, String columnName) {
        AbstractScreenShotGenerator.runSwing(() -> {
            GTableColumnModel columnModel = (GTableColumnModel)table.getColumnModel();
            List allColumns = columnModel.getAllColumns();
            for (TableColumn column : allColumns) {
                if (!columnName.equals(column.getHeaderValue())) continue;
                columnModel.setVisible(column, true);
            }
        });
    }

    public void setSelectedAnayzer(Object analysisPanel, String analyzerName) {
        JTable table = (JTable)AbstractScreenShotGenerator.getInstanceField((String)"table", (Object)analysisPanel);
        AbstractScreenShotGenerator.runSwing(() -> {
            int rowCount = table.getModel().getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                String name = table.getValueAt(i, 1).toString();
                if (!name.equals(analyzerName)) continue;
                table.setRowSelectionInterval(i, i);
                break;
            }
        });
    }

    public void showCommentDialog(String text) {
        this.performAction("Set EOL Comment", "CommentsPlugin", false);
        this.prepareCommentsDialog((CommentsDialog)this.getDialog(), text);
    }

    public void prepareCommentsDialog(CommentsDialog dialog, String annotationText) {
        AbstractScreenShotGenerator.runSwing(() -> {
            JTextArea textArea = (JTextArea)AbstractScreenShotGenerator.getInstanceField((String)"eolField", (Object)dialog);
            textArea.setText(annotationText);
            JComboBox combo = (JComboBox)AbstractScreenShotGenerator.findComponent((Container)dialog.getComponent(), JComboBox.class);
            int itemCount = combo.getItemCount();
            for (int i = 0; i < itemCount; ++i) {
                Object itemAt = combo.getItemAt(i);
                if (!"URL".equals(itemAt.toString())) continue;
                combo.setSelectedIndex(i);
                break;
            }
        });
    }

    public void createBookmark(long address) {
        this.goToListing(address);
        this.performAction("Add Bookmark", "BookmarkPlugin", false);
        CreateBookmarkDialog d = (CreateBookmarkDialog)this.getDialog();
        Assert.assertNotNull((String)"Could not find the Create Bookmark dialog", (Object)((Object)d));
        AbstractScreenShotGenerator.runSwing(() -> {
            JTextField commentTextField = (JTextField)AbstractScreenShotGenerator.getInstanceField((String)"commentTextField", (Object)((Object)d));
            commentTextField.setText("My Comment");
            JComboBox categoryComboBox = (JComboBox)AbstractGenericTest.getInstanceField((String)"categoryComboBox", (Object)((Object)d));
            categoryComboBox.setSelectedItem("fred");
        });
        this.pressOkOnDialog();
    }

    public void selectRow(JTable table, String searchString) {
        this.waitForTable(table);
        int row = this.findRowByPartialText(table, searchString);
        AbstractScreenShotGenerator.runSwing(() -> {
            table.setRowSelectionInterval(row, row);
            Rectangle rect = table.getCellRect(row, 0, false);
            table.scrollRectToVisible(rect);
        });
        this.waitForTable(table);
    }

    public void scrollToRow(JTable table, int row) {
        AbstractScreenShotGenerator.runSwing(() -> {
            Rectangle rect = table.getCellRect(row, 0, false);
            table.scrollRectToVisible(rect);
        });
    }

    public int findRowByPartialText(JTable table, String searchString) {
        this.waitForTable(table);
        AtomicReference result = new AtomicReference();
        AbstractScreenShotGenerator.runSwing(() -> {
            TableModel model = table.getModel();
            int rowCount = model.getRowCount();
            int columnCount = model.getColumnCount();
            StringBuilder buffy = new StringBuilder();
            for (int row = 0; row < rowCount; ++row) {
                buffy.delete(0, buffy.length());
                for (int col = 0; col < columnCount; ++col) {
                    Object value = model.getValueAt(row, col);
                    if (value == null) continue;
                    String string = value.toString();
                    buffy.append(string);
                }
                String rowString = buffy.toString();
                if (!rowString.contains(searchString)) continue;
                result.set(row);
                return;
            }
        });
        if (result.get() == null) {
            throw new AssertException("Unable to find row with text: " + searchString);
        }
        this.waitForTable(table);
        return (Integer)result.get();
    }

    public void performMemorySearch(String searchString) {
        this.performAction("Search Memory", "MemSearchPlugin", false);
        DialogComponentProvider d = this.getDialog();
        Assert.assertNotNull((String)"Could not find the Memory Search dialog", (Object)d);
        JTextField valueField = (JTextField)AbstractScreenShotGenerator.getInstanceField((String)"valueField", (Object)d);
        AbstractScreenShotGenerator.setText((JTextComponent)valueField, (String)searchString);
        AbstractScreenShotGenerator.pressButtonByName((Container)d.getComponent(), (String)"Search All");
    }

    public void removeField(String fieldName) {
        CodeBrowserPlugin plugin = AbstractScreenShotGenerator.getPlugin(this.tool, CodeBrowserPlugin.class);
        AbstractScreenShotGenerator.runSwing(() -> {
            FormatManager formatManager = plugin.getFormatManager();
            FieldFormatModel codeUnitFormat = formatManager.getCodeUnitFormat();
            codeUnitFormat.getNumRows();
            block0: for (int row = 0; row < codeUnitFormat.getNumRows(); ++row) {
                FieldFactory[] factorys = codeUnitFormat.getFactorys(row);
                for (int col = 0; col < factorys.length; ++col) {
                    if (!fieldName.equals(factorys[col].getFieldName())) continue;
                    codeUnitFormat.removeFactory(row, col);
                    continue block0;
                }
            }
        });
    }

    public void showAnalysisOptions(String selectedAnalyzerName) {
        this.performAction("Auto Analyze", "AutoAnalysisPlugin", false);
        AnalysisOptionsDialog dialog = (AnalysisOptionsDialog)this.getDialog();
        Object panel = AbstractScreenShotGenerator.getInstanceField((String)"panel", (Object)dialog);
        this.setSelectedAnayzer(panel, selectedAnalyzerName);
    }

    public void removeFlowArrows() {
        AbstractScreenShotGenerator.runSwing(() -> {
            CodeBrowserPlugin plugin = AbstractScreenShotGenerator.getPlugin(this.tool, CodeBrowserPlugin.class);
            ListingPanel listingPanel = plugin.getListingPanel();
            List list = (List)AbstractScreenShotGenerator.getInstanceField((String)"marginProviders", (Object)listingPanel);
            for (MarginProvider marginProvider : list) {
                listingPanel.removeMarginProvider(marginProvider);
            }
        });
    }

    public void makeSelection(AddressSet addrSet) {
        AbstractScreenShotGenerator.runSwing(() -> this.tool.firePluginEvent((PluginEvent)new ProgramSelectionPluginEvent("test", new ProgramSelection((AddressSetView)addrSet), this.program)), (boolean)true);
    }

    public void addSelection(long start, long end) {
        AbstractScreenShotGenerator.runSwing(() -> {
            CodeBrowserPlugin plugin = AbstractScreenShotGenerator.getPlugin(this.tool, CodeBrowserPlugin.class);
            AddressSet set = new AddressSet((AddressSetView)plugin.getCurrentSelection());
            set.addRange(this.addr(start), this.addr(end));
            this.tool.firePluginEvent((PluginEvent)new ProgramSelectionPluginEvent("test", new ProgramSelection((AddressSetView)set), this.program));
        }, (boolean)true);
    }

    public void makeSelection(long start, long end) {
        AddressSet addressSet = new AddressSet();
        addressSet.addRange(this.addr(start), this.addr(end));
        this.makeSelection(addressSet);
    }

    public void go(long address) {
        this.goToListing(address);
    }

    public void goToListing(long address) {
        this.goToListing(address, "Address", true);
    }

    public void goToListing(long address, boolean scrollToMiddle) {
        this.goToListing(address, "Address", scrollToMiddle);
    }

    public void goToListing(long address, String fieldName, boolean scrollToMiddle) {
        AbstractScreenShotGenerator.runSwing(() -> {
            CodeBrowserPlugin plugin = AbstractScreenShotGenerator.getPlugin(this.tool, CodeBrowserPlugin.class);
            plugin.goToField(this.addr(address), fieldName, 0, 0, 0, scrollToMiddle);
        });
        AbstractScreenShotGenerator.waitForPostedSwingRunnables();
    }

    public void positionCursor(long address) {
        this.positionCursor(address, "Address");
    }

    public void positionCursor(long address, String fieldName) {
        AbstractScreenShotGenerator.runSwing(() -> {
            CodeBrowserPlugin plugin = AbstractScreenShotGenerator.getPlugin(this.tool, CodeBrowserPlugin.class);
            plugin.goToField(this.addr(address), fieldName, 0, 0, 0, false);
        });
        AbstractScreenShotGenerator.waitForPostedSwingRunnables();
    }

    public void positionListingTop(long address) {
        AbstractScreenShotGenerator.runSwing(() -> {
            CodeBrowserPlugin plugin = AbstractScreenShotGenerator.getPlugin(this.tool, CodeBrowserPlugin.class);
            FieldPanel fieldPanel = plugin.getFieldPanel();
            plugin.goToField(this.addr(address), "Address", 0, 0);
            fieldPanel.positionCursor(0);
        });
    }

    public void positionListingCenter(long address) {
        AbstractScreenShotGenerator.runSwing(() -> {
            CodeBrowserPlugin plugin = AbstractScreenShotGenerator.getPlugin(this.tool, CodeBrowserPlugin.class);
            plugin.goToField(this.addr(address), "Address", 0, 0);
        });
        CodeBrowserPlugin plugin = AbstractScreenShotGenerator.getPlugin(this.tool, CodeBrowserPlugin.class);
        plugin.goToField(this.addr(address), "Address", 0, 0);
    }

    @Deprecated
    public void topOfListing(long address) {
        this.positionListingTop(address);
    }

    public Plugin loadPlugin(Class<? extends Plugin> clazz) {
        try {
            this.tool.addPlugin(clazz.getName());
            return this.env.getPlugin(clazz);
        }
        catch (PluginException e) {
            e.printStackTrace();
            System.exit(0);
            return null;
        }
    }

    public Plugin loadPlugin(String className) {
        try {
            Class<?> clazz;
            Class<?> pluginClazz = clazz = Class.forName(className);
            return this.loadPlugin(pluginClazz);
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            System.exit(0);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.exit(0);
        }
        return null;
    }

    public ComponentProvider getProvider(String name) {
        return this.tool.getWindowManager().getComponentProvider(name);
    }

    public <T extends ComponentProvider> T getProvider(Class<T> clazz) {
        return (T)((ComponentProvider)clazz.cast(this.tool.getWindowManager().getComponentProvider(clazz)));
    }

    public DockableComponent getDockableComponent(Class<? extends ComponentProvider> clazz) {
        ComponentProvider provider = this.tool.getWindowManager().getComponentProvider(clazz);
        return this.getDockableComponent(provider);
    }

    public JButton findProviderToolBarButton(ComponentProvider provider, String actionName) {
        DockableComponent dockingComponent = this.getDockableComponent(provider);
        JButton button = (JButton)AbstractScreenShotGenerator.findComponentByName((Container)dockingComponent, (String)actionName);
        Assert.assertNotNull((String)("Can't find button for action: " + actionName), (Object)button);
        return button;
    }

    @Deprecated
    public Address address(long value) {
        return this.program.getAddressFactory().getDefaultAddressSpace().getAddress(value);
    }

    public Rectangle getBounds(JComponent component) {
        AtomicReference ref = new AtomicReference();
        AbstractScreenShotGenerator.runSwing(() -> ref.set(component.getBounds()));
        return (Rectangle)ref.get();
    }

    public void drawRectangleWithDropShadowAround(JComponent component, Color color, int padding) {
        Rectangle r = this.drawRectangleAround(component, Color.BLACK, padding);
        r.x -= padding;
        r.y -= padding;
        this.drawRectangle(color, r, 4);
    }

    public Rectangle drawRectangleAround(JComponent component, Color color, int padding) {
        return this.drawRectangleAround(component, null, color, padding);
    }

    public Rectangle drawRectangleAround(JComponent component, JComponent root, Color color, int padding) {
        Rectangle bounds = this.getBounds(component);
        Rectangle converted = SwingUtilities.convertRectangle(component.getParent(), bounds, root);
        this.drawRectangle(color, converted, padding, 4);
        return converted;
    }

    public Rectangle drawRectangle(Color c, Rectangle r, int padding, int thickness) {
        r.x -= padding;
        r.y -= padding;
        r.width += 2 * padding;
        r.height += 2 * padding;
        this.drawRectangle(c, r, thickness);
        return r;
    }

    public void drawBorder(Color c) {
        Graphics g = this.image.getGraphics();
        g.setColor(c);
        g.drawRect(0, 0, this.image.getWidth(null) - 1, this.image.getHeight(null) - 1);
    }

    public void drawRectangle(Color c, Rectangle rect, int thickness) {
        Graphics g = this.image.getGraphics();
        Graphics2D g2d = (Graphics2D)g;
        BasicStroke stroke = new BasicStroke(thickness);
        g2d.setStroke(stroke);
        g.setColor(c);
        g.drawRect(rect.x, rect.y, rect.width, rect.height);
    }

    public void fillRectangle(Color c, Rectangle rect) {
        Graphics g = this.image.getGraphics();
        g.setColor(c);
        g.fillRect(rect.x, rect.y, rect.width, rect.height);
    }

    public void drawOval(Color c, Rectangle rect, int thickness) {
        Graphics g = this.image.getGraphics();
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        BasicStroke stroke = new BasicStroke(thickness);
        g2d.setStroke(stroke);
        g.setColor(c);
        g.drawOval(rect.x, rect.y, rect.width, rect.height);
    }

    public void drawText(String text, Color color, Point start, float size) {
        Graphics g = this.image.getGraphics();
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        Font font = g.getFont();
        g.setFont(font.deriveFont(size));
        g.setColor(color);
        g.drawString(text, start.x, start.y);
    }

    public void drawText(String text, Color color, Point start, Font font) {
        Graphics g = this.image.getGraphics();
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setColor(color);
        g.setFont(font);
        g.drawString(text, start.x, start.y);
    }

    public void drawLine(Color c, int thickness, Point start, Point end) {
        Graphics g = this.image.getGraphics();
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        BasicStroke stroke = new BasicStroke(thickness);
        g2d.setStroke(stroke);
        g.setColor(c);
        g.drawLine(start.x, start.y, end.x, end.y);
    }

    public void drawArrow(Color c, Point start, Point end) {
        this.drawArrow(c, 3, start, end, 12);
    }

    public void drawArrow(Color c, int thickness, Point start, Point end, int arrowSize) {
        Graphics g = this.image.getGraphics();
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        BasicStroke stroke = new BasicStroke(thickness);
        g2d.setStroke(stroke);
        g.setColor(c);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double unitX = 0.0;
        double unitY = 0.0;
        if (end.x == start.x) {
            unitY = 1.0;
        } else if (end.y == start.y) {
            unitX = 1.0;
        } else {
            double slope = ((double)end.y - (double)start.y) / ((double)end.x - (double)start.x);
            double crossSlope = 1.0 / slope;
            unitX = Math.sqrt(1.0 / (slope * slope + 1.0));
            unitY = Math.sqrt(1.0 / (crossSlope * crossSlope + 1.0));
        }
        if (end.x < start.x) {
            unitX = -unitX;
        }
        if (end.y < start.y) {
            unitY = -unitY;
        }
        int crossx = end.x - (int)(unitX * (double)arrowSize);
        int crossy = end.y - (int)(unitY * (double)arrowSize);
        g.drawLine(start.x, start.y, crossx, crossy);
        int arrow1x = crossx - (int)(unitY * (double)arrowSize);
        int arrow1y = crossy + (int)(unitX * (double)arrowSize);
        int arrow2x = crossx + (int)(unitY * (double)arrowSize);
        int arrow2y = crossy - (int)(unitX * (double)arrowSize);
        Polygon p = new Polygon();
        p.addPoint(end.x, end.y);
        p.addPoint(arrow1x, arrow1y);
        p.addPoint(arrow2x, arrow2y);
        g.fillPolygon(p);
    }

    protected void writeFile(File imageFile) {
        try {
            AbstractScreenShotGenerator.writeImage((Image)this.image, (File)imageFile);
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    protected BufferedImage readImage(File imageFile) {
        try {
            return ImageUtils.readFile((File)imageFile);
        }
        catch (IOException e) {
            this.error(e);
            return null;
        }
    }

    public Image crop(Rectangle bounds) {
        this.image = ImageUtils.crop((Image)this.image, (Rectangle)bounds);
        return this.image;
    }

    public Image padImage(Color c, int top, int left, int right, int bottom) {
        this.image = ImageUtils.padImage((Image)this.image, (Color)c, (int)top, (int)left, (int)right, (int)bottom);
        return this.image;
    }

    public Image placeImagesSideBySide(Image left, Image right) {
        this.image = ImageUtils.placeImagesSideBySide((Image)left, (Image)right);
        return this.image;
    }

    public BufferedImage createEmptyImage(int width, int height) {
        return ImageUtils.createEmptyImage((int)width, (int)height);
    }

    public Image takeSnippet(Rectangle bounds) {
        int margin = 20;
        int topMargin = 4;
        this.padImage(Color.WHITE, 0, margin, 0, margin);
        int rise = 8;
        bounds.width += 2 * margin;
        GeneralPath topPath = new GeneralPath();
        GeneralPath bottomPath = new GeneralPath();
        GeneralPath path = new GeneralPath();
        int centerx = bounds.x + bounds.width / 2;
        topPath.moveTo(0.0f, rise + topMargin);
        topPath.lineTo(centerx, topMargin);
        topPath.lineTo(centerx - rise, 2 * rise + topMargin);
        topPath.lineTo(bounds.width, rise + topMargin);
        bottomPath.moveTo(bounds.width, bounds.height + 3 * rise + topMargin);
        bottomPath.lineTo(centerx - rise, bounds.height + 4 * rise + topMargin);
        bottomPath.lineTo(centerx, bounds.height + 2 * rise + topMargin);
        bottomPath.lineTo(0.0f, bounds.height + 3 * rise + topMargin);
        path.append(topPath, true);
        path.append(bottomPath, true);
        path.closePath();
        bounds.y -= 2 * rise + topMargin;
        bounds.height += 4 * rise + 2 * topMargin;
        this.crop(path, bounds);
        Graphics2D g2 = (Graphics2D)this.image.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.BLACK);
        g2.setStroke(new BasicStroke(3.0f));
        g2.draw(topPath);
        g2.draw(bottomPath);
        return this.image;
    }

    private void crop(Shape shape, Rectangle bounds) {
        BufferedImage newImage = this.createEmptyImage(bounds.width, bounds.height);
        Graphics2D g2 = (Graphics2D)newImage.getGraphics();
        g2.setClip(shape);
        g2.translate(-bounds.x, -bounds.y);
        g2.drawImage(this.image, 0, 0, null);
        this.image = newImage;
    }

    public void setDividerPercentage(Class<? extends ComponentProvider> provider1, Class<? extends ComponentProvider> provider2, float percentage) {
        AbstractScreenShotGenerator.runSwing(() -> {
            Object splitNode = this.findSplitNode(provider1, provider2);
            SplitPanel splitPanel = (SplitPanel)AbstractScreenShotGenerator.getInstanceField((String)"splitPane", (Object)splitNode);
            splitPanel.setDividerPosition(percentage);
        });
    }

    private Object findSplitNode(Class<? extends ComponentProvider> provider1, Class<? extends ComponentProvider> provider2) {
        DockingWindowManager windowMgr = DockingWindowManager.getActiveInstance();
        Object rootNode = AbstractScreenShotGenerator.getInstanceField((String)"root", (Object)windowMgr);
        List<Object> nodePath1 = this.findNodePath(rootNode, provider1);
        List<Object> nodePath2 = this.findNodePath(rootNode, provider2);
        for (int i = 0; i < nodePath1.size(); ++i) {
            Object n2;
            Object n1 = nodePath1.get(i);
            if (n1 == (n2 = nodePath2.get(i))) continue;
            return nodePath1.get(i - 1);
        }
        return null;
    }

    private List<Object> findNodePath(Object rootNode, Class<? extends ComponentProvider> providerClass) {
        Object node = AbstractScreenShotGenerator.getInstanceField((String)"child", (Object)rootNode);
        Object resultNode = this.findNode(node, providerClass);
        ArrayList<Object> list = new ArrayList<Object>();
        Object n = resultNode;
        while (n != null) {
            list.add(n);
            n = AbstractScreenShotGenerator.getInstanceField((String)"parent", (Object)n);
        }
        Collections.reverse(list);
        return list;
    }

    private Object findNode(Object node, Class<? extends ComponentProvider> providerClass) {
        if ("SplitNode".equals(node.getClass().getSimpleName())) {
            Object child1 = AbstractScreenShotGenerator.getInstanceField((String)"child1", (Object)node);
            Object resultNode = this.findNode(child1, providerClass);
            if (resultNode != null) {
                return resultNode;
            }
            Object child2 = AbstractScreenShotGenerator.getInstanceField((String)"child2", (Object)node);
            return this.findNode(child2, providerClass);
        }
        Object placeHolder = AbstractScreenShotGenerator.getInstanceField((String)"top", (Object)node);
        Object componentProvider = AbstractScreenShotGenerator.getInstanceField((String)"componentProvider", (Object)placeHolder);
        if (componentProvider != null && componentProvider.getClass() == providerClass) {
            return node;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends JComponent> T findChildWithType(Container node, Class<T> cls, Predicate<T> pred) {
        Object object = node.getTreeLock();
        synchronized (object) {
            if (cls.isInstance(node)) {
                JComponent potential = (JComponent)cls.cast(node);
                if (pred == null || pred.test(potential)) {
                    return (T)potential;
                }
            }
            for (Component child : node.getComponents()) {
                if (!(child instanceof Container)) {
                    return null;
                }
                Container cont = (Container)child;
                T found = this.findChildWithType(cont, cls, pred);
                if (found == null) continue;
                return (T)((JComponent)cls.cast(found));
            }
        }
        return null;
    }

    public <T extends JComponent> T findComponent(Class<T> cls, Predicate<T> pred) {
        DialogComponentProvider dialog = this.getDialog();
        AtomicReference result = new AtomicReference();
        AbstractScreenShotGenerator.runSwing(() -> {
            JComponent top = dialog.getComponent();
            result.set(this.findChildWithType(top, cls, pred));
        });
        AbstractScreenShotGenerator.waitForSwing();
        return (T)((JComponent)result.get());
    }

    public Component showTab(String title) {
        DialogComponentProvider dialog = this.getDialog();
        AtomicReference result = new AtomicReference();
        AbstractScreenShotGenerator.runSwing(() -> {
            JComponent top = dialog.getComponent();
            JTabbedPane tabs = this.findChildWithType(top, JTabbedPane.class, null);
            if (tabs == null) {
                throw new IllegalStateException("No tab pane is present in current dialog");
            }
            int index = tabs.indexOfTab(title);
            if (index == -1) {
                throw new IllegalStateException("No such tab by title: " + title);
            }
            tabs.setSelectedIndex(index);
            result.set(tabs.getSelectedComponent());
        });
        AbstractScreenShotGenerator.waitForSwing();
        return (Component)result.get();
    }

    static {
        System.setProperty("user.name", "User-1");
        SAVE_CREATED_IMAGE_FILE = Boolean.parseBoolean(System.getProperty(SAVE_CREATED_IMAGE_FILE_KEY, Boolean.FALSE.toString()));
        NEW_FILENAME_SUFFIX = System.getProperty(NEW_FILENAME_SUFFIX_KEY, DEFAULT_FILENAME_SUFFIX);
    }
}

