/*
 * Decompiled with CFR 0.152.
 */
package ghidra.formats.gfilesystem;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.RandomAccessByteProvider;
import ghidra.formats.gfilesystem.DerivedFileProducer;
import ghidra.formats.gfilesystem.DerivedFilePushProducer;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileCache;
import ghidra.formats.gfilesystem.FileCacheEntry;
import ghidra.formats.gfilesystem.FileCacheNameIndex;
import ghidra.formats.gfilesystem.FileFingerprintCache;
import ghidra.formats.gfilesystem.FileSystemCache;
import ghidra.formats.gfilesystem.FileSystemProbeConflictResolver;
import ghidra.formats.gfilesystem.FileSystemRef;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.LocalFileSystem;
import ghidra.formats.gfilesystem.LocalFileSystemSub;
import ghidra.formats.gfilesystem.RefdFile;
import ghidra.formats.gfilesystem.factory.FileSystemFactoryMgr;
import ghidra.framework.Application;
import ghidra.util.Msg;
import ghidra.util.datastruct.FixedSizeHashMap;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.timer.GTimer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

public class FileSystemService {
    private static int FSRL_INTERN_SIZE = 1000;
    private static FileSystemService instance;
    private final LocalFileSystem localFS = LocalFileSystem.makeGlobalRootFS();
    private final FSRLRoot localFSRL = this.localFS.getFSRL();
    private final FileSystemFactoryMgr fsFactoryMgr = FileSystemFactoryMgr.getInstance();
    private FileCache fileCache;
    private FileSystemCache filesystemCache = new FileSystemCache(this.localFS);
    private FileCacheNameIndex fileCacheNameIndex = new FileCacheNameIndex();
    private FileFingerprintCache fileFingerprintCache = new FileFingerprintCache();
    private long fsCacheMaintIntervalMS = 10000L;
    private FixedSizeHashMap<FSRLRoot, FSRLRoot> fsrlInternMap = new FixedSizeHashMap(FSRL_INTERN_SIZE, FSRL_INTERN_SIZE);

    public static synchronized FileSystemService getInstance() {
        if (instance == null) {
            instance = new FileSystemService();
        }
        return instance;
    }

    public static synchronized boolean isInitialized() {
        return instance != null;
    }

    public FileSystemService() {
        this(new File(Application.getUserCacheDirectory(), "fscache"));
    }

    public FileSystemService(File fscacheDir) {
        try {
            this.fileCache = new FileCache(fscacheDir);
            GTimer.scheduleRepeatingRunnable((long)this.fsCacheMaintIntervalMS, (long)this.fsCacheMaintIntervalMS, () -> this.filesystemCache.cacheMaint());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to init global cache " + fscacheDir, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        FileSystemCache fileSystemCache = this.filesystemCache;
        synchronized (fileSystemCache) {
            this.filesystemCache.clear();
            this.fsrlInternMap.clear();
            this.fileCacheNameIndex.clear();
        }
    }

    public void closeUnusedFileSystems() {
        this.filesystemCache.closeAllUnused();
    }

    public GFileSystem getLocalFS() {
        return this.localFS;
    }

    public boolean isFilesystemMountedAt(FSRL fsrl) {
        return this.filesystemCache.isFilesystemMountedAt(fsrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefdFile getRefdFile(FSRL fsrl, TaskMonitor monitor) throws CancelledException, IOException {
        FSRLRoot fsRoot = fsrl.getFS();
        try (FileSystemRef ref = this.getFilesystem(fsRoot, monitor);){
            GFile gfile = ref.getFilesystem().lookup(fsrl.getPath());
            if (gfile == null) {
                throw new IOException("File [" + fsrl + "] not found in filesystem [" + ref.getFilesystem().getFSRL() + "]");
            }
            RefdFile result = new RefdFile(ref, gfile);
            ref = null;
            RefdFile refdFile = result;
            return refdFile;
        }
    }

    private FileCacheEntry getCacheFile(FSRL fsrl, TaskMonitor monitor) throws IOException, CancelledException {
        FileCacheEntry result;
        File f;
        if (fsrl.getPath() == null) {
            throw new IOException("Invalid FSRL specified: " + fsrl);
        }
        String md5 = fsrl.getMD5();
        if (md5 == null && fsrl.getNestingDepth() == 1 && (f = this.localFS.getLocalFile(fsrl)).isFile()) {
            md5 = this.fileFingerprintCache.getMD5(f.getPath(), f.lastModified(), f.length());
        }
        FSRLRoot fsRoot = fsrl.getFS();
        FileCacheEntry fileCacheEntry = result = md5 != null ? this.fileCache.getFile(md5) : null;
        if (result == null) {
            try (FileSystemRef ref = this.getFilesystem(fsRoot, monitor);){
                File f2;
                GFileSystem fs = ref.getFilesystem();
                GFile gfile = fs.lookup(fsrl.getPath());
                if (gfile == null) {
                    throw new IOException("File [" + fsrl + "] not found in filesystem [" + fs.getFSRL() + "]");
                }
                if (gfile.getFSRL().getMD5() != null && (result = this.fileCache.getFile(gfile.getFSRL().getMD5())) != null) {
                    FileCacheEntry fileCacheEntry2 = result;
                    return fileCacheEntry2;
                }
                try (InputStream dataStream = fs.getInputStream(gfile, monitor);){
                    if (dataStream == null) {
                        throw new IOException("Unable to get datastream for " + fsrl);
                    }
                    monitor.setMessage("Caching " + gfile.getName());
                    monitor.initialize(gfile.getLength());
                    result = this.fileCache.addStream(dataStream, monitor);
                    if (md5 != null && !md5.equals(result.md5)) {
                        throw new IOException("Error reading file, MD5 has changed: " + fsrl + ", md5 now " + result.md5);
                    }
                }
                if (fsrl.getNestingDepth() == 1 && (f2 = this.localFS.getLocalFile(fsrl)).isFile()) {
                    this.fileFingerprintCache.add(f2.getPath(), result.md5, f2.lastModified(), f2.length());
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileSystemRef getFilesystem(FSRLRoot fsFSRL, TaskMonitor monitor) throws IOException, CancelledException {
        FileSystemCache fileSystemCache = this.filesystemCache;
        synchronized (fileSystemCache) {
            FileSystemRef ref = this.filesystemCache.getRef(fsFSRL);
            if (ref == null) {
                if (!fsFSRL.hasContainer()) {
                    throw new IOException("Bad FSRL " + fsFSRL);
                }
                fsFSRL = this.intern(fsFSRL);
                FSRL containerFSRL = fsFSRL.getContainer();
                FileCacheEntry cfi = this.getCacheFile(containerFSRL, monitor);
                if (containerFSRL.getMD5() == null) {
                    containerFSRL = containerFSRL.withMD5(cfi.md5);
                }
                GFileSystem fs = FileSystemFactoryMgr.getInstance().mountFileSystem(fsFSRL.getProtocol(), containerFSRL, cfi.file, this, monitor);
                ref = fs.getRefManager().create();
                this.filesystemCache.add(fs);
            }
            return ref;
        }
    }

    public FileCacheEntry addFileToCache(GFile file, InputStream is, TaskMonitor monitor) throws IOException, CancelledException {
        FileCacheEntry fce = this.fileCache.addStream(is, monitor);
        return fce;
    }

    public FileCacheEntry addStreamToCache(InputStream is, TaskMonitor monitor) throws IOException, CancelledException {
        FileCacheEntry fce = this.fileCache.addStream(is, monitor);
        return fce;
    }

    public File getFile(FSRL fsrl, TaskMonitor monitor) throws CancelledException, IOException {
        if (fsrl.getNestingDepth() == 1) {
            File f = this.localFS.getLocalFile(fsrl);
            if (f.isFile() && fsrl.getMD5() != null && !this.fileFingerprintCache.contains(f.getPath(), fsrl.getMD5(), f.lastModified(), f.length())) {
                String fileMD5 = FSUtilities.getFileMD5(f, monitor);
                if (!fsrl.getMD5().equals(fileMD5)) {
                    throw new IOException("Exact file no longer exists: " + f.getPath() + " contents have changed, old md5: " + fsrl.getMD5() + ", new md5: " + fileMD5);
                }
                this.fileFingerprintCache.add(f.getPath(), fileMD5, f.lastModified(), f.length());
            }
            return f;
        }
        FileCacheEntry fce = this.getCacheFile(fsrl, monitor);
        return fce.file;
    }

    private String getMD5(FSRL fsrl, TaskMonitor monitor) throws CancelledException, IOException {
        if (fsrl.getNestingDepth() == 1) {
            File f = this.localFS.getLocalFile(fsrl);
            if (!f.isFile()) {
                return null;
            }
            String md5 = this.fileFingerprintCache.getMD5(f.getPath(), f.lastModified(), f.length());
            if (md5 == null) {
                md5 = FSUtilities.getFileMD5(f, monitor);
                this.fileFingerprintCache.add(f.getPath(), md5, f.lastModified(), f.length());
            }
            return md5;
        }
        FileCacheEntry fce = this.getCacheFile(fsrl, monitor);
        return fce.md5;
    }

    public FSRL getLocalFSRL(File f) {
        return this.localFS.getFSRL().withPath(FSUtilities.appendPath("/", FilenameUtils.separatorsToUnix((String)f.getPath())));
    }

    public GFile getLocalGFile(File f) {
        try {
            return this.localFS.lookup(f.getPath());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public ByteProvider getByteProvider(FSRL fsrl, TaskMonitor monitor) throws CancelledException, IOException {
        File file = this.getFile(fsrl, monitor);
        RandomAccessByteProvider rabp = new RandomAccessByteProvider(file, fsrl);
        return rabp;
    }

    public FileCacheEntry getDerivedFile(FSRL fsrl, String derivedName, DerivedFileProducer producer, TaskMonitor monitor) throws CancelledException, IOException {
        FileCacheEntry derivedFile;
        FileCacheEntry cacheEntry = this.getCacheFile(fsrl, monitor);
        String derivedMD5 = this.fileCacheNameIndex.get(cacheEntry.md5, derivedName);
        FileCacheEntry fileCacheEntry = derivedFile = derivedMD5 != null ? this.fileCache.getFile(derivedMD5) : null;
        if (derivedFile == null) {
            monitor.setMessage(derivedName + " " + fsrl.getName());
            try (InputStream is = producer.produceDerivedStream(cacheEntry.file);){
                derivedFile = this.fileCache.addStream(is, monitor);
                this.fileCacheNameIndex.add(cacheEntry.md5, derivedName, derivedFile.md5);
            }
        }
        return derivedFile;
    }

    public FileCacheEntry getDerivedFilePush(FSRL fsrl, String derivedName, DerivedFilePushProducer pusher, TaskMonitor monitor) throws CancelledException, IOException {
        FileCacheEntry derivedFile;
        FileCacheEntry cacheEntry = this.getCacheFile(fsrl, monitor);
        String derivedMD5 = this.fileCacheNameIndex.get(cacheEntry.md5, derivedName);
        FileCacheEntry fileCacheEntry = derivedFile = derivedMD5 != null ? this.fileCache.getFile(derivedMD5) : null;
        if (derivedFile == null) {
            monitor.setMessage("Caching " + fsrl.getName() + " " + derivedName);
            derivedFile = this.fileCache.pushStream(pusher, monitor);
            this.fileCacheNameIndex.add(cacheEntry.md5, derivedName, derivedFile.md5);
        }
        return derivedFile;
    }

    public boolean hasDerivedFile(FSRL fsrl, String derivedName, TaskMonitor monitor) throws CancelledException, IOException {
        FileCacheEntry cacheEntry = this.getCacheFile(fsrl, monitor);
        String derivedMD5 = this.fileCacheNameIndex.get(cacheEntry.md5, derivedName);
        return derivedMD5 != null;
    }

    public boolean isFileFilesystemContainer(FSRL containerFSRL, TaskMonitor monitor) throws CancelledException, IOException {
        File containerFile = this.getFile(containerFSRL, monitor);
        return this.fsFactoryMgr.test(containerFSRL, containerFile, this, monitor);
    }

    public FileSystemRef probeFileForFilesystem(FSRL containerFSRL, TaskMonitor monitor, FileSystemProbeConflictResolver conflictResolver) throws CancelledException, IOException {
        return this.probeFileForFilesystem(containerFSRL, monitor, conflictResolver, Integer.MIN_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileSystemRef probeFileForFilesystem(FSRL containerFSRL, TaskMonitor monitor, FileSystemProbeConflictResolver conflictResolver, int priorityFilter) throws CancelledException, IOException {
        containerFSRL = this.getFullyQualifiedFSRL(containerFSRL, monitor);
        FileSystemCache fileSystemCache = this.filesystemCache;
        synchronized (fileSystemCache) {
            containerFSRL = this.intern(containerFSRL);
            FileSystemRef ref = this.filesystemCache.getFilesystemRefMountedAt(containerFSRL);
            if (ref != null) {
                return ref;
            }
            if (this.localFS.isLocalSubdir(containerFSRL)) {
                try {
                    File localDir = new File(containerFSRL.getPath());
                    LocalFileSystemSub fs = new LocalFileSystemSub(localDir, this.getLocalFS());
                    ref = fs.getRefManager().create();
                    this.filesystemCache.add(fs);
                    return ref;
                }
                catch (IOException e) {
                    Msg.error((Object)this, (Object)"Problem when probing for local directory: ", (Throwable)e);
                    return null;
                }
            }
        }
        File containerFile = this.getFile(containerFSRL, monitor);
        try {
            GFileSystem fs = this.fsFactoryMgr.probe(containerFSRL, containerFile, this, conflictResolver, priorityFilter, monitor);
            if (fs != null) {
                FileSystemCache fileSystemCache2 = this.filesystemCache;
                synchronized (fileSystemCache2) {
                    FileSystemRef fsRef = this.filesystemCache.getFilesystemRefMountedAt(fs.getFSRL());
                    if (fsRef != null) {
                        fs.close();
                        return fsRef;
                    }
                    this.filesystemCache.add(fs);
                    return fs.getRefManager().create();
                }
            }
        }
        catch (IOException ioe) {
            Msg.trace((Object)this, (Object)"Probe exception", (Throwable)ioe);
            throw ioe;
        }
        return null;
    }

    public <FSTYPE extends GFileSystem> FSTYPE mountSpecificFileSystem(FSRL containerFSRL, Class<FSTYPE> fsClass, TaskMonitor monitor) throws CancelledException, IOException {
        containerFSRL = this.getFullyQualifiedFSRL(containerFSRL, monitor);
        File containerFile = this.getFile(containerFSRL, monitor);
        String fsType = this.fsFactoryMgr.getFileSystemType(fsClass);
        if (fsType == null) {
            Msg.error((Object)this, (Object)("Specific file system implemention " + fsClass.getName() + " not registered correctly in file system factory."));
            return null;
        }
        GFileSystem fs = this.fsFactoryMgr.mountFileSystem(fsType, containerFSRL, containerFile, this, monitor);
        Class<?> producedClass = fs.getClass();
        if (!fsClass.isAssignableFrom(fs.getClass())) {
            fs.close();
            throw new IOException("Bad file system type returned by factory. Expecting " + fsClass.getName() + " but factory produced " + producedClass.getName());
        }
        return (FSTYPE)((GFileSystem)fsClass.cast(fs));
    }

    public GFileSystem openFileSystemContainer(FSRL containerFSRL, TaskMonitor monitor) throws CancelledException, IOException {
        if (this.localFS.isLocalSubdir(containerFSRL)) {
            File localDir = this.localFS.getLocalFile(containerFSRL);
            return new LocalFileSystemSub(localDir, this.localFS);
        }
        File containerFile = this.getFile(containerFSRL, monitor);
        return this.fsFactoryMgr.probe(containerFSRL, containerFile, this, null, Integer.MIN_VALUE, monitor);
    }

    public FSRL getFullyQualifiedFSRL(FSRL fsrl, TaskMonitor monitor) throws CancelledException, IOException {
        FSRL resultFSRL;
        if (fsrl == null) {
            return null;
        }
        FSRL fqParentContainer = this.getFullyQualifiedFSRL(fsrl.getFS().getContainer(), monitor);
        FSRL fSRL = resultFSRL = fqParentContainer != fsrl.getFS().getContainer() ? FSRLRoot.nestedFS(fqParentContainer, fsrl.getFS()).withPath(fsrl) : fsrl;
        if (resultFSRL.getMD5() == null) {
            String md5 = null;
            if (fqParentContainer != null) {
                md5 = this.fileCacheNameIndex.get(fqParentContainer.getMD5(), resultFSRL.getPath());
            }
            if (md5 == null) {
                try {
                    md5 = this.getMD5(resultFSRL, monitor);
                    if (fqParentContainer != null) {
                        this.fileCacheNameIndex.add(fqParentContainer.getMD5(), resultFSRL.getPath(), md5);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (md5 != null) {
                resultFSRL = resultFSRL.withMD5(md5);
            }
        }
        return resultFSRL;
    }

    public boolean isLocal(GFile gfile) {
        return !gfile.getFSRL().getFS().hasContainer();
    }

    public boolean isLocal(FSRL fsrl) {
        return !fsrl.getFS().hasContainer();
    }

    public String getFileHash(GFile gfile, TaskMonitor monitor) throws CancelledException, IOException {
        if (this.isLocal(gfile)) {
            File f = this.localFS.getLocalFile(gfile.getFSRL());
            if (f.isFile()) {
                return FSUtilities.getFileMD5(f, monitor);
            }
        } else {
            try (InputStream dataStream = gfile.getFilesystem().getInputStream(gfile, monitor);){
                if (dataStream == null) {
                    throw new IOException("Unable to get datastream for " + gfile.getFSRL());
                }
                monitor.setMessage("Caching " + gfile.getName());
                monitor.initialize(gfile.getLength());
                FileCacheEntry cfi = this.fileCache.addStream(dataStream, monitor);
                String string = cfi.md5;
                return string;
            }
        }
        return null;
    }

    public List<String> getAllFilesystemNames() {
        return FileSystemFactoryMgr.getInstance().getAllFilesystemNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FSRLRoot> getMountedFilesystems() {
        FileSystemCache fileSystemCache = this.filesystemCache;
        synchronized (fileSystemCache) {
            return this.filesystemCache.getMountedFilesystems();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileSystemRef getMountedFilesystem(FSRLRoot fsFSRL) {
        FileSystemCache fileSystemCache = this.filesystemCache;
        synchronized (fileSystemCache) {
            return this.filesystemCache.getRef(fsFSRL);
        }
    }

    private FSRLRoot intern(FSRLRoot fsrl) {
        FSRLRoot existing;
        FSRLRoot parentFSRL;
        if (this.localFSRL.equals(fsrl)) {
            return this.localFSRL;
        }
        FSRL container = fsrl.getContainer();
        if (container != null && (parentFSRL = this.intern(container.getFS())) != container.getFS()) {
            FSRL internedContainer = parentFSRL.withPath(container);
            fsrl = FSRLRoot.nestedFS(internedContainer, fsrl);
        }
        if ((existing = (FSRLRoot)this.fsrlInternMap.get((Object)fsrl)) == null) {
            this.fsrlInternMap.put((Object)fsrl, (Object)fsrl);
            existing = fsrl;
        }
        return existing;
    }

    private FSRL intern(FSRL fsrl) {
        FSRLRoot internedRoot = this.intern(fsrl.getFS());
        return internedRoot == fsrl.getFS() ? fsrl : internedRoot.withPath(fsrl);
    }
}

