/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.datatype.microsoft;

import ghidra.app.util.bin.BinaryReader;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.Conv;
import ghidra.util.DataConverter;
import ghidra.util.NumericUtilities;
import java.io.IOException;
import java.util.Arrays;

public class GUID {
    public static final int SIZEOF = 16;
    private int data1;
    private short data2;
    private short data3;
    private byte[] data4 = new byte[8];

    public GUID(String guidString) {
        if (guidString.length() != 36) {
            throw new IllegalArgumentException("Invalid GUID string.");
        }
        int pos = guidString.indexOf(45);
        if (pos == -1) {
            throw new IllegalArgumentException("Invalid GUID string.");
        }
        this.data1 = (int)NumericUtilities.parseHexLong((String)guidString.substring(0, pos));
        if ((pos = (guidString = guidString.substring(pos + 1)).indexOf(45)) == -1) {
            throw new IllegalArgumentException("Invalid GUID string.");
        }
        this.data2 = (short)Integer.parseInt(guidString.substring(0, pos), 16);
        if ((pos = (guidString = guidString.substring(pos + 1)).indexOf(45)) == -1) {
            throw new IllegalArgumentException("Invalid GUID string.");
        }
        this.data3 = (short)Integer.parseInt(guidString.substring(0, pos), 16);
        if ((pos = (guidString = guidString.substring(pos + 1)).indexOf(45)) == -1) {
            throw new IllegalArgumentException("Invalid GUID string.");
        }
        int value = Integer.parseInt(guidString.substring(0, pos), 16);
        this.data4[0] = (byte)(value >> 8);
        this.data4[1] = (byte)(value & 0xFF);
        guidString = guidString.substring(pos + 1);
        this.data4[2] = (byte)Integer.parseInt(guidString.substring(0, 2), 16);
        guidString = guidString.substring(2);
        this.data4[3] = (byte)Integer.parseInt(guidString.substring(0, 2), 16);
        guidString = guidString.substring(2);
        this.data4[4] = (byte)Integer.parseInt(guidString.substring(0, 2), 16);
        guidString = guidString.substring(2);
        this.data4[5] = (byte)Integer.parseInt(guidString.substring(0, 2), 16);
        guidString = guidString.substring(2);
        this.data4[6] = (byte)Integer.parseInt(guidString.substring(0, 2), 16);
        guidString = guidString.substring(2);
        this.data4[7] = (byte)Integer.parseInt(guidString.substring(0, 2), 16);
    }

    public GUID(int data1, short data2, short data3, byte[] data4) {
        this.data1 = data1;
        this.data2 = data2;
        this.data3 = data3;
        this.data4 = data4;
    }

    public GUID(BinaryReader reader) throws IOException {
        this.data1 = reader.readNextInt();
        this.data2 = reader.readNextShort();
        this.data3 = reader.readNextShort();
        this.data4 = reader.readNextByteArray(8);
    }

    public GUID(MemBuffer buf) throws MemoryAccessException {
        int i;
        byte[] data1bytes = new byte[4];
        byte[] data2bytes = new byte[2];
        byte[] data3bytes = new byte[2];
        byte[] data4bytes = new byte[8];
        int offset = 0;
        for (i = 0; i < data1bytes.length; ++i) {
            data1bytes[i] = buf.getByte(offset++);
        }
        for (i = 0; i < data2bytes.length; ++i) {
            data2bytes[i] = buf.getByte(offset++);
        }
        for (i = 0; i < data3bytes.length; ++i) {
            data3bytes[i] = buf.getByte(offset++);
        }
        for (i = 0; i < data4bytes.length; ++i) {
            data4bytes[i] = buf.getByte(offset++);
        }
        DataConverter dc = this.getDataConverter(buf);
        this.data1 = dc.getInt(data1bytes);
        this.data2 = dc.getShort(data2bytes);
        this.data3 = dc.getShort(data3bytes);
        this.data4 = data4bytes;
    }

    private DataConverter getDataConverter(MemBuffer buf) {
        return DataConverter.getInstance((boolean)buf.isBigEndian());
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Conv.toHexString((int)this.data1));
        buffer.append("-");
        buffer.append(Conv.toHexString((short)this.data2));
        buffer.append("-");
        buffer.append(Conv.toHexString((short)this.data3));
        buffer.append("-");
        buffer.append(Conv.toHexString((byte)this.data4[0]));
        buffer.append(Conv.toHexString((byte)this.data4[1]));
        buffer.append("-");
        buffer.append(Conv.toHexString((byte)this.data4[2]));
        buffer.append(Conv.toHexString((byte)this.data4[3]));
        buffer.append(Conv.toHexString((byte)this.data4[4]));
        buffer.append(Conv.toHexString((byte)this.data4[5]));
        buffer.append(Conv.toHexString((byte)this.data4[6]));
        buffer.append(Conv.toHexString((byte)this.data4[7]));
        return buffer.toString();
    }

    public int getData1() {
        return this.data1;
    }

    public short getData2() {
        return this.data2;
    }

    public short getData3() {
        return this.data3;
    }

    public byte[] getData4() {
        return this.data4;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.data1;
        result = 31 * result + this.data2;
        result = 31 * result + this.data3;
        result = 31 * result + Arrays.hashCode(this.data4);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GUID other = (GUID)obj;
        if (this.data1 != other.data1) {
            return false;
        }
        if (this.data2 != other.data2) {
            return false;
        }
        if (this.data3 != other.data3) {
            return false;
        }
        return Arrays.equals(this.data4, other.data4);
    }
}

