/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.rich;

import ghidra.app.util.bin.format.pe.rich.CompId;
import ghidra.app.util.bin.format.pe.rich.MSRichProductBuildNumberDataType;
import ghidra.app.util.bin.format.pe.rich.MSRichProductIDDataType;
import ghidra.docking.settings.Settings;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.mem.MemBuffer;

class MSRichProductInfoDataType
extends StructureDataType {
    private final CompId compid;

    public MSRichProductInfoDataType(CompId compid) {
        this(compid, null);
    }

    public MSRichProductInfoDataType(CompId compid, DataTypeManager dtm) {
        super(new CategoryPath("/PE"), "ProductInfo", 0, dtm);
        this.compid = compid;
        this.initialize();
    }

    public boolean isDynamicallySized() {
        return false;
    }

    public MSRichProductInfoDataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new MSRichProductInfoDataType(this.compid, dtm);
    }

    public String getMnemonic(Settings settings) {
        return "Product Info";
    }

    public int getLength() {
        return 4;
    }

    public String getDescription() {
        return "Product Info";
    }

    public Object getValue(MemBuffer buf, Settings settings, int length) {
        return this.compid;
    }

    private void initialize() {
        this.add((DataType)new MSRichProductIDDataType(this.compid), 2, "product", null);
        this.add((DataType)new MSRichProductBuildNumberDataType(this.compid), 2, "buildNumber", null);
    }
}

