/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.blobs;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig;
import ghidra.app.util.bin.format.pe.cli.blobs.CliBlob;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;

public class CliSigProperty
extends CliAbstractSig {
    private int sizeOfCount;
    private CliAbstractSig.CliRetType returnType;
    private CliAbstractSig.CliParam[] params;

    public CliSigProperty(CliBlob blob) throws IOException {
        super(blob);
        BinaryReader reader = this.getContentsReader();
        byte firstByte = reader.readNextByte();
        if ((firstByte & 8) != 8) {
            return;
        }
        long origIndex = reader.getPointerIndex();
        int paramsCount = CliSigProperty.decodeCompressedUnsignedInt(reader);
        this.sizeOfCount = (int)(reader.getPointerIndex() - origIndex);
        try {
            this.returnType = new CliAbstractSig.CliRetType(this, reader);
        }
        catch (InvalidInputException e) {
            this.returnType = null;
        }
        this.params = new CliAbstractSig.CliParam[paramsCount];
        for (int i = 0; i < paramsCount; ++i) {
            try {
                this.params[i] = new CliAbstractSig.CliParam(this, reader);
                continue;
            }
            catch (InvalidInputException e) {
                this.params[i] = null;
                e.printStackTrace();
            }
        }
    }

    @Override
    public String getContentsName() {
        return "PropertySig";
    }

    @Override
    public String getContentsComment() {
        return "Contains signature for properties. Gives params for getters/setters.";
    }

    @Override
    public DataType getContentsDataType() {
        StructureDataType struct = new StructureDataType(new CategoryPath("/PE/CLI/Blobs/Signatures"), this.getName(), 0);
        struct.add(BYTE, "PROPERTY", "must be 0x08 or 0x28. ORed 0x20=HASTHIS and 0x08=PROPERTY");
        struct.add(CliSigProperty.getDataTypeForBytes(this.sizeOfCount), "Count", "Number of params to follow RetType");
        struct.add(this.returnType.getDefinitionDataType(), "RetType", "Return type");
        for (CliAbstractSig.CliParam param : this.params) {
            struct.add(param.getDefinitionDataType(), "Param", null);
        }
        return struct;
    }

    @Override
    public String getRepresentationCommon(CliStreamMetadata stream, boolean isShort) {
        Object paramsStr = "";
        for (CliAbstractSig.CliParam param : this.params) {
            paramsStr = (String)paramsStr + this.getRepresentationOf(param, stream, isShort) + ", ";
        }
        if (this.params.length > 0) {
            paramsStr = ((String)paramsStr).substring(0, ((String)paramsStr).length() - 2);
        }
        return String.format("%s get(%s)", this.getRepresentationOf(this.returnType, stream, isShort), paramsStr);
    }
}

