/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.blobs;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig;
import ghidra.app.util.bin.format.pe.cli.blobs.CliBlob;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.EnumDataType;
import ghidra.program.model.data.StructureDataType;
import java.io.IOException;

public class CliBlobMarshalSpec
extends CliBlob {
    private static final int INIT_VALUE = -1;
    private CliNativeType nativeIntrinsic;
    private CliNativeType arrayElemType;
    private int paramNum = -1;
    private int paramNumBytes;
    private int numElem = -1;
    private int numElemBytes;

    public CliBlobMarshalSpec(CliBlob blob) throws IOException {
        super(blob);
        BinaryReader reader = blob.getContentsReader();
        this.nativeIntrinsic = CliNativeType.fromInt(reader.readNextByte());
        if (this.nativeIntrinsic == CliNativeType.NATIVE_TYPE_ARRAY || this.nativeIntrinsic == CliNativeType.NATIVE_TYPE_FIXEDARRAY) {
            this.arrayElemType = CliNativeType.fromInt(reader.readNextByte());
            if (this.contentsSize > 2) {
                long origIndex = reader.getPointerIndex();
                this.paramNum = CliBlobMarshalSpec.decodeCompressedUnsignedInt(reader);
                this.paramNumBytes = (int)(reader.getPointerIndex() - origIndex);
                if (this.contentsSize > 2 + this.paramNumBytes) {
                    origIndex = reader.getPointerIndex();
                    this.numElem = CliBlobMarshalSpec.decodeCompressedUnsignedInt(reader);
                    this.numElemBytes = (int)(reader.getPointerIndex() - origIndex);
                }
            }
        }
    }

    @Override
    public DataType getContentsDataType() {
        StructureDataType struct = new StructureDataType(new CategoryPath("/PE/CLI/Blobs"), this.getName(), 0);
        struct.add((DataType)CliNativeTypeDataType.dataType, "NativeIntrinsic", "Type");
        if (this.arrayElemType != null) {
            struct.add((DataType)CliNativeTypeDataType.dataType, "ArrayElemTyp", null);
            if (this.paramNum != -1) {
                struct.add(CliBlobMarshalSpec.getDataTypeForBytes(this.paramNumBytes), "ParamNum", "which parameter provides number of elems for this array");
                if (this.numElem != -1) {
                    struct.add(CliBlobMarshalSpec.getDataTypeForBytes(this.numElemBytes), "NumElem", "number of elements or additional elements");
                }
            }
        }
        return struct;
    }

    @Override
    public String getContentsName() {
        return "MarshalSpec";
    }

    @Override
    public String getContentsComment() {
        return "Defines a native type for marshalling between managed/unmanaged code";
    }

    @Override
    public String getRepresentation() {
        return "Blob (" + this.getContentsDataType().getDisplayName() + ")";
    }

    public static class CliNativeTypeDataType
    extends EnumDataType {
        public static final CliNativeTypeDataType dataType = new CliNativeTypeDataType();

        public CliNativeTypeDataType() {
            super(new CategoryPath("/PE/CLI/Blobs"), "NativeType", 1);
            for (CliAbstractSig.CliElementType c : CliAbstractSig.CliElementType.values()) {
                this.add(c.toString(), c.id());
            }
        }
    }

    public static enum CliNativeType {
        NATIVE_TYPE_END(0),
        NATIVE_TYPE_VOID(1),
        NATIVE_TYPE_BOOLEAN(2),
        NATIVE_TYPE_I1(3),
        NATIVE_TYPE_U1(4),
        NATIVE_TYPE_I2(5),
        NATIVE_TYPE_U2(6),
        NATIVE_TYPE_I4(7),
        NATIVE_TYPE_U4(8),
        NATIVE_TYPE_I8(9),
        NATIVE_TYPE_U8(10),
        NATIVE_TYPE_R4(11),
        NATIVE_TYPE_R8(12),
        NATIVE_TYPE_SYSCHAR(13),
        NATIVE_TYPE_VARIANT(14),
        NATIVE_TYPE_CURRENCY(15),
        NATIVE_TYPE_PTR(16),
        NATIVE_TYPE_DECIMAL(17),
        NATIVE_TYPE_DATE(18),
        NATIVE_TYPE_BSTR(19),
        NATIVE_TYPE_LPSTR(20),
        NATIVE_TYPE_LPWSTR(21),
        NATIVE_TYPE_LPTSTR(22),
        NATIVE_TYPE_FIXEDSYSSTRING(23),
        NATIVE_TYPE_OBJECTREF(24),
        NATIVE_TYPE_IUNKNOWN(25),
        NATIVE_TYPE_IDISPATCH(26),
        NATIVE_TYPE_STRUCT(27),
        NATIVE_TYPE_INTF(28),
        NATIVE_TYPE_SAFEARRAY(29),
        NATIVE_TYPE_FIXEDARRAY(30),
        NATIVE_TYPE_INT(31),
        NATIVE_TYPE_UINT(32),
        NATIVE_TYPE_NESTEDSTRUCT(33),
        NATIVE_TYPE_BYVALSTR(34),
        NATIVE_TYPE_ANSIBSTR(35),
        NATIVE_TYPE_TBSTR(36),
        NATIVE_TYPE_VARIANTBOOL(37),
        NATIVE_TYPE_FUNC(38),
        NATIVE_TYPE_ASANY(40),
        NATIVE_TYPE_ARRAY(42),
        NATIVE_TYPE_LPSTRUCT(43),
        NATIVE_TYPE_CUSTOMMARSHALER(44),
        NATIVE_TYPE_ERROR(45),
        NATIVE_TYPE_IINSPECTABLE(46),
        NATIVE_TYPE_HSTRING(47),
        NATIVE_TYPE_MAX(80);

        private final int id;

        private CliNativeType(int id) {
            this.id = id;
        }

        public int id() {
            return this.id;
        }

        public static CliNativeType fromInt(int id) {
            CliNativeType[] values;
            for (CliNativeType value : values = CliNativeType.values()) {
                if (value.id != id) continue;
                return value;
            }
            return null;
        }
    }
}

