/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.pe.FileHeader;
import ghidra.app.util.bin.format.pe.InvalidNTHeaderException;
import ghidra.app.util.bin.format.pe.OffsetValidator;
import ghidra.app.util.bin.format.pe.OptionalHeader;
import ghidra.app.util.bin.format.pe.OptionalHeaderImpl;
import ghidra.app.util.bin.format.pe.PortableExecutable;
import ghidra.app.util.bin.format.pe.SectionHeader;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.DataConverter;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.NotYetImplementedException;
import ghidra.util.task.TaskMonitorAdapter;
import java.io.IOException;
import java.io.RandomAccessFile;

public class NTHeader
implements StructConverter,
OffsetValidator {
    public static final int SIZEOF_SIGNATURE = 4;
    public static final int MAX_SANE_COUNT = 65536;
    private int signature;
    private FileHeader fileHeader;
    private OptionalHeader optionalHeader;
    private FactoryBundledWithBinaryReader reader;
    private int index;
    private boolean advancedProcess = true;
    private boolean parseCliHeaders = false;
    private PortableExecutable.SectionLayout layout = PortableExecutable.SectionLayout.FILE;

    public static NTHeader createNTHeader(FactoryBundledWithBinaryReader reader, int index, PortableExecutable.SectionLayout layout, boolean advancedProcess, boolean parseCliHeaders) throws InvalidNTHeaderException, IOException {
        NTHeader ntHeader = (NTHeader)reader.getFactory().create(NTHeader.class, new Object[0]);
        ntHeader.initNTHeader(reader, index, layout, advancedProcess, parseCliHeaders);
        return ntHeader;
    }

    private void initNTHeader(FactoryBundledWithBinaryReader reader, int index, PortableExecutable.SectionLayout layout, boolean advancedProcess, boolean parseCliHeaders) throws InvalidNTHeaderException, IOException {
        this.reader = reader;
        this.index = index;
        this.layout = layout;
        this.advancedProcess = advancedProcess;
        this.parseCliHeaders = parseCliHeaders;
        this.parse();
    }

    public String getName() {
        return "IMAGE_NT_HEADERS" + (this.optionalHeader.is64bit() ? "64" : "32");
    }

    public boolean isRVAResoltionSectionAligned() {
        return this.layout == PortableExecutable.SectionLayout.MEMORY;
    }

    public FileHeader getFileHeader() {
        return this.fileHeader;
    }

    public OptionalHeader getOptionalHeader() {
        return this.optionalHeader;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getName(), 0);
        struct.add((DataType)new ArrayDataType(ASCII, 4, 1), "Signature", null);
        struct.add(this.fileHeader.toDataType(), "FileHeader", null);
        struct.add(this.optionalHeader.toDataType(), "OptionalHeader", null);
        struct.setCategoryPath(new CategoryPath("/PE"));
        return struct;
    }

    public int rvaToPointer(int rva) {
        return (int)this.rvaToPointer((long)rva & 0xFFFFFFFFL);
    }

    public long rvaToPointer(long rva) {
        SectionHeader[] sections;
        for (SectionHeader section : sections = this.fileHeader.getSectionHeaders()) {
            long sectionVA = (long)section.getVirtualAddress() & 0xFFFFFFFFL;
            long rawSize = (long)section.getSizeOfRawData() & 0xFFFFFFFFL;
            long rawPtr = (long)section.getPointerToRawData() & 0xFFFFFFFFL;
            switch (this.layout) {
                case MEMORY: {
                    return rva;
                }
            }
            if (rva < sectionVA || rva >= sectionVA + rawSize) continue;
            return rva + rawPtr - sectionVA;
        }
        if (this.optionalHeader != null && this.optionalHeader.getFileAlignment() == this.optionalHeader.getSectionAlignment() && this.optionalHeader.getSectionAlignment() < 800 && this.optionalHeader.getFileAlignment() > 1) {
            return rva;
        }
        return -1L;
    }

    @Override
    public boolean checkPointer(long ptr) {
        SectionHeader[] sections;
        for (SectionHeader section : sections = this.fileHeader.getSectionHeaders()) {
            long sectionSize;
            long virtPtr = (long)section.getVirtualAddress() & 0xFFFFFFFFL;
            long virtSize = (long)section.getVirtualSize() & 0xFFFFFFFFL;
            long rawSize = (long)section.getSizeOfRawData() & 0xFFFFFFFFL;
            long rawPtr = (long)section.getPointerToRawData() & 0xFFFFFFFFL;
            long sectionBasePtr = this.layout == PortableExecutable.SectionLayout.MEMORY ? virtPtr : rawPtr;
            long l = sectionSize = this.layout == PortableExecutable.SectionLayout.MEMORY ? virtSize : rawSize;
            if (ptr < sectionBasePtr || ptr > sectionBasePtr + sectionSize) continue;
            return true;
        }
        if (this.optionalHeader != null && this.optionalHeader.getFileAlignment() == this.optionalHeader.getSectionAlignment()) {
            return this.checkRVA(ptr);
        }
        return false;
    }

    @Override
    public boolean checkRVA(long rva) {
        if (this.optionalHeader != null) {
            return 0L <= rva && rva <= this.optionalHeader.getSizeOfImage();
        }
        return true;
    }

    public int vaToPointer(int va) {
        return (int)this.vaToPointer((long)va & 0xFFFFFFFFL);
    }

    public long vaToPointer(long va) {
        return this.rvaToPointer(va - this.getOptionalHeader().getImageBase());
    }

    private void parse() throws InvalidNTHeaderException, IOException {
        if (this.index < 0 || (long)this.index > this.reader.length()) {
            return;
        }
        int tmpIndex = this.index;
        try {
            this.signature = this.reader.readInt(tmpIndex);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        if (this.signature != 17744) {
            throw new InvalidNTHeaderException();
        }
        this.fileHeader = FileHeader.createFileHeader(this.reader, tmpIndex += 4, this);
        if (this.fileHeader.getSizeOfOptionalHeader() == 0) {
            Msg.warn((Object)this, (Object)"Section headers overlap optional header");
        }
        tmpIndex += 20;
        try {
            this.optionalHeader = OptionalHeaderImpl.createOptionalHeader(this, this.reader, tmpIndex);
        }
        catch (NotYetImplementedException e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()));
            return;
        }
        this.fileHeader.processSections(this.optionalHeader);
        this.fileHeader.processSymbols();
        if (this.advancedProcess) {
            this.optionalHeader.processDataDirectories(TaskMonitorAdapter.DUMMY_MONITOR);
        }
    }

    void writeHeader(RandomAccessFile raf, DataConverter dc) throws IOException {
        SectionHeader[] sections;
        raf.seek(this.index);
        raf.write(dc.getBytes(this.signature));
        this.fileHeader.writeHeader(raf, dc);
        this.optionalHeader.writeHeader(raf, dc);
        for (SectionHeader section : sections = this.fileHeader.getSectionHeaders()) {
            section.writeHeader(raf, dc);
        }
    }

    boolean shouldParseCliHeaders() {
        return this.parseCliHeaders;
    }
}

