/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.pe.DataDirectory;
import ghidra.app.util.bin.format.pe.ExportDataDirectory;
import ghidra.app.util.bin.format.pe.ExportInfo;
import ghidra.app.util.bin.format.pe.ImportByName;
import ghidra.app.util.bin.format.pe.ImportDescriptor;
import ghidra.app.util.bin.format.pe.ImportInfo;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.PeUtils;
import ghidra.app.util.bin.format.pe.ThunkData;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictException;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.TerminatedStringDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.DataConverter;
import ghidra.util.LittleEndianDataConverter;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;

public class ImportDataDirectory
extends DataDirectory {
    private static final String NAME = "IMAGE_DIRECTORY_ENTRY_IMPORT";
    private ImportDescriptor[] descriptors;
    private ImportInfo[] imports;
    ExportDataDirectory exportDirectory;
    DataConverter conv = LittleEndianDataConverter.INSTANCE;

    static ImportDataDirectory createImportDataDirectory(NTHeader ntHeader, FactoryBundledWithBinaryReader reader) throws IOException {
        ImportDataDirectory importDataDirectory = (ImportDataDirectory)reader.getFactory().create(ImportDataDirectory.class, new Object[0]);
        importDataDirectory.initImportDataDirectory(ntHeader, reader);
        return importDataDirectory;
    }

    private void initImportDataDirectory(NTHeader ntHeader, FactoryBundledWithBinaryReader reader) throws IOException {
        this.processDataDirectory(ntHeader, reader);
        if (this.imports == null) {
            this.imports = new ImportInfo[0];
        }
        if (this.descriptors == null) {
            this.descriptors = new ImportDescriptor[0];
        }
    }

    public ImportInfo[] getImports() {
        return this.imports;
    }

    public ImportDescriptor[] getImportDescriptors() {
        return this.descriptors;
    }

    @Override
    public String getDirectoryName() {
        return NAME;
    }

    @Override
    public void markup(Program program, boolean isBinary, TaskMonitor monitor, MessageLog log, NTHeader ntHeader) throws DuplicateNameException, CodeUnitInsertionException, DataTypeConflictException, IOException, MemoryAccessException {
        if (this.imports == null || this.descriptors == null) {
            return;
        }
        monitor.setMessage("[" + program.getName() + "]: import(s)...");
        Address addr = PeUtils.getMarkupAddress(program, isBinary, ntHeader, this.virtualAddress);
        if (!program.getMemory().contains(addr)) {
            return;
        }
        this.createDirectoryBookmark(program, addr);
        TerminatedStringDataType tsdt = new TerminatedStringDataType();
        AddressSpace space = program.getAddressFactory().getDefaultAddressSpace();
        block4: for (ImportDescriptor descriptor : this.descriptors) {
            if (monitor.isCancelled()) break;
            this.setPlateComment(program, addr, "IMAGE_IMPORT_DESCRIPTOR");
            for (int j = 0; j < 5; ++j) {
                PeUtils.createData(program, addr, DWORD, log);
                addr = addr.add((long)DWORD.getLength());
            }
            if (descriptor.getName() == 0 && descriptor.getTimeDateStamp() == 0) continue;
            String dll = descriptor.getDLL();
            if (dll != null && dll.startsWith(program.getName())) {
                Msg.warn((Object)this, (Object)(program.getName() + " potentially modified via import of local exports"));
                DataDirectory[] dataDirectories = ntHeader.getOptionalHeader().getDataDirectories();
                this.exportDirectory = (ExportDataDirectory)dataDirectories[0];
            }
            long nameAddr = this.va(descriptor.getName(), isBinary);
            Address nameAddress = space.getAddress(nameAddr);
            this.setPlateComment(program, nameAddress, "IMAGE_IMPORT_DESCRIPTOR - DLL NAME");
            PeUtils.createData(program, nameAddress, (DataType)tsdt, log);
            int intptr = descriptor.getOriginalFirstThunk() != 0 ? descriptor.getOriginalFirstThunk() : descriptor.getFirstThunk();
            int iatptr = descriptor.getFirstThunk();
            ThunkData[] thunks = descriptor.getImportNameTableThunkData();
            for (int j = 0; j < thunks.length && !monitor.isCancelled(); ++j) {
                try {
                    this.markupINT(intptr, iatptr, isBinary, program, thunks[j], log);
                    this.markupIAT(iatptr, isBinary, program, log);
                }
                catch (MemoryAccessException mae) {
                    Msg.error((Object)this, (Object)("Invalid memory access for iaptr " + Integer.toHexString(iatptr)));
                    continue block4;
                }
                if (descriptor.getDLL().startsWith(program.getName())) {
                    ExportInfo exportInfo = this.exportDirectory.getExports()[j];
                    long address = exportInfo.getAddress();
                    long thunkAddr = this.va(intptr, isBinary);
                    byte[] bytes = ntHeader.getOptionalHeader().is64bit() ? this.conv.getBytes(address) : this.conv.getBytes((int)address);
                    try {
                        program.getMemory().setBytes(program.getImageBase().getAddress(Long.toHexString(thunkAddr)), bytes);
                    }
                    catch (AddressFormatException e) {
                        Msg.warn((Object)this, (Object)("Unable to convert " + thunkAddr));
                    }
                }
                intptr += thunks[j].getStructSize();
                iatptr += thunks[j].getStructSize();
                ImportByName ibn = thunks[j].getImportByName();
                if (thunks[j].isOrdinal() || ibn == null) continue;
                long ibnAddr = this.va(thunks[j].getAddressOfData(), isBinary);
                Address ibnAddress = space.getAddress(ibnAddr);
                this.setPlateComment(program, ibnAddress, "IMAGE_IMPORT_BY_NAME");
                PeUtils.createData(program, ibnAddress, WORD, log);
                Address ibnNameAddress = ibnAddress.add((long)WORD.getLength());
                PeUtils.createData(program, ibnNameAddress, (DataType)tsdt, log);
            }
        }
    }

    private void markupIAT(int iatptr, boolean isBinary, Program program, MessageLog log) throws MemoryAccessException {
        Object dt = null;
        dt = isBinary ? (this.ntHeader.getOptionalHeader().is64bit() ? QWORD : DWORD) : PointerDataType.getPointer(null, (int)-1);
        AddressSpace space = program.getAddressFactory().getDefaultAddressSpace();
        long thunkAddr = this.va(iatptr, isBinary);
        Address thunkAddress = space.getAddress(thunkAddr);
        if (program.getMemory().getInt(thunkAddress) != 0) {
            PeUtils.createData(program, thunkAddress, (DataType)dt, log);
        }
    }

    private void markupINT(int intptr, int iatptr, boolean isBinary, Program program, ThunkData thunk, MessageLog log) {
        AddressSpace space = program.getAddressFactory().getDefaultAddressSpace();
        long thunkAddr = this.va(intptr, isBinary);
        Address thunkAddress = space.getAddress(thunkAddr);
        this.setEolComment(program, thunkAddress, thunk.getStructName());
        Object dt = null;
        dt = intptr == iatptr && !isBinary ? PointerDataType.getPointer(null, (int)program.getMinAddress().getPointerSize()) : (this.ntHeader.getOptionalHeader().is64bit() ? QWORD : DWORD);
        PeUtils.createData(program, thunkAddress, dt, log);
    }

    @Override
    public boolean parse() throws IOException {
        ArrayList<ImportInfo> importList = new ArrayList<ImportInfo>();
        ArrayList<ImportDescriptor> descriptorsList = new ArrayList<ImportDescriptor>();
        int ptr = this.getPointer();
        if (ptr < 0) {
            return false;
        }
        ImportDescriptor id = ImportDescriptor.createImportDescriptor(this.reader, ptr);
        while (!id.isNullEntry()) {
            ptr += 20;
            if (descriptorsList.size() > 65536) {
                Msg.error((Object)this, (Object)"Too many import descriptors");
                return false;
            }
            descriptorsList.add(id);
            if (id.getName() == 0 && id.getTimeDateStamp() == 0) break;
            int tmpPtr = this.ntHeader.rvaToPointer(id.getName());
            if (tmpPtr < 0) {
                id = ImportDescriptor.createImportDescriptor(this.reader, ptr);
                continue;
            }
            String dllName = this.reader.readAsciiString(tmpPtr);
            id.setDLL(dllName);
            if (id.getOriginalFirstThunk() == 0 && id.getFirstThunk() == 0) {
                return false;
            }
            int intptr = -1;
            if (id.getOriginalFirstThunk() != 0) {
                intptr = this.ntHeader.rvaToPointer(id.getOriginalFirstThunk());
            }
            if (intptr < 0) {
                intptr = this.ntHeader.rvaToPointer(id.getFirstThunk());
            }
            if (intptr < 0) {
                Msg.error((Object)this, (Object)("Invalid RVA " + Integer.toHexString(id.getOriginalFirstThunk()) + " : " + Integer.toHexString(id.getFirstThunk())));
                id = ImportDescriptor.createImportDescriptor(this.reader, ptr);
                return false;
            }
            int iatptr = this.ntHeader.rvaToPointer(id.getFirstThunk());
            int nextPosToCreateExternalRef = 0;
            while (true) {
                if (!this.ntHeader.checkPointer(intptr)) {
                    Msg.error((Object)this, (Object)("Invalid file index " + Integer.toHexString(intptr)));
                    break;
                }
                if (!this.ntHeader.checkPointer(iatptr)) {
                    Msg.error((Object)this, (Object)("Invalid file index " + Integer.toHexString(iatptr)));
                    break;
                }
                ThunkData intThunk = ThunkData.createThunkData(this.reader, intptr, this.ntHeader.getOptionalHeader().is64bit());
                intptr += intThunk.getStructSize();
                ThunkData iatThunk = ThunkData.createThunkData(this.reader, iatptr, this.ntHeader.getOptionalHeader().is64bit());
                iatptr += iatThunk.getStructSize();
                if (intThunk.getAddressOfData() == 0L) break;
                id.addImportNameTableThunkData(intThunk);
                id.addImportAddressTableThunkData(iatThunk);
                int addr = id.getFirstThunk() + nextPosToCreateExternalRef;
                nextPosToCreateExternalRef += intThunk.getStructSize();
                Object boundName = null;
                long ordinal = -1L;
                if (intThunk.isOrdinal()) {
                    ordinal = intThunk.getOrdinal();
                    String ordinalStr = "Ordinal_" + ordinal;
                    boundName = ordinalStr;
                } else {
                    int ptrToData = this.ntHeader.rvaToPointer((int)intThunk.getAddressOfData());
                    if (ptrToData < 0) {
                        Msg.error((Object)this, (Object)("Invalid RVA " + Long.toHexString(intThunk.getAddressOfData())));
                        break;
                    }
                    ImportByName ibn = ImportByName.createImportByName(this.reader, ptrToData);
                    intThunk.setImportByName(ibn);
                    boundName = ibn.getName();
                    ordinal = ibn.getHint();
                }
                StringBuffer cmt = new StringBuffer();
                if (ordinal != -1L) {
                    cmt.append(Long.toString(ordinal) + "  ");
                }
                if (boundName != null) {
                    cmt.append((String)boundName + "  ");
                }
                if (id.isBound()) {
                    long boundAddr = iatThunk.getAddressOfData();
                    cmt.append("[Bound to: 0x" + Long.toHexString(boundAddr) + "]");
                } else {
                    cmt.append("<<not bound>>");
                }
                if (importList.size() > 65536) {
                    Msg.error((Object)this, (Object)"Too many imports");
                    return false;
                }
                importList.add(new ImportInfo(addr, cmt.toString(), dllName, (String)boundName, id.isBound()));
            }
            id = ImportDescriptor.createImportDescriptor(this.reader, ptr);
        }
        this.imports = new ImportInfo[importList.size()];
        importList.toArray(this.imports);
        this.descriptors = new ImportDescriptor[descriptorsList.size()];
        descriptorsList.toArray(this.descriptors);
        return true;
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("\t\tImport Directory: [" + super.toString() + "]\n");
        for (ImportInfo info : this.imports) {
            buff.append("\t\t\t0x" + Long.toHexString(info.getAddress()) + "  " + info.getDLL() + " " + info.getName() + "\n");
        }
        return buff.toString();
    }

    @Override
    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        ArrayDataType array = new ArrayDataType(BYTE, this.size, 1);
        struct.add((DataType)array, array.getLength(), "IMPORT", null);
        struct.setCategoryPath(new CategoryPath("/PE"));
        return struct;
    }
}

