/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc2;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_Cache;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_ClassRW;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_Constants;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_Implementation;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_State;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_Utilities;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_Utilities;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ObjectiveC2_Class
implements StructConverter {
    public static final String NAME = "class_t";
    private ObjectiveC2_State _state;
    private long _index;
    private ObjectiveC2_Class isa;
    private ObjectiveC2_Class superclass;
    private ObjectiveC2_Cache cache;
    private ObjectiveC2_Implementation vtable;
    private ObjectiveC2_ClassRW data;

    public ObjectiveC2_Class(ObjectiveC2_State state, BinaryReader reader) {
        this._state = state;
        this._index = reader.getPointerIndex();
        state.classIndexMap.put(this._index, this);
        try {
            this.readISA(reader);
            this.readSuperClass(reader);
            this.readCache(reader);
            this.readVTable(reader);
            this.readData(reader);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean equals(Object that) {
        if (that instanceof ObjectiveC2_Class) {
            return this._index == ((ObjectiveC2_Class)that)._index;
        }
        return false;
    }

    public int hashCode() {
        return (int)this._index;
    }

    public ObjectiveC2_Class getISA() {
        return this.isa;
    }

    public ObjectiveC2_Class getSuperClass() {
        return this.superclass;
    }

    public ObjectiveC2_Cache getCache() {
        return this.cache;
    }

    public ObjectiveC2_Implementation getVTable() {
        return this.vtable;
    }

    public ObjectiveC2_ClassRW getData() {
        return this.data;
    }

    public long getIndex() {
        return this._index;
    }

    private void readData(BinaryReader reader) throws IOException {
        long index = 0L;
        try {
            index = ObjectiveC1_Utilities.readNextIndex(reader, this._state.is32bit);
        }
        catch (IOException ioe) {
            return;
        }
        if (index != 0L && reader.isValidIndex(index)) {
            long originalIndex = reader.getPointerIndex();
            reader.setPointerIndex(index);
            this.data = new ObjectiveC2_ClassRW(this._state, reader);
            reader.setPointerIndex(originalIndex);
        }
    }

    private void readVTable(BinaryReader reader) {
        try {
            this.vtable = new ObjectiveC2_Implementation(this._state, reader);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void readCache(BinaryReader reader) {
        try {
            this.cache = new ObjectiveC2_Cache(this._state, reader);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void readSuperClass(BinaryReader reader) throws IOException {
        long index = 0L;
        try {
            index = ObjectiveC1_Utilities.readNextIndex(reader, this._state.is32bit);
        }
        catch (IOException ioe) {
            return;
        }
        if (this._state.classIndexMap.containsKey(index)) {
            this.superclass = this._state.classIndexMap.get(index);
            return;
        }
        if (index != 0L && reader.isValidIndex(index)) {
            long originalIndex = reader.getPointerIndex();
            reader.setPointerIndex(index);
            this.superclass = new ObjectiveC2_Class(this._state, reader);
            reader.setPointerIndex(originalIndex);
        }
    }

    private void readISA(BinaryReader reader) throws IOException {
        long index = 0L;
        try {
            index = ObjectiveC2_Utilities.readNextIndex(reader, this._state.is32bit);
        }
        catch (IOException ioe) {
            return;
        }
        if (this._state.classIndexMap.containsKey(index)) {
            this.isa = this._state.classIndexMap.get(index);
            return;
        }
        if (index != 0L && reader.isValidIndex(index)) {
            long originalIndex = reader.getPointerIndex();
            reader.setPointerIndex(index);
            this.isa = new ObjectiveC2_Class(this._state, reader);
            reader.setPointerIndex(originalIndex);
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add((DataType)new PointerDataType((DataType)struct), this._state.pointerSize, "isa", null);
        struct.add((DataType)new PointerDataType((DataType)struct), this._state.pointerSize, "superclass", null);
        struct.add(this.cache.toDataType(), "cache", null);
        struct.add(this.vtable.toDataType(), "vtable", null);
        if (this.data == null) {
            ObjectiveC2_ClassRW fakeData = new ObjectiveC2_ClassRW();
            struct.add((DataType)new PointerDataType(fakeData.toDataType()), this._state.pointerSize, "data", null);
        } else {
            struct.add((DataType)new PointerDataType(this.data.toDataType()), this._state.pointerSize, "data", null);
        }
        struct.setCategoryPath(ObjectiveC2_Constants.CATEGORY_PATH);
        return struct;
    }

    public void applyTo() throws Exception {
        if (this._state.beenApplied.contains(this._index)) {
            return;
        }
        this._state.beenApplied.add(this._index);
        Address address = ObjectiveC1_Utilities.toAddress(this._state.program, this.getIndex());
        try {
            ObjectiveC1_Utilities.applyData(this._state.program, this.toDataType(), address);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Namespace namespace = ObjectiveC1_Utilities.createNamespace(this._state.program, "objc", NAME);
            ObjectiveC1_Utilities.createSymbol(this._state.program, namespace, this.data.getName(), address);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.isa != null) {
            this.isa.applyTo();
        }
        if (this.superclass != null) {
            this.superclass.applyTo();
        }
        if (this.cache != null) {
            this.cache.applyTo();
        }
        if (this.vtable != null) {
            this.vtable.applyTo();
        }
        if (this.data != null) {
            this.data.applyTo();
        }
    }
}

