/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.dyld;

import ghidra.app.util.bin.ByteProvider;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.LanguageService;
import java.io.IOException;

public final class DyldArchitecture {
    public static final String DYLD_V1_SIGNATURE_PREFIX = "dyld_v1";
    public static final int DYLD_V1_SIGNATURE_LEN = 16;
    public static final DyldArchitecture X86 = new DyldArchitecture(7, -1, "dyld_v1    i386", "i386", Endian.LITTLE);
    public static final DyldArchitecture X86_64 = new DyldArchitecture(0x1000007, -1, "dyld_v1  x86_64", "x86_64", Endian.LITTLE);
    public static final DyldArchitecture X86_64h = new DyldArchitecture(0x1000007, -1, "dyld_v1 x86_64h", "x86_64", Endian.LITTLE);
    public static final DyldArchitecture POWERPC = new DyldArchitecture(18, -1, "dyld_v1     ppc", "rosetta", Endian.BIG);
    public static final DyldArchitecture ARMV6 = new DyldArchitecture(12, 6, "dyld_v1   armv6", "armv6", Endian.LITTLE);
    public static final DyldArchitecture ARMV7 = new DyldArchitecture(12, 9, "dyld_v1   armv7", "arm7", Endian.LITTLE);
    public static final DyldArchitecture ARMV7F = new DyldArchitecture(12, 10, "dyld_v1  armv7f", "arm7", Endian.LITTLE);
    public static final DyldArchitecture ARMV7S = new DyldArchitecture(12, 11, "dyld_v1  armv7s", "arm7", Endian.LITTLE);
    public static final DyldArchitecture ARMV7K = new DyldArchitecture(12, 12, "dyld_v1  armv7k", "arm7", Endian.LITTLE);
    public static final DyldArchitecture ARMV8A = new DyldArchitecture(0x100000C, -1, "dyld_v1   arm64", "AARCH64", Endian.LITTLE);
    public static final DyldArchitecture ARMV8Ae = new DyldArchitecture(0x100000C, -1, "dyld_v1  arm64e", "AARCH64", Endian.LITTLE);
    public static final DyldArchitecture[] ARCHITECTURES = new DyldArchitecture[]{X86, X86_64, X86_64h, POWERPC, ARMV6, ARMV7, ARMV7F, ARMV7S, ARMV7K, ARMV8A, ARMV8Ae};
    private int cpuType;
    private int cpuSubType;
    private String signature;
    private String processor;
    private Endian endianness;

    public static final DyldArchitecture getArchitecture(String signature) {
        for (DyldArchitecture architecture : ARCHITECTURES) {
            if (!architecture.getSignature().equals(signature)) continue;
            return architecture;
        }
        return null;
    }

    public static final DyldArchitecture getArchitecture(ByteProvider provider) throws IOException {
        byte[] signatureBytes = provider.readBytes(0L, 16L);
        String signature = new String(signatureBytes);
        return DyldArchitecture.getArchitecture(signature.trim());
    }

    private DyldArchitecture(int cpuType, int cpuSubType, String signature, String processor, Endian endianness) {
        this.cpuType = cpuType;
        this.cpuSubType = cpuSubType;
        this.signature = signature;
        this.processor = processor;
        this.endianness = endianness;
        if (signature.length() + 1 != 16) {
            throw new IllegalArgumentException("invalid signature string length: " + signature);
        }
    }

    public int getCpuType() {
        return this.cpuType;
    }

    public int getCpuSubType() {
        return this.cpuSubType;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getProcessor() {
        return this.processor;
    }

    public Endian getEndianness() {
        return this.endianness;
    }

    public String toString() {
        return this.signature;
    }

    public LanguageCompilerSpecPair getLanguageCompilerSpecPair(LanguageService languageService) throws IOException {
        if (this == X86) {
            return new LanguageCompilerSpecPair(new LanguageID("x86:LE:32:default"), new CompilerSpecID("gcc"));
        }
        if (this == X86_64 || this == X86_64h) {
            return new LanguageCompilerSpecPair(new LanguageID("x86:LE:64:default"), new CompilerSpecID("gcc"));
        }
        if (this == POWERPC) {
            return new LanguageCompilerSpecPair(new LanguageID("PowerPC:BE:32:default"), new CompilerSpecID("macosx"));
        }
        if (this == ARMV6) {
            return new LanguageCompilerSpecPair(new LanguageID("ARM:LE:32:v6"), new CompilerSpecID("default"));
        }
        if (this == ARMV7) {
            return new LanguageCompilerSpecPair(new LanguageID("ARM:LE:32:v7"), new CompilerSpecID("default"));
        }
        if (this == ARMV7S) {
            return new LanguageCompilerSpecPair(new LanguageID("ARM:LE:32:v7"), new CompilerSpecID("default"));
        }
        throw new LanguageNotFoundException("Unable to locate language for " + this);
    }
}

