/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf;

import ghidra.app.plugin.exceptionhandlers.gcc.datatype.AbstractLeb128DataType;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.scalar.Scalar;

class AndroidElfRelocationOffset
extends AbstractLeb128DataType {
    private final long baseOffset;
    private long relocationOffset;

    AndroidElfRelocationOffset(DataTypeManager dtm, long baseOffset) {
        super("sleb128_offset", true, dtm);
        this.baseOffset = baseOffset;
    }

    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new AndroidElfRelocationOffset(dtm, this.baseOffset);
    }

    public String getMnemonic(Settings settings) {
        return this.name;
    }

    @Override
    public String getDescription() {
        return "Android Packed Relocation Offset for ELF";
    }

    public String getDefaultLabelPrefix() {
        return "sleb128";
    }

    @Override
    protected SettingsDefinition[] getBuiltInSettingsDefinitions() {
        return null;
    }

    public Class<?> getValueClass(Settings settings) {
        return Address.class;
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        Scalar s = (Scalar)super.getValue(buf, settings, length);
        if (s == null) {
            return null;
        }
        AddressSpace space = buf.getAddress().getAddressSpace().getPhysicalSpace();
        return space.getAddress(s.getUnsignedValue() + this.baseOffset);
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        Scalar s = (Scalar)super.getValue(buf, settings, length);
        if (s == null) {
            return "??";
        }
        StringBuilder b = new StringBuilder();
        if (this.baseOffset != 0L) {
            b.append("0x");
            b.append(Long.toHexString(this.baseOffset));
            b.append(" + ");
        }
        b.append("0x");
        b.append(Long.toHexString(s.getUnsignedValue()));
        return b.toString();
    }

    long getRelocationOffset() {
        return this.relocationOffset;
    }

    void setRelocationOffset(long relocationOffset) {
        this.relocationOffset = relocationOffset;
    }
}

