/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.MemBufferByteProvider;
import ghidra.app.util.bin.format.elf.AndroidElfRelocationData;
import ghidra.app.util.bin.format.elf.AndroidElfRelocationOffset;
import ghidra.app.util.bin.format.elf.AndroidElfRelocationTableDataType;
import ghidra.docking.settings.Settings;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DynamicDataType;
import ghidra.program.model.data.ReadOnlyDataTypeComponent;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.WrappedMemBuffer;
import ghidra.program.model.scalar.Scalar;
import java.io.IOException;
import java.util.ArrayList;

class AndroidElfRelocationGroup
extends DynamicDataType {
    static final long RELOCATION_GROUPED_BY_INFO_FLAG = 1L;
    static final long RELOCATION_GROUPED_BY_OFFSET_DELTA_FLAG = 2L;
    static final long RELOCATION_GROUPED_BY_ADDEND_FLAG = 4L;
    static final long RELOCATION_GROUP_HAS_ADDEND_FLAG = 8L;
    private final long baseRelocOffset;

    AndroidElfRelocationGroup(DataTypeManager dtm, long baseRelocOffset) {
        super(CategoryPath.ROOT, "AndroidElfRelocationGroup", dtm);
        this.baseRelocOffset = baseRelocOffset;
    }

    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.dataMgr) {
            return this;
        }
        return new AndroidElfRelocationGroup(dtm, this.baseRelocOffset);
    }

    public String getDescription() {
        return "Android Packed Relocation Entry Group for ELF";
    }

    public Object getValue(MemBuffer buf, Settings settings, int length) {
        return null;
    }

    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return "";
    }

    protected DataTypeComponent[] getAllComponents(MemBuffer buf) {
        try {
            MemBufferByteProvider provider = new MemBufferByteProvider(buf);
            BinaryReader reader = new BinaryReader(provider, false);
            ArrayList<Object> list = new ArrayList<Object>();
            AndroidElfRelocationTableDataType.LEB128Info sleb128 = AndroidElfRelocationTableDataType.LEB128Info.parse(reader, true);
            long groupSize = sleb128.value;
            list.add(sleb128.getComponent(this, list.size(), "group_size", null));
            sleb128 = AndroidElfRelocationTableDataType.LEB128Info.parse(reader, true);
            long groupFlags = sleb128.value;
            list.add(sleb128.getComponent(this, list.size(), "group_flags", null));
            boolean groupedByInfo = (groupFlags & 1L) != 0L;
            boolean groupedByDelta = (groupFlags & 2L) != 0L;
            boolean groupedByAddend = (groupFlags & 4L) != 0L;
            boolean groupHasAddend = (groupFlags & 8L) != 0L;
            long groupOffsetDelta = 0L;
            if (groupedByDelta) {
                sleb128 = AndroidElfRelocationTableDataType.LEB128Info.parse(reader, true);
                groupOffsetDelta = sleb128.value;
                long minOffset = this.baseRelocOffset + groupOffsetDelta;
                String rangeStr = "First relocation offset: 0x" + Long.toHexString(minOffset);
                list.add(sleb128.getComponent(this, list.size(), "group_offsetDelta", rangeStr));
            }
            if (groupedByInfo) {
                sleb128 = AndroidElfRelocationTableDataType.LEB128Info.parse(reader, true);
                list.add(sleb128.getComponent(this, list.size(), "group_info", null));
            }
            if (groupedByAddend && groupHasAddend) {
                sleb128 = AndroidElfRelocationTableDataType.LEB128Info.parse(reader, true);
                list.add(sleb128.getComponent(this, list.size(), "group_addend", null));
            }
            long relocOffset = this.baseRelocOffset;
            if (groupedByDelta && groupedByInfo && (!groupHasAddend || groupedByAddend)) {
                relocOffset += (groupSize - 1L) * groupOffsetDelta;
            } else {
                int i = 0;
                while ((long)i < groupSize) {
                    if (groupedByDelta) {
                        relocOffset += groupOffsetDelta;
                    } else {
                        sleb128 = AndroidElfRelocationTableDataType.LEB128Info.parse(reader, true);
                        ReadOnlyDataTypeComponent dtc = new ReadOnlyDataTypeComponent((DataType)new AndroidElfRelocationOffset(this.dataMgr, relocOffset += sleb128.value), (DynamicDataType)this, sleb128.byteLength, list.size(), sleb128.offset, "reloc_offset_" + i, null);
                        list.add(dtc);
                    }
                    if (!groupedByInfo) {
                        sleb128 = AndroidElfRelocationTableDataType.LEB128Info.parse(reader, true);
                        list.add(sleb128.getComponent(this, list.size(), "reloc_info_" + i, null, relocOffset));
                    }
                    if (groupHasAddend && !groupedByAddend) {
                        sleb128 = AndroidElfRelocationTableDataType.LEB128Info.parse(reader, true);
                        list.add(sleb128.getComponent(this, list.size(), "reloc_addend_" + i, null, relocOffset));
                    }
                    ++i;
                }
            }
            DataTypeComponent[] comps = new DataTypeComponent[list.size()];
            return list.toArray(comps);
        }
        catch (IOException e) {
            return null;
        }
    }

    long getLastRelocationOffset(WrappedMemBuffer buf) {
        DataTypeComponent[] comps = this.getComps((MemBuffer)buf);
        if (comps == null || comps.length < 3) {
            return -1L;
        }
        Scalar s = (Scalar)comps[0].getDataType().getValue((MemBuffer)buf, null, comps[0].getLength());
        int groupSize = (int)s.getValue();
        DataTypeComponent lastDtc = comps[comps.length - 1];
        if ("group_offsetDelta".equals(comps[2].getFieldName())) {
            WrappedMemBuffer cbuf = new WrappedMemBuffer((MemBuffer)buf, comps[2].getOffset());
            s = (Scalar)comps[2].getDataType().getValue((MemBuffer)cbuf, null, comps[2].getLength());
            long groupOffsetDelta = s.getValue();
            if (lastDtc.getFieldName().startsWith("group_")) {
                return this.baseRelocOffset + (long)groupSize * groupOffsetDelta;
            }
        }
        if (lastDtc.getFieldName().startsWith("group_")) {
            return -1L;
        }
        DataType dt = lastDtc.getDataType();
        if (dt instanceof AndroidElfRelocationOffset) {
            AndroidElfRelocationOffset d = (AndroidElfRelocationOffset)dt;
            return d.getRelocationOffset();
        }
        if (dt instanceof AndroidElfRelocationData) {
            AndroidElfRelocationData d = (AndroidElfRelocationData)dt;
            return d.getRelocationOffset();
        }
        return -1L;
    }
}

