/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.services;

import ghidra.app.plugin.core.marker.MarkerManagerPlugin;
import ghidra.app.services.MarkerSet;
import ghidra.framework.plugintool.ServiceInfo;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import java.awt.Color;
import javax.swing.ImageIcon;
import javax.swing.event.ChangeListener;

@ServiceInfo(defaultProvider={MarkerManagerPlugin.class}, description="Service to manage navigation markers displayed around a scrollable window.")
public interface MarkerService {
    public static final int SELECTION_PRIORITY = 100;
    public static final int HIGHLIGHT_PRIORITY = 50;
    public static final int CHANGE_PRIORITY = -50;
    public static final int GROUP_PRIORITY = -25;
    public static final int CURSOR_PRIORITY = 200;
    public static final int FUNCTION_COMPARE_CURSOR_PRIORITY = 49;
    public static final int SEARCH_PRIORITY = 75;
    public static final int BREAKPOINT_PRIORITY = 50;
    public static final int BOOKMARK_PRIORITY = 0;
    public static final int PROPERTY_PRIORITY = 75;
    public static final int DIFF_PRIORITY = 80;
    public static final int REFERENCE_PRIORITY = -10;
    public static final String HIGHLIGHT_GROUP = "HIGHLIGHT_GROUP";

    public MarkerSet createAreaMarker(String var1, String var2, Program var3, int var4, boolean var5, boolean var6, boolean var7, Color var8);

    public MarkerSet createAreaMarker(String var1, String var2, Program var3, int var4, boolean var5, boolean var6, boolean var7, Color var8, boolean var9);

    public MarkerSet createPointMarker(String var1, String var2, Program var3, int var4, boolean var5, boolean var6, boolean var7, Color var8, ImageIcon var9);

    public MarkerSet createPointMarker(String var1, String var2, Program var3, int var4, boolean var5, boolean var6, boolean var7, Color var8, ImageIcon var9, boolean var10);

    public void removeMarker(MarkerSet var1, Program var2);

    public MarkerSet getMarkerSet(String var1, Program var2);

    public void setMarkerForGroup(String var1, MarkerSet var2, Program var3);

    public void removeMarkerForGroup(String var1, MarkerSet var2, Program var3);

    public Color getBackgroundColor(Address var1);

    public Color getBackgroundColor(Program var1, Address var2);

    public void addChangeListener(ChangeListener var1);

    public void removeChangeListener(ChangeListener var1);
}

