/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree.nodes;

import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolTreeNode;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.datastruct.IntArray;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.datatransfer.DataFlavor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import resources.ResourceManager;

public class OrganizationNode
extends SymbolTreeNode {
    static final Comparator<GTreeNode> COMPARATOR = new OrganizationNodeComparator();
    private static Icon OPEN_FOLDER_GROUP_ICON = ResourceManager.loadImage((String)"images/openFolderGroup.png");
    private static Icon CLOSED_FOLDER_GROUP_ICON = ResourceManager.loadImage((String)"images/closedFolderGroup.png");
    private String baseName;

    private OrganizationNode(List<GTreeNode> list, int max, int parentLevel, TaskMonitor monitor) throws CancelledException {
        this.doSetChildren(OrganizationNode.computeChildren(list, max, (GTreeNode)this, parentLevel, monitor));
        GTreeNode child = this.getChild(0);
        this.baseName = child.getName().substring(0, OrganizationNode.getPrefixSizeForGrouping(this.getChildren(), 1) + 1);
    }

    public static List<GTreeNode> organize(List<GTreeNode> nodes, int max, TaskMonitor monitor) throws CancelledException {
        return OrganizationNode.organize(nodes, null, max, monitor);
    }

    private static List<GTreeNode> organize(List<GTreeNode> nodes, GTreeNode parent, int max, TaskMonitor monitor) throws CancelledException {
        return OrganizationNode.computeChildren(nodes, max, parent, 0, monitor);
    }

    private static List<GTreeNode> computeChildren(List<GTreeNode> list, int maxNodes, GTreeNode parent, int parentLevel, TaskMonitor monitor) throws CancelledException {
        ArrayList<Object> children;
        if (list.size() <= maxNodes) {
            children = new ArrayList<GTreeNode>(list);
        } else {
            int characterOffset = OrganizationNode.getPrefixSizeForGrouping(list, maxNodes);
            characterOffset = Math.max(characterOffset, parentLevel + 1);
            children = new ArrayList();
            String prevStr = list.get(0).getName();
            int start = 0;
            int end = list.size();
            for (int i = 1; i < end; ++i) {
                monitor.checkCanceled();
                String str = list.get(i).getName();
                if (OrganizationNode.stringsDiffer(prevStr, str, characterOffset)) {
                    OrganizationNode.addNode(children, list, start, i - 1, maxNodes, characterOffset, monitor);
                    start = i;
                }
                prevStr = str;
            }
            OrganizationNode.addNode(children, list, start, end - 1, maxNodes, characterOffset, monitor);
        }
        return children;
    }

    private static boolean stringsDiffer(String s1, String s2, int diffLevel) {
        if (s1.length() <= diffLevel || s2.length() <= diffLevel) {
            return true;
        }
        return s1.substring(0, diffLevel + 1).compareToIgnoreCase(s2.substring(0, diffLevel + 1)) != 0;
    }

    private static void addNode(List<GTreeNode> children, List<GTreeNode> list, int start, int end, int max, int diffLevel, TaskMonitor monitor) throws CancelledException {
        if (end - start > 0) {
            children.add((GTreeNode)new OrganizationNode(list.subList(start, end + 1), max, diffLevel, monitor));
        } else {
            GTreeNode node = list.get(start);
            children.add(node);
        }
    }

    private static int getPrefixSizeForGrouping(List<GTreeNode> list, int maxNodes) {
        IntArray prefixSizeCountBins = new IntArray();
        Iterator<GTreeNode> it = list.iterator();
        String previousNodeName = it.next().getName();
        prefixSizeCountBins.put(0, 1);
        while (it.hasNext()) {
            String currentNodeName = it.next().getName();
            int prefixSize = OrganizationNode.getCommonPrefixSize(previousNodeName, currentNodeName);
            prefixSizeCountBins.put(prefixSize, prefixSizeCountBins.get(prefixSize) + 1);
            previousNodeName = currentNodeName;
        }
        int binContentsTotal = 0;
        for (int i = 0; i <= prefixSizeCountBins.getLastNonEmptyIndex(); ++i) {
            if ((binContentsTotal += prefixSizeCountBins.get(i)) <= maxNodes) continue;
            return Math.max(0, i - 1);
        }
        return prefixSizeCountBins.getLastNonEmptyIndex();
    }

    private static int getCommonPrefixSize(String s1, String s2) {
        int maxCompareLength = Math.min(s1.length(), s2.length());
        for (int i = 0; i < maxCompareLength; ++i) {
            if (Character.toUpperCase(s1.charAt(i)) == Character.toUpperCase(s2.charAt(i))) continue;
            return i;
        }
        return maxCompareLength;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        OrganizationNode node = (OrganizationNode)((Object)o);
        return this.baseName.equals(node.baseName);
    }

    @Override
    public boolean canCut() {
        return false;
    }

    @Override
    public boolean canPaste(List<GTreeNode> pastedNodes) {
        return false;
    }

    @Override
    public boolean isCut() {
        return false;
    }

    public boolean isModifiable() {
        return false;
    }

    @Override
    public void setNodeCut(boolean isCut) {
        throw new UnsupportedOperationException("Cannot cut an organization node");
    }

    public Icon getIcon(boolean expanded) {
        if (expanded) {
            return OPEN_FOLDER_GROUP_ICON;
        }
        return CLOSED_FOLDER_GROUP_ICON;
    }

    public String getName() {
        return this.baseName + "...";
    }

    public String getToolTip() {
        return this.getName();
    }

    public boolean isLeaf() {
        return false;
    }

    @Override
    public DataFlavor getNodeDataFlavor() {
        return null;
    }

    @Override
    public boolean supportsDataFlavors(DataFlavor[] dataFlavors) {
        return false;
    }

    @Override
    public Namespace getNamespace() {
        return null;
    }

    public void insertNode(GTreeNode newNode) {
        int index = Collections.binarySearch(this.getChildren(), newNode, this.getChildrenComparator());
        if (index >= 0) {
            GTreeNode matchingNode = this.getChild(index);
            if (matchingNode instanceof OrganizationNode) {
                OrganizationNode orgNode = (OrganizationNode)matchingNode;
                orgNode.insertNode(newNode);
                return;
            }
        } else {
            index = -index - 1;
        }
        this.addNode(index, newNode);
    }

    @Override
    public GTreeNode findSymbolTreeNode(SymbolNode key, boolean loadChildren, TaskMonitor taskMonitor) {
        String symbolName = key.getName();
        if (!symbolName.startsWith(this.baseName)) {
            return null;
        }
        return super.findSymbolTreeNode(key, loadChildren, taskMonitor);
    }

    public int compareTo(GTreeNode node) {
        String nodeName;
        if (!(node instanceof OrganizationNode) && (nodeName = node.getName()).regionMatches(true, 0, this.baseName, 0, this.baseName.length())) {
            return 0;
        }
        return super.compareTo(node);
    }

    @Override
    public Comparator<GTreeNode> getChildrenComparator() {
        return COMPARATOR;
    }

    public List<GTreeNode> generateChildren(TaskMonitor monitor) throws CancelledException {
        return null;
    }

    static class OrganizationNodeComparator
    implements Comparator<GTreeNode> {
        OrganizationNodeComparator() {
        }

        @Override
        public int compare(GTreeNode g1, GTreeNode g2) {
            if (!(g1 instanceof OrganizationNode) && g2 instanceof OrganizationNode) {
                int result = -g2.compareTo(g1);
                return result;
            }
            int result = g1.compareTo(g2);
            return result;
        }
    }
}

