/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.searchmem;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.ComponentProviderActivationListener;
import docking.DockingContextListener;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.fieldpanel.support.Highlight;
import docking.widgets.table.threaded.GThreadedTablePanel;
import docking.widgets.table.threaded.ThreadedTableModel;
import docking.widgets.table.threaded.ThreadedTableModelListener;
import ghidra.app.context.NavigatableActionContext;
import ghidra.app.context.NavigatableContextAction;
import ghidra.app.context.RestrictedAddressSetContext;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.nav.Navigatable;
import ghidra.app.nav.NavigatableRemovalListener;
import ghidra.app.plugin.core.searchmem.MemSearchDialog;
import ghidra.app.plugin.core.searchmem.MemSearchTableModel;
import ghidra.app.plugin.core.searchmem.SearchData;
import ghidra.app.plugin.core.table.TableComponentProvider;
import ghidra.app.services.CodeViewerService;
import ghidra.app.services.GoToService;
import ghidra.app.services.MemorySearchService;
import ghidra.app.services.ProgramManager;
import ghidra.app.util.HighlightProvider;
import ghidra.app.util.PluginConstants;
import ghidra.app.util.query.TableService;
import ghidra.app.util.viewer.field.BytesFieldFactory;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.util.BytesFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.bean.opteditor.OptionsVetoException;
import ghidra.util.search.memory.MemSearchResult;
import ghidra.util.search.memory.MemSearcherTask;
import ghidra.util.search.memory.MemorySearchAlgorithm;
import ghidra.util.search.memory.SearchInfo;
import ghidra.util.table.GhidraProgramTableModel;
import ghidra.util.task.Task;
import ghidra.util.task.TaskListener;
import ghidra.util.task.TaskMonitor;
import java.awt.Color;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import resources.ResourceManager;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Search", shortDescription="Search bytes in memory", description="This plugin searches bytes in memory; the search is based on a value entered as hex or decimal numbers, or strings. The value may contain \"wildcards\" or regular expressions that will match any byte or nibble.", servicesRequired={ProgramManager.class, GoToService.class, TableService.class, CodeViewerService.class}, servicesProvided={MemorySearchService.class}, eventsConsumed={ProgramSelectionPluginEvent.class})
public class MemSearchPlugin
extends Plugin
implements OptionsChangeListener,
DockingContextListener,
NavigatableRemovalListener,
MemorySearchService {
    private static final String SHOW_ADVANCED_OPTIONS = "Show Advanced Options";
    static final Highlight[] NO_HIGHLIGHTS = new Highlight[0];
    private static final int MAX_PRE_POPULTATE_BYTE_COUNT = 20;
    private DockingAction searchAction;
    private DockingAction searchAgainAction;
    private MemSearchDialog searchDialog;
    private GoToService goToService;
    private int searchLimit;
    private static int DEFAULT_SEARCH_LIMIT = 500;
    private ImageIcon searchIcon = ResourceManager.loadImage((String)"images/searchm_obj.gif");
    private Color defaultHighlightColor;
    private Color activeHighlightColor;
    private boolean doHighlight;
    private int byteGroupSize;
    private String byteDelimiter;
    private boolean showAdvancedOptions;
    private boolean prepopulateSearch;
    private boolean autoRestrictSelection;
    private TableComponentProvider<MemSearchResult> currentResultsTableProvider;
    private TaskMonitor searchAllTaskMonitor;
    private TableLoadingListener currentTableListener;
    private volatile boolean waitingForSearchAll;
    private SearchInfo searchInfo;
    private Address lastMatchingAddress;
    private Navigatable navigatable;
    private boolean isMnemonic = false;

    public MemSearchPlugin(PluginTool tool) {
        super(tool);
        this.createActions();
        this.initializeOptionListeners();
        this.getOptions();
        tool.addContextListener((DockingContextListener)this);
    }

    public void dispose() {
        this.tool.removeContextListener((DockingContextListener)this);
        ToolOptions opt = this.tool.getOptions("Tool");
        opt.removeOptionsChangeListener((OptionsChangeListener)this);
        opt = this.tool.getOptions("Search");
        opt.removeOptionsChangeListener((OptionsChangeListener)this);
        if (this.searchAction != null) {
            this.searchAction.dispose();
            this.searchAction = null;
        }
        if (this.searchAgainAction != null) {
            this.searchAgainAction.dispose();
            this.searchAgainAction = null;
        }
        if (this.searchAllTaskMonitor != null) {
            this.searchAllTaskMonitor.cancel();
        }
        if (this.searchDialog != null) {
            this.searchDialog.dispose();
            this.searchDialog = null;
        }
        this.goToService = null;
        super.dispose();
    }

    int getSearchLimit() {
        return this.searchLimit;
    }

    boolean searchAll(SearchInfo newSearchInfo) {
        this.searchInfo = newSearchInfo;
        return this.performSearch(newSearchInfo);
    }

    boolean searchOnce(SearchInfo newSearchInfo) {
        this.searchInfo = newSearchInfo;
        return this.performSearch(this.searchInfo);
    }

    private boolean performSearch(SearchInfo localSearchInfo) {
        Program program = this.navigatable.getProgram();
        if (program == null) {
            return false;
        }
        this.searchAgainAction.setEnabled(true);
        if (localSearchInfo.isSearchAll()) {
            this.waitingForSearchAll = true;
            this.showIncrementalSearchResults(localSearchInfo);
        } else {
            Address start = this.getSearchStartAddress(localSearchInfo);
            ProgramSelection selection = this.navigatable.getSelection();
            MemorySearchAlgorithm algorithm = this.searchInfo.createSearchAlgorithm(program, start, selection);
            MemSearcherTask task = new MemSearcherTask(this.searchInfo, algorithm);
            this.searchDialog.executeProgressTask(task, 500);
        }
        return true;
    }

    void disableSearchAgain() {
        this.searchAgainAction.setEnabled(false);
    }

    private Address getSearchStartAddress(SearchInfo localSearchInfo) {
        Address startAddress;
        ProgramLocation location = this.navigatable.getLocation();
        Address address = startAddress = location == null ? null : location.getAddress();
        if (startAddress == null) {
            Program program = this.navigatable.getProgram();
            if (program == null) {
                return null;
            }
            Address address2 = startAddress = localSearchInfo.isSearchForward() ? program.getMinAddress() : program.getMaxAddress();
        }
        if (this.lastMatchingAddress == null) {
            return startAddress;
        }
        CodeUnit cu = this.navigatable.getProgram().getListing().getCodeUnitContaining(startAddress);
        if (cu.contains(this.lastMatchingAddress)) {
            startAddress = localSearchInfo.isSearchForward() ? this.lastMatchingAddress.next() : this.lastMatchingAddress.previous();
        }
        return startAddress;
    }

    protected void updateNavigatable(ActionContext context) {
        if (context instanceof NavigatableActionContext) {
            NavigatableActionContext navContext = (NavigatableActionContext)context;
            this.setNavigatable(navContext.getNavigatable());
            this.updateSelection(navContext);
        }
    }

    public void processEvent(PluginEvent event) {
        if (event instanceof ProgramSelectionPluginEvent) {
            boolean hasSelection;
            ProgramSelection selection = ((ProgramSelectionPluginEvent)event).getSelection();
            boolean bl = hasSelection = !selection.isEmpty();
            if (this.searchDialog != null) {
                this.searchDialog.setHasSelection(hasSelection, this.autoRestrictSelection);
            }
        }
    }

    @Override
    public void setIsMnemonic(boolean isMnemonic) {
        this.isMnemonic = isMnemonic;
    }

    private void setNavigatable(Navigatable newNavigatable) {
        if (newNavigatable == this.navigatable) {
            return;
        }
        if (this.navigatable != null) {
            this.navigatable.removeNavigatableListener(this);
        }
        if (newNavigatable != null) {
            newNavigatable.addNavigatableListener(this);
        }
        this.navigatable = newNavigatable;
        this.lastMatchingAddress = null;
        if (this.searchDialog != null) {
            this.searchDialog.setSearchEnabled(newNavigatable != null);
        }
    }

    protected void init() {
        this.goToService = (GoToService)this.tool.getService(GoToService.class);
    }

    private void invokeSearchDialog(NavigatableActionContext context) {
        if (this.searchDialog == null) {
            boolean isBigEndian = this.navigatable.getProgram().getLanguage().isBigEndian();
            this.searchDialog = new MemSearchDialog(this, isBigEndian, this.isMnemonic);
            this.searchDialog.setShowAdvancedOptions(this.showAdvancedOptions);
        } else {
            this.searchDialog.setEndianess(this.navigatable.getProgram().getLanguage().isBigEndian());
            this.searchDialog.close();
        }
        byte[] searchBytes = this.getInitialSearchBytes(context);
        if (searchBytes != null) {
            this.searchDialog.setBytes(searchBytes);
        }
        boolean hasSelection = context.hasSelection();
        this.searchDialog.setHasSelection(hasSelection, this.autoRestrictSelection);
        this.searchDialog.show(context.getComponentProvider());
    }

    private byte[] getInitialSearchBytes(NavigatableActionContext context) {
        if (!this.prepopulateSearch) {
            return null;
        }
        ProgramSelection selection = context.getSelection();
        if (selection == null || selection.isEmpty() || this.hasBigSelection(context)) {
            return null;
        }
        int numAddresses = (int)selection.getNumAddresses();
        Address address = selection.getMinAddress();
        Memory memory = context.getProgram().getMemory();
        byte[] bytes = new byte[numAddresses];
        try {
            int count = memory.getBytes(address, bytes);
            if (count == numAddresses) {
                return bytes;
            }
        }
        catch (MemoryAccessException memoryAccessException) {
            // empty catch block
        }
        return null;
    }

    private BytesFieldLocation getBytesFieldLocation(Address address) {
        if (address == null) {
            return null;
        }
        Program program = this.navigatable.getProgram();
        return new BytesFieldLocation(program, address);
    }

    @Override
    public void search(byte[] bytes, NavigatableActionContext context) {
        this.setNavigatable(context.getNavigatable());
        this.invokeSearchDialog(context);
    }

    @Override
    public void setSearchText(String maskedString) {
        this.searchDialog.setSearchText(maskedString);
    }

    private void createActions() {
        this.searchAction = new NavigatableContextAction("Search Memory", this.getName()){

            @Override
            public void actionPerformed(NavigatableActionContext context) {
                MemSearchPlugin.this.setNavigatable(context.getNavigatable());
                MemSearchPlugin.this.invokeSearchDialog(context);
            }

            @Override
            protected boolean isEnabledForContext(NavigatableActionContext context) {
                return !(context instanceof RestrictedAddressSetContext);
            }
        };
        this.searchAction.setHelpLocation(new HelpLocation("Search", this.searchAction.getName()));
        String[] menuPath = new String[]{"&Search", "&Memory..."};
        this.searchAction.setMenuBarData(new MenuData(menuPath, "search"));
        this.searchAction.setKeyBindingData(new KeyBindingData('S', 0));
        this.searchAction.setDescription("Search Memory for byte sequence");
        this.tool.addAction((DockingActionIf)this.searchAction);
        this.searchAgainAction = new NavigatableContextAction("Repeat Memory Search", this.getName()){

            @Override
            public void actionPerformed(NavigatableActionContext context) {
                MemSearchPlugin.this.setNavigatable(context.getNavigatable());
                MemSearchPlugin.this.performSearch(MemSearchPlugin.this.searchInfo);
            }

            @Override
            protected boolean isEnabledForContext(NavigatableActionContext context) {
                return !(context instanceof RestrictedAddressSetContext) && MemSearchPlugin.this.searchInfo != null;
            }
        };
        this.searchAgainAction.setHelpLocation(new HelpLocation("Search", this.searchAgainAction.getName()));
        menuPath = new String[]{"&Search", "Repeat Memory Search"};
        this.searchAgainAction.setMenuBarData(new MenuData(menuPath, "search"));
        this.searchAgainAction.setKeyBindingData(new KeyBindingData(114, 0));
        this.searchAgainAction.setDescription("Search Memory for byte sequence");
        this.tool.addAction((DockingActionIf)this.searchAgainAction);
    }

    private void initializeOptionListeners() {
        ToolOptions opt = this.tool.getOptions("Search");
        opt.registerOption("Pre-populate Memory Search", (Object)true, null, "Initializes memory search byte sequence from the current selection provided the selection is less than 10 bytes.");
        opt.registerOption("Auto Restrict Memory Search on Selection", (Object)true, null, "Automactically adjusts memory searches restricted to the current selection, as selections comes and goes");
        opt.registerOption("Search Limit", (Object)DEFAULT_SEARCH_LIMIT, null, "Number of search hits found before stopping");
        opt.registerOption("Highlight Search Results", (Object)true, null, "Toggles highlight search results");
        opt.registerOption(" Highlight Color", (Object)PluginConstants.SEARCH_HIGHLIGHT_COLOR, null, "The search result highlight color");
        opt.registerOption("Highlight Color for Current Match", (Object)PluginConstants.SEARCH_HIGHLIGHT_CURRENT_ADDR_COLOR, null, "The search result highlight color for the currently selected match");
        opt.addOptionsChangeListener((OptionsChangeListener)this);
        opt = this.tool.getOptions("Listing Fields");
        opt.addOptionsChangeListener((OptionsChangeListener)this);
    }

    private void getOptions() {
        ToolOptions opt = this.tool.getOptions("Search");
        int newSearchLimit = opt.getInt("Search Limit", DEFAULT_SEARCH_LIMIT);
        if (newSearchLimit <= 0) {
            throw new OptionsVetoException("Search limit must be greater than 0");
        }
        this.searchLimit = newSearchLimit;
        this.prepopulateSearch = opt.getBoolean("Pre-populate Memory Search", true);
        this.autoRestrictSelection = opt.getBoolean("Auto Restrict Memory Search on Selection", true);
        this.doHighlight = opt.getBoolean("Highlight Search Results", true);
        this.defaultHighlightColor = opt.getColor(" Highlight Color", PluginConstants.SEARCH_HIGHLIGHT_COLOR);
        this.activeHighlightColor = opt.getColor("Highlight Color for Current Match", PluginConstants.SEARCH_HIGHLIGHT_CURRENT_ADDR_COLOR);
        opt = this.tool.getOptions("Listing Fields");
        this.byteGroupSize = opt.getInt("Bytes Field.Byte Group Size", 1);
        this.byteDelimiter = opt.getString("Bytes Field.Delimiter", " ");
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        this.getOptions();
    }

    protected void updateSelection(NavigatableActionContext context) {
        if (this.searchDialog != null) {
            this.searchDialog.setHasSelection(context.hasSelection(), this.autoRestrictSelection);
        }
    }

    private boolean hasBigSelection(NavigatableActionContext context) {
        if (!context.hasSelection()) {
            return false;
        }
        ProgramSelection selection = context.getSelection();
        if (selection.getNumAddressRanges() > 1) {
            return true;
        }
        return selection.getNumAddresses() > 20L;
    }

    private void showIncrementalSearchResults(SearchInfo info) {
        Program program = this.navigatable.getProgram();
        TableService query = (TableService)this.tool.getService(TableService.class);
        this.searchDialog.setStatusText("Searching...");
        SearchData searchData = info.getSearchData();
        byte[] searchBytes = searchData.getBytes();
        int selectionSize = searchBytes.length == 0 ? 1 : searchBytes.length;
        MemSearchTableModel model = new MemSearchTableModel((ServiceProvider)this.tool, selectionSize, program, info, this.getSearchStartAddress(info), this.navigatable.getSelection());
        this.currentResultsTableProvider = this.getTableResultsProvider(info.getSearchData(), program, model, query);
        this.currentResultsTableProvider.installRemoveItemsAction();
        this.currentTableListener = new TableLoadingListener(model);
        model.addInitialLoadListener(this.currentTableListener);
        GThreadedTablePanel<MemSearchResult> tablePanel = this.currentResultsTableProvider.getThreadedTablePanel();
        this.searchAllTaskMonitor = tablePanel.getTaskMonitor();
        this.installHighlightProvider(model, this.currentResultsTableProvider);
    }

    private void searchFinished() {
        this.searchDialog.searchCompleted();
        this.currentResultsTableProvider = null;
    }

    protected boolean canCloseDomainObject(DomainObject dObj) {
        if (this.navigatable != null && this.navigatable.getProgram() == dObj && this.isSearching()) {
            this.tool.setStatusInfo("Can't close program while searching...", true);
            return false;
        }
        return true;
    }

    boolean isSearching() {
        if (this.waitingForSearchAll) {
            return true;
        }
        if (this.searchDialog == null) {
            return false;
        }
        return this.searchDialog.getTaskScheduler().isBusy();
    }

    private TableComponentProvider<MemSearchResult> getTableResultsProvider(SearchData searchData, Program program, GhidraProgramTableModel<MemSearchResult> model, TableService tableService) {
        String searchString = this.searchDialog.getSearchText();
        String title = "Search Memory - \"" + searchString + "\"";
        String type = "Search";
        if (this.navigatable.supportsMarkers()) {
            return tableService.showTableWithMarkers(title, type, model, PluginConstants.SEARCH_HIGHLIGHT_COLOR, this.searchIcon, type, this.navigatable);
        }
        return tableService.showTable(title, type, model, type, this.navigatable);
    }

    private void installHighlightProvider(MemSearchTableModel model, TableComponentProvider<MemSearchResult> provider) {
        Program program = this.navigatable.getProgram();
        new SearchTableHighlightHandler(this.navigatable, model, provider, program);
    }

    private void installHighlightProvider(MemSearcherTask searcher, TableComponentProvider<MemSearchResult> provider) {
        Program program = this.navigatable.getProgram();
        new TaskHighlightHandler(this.navigatable, searcher, provider, program);
    }

    public void readConfigState(SaveState saveState) {
        this.showAdvancedOptions = saveState.getBoolean(SHOW_ADVANCED_OPTIONS, false);
        if (this.searchDialog != null) {
            this.searchDialog.setShowAdvancedOptions(this.showAdvancedOptions);
        }
    }

    public void writeConfigState(SaveState saveState) {
        if (this.searchDialog != null) {
            saveState.putBoolean(SHOW_ADVANCED_OPTIONS, this.searchDialog.getShowAdvancedOptions());
        }
    }

    @Override
    public void navigatableRemoved(Navigatable removedNavigatable) {
        this.setNavigatable(null);
    }

    public void contextChanged(ActionContext context) {
        this.updateNavigatable(context);
    }

    TaskListener createTaskListener() {
        return new SearchOnceTaskListener();
    }

    private class SearchOnceTaskListener
    implements TaskListener {
        private SearchOnceTaskListener() {
        }

        public void taskCompleted(Task task) {
            if (MemSearchPlugin.this.isDisposed()) {
                return;
            }
            MemSearcherTask searcher = (MemSearcherTask)task;
            List<MemSearchResult> results = searcher.getMatchingAddresses();
            if (results.isEmpty()) {
                MemSearchPlugin.this.searchDialog.setStatusText("Not Found");
                return;
            }
            MemSearchPlugin.this.searchDialog.setStatusText("Found");
            MemSearchResult result = results.get(0);
            Address addr = result.getAddress();
            MemSearchPlugin.this.goToService.goTo(MemSearchPlugin.this.navigatable, (ProgramLocation)MemSearchPlugin.this.getBytesFieldLocation(addr), MemSearchPlugin.this.navigatable.getProgram());
            MemSearchPlugin.this.lastMatchingAddress = addr;
            MemSearchPlugin.this.installHighlightProvider(searcher, null);
        }

        public void taskCancelled(Task task) {
        }
    }

    private class TaskHighlightHandler
    extends SearchResultsHighlighter {
        private final MemSearcherTask searchTask;

        TaskHighlightHandler(Navigatable navigatable, MemSearcherTask searcher, TableComponentProvider<MemSearchResult> provider, Program program) {
            super(navigatable, provider, program);
            this.searchTask = searcher;
        }

        @Override
        List<MemSearchResult> getMatches() {
            return this.searchTask.getMatchingAddresses();
        }
    }

    private class SearchTableHighlightHandler
    extends SearchResultsHighlighter {
        private final MemSearchTableModel model;

        SearchTableHighlightHandler(Navigatable navigatable, MemSearchTableModel model, TableComponentProvider<MemSearchResult> provider, Program program) {
            super(navigatable, provider, program);
            this.model = model;
        }

        @Override
        List<MemSearchResult> getMatches() {
            return this.model.getModelData();
        }
    }

    private abstract class SearchResultsHighlighter
    implements HighlightProvider,
    ComponentProviderActivationListener {
        private TableComponentProvider<MemSearchResult> provider;
        private Program highlightProgram;
        private final Navigatable highlightNavigatable;

        SearchResultsHighlighter(Navigatable navigatable, TableComponentProvider<MemSearchResult> provider, Program program) {
            this.highlightNavigatable = navigatable;
            this.provider = provider;
            this.highlightProgram = program;
            if (provider != null) {
                provider.addActivationListener(this);
            }
            this.highlightNavigatable.setHighlightProvider(this, program);
        }

        abstract List<MemSearchResult> getMatches();

        private List<MemSearchResult> getAddressesFoundInRange(Address start, Address end) {
            List<MemSearchResult> data = this.getMatches();
            int startIndex = this.findFirstIndex(data, start, end);
            if (startIndex < 0) {
                return Collections.emptyList();
            }
            int endIndex = this.findIndexAtOrGreater(data, end);
            if (endIndex < data.size() && data.get(endIndex).addressEquals(end)) {
                ++endIndex;
            }
            List<MemSearchResult> resultList = data.subList(startIndex, endIndex);
            return resultList;
        }

        private int findFirstIndex(List<MemSearchResult> list, Address start, Address end) {
            List<MemSearchResult> data = this.getMatches();
            int startIndex = this.findIndexAtOrGreater(data, start);
            if (startIndex > 0) {
                MemSearchResult resultBefore = data.get(startIndex - 1);
                Address beforeAddr = resultBefore.getAddress();
                int length = resultBefore.getLength();
                if (start.hasSameAddressSpace(beforeAddr) && start.subtract(beforeAddr) < (long)length) {
                    return startIndex - 1;
                }
            }
            if (startIndex == data.size()) {
                return -1;
            }
            MemSearchResult result = data.get(startIndex);
            Address addr = result.getAddress();
            if (end.compareTo((Object)addr) >= 0) {
                return startIndex;
            }
            return -1;
        }

        private int findIndexAtOrGreater(List<MemSearchResult> list, Address address) {
            MemSearchResult key = new MemSearchResult(address, 1);
            int index = Collections.binarySearch(list, key);
            if (index < 0) {
                index = -index - 1;
            }
            return index;
        }

        @Override
        public Highlight[] getHighlights(String text, Object obj, Class<? extends FieldFactory> fieldFactoryClass, int cursorTextOffset) {
            Program program;
            Program program2 = program = MemSearchPlugin.this.navigatable != null ? MemSearchPlugin.this.navigatable.getProgram() : null;
            if (fieldFactoryClass != BytesFieldFactory.class) {
                return NO_HIGHLIGHTS;
            }
            if (this.checkRemoveHighlights()) {
                return NO_HIGHLIGHTS;
            }
            if (!(obj instanceof CodeUnit)) {
                return NO_HIGHLIGHTS;
            }
            if (!MemSearchPlugin.this.doHighlight) {
                return NO_HIGHLIGHTS;
            }
            if (this.highlightProgram != program) {
                return NO_HIGHLIGHTS;
            }
            CodeUnit cu = (CodeUnit)obj;
            Address minAddr = cu.getMinAddress();
            Address maxAddr = cu.getMaxAddress();
            List<MemSearchResult> results = this.getAddressesFoundInRange(minAddr, maxAddr);
            Highlight[] highlights = new Highlight[results.size()];
            for (int i = 0; i < highlights.length; ++i) {
                MemSearchResult result = results.get(i);
                int highlightLength = result.getLength();
                Address addr = result.getAddress();
                Color highlightColor = this.getHighlightColor(addr, highlightLength);
                int startByteOffset = (int)addr.subtract(minAddr);
                int endByteOffset = startByteOffset + highlightLength - 1;
                startByteOffset = Math.max(startByteOffset, 0);
                highlights[i] = this.getHighlight(text, startByteOffset, endByteOffset, highlightColor);
            }
            return highlights;
        }

        private Highlight getHighlight(String text, int start, int end, Color color) {
            int charStart = this.getCharPosition(text, start);
            int charEnd = this.getCharPosition(text, end) + 1;
            return new Highlight(charStart, charEnd, color);
        }

        private int getCharPosition(String text, int byteOffset) {
            int groupSize = MemSearchPlugin.this.byteGroupSize * 2 + MemSearchPlugin.this.byteDelimiter.length();
            int groupIndex = byteOffset / MemSearchPlugin.this.byteGroupSize;
            int groupOffset = byteOffset % MemSearchPlugin.this.byteGroupSize;
            int pos = groupIndex * groupSize + 2 * groupOffset;
            return Math.min(text.length() - 1, pos);
        }

        private Color getHighlightColor(Address highlightStart, int highlightLength) {
            BytesFieldLocation byteLoc;
            Address byteAddress;
            long diff;
            ProgramLocation location;
            ProgramLocation programLocation = location = MemSearchPlugin.this.navigatable != null ? MemSearchPlugin.this.navigatable.getLocation() : null;
            if (location instanceof BytesFieldLocation && (diff = (byteAddress = (byteLoc = (BytesFieldLocation)location).getAddressForByte()).subtract(highlightStart)) >= 0L && diff < (long)highlightLength) {
                return MemSearchPlugin.this.activeHighlightColor;
            }
            return MemSearchPlugin.this.defaultHighlightColor;
        }

        private boolean checkRemoveHighlights() {
            if (this.provider != null) {
                if (!MemSearchPlugin.this.tool.isVisible(this.provider)) {
                    this.highlightNavigatable.removeHighlightProvider(this, this.highlightProgram);
                    return true;
                }
            } else if (!MemSearchPlugin.this.searchDialog.isVisible()) {
                this.highlightNavigatable.removeHighlightProvider(this, this.highlightProgram);
                return true;
            }
            return false;
        }

        public void componentProviderActivated(ComponentProvider componentProvider) {
            this.highlightNavigatable.setHighlightProvider(this, this.highlightProgram);
        }

        public void componentProviderDeactivated(ComponentProvider componentProvider) {
        }
    }

    class TableLoadingListener
    implements ThreadedTableModelListener {
        private ThreadedTableModel<MemSearchResult, ?> model;

        TableLoadingListener(ThreadedTableModel<MemSearchResult, ?> model) {
            this.model = model;
        }

        public void loadingFinished(boolean wasCancelled) {
            if (MemSearchPlugin.this.isDisposed()) {
                return;
            }
            TableComponentProvider<MemSearchResult> provider = MemSearchPlugin.this.currentResultsTableProvider;
            MemSearchPlugin.this.waitingForSearchAll = false;
            MemSearchPlugin.this.searchFinished();
            if (wasCancelled) {
                MemSearchPlugin.this.searchDialog.setStatusText("Search Cancelled");
                return;
            }
            int matchCount = this.model.getRowCount();
            if (matchCount == 0) {
                MemSearchPlugin.this.searchDialog.setStatusText("No matches found.");
                return;
            }
            if (matchCount >= MemSearchPlugin.this.searchLimit) {
                JComponent resultsTable = provider.getComponent();
                Msg.showInfo(this.getClass(), (Component)resultsTable, (String)"Search Limit Exceeded!", (Object)("Stopped search after finding " + matchCount + " matches.\nThe Search limit can be changed in the Edit->Options, under Tool Options"));
            }
            MemSearchPlugin.this.searchDialog.setStatusText("Done");
        }

        public void loadingStarted() {
        }

        public void loadPending() {
        }
    }
}

