/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.progmgr;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.app.context.ProgramActionContext;
import ghidra.app.context.ProgramContextAction;
import ghidra.app.services.GoToService;
import ghidra.app.services.NavigationHistoryService;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public class RedoAction
extends ProgramContextAction {
    private final PluginTool tool;

    public RedoAction(PluginTool tool, String owner) {
        super("Redo", owner);
        this.tool = tool;
        this.setHelpLocation(new HelpLocation("Tool", "Redo"));
        String[] menuPath = new String[]{"&Edit", "&Redo"};
        String group = "Undo";
        ImageIcon icon = ResourceManager.loadImage((String)"images/redo.png");
        MenuData menuData = new MenuData(menuPath, (Icon)icon, group);
        menuData.setMenuSubGroup("2Redo");
        this.setMenuBarData(menuData);
        this.setToolBarData(new ToolBarData((Icon)icon, group));
        this.setKeyBindingData(new KeyBindingData("ctrl shift Z"));
        this.setDescription("Redo");
        this.setSupportsDefaultToolContext(true);
    }

    @Override
    protected void actionPerformed(ProgramActionContext programContext) {
        Program program = programContext.getProgram();
        try {
            this.saveCurrentLocationToHistory();
            program.redo();
        }
        catch (IOException e) {
            Msg.showError((Object)((Object)this), null, null, null, (Throwable)e);
        }
    }

    public void update(Program program) {
        if (program == null) {
            this.getMenuBarData().setMenuItemName("Redo ");
            this.setDescription("");
            this.setEnabled(false);
        } else if (program.canRedo()) {
            String programName = program.getDomainFile().getName();
            this.getMenuBarData().setMenuItemName("Redo " + programName);
            String tip = HTMLUtilities.toWrappedHTML((String)("Redo " + HTMLUtilities.escapeHTML((String)program.getRedoName())));
            this.setDescription(tip);
            this.setEnabled(true);
        } else {
            this.setDescription("Redo");
            this.setEnabled(false);
        }
    }

    @Override
    protected boolean isEnabledForContext(ProgramActionContext context) {
        Program program = context.getProgram();
        return program.canRedo();
    }

    private void saveCurrentLocationToHistory() {
        GoToService goToService = (GoToService)this.tool.getService(GoToService.class);
        NavigationHistoryService historyService = (NavigationHistoryService)this.tool.getService(NavigationHistoryService.class);
        if (goToService != null && historyService != null) {
            historyService.addNewLocation(goToService.getDefaultNavigatable());
        }
    }
}

