/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.progmgr;

import docking.DialogComponentProvider;
import docking.Tool;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.builder.ActionBuilder;
import docking.options.editor.OptionsDialog;
import docking.options.editor.OptionsEditorListener;
import docking.options.editor.StringBasedFileEditor;
import ghidra.app.context.ProgramActionContext;
import ghidra.app.events.CloseProgramPluginEvent;
import ghidra.app.events.ExternalProgramLocationPluginEvent;
import ghidra.app.events.ExternalProgramSelectionPluginEvent;
import ghidra.app.events.OpenProgramPluginEvent;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.events.ProgramOpenedPluginEvent;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.plugin.core.progmgr.MultiProgramManager;
import ghidra.app.plugin.core.progmgr.ProgramSaveManager;
import ghidra.app.plugin.core.progmgr.RedoAction;
import ghidra.app.plugin.core.progmgr.UndoAction;
import ghidra.app.services.ProgramManager;
import ghidra.app.util.NamespaceUtils;
import ghidra.app.util.task.OpenProgramTask;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.data.ProjectFileManager;
import ghidra.framework.main.OpenVersionedFileDialog;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFileFilter;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.ProjectData;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.Options;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.framework.protocol.ghidra.GhidraURL;
import ghidra.framework.protocol.ghidra.GhidraURLConnection;
import ghidra.framework.protocol.ghidra.GhidraURLWrappedContent;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.util.CodeUnitLocation;
import ghidra.program.util.FunctionSignatureFieldLocation;
import ghidra.program.util.LabelFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.NotOwnerException;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Support", shortDescription="Manage open programs", description="This plugin provides actions for opening and closing programs.  It also provides a service to allow plugins to open/close programs.  This plugin is responsible for sending out plugin events to notify all other programs when a program is opened or close.", servicesProvided={ProgramManager.class}, eventsConsumed={OpenProgramPluginEvent.class, CloseProgramPluginEvent.class, ExternalProgramLocationPluginEvent.class, ExternalProgramSelectionPluginEvent.class, ProgramActivatedPluginEvent.class, ProgramLocationPluginEvent.class, ProgramSelectionPluginEvent.class}, eventsProduced={OpenProgramPluginEvent.class, CloseProgramPluginEvent.class, ExternalProgramLocationPluginEvent.class, ExternalProgramSelectionPluginEvent.class, ProgramOpenedPluginEvent.class, ProgramClosedPluginEvent.class, ProgramActivatedPluginEvent.class})
public class ProgramManagerPlugin
extends Plugin
implements ProgramManager {
    private static final String SAVE_GROUP = "DomainObjectSave";
    private static final String OPEN_GROUP = "DomainObjectOpen";
    private MultiProgramManager programMgr;
    private ProgramSaveManager programSaveMgr;
    private DockingAction openAction;
    private DockingAction saveAllAction;
    private DockingAction closeAction;
    private DockingAction saveAction;
    private DockingAction saveAsAction;
    private DockingAction optionsAction;
    private DockingAction closeOthersAction;
    private DockingAction closeAllAction;
    private int transactionID = -1;
    private OpenVersionedFileDialog openDialog;
    private boolean locked = false;
    private UndoAction undoAction;
    private RedoAction redoAction;
    private ProgramLocation currentLocation;

    public ProgramManagerPlugin(PluginTool tool) {
        super(tool);
        this.createActions();
        this.programMgr = new MultiProgramManager(this);
        this.programSaveMgr = new ProgramSaveManager(tool, this);
    }

    public boolean acceptData(DomainFile[] data) {
        if (data == null || data.length == 0) {
            return false;
        }
        if (this.locked) {
            Msg.showError((Object)this, (Component)this.tool.getToolFrame(), (String)"Open Program Failed", (Object)"Program manager is locked and cannot open additional programs");
            return false;
        }
        ArrayList<DomainFile> filesToOpen = new ArrayList<DomainFile>();
        for (DomainFile domainFile : data) {
            if (domainFile == null || !Program.class.isAssignableFrom(domainFile.getDomainObjectClass())) continue;
            filesToOpen.add(domainFile);
        }
        this.openPrograms(filesToOpen);
        return !filesToOpen.isEmpty();
    }

    public Class<?>[] getSupportedDataTypes() {
        return new Class[]{Program.class};
    }

    @Override
    public Program openProgram(URL ghidraURL, int state) {
        if (this.locked) {
            Msg.showError((Object)this, (Component)this.tool.getToolFrame(), (String)"Open Program Failed", (Object)"Program manager is locked and cannot open additional programs");
            return null;
        }
        AtomicReference ref = new AtomicReference();
        Runnable r = () -> ref.set(this.doOpenProgram(ghidraURL, state));
        SystemUtilities.runSwingNow((Runnable)r);
        return (Program)ref.get();
    }

    private void messageBadProgramURL(URL ghidraURL) {
        Msg.showError((Object)this, null, (String)"Invalid Ghidra URL", (Object)("Ghidra URL does not reference a Ghidra Program: " + ghidraURL));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Program doOpenProgram(URL ghidraURL, int openState) {
        Program program;
        Object content;
        GhidraURLWrappedContent wrappedContent;
        block27: {
            Program program2;
            block26: {
                Program program3;
                block25: {
                    Program program4;
                    block24: {
                        Program program5;
                        block23: {
                            if (!GhidraURL.isServerRepositoryURL((URL)ghidraURL)) {
                                Msg.showError((Object)this, null, (String)"Invalid Ghidra URL", (Object)("Ghidra URL does not reference a Ghidra Program: " + ghidraURL));
                                return null;
                            }
                            Program openProgram = this.programMgr.getOpenProgram(ghidraURL);
                            if (openProgram != null) {
                                this.programMgr.addProgram(openProgram, GhidraURL.getNormalizedURL((URL)ghidraURL), openState);
                                this.updateActions();
                                if (openState != 1) return openProgram;
                                this.gotoProgramRef(openProgram, ghidraURL.getRef());
                                this.programMgr.saveLocation();
                                return openProgram;
                            }
                            wrappedContent = null;
                            content = null;
                            try {
                                GhidraURLConnection c = (GhidraURLConnection)ghidraURL.openConnection();
                                Object obj = c.getContent();
                                if (c.getResponseCode() == 401) {
                                    Program program6 = null;
                                    return program6;
                                }
                                if (!(obj instanceof GhidraURLWrappedContent)) {
                                    this.messageBadProgramURL(ghidraURL);
                                    program5 = null;
                                    if (content == null) return program5;
                                    break block23;
                                }
                                wrappedContent = (GhidraURLWrappedContent)obj;
                                content = wrappedContent.getContent((Object)this);
                                if (!(content instanceof DomainFile)) {
                                    this.messageBadProgramURL(ghidraURL);
                                    program4 = null;
                                    if (content == null) return program4;
                                    break block24;
                                }
                                DomainFile df = (DomainFile)content;
                                if (!"Program".equals(df.getContentType())) {
                                    this.messageBadProgramURL(ghidraURL);
                                    program3 = null;
                                    if (content == null) return program3;
                                    break block25;
                                }
                                OpenProgramTask task = new OpenProgramTask(df, true, (Object)this);
                                TaskLauncher.launch((Task)task);
                                openProgram = task.getOpenProgram();
                                if (openProgram == null) {
                                    program2 = null;
                                    if (content == null) return program2;
                                    break block26;
                                }
                                this.programMgr.addProgram(openProgram, GhidraURL.getNormalizedURL((URL)ghidraURL), openState);
                                this.updateActions();
                                openProgram.release((Object)this);
                                if (openState == 1) {
                                    this.gotoProgramRef(openProgram, ghidraURL.getRef());
                                    this.programMgr.saveLocation();
                                }
                                program = openProgram;
                                if (content == null) return program;
                                break block27;
                            }
                            catch (NotFoundException e) {
                                this.messageBadProgramURL(ghidraURL);
                                return null;
                            }
                            catch (MalformedURLException e) {
                                Msg.showError((Object)this, null, (String)"Invalid Ghidra URL", (Object)("Improperly formed Ghidra URL: " + ghidraURL));
                                return null;
                            }
                            catch (IOException e) {
                                Msg.showError((Object)this, null, (String)"Program Open Failed", (Object)("Failed to open Ghidra URL: " + e.getMessage()));
                                return null;
                            }
                        }
                        wrappedContent.release(content, (Object)this);
                        return program5;
                    }
                    wrappedContent.release(content, (Object)this);
                    return program4;
                }
                wrappedContent.release(content, (Object)this);
                return program3;
            }
            wrappedContent.release(content, (Object)this);
            return program2;
        }
        wrappedContent.release(content, (Object)this);
        return program;
        finally {
            if (content != null) {
                wrappedContent.release(content, (Object)this);
            }
        }
    }

    private boolean gotoProgramRef(Program program, String ref) {
        if (ref == null) {
            return false;
        }
        String trimmedRef = ref.trim();
        if (trimmedRef.length() == 0) {
            return false;
        }
        List symbols = NamespaceUtils.getSymbols((String)trimmedRef, (Program)program);
        Symbol sym = symbols.isEmpty() ? null : (Symbol)symbols.get(0);
        FunctionSignatureFieldLocation loc = null;
        if (sym != null) {
            SymbolType type = sym.getSymbolType();
            if (type == SymbolType.FUNCTION) {
                loc = new FunctionSignatureFieldLocation(sym.getProgram(), sym.getAddress());
            } else if (type == SymbolType.LABEL) {
                loc = new LabelFieldLocation(sym);
            }
        } else {
            Address addr = program.getAddressFactory().getAddress(trimmedRef);
            if (addr != null && addr.isMemoryAddress()) {
                loc = new CodeUnitLocation(program, addr, 0, 0, 0);
            }
        }
        if (loc == null) {
            Msg.showError((Object)this, null, (String)"Navigation Failed", (Object)("Referenced label/function not found: " + trimmedRef));
            return false;
        }
        this.firePluginEvent(new ProgramLocationPluginEvent(this.getName(), (ProgramLocation)loc, program));
        return true;
    }

    @Override
    public Program openProgram(DomainFile df) {
        return this.openProgram(df, -1, 1);
    }

    @Override
    public Program openProgram(DomainFile df, Component parent) {
        return this.openProgram(df, -1, 1, parent);
    }

    @Override
    public Program openProgram(DomainFile df, int version) {
        return this.openProgram(df, version, 1);
    }

    @Override
    public Program openProgram(DomainFile df, int version, int state) {
        return this.openProgram(df, version, state, this.tool.getToolFrame());
    }

    private Program openProgram(DomainFile domainFile, int version, int state, Component parent) {
        if (domainFile == null) {
            throw new IllegalArgumentException("Domain file cannot be null");
        }
        if (this.locked) {
            Msg.showError((Object)this, (Component)this.tool.getToolFrame(), (String)"Open Program Failed", (Object)"Program manager is locked and cannot open additional programs");
            return null;
        }
        AtomicReference ref = new AtomicReference();
        Runnable r = () -> {
            ref.set(this.doOpenProgram(domainFile, version, state));
            this.updateActions();
        };
        SystemUtilities.runSwingNow((Runnable)r);
        Program program = (Program)ref.get();
        if (program != null) {
            Msg.info((Object)this, (Object)("Opened program in " + this.tool.getName() + " tool: " + domainFile));
        }
        return program;
    }

    @Override
    public Program getCurrentProgram() {
        return this.programMgr.getCurrentProgram();
    }

    public DomainFile[] getData() {
        Program[] p = this.getAllOpenPrograms();
        DomainFile[] dfs = new DomainFile[p.length];
        for (int i = 0; i < dfs.length; ++i) {
            dfs[i] = p[i].getDomainFile();
        }
        return dfs;
    }

    @Override
    public Program[] getAllOpenPrograms() {
        return this.programMgr.getAllPrograms();
    }

    public void dispose() {
        this.programMgr.dispose();
        this.tool.clearLastEvents();
    }

    @Override
    public boolean closeOtherPrograms(boolean ignoreChanges) {
        Program[] otherPrograms = this.programMgr.getOtherPrograms();
        Runnable r = () -> this.doCloseAllPrograms(otherPrograms, ignoreChanges);
        SystemUtilities.runSwingNow((Runnable)r);
        return this.programMgr.isEmpty();
    }

    @Override
    public boolean closeAllPrograms(boolean ignoreChanges) {
        Program[] openPrograms = this.programMgr.getAllPrograms();
        Runnable r = () -> this.doCloseAllPrograms(openPrograms, ignoreChanges);
        SystemUtilities.runSwingNow((Runnable)r);
        return this.programMgr.isEmpty();
    }

    private void doCloseAllPrograms(Program[] openPrograms, boolean ignoreChanges) {
        ArrayList<Program> toRemove = new ArrayList<Program>();
        Program currentProgram = this.programMgr.getCurrentProgram();
        for (Program p : openPrograms) {
            if (ignoreChanges) {
                toRemove.add(p);
            } else if (p.isClosed()) {
                toRemove.add(p);
            }
            if (!this.tool.canCloseDomainObject((DomainObject)p)) continue;
            if (!this.programSaveMgr.canClose(p)) {
                return;
            }
            toRemove.add(p);
        }
        if (toRemove.contains(currentProgram)) {
            toRemove.remove(currentProgram);
            toRemove.add(currentProgram);
        }
        for (Program program : toRemove) {
            this.programMgr.removeProgram(program);
        }
        this.updateActions();
    }

    @Override
    public boolean closeProgram(Program program, boolean ignoreChanges) {
        if (program == null) {
            return false;
        }
        Runnable r = () -> {
            if (ignoreChanges || program.isClosed() || this.programMgr.isPersistent(program) || this.tool.canCloseDomainObject((DomainObject)program) && this.programSaveMgr.canClose(program)) {
                this.programMgr.removeProgram(program);
                this.updateActions();
            }
        };
        SystemUtilities.runSwingNow((Runnable)r);
        return !this.programMgr.contains(program);
    }

    protected void close() {
        Program[] programs = this.programMgr.getAllPrograms();
        if (programs.length == 0) {
            return;
        }
        Program currentProgram = this.getCurrentProgram();
        for (Program program : programs) {
            if (program == currentProgram) continue;
            this.programMgr.removeProgram(program);
        }
        if (currentProgram != null) {
            this.programMgr.removeProgram(currentProgram);
        }
        this.updateActions();
        this.tool.setSubTitle("");
        this.tool.clearLastEvents();
    }

    @Override
    public void setCurrentProgram(Program p) {
        Runnable r = () -> {
            this.programMgr.setCurrentProgram(p);
            this.updateActions();
        };
        SystemUtilities.runSwingNow((Runnable)r);
    }

    @Override
    public Program getProgram(Address addr) {
        return this.programMgr.getProgram(addr);
    }

    @Override
    public void openProgram(Program program) {
        this.openProgram(program, true);
    }

    @Override
    public void openProgram(Program program, boolean current) {
        this.openProgram(program, current ? 1 : 2);
    }

    @Override
    public void openProgram(Program program, int state) {
        if (this.locked) {
            throw new IllegalStateException("Progam manager is locked and cannot accept a new program");
        }
        Runnable r = () -> {
            this.programMgr.addProgram(program, null, state);
            if (state == 1) {
                this.programMgr.saveLocation();
            }
            this.updateActions();
        };
        SystemUtilities.runSwingNow((Runnable)r);
    }

    @Override
    public boolean closeProgram() {
        return this.closeProgram(this.getCurrentProgram(), false);
    }

    protected boolean saveData() {
        boolean result = this.programSaveMgr.canCloseAll();
        this.updateActions();
        return result;
    }

    protected boolean hasUnsaveData() {
        Program[] allOpenPrograms;
        for (Program program : allOpenPrograms = this.getAllOpenPrograms()) {
            if (!program.isChanged()) continue;
            return true;
        }
        return false;
    }

    private void createActions() {
        int subMenuGroupOrder = 1;
        this.openAction = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Open File", this.getName()).onAction(c -> this.open())).menuPath(new String[]{"&File", "&Open..."})).menuGroup(OPEN_GROUP, Integer.toString(subMenuGroupOrder++))).keyBinding("ctrl O")).buildAndInstall((Tool)this.tool);
        this.closeAction = (DockingAction)((ActionBuilder)((ActionBuilder)new ActionBuilder("Close File", this.getName()).menuPath(new String[]{"&File", "&Close"})).menuGroup(OPEN_GROUP, Integer.toString(subMenuGroupOrder++))).withContext(ProgramActionContext.class).supportsDefaultToolContext(true).onAction(c -> this.closeProgram(c.getProgram(), false)).keyBinding("ctrl W").buildAndInstall((Tool)this.tool);
        this.closeOthersAction = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Close Others", this.getName()).menuPath(new String[]{"&File", "Close &Others"})).menuGroup(OPEN_GROUP, Integer.toString(subMenuGroupOrder++))).enabled(false)).onAction(c -> this.closeOtherPrograms(false))).buildAndInstall((Tool)this.tool);
        this.closeAllAction = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Close All", this.getName()).menuPath(new String[]{"&File", "Close &All"})).menuGroup(OPEN_GROUP, Integer.toString(subMenuGroupOrder++))).onAction(c -> this.closeAllPrograms(false))).enabled(false)).buildAndInstall((Tool)this.tool);
        this.saveAction = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Save File", this.getName()).menuPath(new String[]{"&File", "Save File"})).description("Save Program")).menuGroup(SAVE_GROUP, Integer.toString(subMenuGroupOrder++))).menuIcon(null)).toolBarIcon("images/disk.png")).toolBarGroup("1_Toolbar_Navigation_Group")).keyBinding("ctrl S")).withContext(ProgramActionContext.class).supportsDefaultToolContext(true).enabledWhen(c -> c.getProgram() != null && c.getProgram().isChanged()).onAction(c -> this.programSaveMgr.saveProgram(c.getProgram())).buildAndInstall((Tool)this.tool);
        this.saveAsAction = (DockingAction)((ActionBuilder)((ActionBuilder)new ActionBuilder("Save As File", this.getName()).menuPath(new String[]{"&File", "Save &As..."})).menuGroup(SAVE_GROUP, Integer.toString(subMenuGroupOrder++))).withContext(ProgramActionContext.class).supportsDefaultToolContext(true).onAction(c -> this.programSaveMgr.saveAs(c.getProgram())).buildAndInstall((Tool)this.tool);
        this.saveAllAction = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Save All Files", this.getName()).menuPath(new String[]{"&File", "Save All"})).description("Save All Programs")).menuGroup(SAVE_GROUP, Integer.toString(subMenuGroupOrder++))).onAction(c -> this.programSaveMgr.saveChangedPrograms())).buildAndInstall((Tool)this.tool);
        this.optionsAction = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Program Options", this.getName()).menuPath(new String[]{"&Edit", "P&rogram Options..."})).description("Edit Options for current program")).menuGroup("AOptions", "AOptionsb")).withContext(ProgramActionContext.class).supportsDefaultToolContext(true).onAction(c -> this.showProgramOptions(c.getProgram())).buildAndInstall((Tool)this.tool);
        this.undoAction = new UndoAction(this.tool, this.getName());
        this.redoAction = new RedoAction(this.tool, this.getName());
        this.tool.addAction((DockingActionIf)this.undoAction);
        this.tool.addAction((DockingActionIf)this.redoAction);
    }

    private void showProgramOptions(final Program currentProgram) {
        List names = currentProgram.getOptionsNames();
        Options[] options = new Options[names.size()];
        for (int i = 0; i < names.size(); ++i) {
            String optionName = (String)names.get(i);
            options[i] = currentProgram.getOptions(optionName);
            if (!optionName.equals("Program Information")) continue;
            this.setPropertyEditor(options[i], "Executable Location");
            options[i].setOptionsHelpLocation(new HelpLocation(this.getName(), "Program_Options"));
        }
        OptionsDialog dialog = new OptionsDialog("Properties for " + currentProgram.getName(), "Properties", options, new OptionsEditorListener(){

            public void beforeChangesApplied() {
                ProgramManagerPlugin.this.startTransaction(currentProgram);
            }

            public void changesApplied() {
                ProgramManagerPlugin.this.endTransaction(currentProgram);
            }
        });
        dialog.setHelpLocation(new HelpLocation("ProgramManagerPlugin", "Program_Options"));
        this.tool.showDialog((DialogComponentProvider)dialog);
    }

    private void setPropertyEditor(Options options, String filePropertyName) {
        PropertyEditor editor = options.getPropertyEditor(filePropertyName);
        if (editor == null && options.getType(filePropertyName) == OptionType.STRING_TYPE) {
            options.registerOption(filePropertyName, OptionType.STRING_TYPE, null, null, null, (PropertyEditor)new StringBasedFileEditor());
        }
    }

    private void startTransaction(Program currentProgram) {
        if (this.transactionID < 0) {
            this.transactionID = currentProgram.startTransaction("Edit Program Properties");
        }
    }

    private void endTransaction(Program currentProgram) {
        if (this.transactionID >= 0) {
            currentProgram.endTransaction(this.transactionID, true);
            this.transactionID = -1;
        }
    }

    private void updateActions() {
        Program p = this.programMgr.getCurrentProgram();
        this.updateCloseAction(p);
        this.updateProgramOptionsAction(p);
        this.updateProgramActions();
        this.closeAllAction.setEnabled(p != null);
        this.optionsAction.setEnabled(p != null);
        Program[] programList = this.programMgr.getAllPrograms();
        this.closeOthersAction.setEnabled(programList.length > 1);
        this.tool.contextChanged(null);
    }

    private void updateSaveAction(Program p) {
        if (p == null) {
            this.saveAction.getMenuBarData().setMenuItemName("&Save");
            this.saveAction.setDescription("Save Program");
            this.saveAction.setEnabled(false);
        } else {
            String programName = "'" + p.getDomainFile().getName() + "'";
            this.saveAction.getMenuBarData().setMenuItemName("&Save " + programName);
            this.saveAction.setDescription("Save " + programName);
            this.saveAction.setEnabled(p.isChanged());
        }
    }

    private void updateSaveAsAction(Program p) {
        if (p == null) {
            this.saveAsAction.getMenuBarData().setMenuItemName("Save &As...");
        } else {
            String programName = "'" + p.getDomainFile().getName() + "'";
            this.saveAsAction.getMenuBarData().setMenuItemName("Save " + programName + " &As...");
        }
    }

    private void updateProgramOptionsAction(Program p) {
        if (p == null) {
            this.optionsAction.getMenuBarData().setMenuItemName("Program Options");
        } else {
            String programName = "'" + p.getDomainFile().getName() + "'";
            this.optionsAction.getMenuBarData().setMenuItemName("Options for " + programName + "...");
        }
        this.optionsAction.setEnabled(p != null);
    }

    private void updateCloseAction(Program p) {
        if (p == null) {
            this.closeAction.getMenuBarData().setMenuItemName("&Close");
            this.closeAction.setDescription("Close Program");
        } else {
            String programName = "'" + p.getDomainFile().getName() + "'";
            this.closeAction.getMenuBarData().setMenuItemName("&Close " + programName);
            this.closeAction.setDescription("<html>Close " + HTMLUtilities.escapeHTML((String)programName));
        }
        this.closeAction.setEnabled(p != null);
    }

    private void open() {
        if (this.openDialog == null) {
            ActionListener listener = e -> {
                DomainFile domainFile = this.openDialog.getDomainFile();
                int version = this.openDialog.getVersion();
                if (domainFile == null) {
                    this.openDialog.setStatusText("Please choose a Program");
                } else {
                    this.openDialog.close();
                    this.doOpenProgram(domainFile, version, 1);
                }
            };
            DomainFileFilter filter = f -> {
                Class c = f.getDomainObjectClass();
                return Program.class.isAssignableFrom(c);
            };
            this.openDialog = new OpenVersionedFileDialog(this.tool, "Open Program", filter);
            this.openDialog.setHelpLocation(new HelpLocation("ProgramManagerPlugin", "Open_File_Dialog"));
            this.openDialog.addOkActionListener(listener);
        }
        this.tool.showDialog((DialogComponentProvider)this.openDialog);
        this.updateActions();
    }

    public void openPrograms(List<DomainFile> filesToOpen) {
        OpenProgramTask openTask = null;
        for (DomainFile domainFile : filesToOpen) {
            if (this.programMgr.getOpenProgram(domainFile, -1) != null) continue;
            if (openTask == null) {
                openTask = new OpenProgramTask(domainFile, -1, (Object)this);
                continue;
            }
            openTask.addProgramToOpen(domainFile, -1);
        }
        if (openTask != null) {
            new TaskLauncher(openTask, (Component)this.tool.getToolFrame());
            List<Program> openPrograms = openTask.getOpenPrograms();
            for (Program program : openPrograms) {
                this.openProgram(program, 2);
                program.release((Object)this);
            }
            if (!openPrograms.isEmpty()) {
                this.openProgram(openPrograms.get(0), 1);
            }
        }
    }

    protected Program doOpenProgram(DomainFile domainFile, int version, int openState) {
        Program openProgram = this.programMgr.getOpenProgram(domainFile, version);
        if (openProgram != null) {
            this.openProgram(openProgram, openState);
            return openProgram;
        }
        OpenProgramTask task = new OpenProgramTask(domainFile, version, (Object)this);
        new TaskLauncher((Task)task, (Component)this.tool.getToolFrame());
        openProgram = task.getOpenProgram();
        if (openProgram != null) {
            this.openProgram(openProgram, openState);
            openProgram.release((Object)this);
        }
        return openProgram;
    }

    void updateProgramActions() {
        this.updateSaveAllAction();
        Program p = this.getCurrentProgram();
        this.updateSaveAction(this.getCurrentProgram());
        this.updateSaveAsAction(this.getCurrentProgram());
        this.undoAction.update(p);
        this.redoAction.update(p);
    }

    private void updateSaveAllAction() {
        Program[] programList;
        boolean saveAllEnable = false;
        for (Program element : programList = this.programMgr.getAllPrograms()) {
            if (!element.isChanged()) continue;
            saveAllEnable = true;
            break;
        }
        this.saveAllAction.setEnabled(saveAllEnable);
    }

    public void writeDataState(SaveState saveState) {
        ProjectLocator projectLocator;
        ArrayList<Program> programs = new ArrayList<Program>();
        for (Program p : this.programMgr.getAllPrograms()) {
            ProjectLocator projectLocator2 = p.getDomainFile().getProjectLocator();
            if (projectLocator2 == null || projectLocator2.isTransient()) continue;
            programs.add(p);
        }
        saveState.putInt("NUM_PROGRAMS", programs.size());
        int i = 0;
        for (Program p : programs) {
            this.writeProgramInfo(p, saveState, i++);
        }
        Program p = this.programMgr.getCurrentProgram();
        if (p != null && (projectLocator = p.getDomainFile().getProjectLocator()) != null && !projectLocator.isTransient()) {
            saveState.putString("CURRENT_FILE", p.getDomainFile().getName());
            if (this.currentLocation != null) {
                this.currentLocation.saveState(saveState);
            }
        }
    }

    public void readDataState(SaveState saveState) {
        if (!this.programMgr.isEmpty()) {
            this.currentLocation = null;
            return;
        }
        this.loadPrograms(saveState);
        String currentFile = saveState.getString("CURRENT_FILE", null);
        Program[] programs = this.programMgr.getAllPrograms();
        if (programs.length != 0) {
            if (currentFile != null) {
                for (Program program : programs) {
                    if (!program.getDomainFile().getName().equals(currentFile)) continue;
                    this.programMgr.setCurrentProgram(program);
                    this.currentLocation = ProgramLocation.getLocation((Program)program, (SaveState)saveState);
                    break;
                }
            }
            if (this.getCurrentProgram() == null) {
                this.programMgr.setCurrentProgram(programs[0]);
            }
        }
        this.updateActions();
    }

    public void dataStateRestoreCompleted() {
        if (this.currentLocation != null) {
            this.tool.firePluginEvent((PluginEvent)new ProgramLocationPluginEvent(this.getName(), this.currentLocation, this.getCurrentProgram()));
        }
    }

    private void writeProgramInfo(Program program, SaveState saveState, int index) {
        if (this.locked) {
            return;
        }
        String projectLocation = null;
        String projectName = null;
        String path = null;
        DomainFile df = program.getDomainFile();
        ProjectLocator projectLocator = df.getProjectLocator();
        if (projectLocator != null && !projectLocator.isTransient()) {
            projectLocation = projectLocator.getLocation();
            projectName = projectLocator.getName();
            path = df.getPathname();
        }
        int version = -1;
        if (!df.isLatestVersion()) {
            version = df.getVersion();
        }
        saveState.putString("LOCATION_" + index, projectLocation);
        saveState.putString("PROJECT_NAME_" + index, projectName);
        saveState.putInt("VERSION_" + index, version);
        saveState.putString("PATHNAME_" + index, path);
    }

    private void loadPrograms(SaveState saveState) {
        int n = saveState.getInt("NUM_PROGRAMS", 0);
        if (n == 0) {
            return;
        }
        OpenProgramTask openTask = null;
        for (int index = 0; index < n; ++index) {
            DomainFile domainFile = this.getDomainFile(saveState, index);
            if (domainFile == null) continue;
            int version = this.getVersion(saveState, index);
            if (openTask == null) {
                openTask = new OpenProgramTask(domainFile, version, (Object)this);
                continue;
            }
            openTask.addProgramToOpen(domainFile, version);
        }
        if (openTask == null) {
            return;
        }
        openTask.setNoCheckout();
        try {
            new TaskLauncher((Task)openTask, (Component)this.tool.getToolFrame(), 100);
        }
        catch (RuntimeException e) {
            Msg.showError((Object)this, (Component)this.tool.getToolFrame(), (String)"Error Getting Domain File", (Object)"Can't open program", (Throwable)e);
        }
        List<Program> openPrograms = openTask.getOpenPrograms();
        for (Program program : openPrograms) {
            this.openProgram(program, 2);
            program.release((Object)this);
        }
    }

    private DomainFile getDomainFile(SaveState saveState, int index) {
        DomainFile df;
        String pathname = saveState.getString("PATHNAME_" + index, null);
        String location = saveState.getString("LOCATION_" + index, null);
        String projectName = saveState.getString("PROJECT_NAME_" + index, null);
        if (location == null || projectName == null) {
            return null;
        }
        ProjectLocator projectLocator = new ProjectLocator(location, projectName);
        ProjectData projectData = this.tool.getProject().getProjectData(projectLocator);
        if (projectData == null) {
            try {
                projectData = new ProjectFileManager(projectLocator, false, false);
            }
            catch (NotOwnerException e) {
                Msg.showError((Object)this, (Component)this.tool.getToolFrame(), (String)"Program Open Failed", (Object)("Not project owner: " + projectLocator + "(" + pathname + ")"));
                return null;
            }
            catch (IOException e) {
                Msg.showError((Object)this, (Component)this.tool.getToolFrame(), (String)"Program Open Failed", (Object)("Project error: " + e.getMessage()));
                return null;
            }
        }
        if ((df = projectData.getFile(pathname)) == null) {
            String message = "Can't open program - \"" + pathname + "\"";
            int version = this.getVersion(saveState, index);
            if (version != -1) {
                message = message + " version " + version;
            }
            Msg.showError((Object)this, (Component)this.tool.getToolFrame(), (String)"Program Not Found", (Object)message);
        }
        return df;
    }

    private int getVersion(SaveState saveState, int index) {
        return saveState.getInt("VERSION_" + index, -1);
    }

    public void processEvent(PluginEvent event) {
        if (event instanceof OpenProgramPluginEvent) {
            OpenProgramPluginEvent ev = (OpenProgramPluginEvent)event;
            this.openProgram(ev.getProgram());
        } else if (event instanceof CloseProgramPluginEvent) {
            CloseProgramPluginEvent ev = (CloseProgramPluginEvent)event;
            this.closeProgram(ev.getProgram(), ev.ignoreChanges());
        } else if (event instanceof ProgramActivatedPluginEvent) {
            Program p = ((ProgramActivatedPluginEvent)event).getActiveProgram();
            this.programMgr.setCurrentProgram(p);
        } else if (event instanceof ProgramLocationPluginEvent) {
            ProgramLocationPluginEvent ev = (ProgramLocationPluginEvent)event;
            this.currentLocation = ev.getLocation();
            this.firePluginEvent(new ExternalProgramLocationPluginEvent(this.getName(), this.currentLocation, ev.getProgram()));
        } else if (event instanceof ExternalProgramLocationPluginEvent) {
            Program currentProgram = this.programMgr.getCurrentProgram();
            if (currentProgram == null) {
                return;
            }
            ExternalProgramLocationPluginEvent ev = (ExternalProgramLocationPluginEvent)event;
            ProgramLocation loc = ev.getLocation();
            if (loc != null && (loc = this.localizeLocation(currentProgram, loc)) != null && currentProgram.getAddressFactory().isValidAddress(loc.getAddress()) && currentProgram.getMemory().contains(loc.getAddress())) {
                this.firePluginEvent(new ProgramLocationPluginEvent(this.getName(), loc, ev.getProgram()));
            }
        } else if (event instanceof ProgramSelectionPluginEvent) {
            ProgramSelectionPluginEvent ev = (ProgramSelectionPluginEvent)event;
            this.firePluginEvent(new ExternalProgramSelectionPluginEvent(this.getName(), ev.getSelection(), ev.getProgram()));
        } else if (event instanceof ExternalProgramSelectionPluginEvent) {
            Program currentProgram = this.programMgr.getCurrentProgram();
            ExternalProgramSelectionPluginEvent ev = (ExternalProgramSelectionPluginEvent)event;
            if (currentProgram == null) {
                return;
            }
            ProgramSelection sel = ev.getSelection();
            if (sel != null && this.hasValidAddresses(currentProgram, sel = this.localizeSelection(currentProgram, sel))) {
                this.firePluginEvent(new ProgramSelectionPluginEvent(this.getName(), sel, ev.getProgram()));
            }
        }
    }

    private ProgramSelection localizeSelection(Program currentProgram, ProgramSelection sel) {
        if (this.hasValidAddresses(currentProgram, sel)) {
            return sel;
        }
        AddressFactory addrFactory = currentProgram.getAddressFactory();
        AddressSpace defaultSpace = addrFactory.getDefaultAddressSpace();
        AddressSet locAddressSet = new AddressSet();
        AddressRangeIterator riter = sel.getAddressRanges();
        while (riter.hasNext()) {
            AddressRange range = (AddressRange)riter.next();
            Address min = range.getMinAddress();
            Address max = range.getMaxAddress();
            try {
                min = defaultSpace.getAddress(min.getOffset());
                max = defaultSpace.getAddress(max.getOffset());
                locAddressSet.addRange(min, max);
            }
            catch (Exception exception) {}
        }
        return new ProgramSelection((AddressSetView)locAddressSet);
    }

    private ProgramLocation localizeLocation(Program currentProgram, ProgramLocation loc) {
        Address addr = loc.getAddress();
        Address refAddr = loc.getRefAddress();
        if (loc.isValid(currentProgram)) {
            return loc;
        }
        AddressFactory addressFactory = currentProgram.getAddressFactory();
        try {
            addr = addressFactory.getAddress(addr.toString(true));
            if (addr == null) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        if (refAddr != null) {
            try {
                refAddr = addressFactory.getAddress(refAddr.toString(true));
            }
            catch (Exception e) {
                refAddr = null;
            }
        }
        return new ProgramLocation(currentProgram, addr, loc.getComponentPath(), refAddr, 0, 0, 0);
    }

    private boolean hasValidAddresses(Program currentProgram, ProgramSelection sel) {
        AddressRangeIterator it = sel.getAddressRanges();
        AddressFactory af = currentProgram.getAddressFactory();
        while (it.hasNext()) {
            AddressRange range = (AddressRange)it.next();
            if (af.isValidAddress(range.getMinAddress())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isVisible(Program program) {
        return this.programMgr.isVisible(program);
    }

    @Override
    public void releaseProgram(Program program, Object owner) {
        if (this.programMgr.contains(program)) {
            this.programMgr.releaseProgram(program, owner);
            Msg.info(ClientUtil.class, (Object)("Released program from " + this.tool.getName() + " tool: " + program.getDomainFile()));
        }
    }

    @Override
    public boolean setPersistentOwner(Program program, Object owner) {
        return this.programMgr.setPersistentOwner(program, owner);
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void lockDown(boolean state) {
        this.locked = state;
        this.openAction.setEnabled(!state);
    }
}

