/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.processors;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import ghidra.app.plugin.core.processors.SetLanguageDialog;
import ghidra.framework.main.FrontEndTool;
import ghidra.framework.main.FrontEndable;
import ghidra.framework.main.datatable.ProjectDataContext;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.ToolServices;
import ghidra.framework.model.ToolTemplate;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.framework.store.LockException;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.listing.IncompatibleLanguageException;
import ghidra.program.model.listing.Program;
import ghidra.program.util.DefaultLanguageService;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Support", shortDescription="Set Language", description="This plugin provides the set language feature.")
public final class LanguageProviderPlugin
extends Plugin
implements FrontEndable {
    private DockingAction setLanguageAction;

    public LanguageProviderPlugin(PluginTool plugintool) {
        super(plugintool);
    }

    protected void init() {
        if (!(this.tool instanceof FrontEndTool)) {
            return;
        }
        this.setLanguageAction = new DockingAction("Set Language", this.getName()){

            public void actionPerformed(ActionContext context) {
                DomainFile file = this.getDomainFile((ProjectDataContext)context);
                if (file != null) {
                    LanguageProviderPlugin.this.setLanguage(file);
                }
            }

            public boolean isEnabledForContext(ActionContext actionContext) {
                if (!(actionContext instanceof ProjectDataContext)) {
                    return false;
                }
                ProjectDataContext context = (ProjectDataContext)actionContext;
                DomainFile file = this.getDomainFile(context);
                if (file == null) {
                    return false;
                }
                return file.isInWritableProject() && Program.class.isAssignableFrom(file.getDomainObjectClass());
            }

            private DomainFile getDomainFile(ProjectDataContext context) {
                if (context.getFileCount() == 1 && context.getFolderCount() == 0) {
                    return (DomainFile)context.getSelectedFiles().get(0);
                }
                return null;
            }

            public void dispose() {
                super.dispose();
            }
        };
        this.setLanguageAction.setPopupMenuData(new MenuData(new String[]{"Set Language..."}, "Language"));
        this.setLanguageAction.setEnabled(true);
        this.setLanguageAction.setHelpLocation(new HelpLocation("LanguageProviderPlugin", "set language"));
        this.tool.addAction((DockingActionIf)this.setLanguageAction);
    }

    public void dispose() {
        if (this.tool != null && this.setLanguageAction != null) {
            this.tool.removeAction((DockingActionIf)this.setLanguageAction);
        }
        super.dispose();
    }

    private void setLanguage(DomainFile domainFile) {
        String dfName = domainFile.getName();
        if (domainFile.isReadOnly()) {
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)this.tool.getToolFrame(), (String)"Permission Denied", (Object)("Program " + dfName + " is read-only!\nSet language may not be done on a read-only Program."));
            return;
        }
        if (!domainFile.getConsumers().isEmpty() || domainFile.isBusy()) {
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)this.tool.getToolFrame(), (String)"File In-Use", (Object)("Program " + dfName + " is in-use!\nSet language may not be done while the associated file is\nopen or in-use.  Be sure the file is not open in a tool."));
            return;
        }
        if (domainFile.isCheckedOut() && !domainFile.isCheckedOutExclusive()) {
            String msg = domainFile.modifiedSinceCheckout() || domainFile.isChanged() ? "check-in this file" : "undo your checkout";
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)this.tool.getToolFrame(), (String)"Exclusive Checkout Required", (Object)("You do not have an exclusive checkout of: " + dfName + "\n \nAn exclusive checkout is required in order to\nchange the current language associated with\nthe selected Program file.  Be sure the file is\nnot open in a tool, " + msg + ", then\ndo a checkout with the exclusive lock."));
            return;
        }
        Object msg = "Setting the language can not be undone!\n";
        if (domainFile.modifiedSinceCheckout()) {
            msg = (String)msg + "\nIt is highly recommended that you check-in your recent\nchanges before performing this operation.";
        } else if (!domainFile.isCheckedOut()) {
            msg = (String)msg + "\nIt is highly recommended that you make a copy of the\nselected file before performing this operation.";
        }
        ToolTemplate defaultToolTemplate = this.tool.getToolServices().getDefaultToolTemplate(domainFile);
        String toolMsg = defaultToolTemplate == null ? "WARNING! Without a default tool the file will be overwritten\nwhen the Set Language is complete." : "When complete you can Save the results or Open the results\nin the " + defaultToolTemplate.getName() + " tool";
        int result = OptionDialog.showOptionDialog((Component)this.tool.getToolFrame(), (String)("Set Language: " + dfName), (String)((String)msg + "\n \n" + toolMsg + "\n \nDo you want to continue?"), (String)"Ok", (int)2);
        if (result > 0) {
            SetLanguageTask task = new SetLanguageTask(domainFile);
            new TaskLauncher((Task)task, (Component)this.tool.getToolFrame(), 0);
            if (task.openTool != null) {
                SwingUtilities.invokeLater(() -> task.openTool.getToolFrame().requestFocus());
            }
        }
    }

    private class SetLanguageTask
    extends Task {
        DomainFile domainFile;
        PluginTool openTool;

        public SetLanguageTask(DomainFile domainFile) {
            super("Setting Language: " + domainFile.getName(), true, true, true);
            this.domainFile = domainFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(TaskMonitor monitor) {
            DomainObject dobj = null;
            try {
                monitor.setMessage("Open " + this.domainFile.getName() + "...");
                dobj = this.domainFile.getDomainObject((Object)LanguageProviderPlugin.this.tool, true, false, monitor);
                if (this.domainFile.getConsumers().size() != 1 || !dobj.canSave() || !dobj.hasExclusiveAccess()) {
                    Msg.showError((Object)((Object)this), null, (String)"Set Language Error", (Object)"Program file in-use or exclusive update not possible.");
                    monitor.cancel();
                }
                dobj.setTemporary(true);
                Program program = (Program)dobj;
                monitor.setMessage("Identify Language...");
                SetLanguageDialog dialog = new SetLanguageDialog(LanguageProviderPlugin.this.tool, program);
                LanguageID langDescID = dialog.getLanguageDescriptionID();
                CompilerSpecID compilerSpecDescID = dialog.getCompilerSpecDescriptionID();
                if (langDescID == null || compilerSpecDescID == null) {
                    monitor.cancel();
                    return;
                }
                boolean success = this.setLanguage(monitor, program, langDescID, compilerSpecDescID);
                if (!success) {
                    return;
                }
                ToolTemplate toolTemplate = LanguageProviderPlugin.this.tool.getToolServices().getDefaultToolTemplate(program.getDomainFile());
                if (toolTemplate == null) {
                    program.save(null, monitor);
                    return;
                }
                int option = OptionDialog.showOptionDialog((Component)LanguageProviderPlugin.this.tool.getToolFrame(), (String)"Set Language Completed", (String)("Would you like to Save the modified program file or Open it in the " + toolTemplate.getName() + " tool?"), (String)"Save", (String)"Open", (int)3);
                if (option == 1) {
                    program.save(null, monitor);
                } else if (option == 2) {
                    monitor.setCancelEnabled(false);
                    program.setTemporary(false);
                    this.openFile(this.domainFile);
                }
            }
            catch (VersionException e) {
                Msg.showError((Object)((Object)this), null, (String)"Set Language Failed", (Object)"File was created with a newer version of Ghidra\nand cannot be read.");
                return;
            }
            catch (CancelledException e) {
            }
            catch (IOException e) {
                Msg.showError((Object)((Object)this), null, (String)"File Error", (Object)e.toString(), (Throwable)e);
            }
            finally {
                if (dobj != null) {
                    dobj.release((Object)LanguageProviderPlugin.this.tool);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean setLanguage(TaskMonitor monitor, Program program, LanguageID langDescID, CompilerSpecID compilerSpecDescID) throws LanguageNotFoundException {
            monitor.setMessage("Setting Language & Compiler Spec...");
            int txId = program.startTransaction("Set Language");
            boolean success = false;
            try {
                program.setLanguage(DefaultLanguageService.getLanguageService().getLanguage(langDescID), compilerSpecDescID, false, monitor);
                success = true;
            }
            catch (IllegalStateException e) {
                if (!monitor.isCancelled()) {
                    Throwable t = e.getCause();
                    if (t == null) {
                        t = e;
                    }
                    Msg.showError((Object)((Object)this), null, (String)"Set Language Error", (Object)t.toString(), (Throwable)t);
                    monitor.cancel();
                }
            }
            catch (IncompatibleLanguageException e) {
                Msg.showError((Object)((Object)this), null, (String)"Set Language Failed", (Object)("Incompatible Language: " + e.getMessage()));
                monitor.cancel();
            }
            catch (LockException e) {
                Msg.showError((Object)((Object)this), null, (String)"Set Language Failed", (Object)("Program not checked out exclusively: " + e.toString()));
                monitor.cancel();
            }
            finally {
                program.endTransaction(txId, success);
            }
            return success;
        }

        private void openFile(DomainFile file) {
            try {
                SwingUtilities.invokeAndWait(() -> {
                    ToolServices toolServices = LanguageProviderPlugin.this.tool.getToolServices();
                    String defaultToolName = toolServices.getDefaultToolTemplate(file).getName();
                    for (PluginTool t : toolServices.getRunningTools()) {
                        if (!t.getName().equals(defaultToolName)) continue;
                        this.openTool = t;
                        break;
                    }
                    if (this.openTool != null) {
                        this.openTool.acceptDomainFiles(new DomainFile[]{file});
                    } else {
                        this.openTool = LanguageProviderPlugin.this.tool.getToolServices().launchDefaultTool(file);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getCause();
                Msg.showError((Object)((Object)this), (Component)LanguageProviderPlugin.this.tool.getToolFrame(), (String)"Tool Launch Failed", (Object)"An error occurred while attempting to launch your default tool!", (Throwable)t);
            }
        }
    }
}

