/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.gotoquery;

import ghidra.app.events.ProgramHighlightPluginEvent;
import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.nav.LocationMemento;
import ghidra.app.nav.Navigatable;
import ghidra.app.nav.NavigatableRegistry;
import ghidra.app.nav.NavigatableRemovalListener;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.gotoquery.DefaultNavigatableLocationMemento;
import ghidra.app.services.CodeViewerService;
import ghidra.app.services.GoToService;
import ghidra.app.services.NavigationHistoryService;
import ghidra.app.services.ProgramManager;
import ghidra.app.util.HighlightProvider;
import ghidra.app.util.navigation.GoToServiceImpl;
import ghidra.app.util.query.TableService;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import javax.swing.Icon;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Support", shortDescription="Go To Service", description="This plugin provides the service used by other plugins to go to an address in the program, or to an address in another program. This plugin also handles wildcards to go a label that matches a query. When multiple hits for a query are found, the plugin shows the results in a query results table.", servicesRequired={TableService.class, ProgramManager.class, NavigationHistoryService.class}, servicesProvided={GoToService.class}, eventsProduced={ProgramLocationPluginEvent.class})
public final class GoToServicePlugin
extends ProgramPlugin {
    private GoToServiceImpl gotoService = new GoToServiceImpl(this, new DefaultNavigatable());
    private boolean disposed;

    public GoToServicePlugin(PluginTool plugintool) {
        super(plugintool, true, true);
        this.registerServiceProvided(GoToService.class, this.gotoService);
    }

    protected void init() {
        NavigatableRegistry.registerNavigatable(this.tool, this.gotoService.getDefaultNavigatable());
    }

    protected void dispose() {
        this.disposed = true;
        NavigatableRegistry.unregisterNavigatable(this.tool, this.gotoService.getDefaultNavigatable());
    }

    int getMaxHits() {
        ToolOptions opt = this.tool.getOptions("Search");
        int maxSearchHits = opt.getInt("Search Limit", 500);
        return maxSearchHits;
    }

    GoToService getGotoService() {
        return this.gotoService;
    }

    private void updateCurrentProgram(Program p) {
        ProgramManager service = (ProgramManager)this.tool.getService(ProgramManager.class);
        if (service != null) {
            service.setCurrentProgram(p);
        }
    }

    class DefaultNavigatable
    implements Navigatable {
        private Navigatable focusedNavigatable;

        DefaultNavigatable() {
        }

        @Override
        public ProgramLocation getLocation() {
            return GoToServicePlugin.this.currentLocation;
        }

        @Override
        public boolean goTo(Program program, ProgramLocation location) {
            GoToServicePlugin.this.updateCurrentProgram(program);
            if (GoToServicePlugin.this.currentProgram != program) {
                return false;
            }
            GoToServicePlugin.this.firePluginEvent(new ProgramLocationPluginEvent(GoToServicePlugin.this.getName(), location, GoToServicePlugin.this.currentProgram));
            GoToServicePlugin.this.currentLocation = location;
            return true;
        }

        @Override
        public LocationMemento getMemento() {
            return new DefaultNavigatableLocationMemento(GoToServicePlugin.this.currentProgram, GoToServicePlugin.this.currentLocation, GoToServicePlugin.this.tool);
        }

        @Override
        public void setMemento(LocationMemento memento) {
            DefaultNavigatableLocationMemento defaultMemento = (DefaultNavigatableLocationMemento)memento;
            defaultMemento.setMementos();
            this.focusedNavigatable = defaultMemento.getFocusedNavigatable();
        }

        @Override
        public Program getProgram() {
            return GoToServicePlugin.this.currentProgram;
        }

        @Override
        public Icon getNavigatableIcon() {
            return null;
        }

        @Override
        public boolean isConnected() {
            return true;
        }

        @Override
        public boolean supportsMarkers() {
            return this.isConnected();
        }

        @Override
        public long getInstanceID() {
            return -1L;
        }

        @Override
        public boolean isVisible() {
            return true;
        }

        @Override
        public boolean isDisposed() {
            return GoToServicePlugin.this.disposed;
        }

        @Override
        public void requestFocus() {
            if (this.focusedNavigatable != null && this.focusedNavigatable.isVisible()) {
                this.focusedNavigatable.requestFocus();
                this.focusedNavigatable = null;
            }
        }

        @Override
        public void addNavigatableListener(NavigatableRemovalListener listener) {
        }

        @Override
        public void removeNavigatableListener(NavigatableRemovalListener listener) {
        }

        @Override
        public void setHighlight(ProgramSelection highlight) {
            GoToServicePlugin.this.tool.firePluginEvent((PluginEvent)new ProgramHighlightPluginEvent(GoToServicePlugin.this.getName(), highlight, GoToServicePlugin.this.currentProgram));
        }

        @Override
        public boolean supportsHighlight() {
            return true;
        }

        @Override
        public void setSelection(ProgramSelection selection) {
            GoToServicePlugin.this.tool.firePluginEvent((PluginEvent)new ProgramSelectionPluginEvent(GoToServicePlugin.this.getName(), selection, GoToServicePlugin.this.currentProgram));
        }

        @Override
        public ProgramSelection getSelection() {
            return GoToServicePlugin.this.currentSelection;
        }

        @Override
        public ProgramSelection getHighlight() {
            return GoToServicePlugin.this.currentHighlight;
        }

        @Override
        public void removeHighlightProvider(HighlightProvider highlightProvider, Program program) {
            CodeViewerService service = (CodeViewerService)GoToServicePlugin.this.tool.getService(CodeViewerService.class);
            if (service != null) {
                service.removeHighlightProvider(highlightProvider, program);
            }
        }

        @Override
        public void setHighlightProvider(HighlightProvider highlightProvider, Program program) {
            CodeViewerService service = (CodeViewerService)GoToServicePlugin.this.tool.getService(CodeViewerService.class);
            if (service != null) {
                service.setHighlightProvider(highlightProvider, program);
            }
        }
    }
}

