/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functioncompare;

import ghidra.program.model.listing.Function;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;

public class FunctionComparison
implements Comparable<FunctionComparison> {
    private Function source;
    private Set<Function> targets = new TreeSet<Function>(new FunctionComparator());

    public Function getSource() {
        return this.source;
    }

    public Set<Function> getTargets() {
        return this.targets;
    }

    public void setSource(Function function) {
        this.source = function;
    }

    public void addTarget(Function function) {
        this.targets.add(function);
    }

    public void addTargets(Set<Function> functions) {
        this.targets.addAll(functions);
    }

    public void removeTarget(Function function) {
        this.targets.remove(function);
    }

    public void clearTargets() {
        this.targets.clear();
    }

    @Override
    public int compareTo(FunctionComparison o) {
        if (o == null) {
            return 1;
        }
        String sourcePath = this.getSource().getProgram().getDomainFile().getPathname();
        String otherPath = o.getSource().getProgram().getDomainFile().getPathname();
        String sourceName = this.getSource().getName();
        String otherName = o.getSource().getName();
        int result = sourcePath.compareTo(otherPath);
        if (result != 0) {
            return result;
        }
        result = sourceName.compareTo(otherName);
        if (result != 0) {
            return result;
        }
        return this.getSource().getEntryPoint().compareTo((Object)o.getSource().getEntryPoint());
    }

    class FunctionComparator
    implements Comparator<Function> {
        FunctionComparator() {
        }

        @Override
        public int compare(Function o1, Function o2) {
            String o2Name;
            String o2Path;
            if (o2 == null) {
                return 1;
            }
            String o1Path = o1.getProgram().getDomainFile().getPathname();
            int result = o1Path.compareTo(o2Path = o2.getProgram().getDomainFile().getPathname());
            if (result != 0) {
                return result;
            }
            String o1Name = o1.getName();
            result = o1Name.compareTo(o2Name = o2.getName());
            if (result != 0) {
                return result;
            }
            return o1.getEntryPoint().compareTo((Object)o2.getEntryPoint());
        }
    }
}

