/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function.tags;

import ghidra.app.cmd.function.RemoveFunctionTagCmd;
import ghidra.app.plugin.core.function.tags.FunctionTagsComponentProvider;
import ghidra.app.plugin.core.function.tags.TagListPanel;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionTag;
import java.util.Collections;
import java.util.List;

public class TargetTagsPanel
extends TagListPanel {
    public TargetTagsPanel(FunctionTagsComponentProvider provider, PluginTool tool, String title) {
        super(provider, tool, title);
        this.table.setDisabled(false);
    }

    @Override
    public void refresh(Function function) {
        this.model.clear();
        this.function = function;
        if (function == null) {
            this.setTitle("No Function Selected");
        } else {
            this.setTitle(function.getName() + " (" + function.getEntryPoint().toString() + ")");
        }
        List<FunctionTag> assignedTags = this.getAssignedTags(function);
        Collections.sort(assignedTags);
        for (FunctionTag tag : assignedTags) {
            this.model.addTag(tag);
        }
        this.model.reload();
        this.applyFilter();
        this.table.setFunction(function);
    }

    public void removeSelectedTags() {
        List<FunctionTag> selectedTags = this.getSelectedTags();
        for (FunctionTag tag : selectedTags) {
            RemoveFunctionTagCmd cmd = new RemoveFunctionTagCmd(tag.getName(), this.function.getEntryPoint());
            this.tool.execute((Command)cmd, (DomainObject)this.program);
        }
    }
}

