/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function.tags;

import ghidra.app.cmd.function.AddFunctionTagCmd;
import ghidra.app.cmd.function.CreateFunctionTagCmd;
import ghidra.app.plugin.core.function.tags.FunctionTagLoader;
import ghidra.app.plugin.core.function.tags.FunctionTagTemp;
import ghidra.app.plugin.core.function.tags.FunctionTagsComponentProvider;
import ghidra.app.plugin.core.function.tags.TagListPanel;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.database.function.FunctionManagerDB;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionTag;
import ghidra.util.Msg;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public class SourceTagsPanel
extends TagListPanel {
    private static String TAG_FILE = "functionTags.xml";
    private List<FunctionTag> tempTags = this.loadTags();
    private List<FunctionTag> tempTagsCache = new ArrayList<FunctionTag>(this.tempTags);

    public SourceTagsPanel(FunctionTagsComponentProvider provider, PluginTool tool, String title) {
        super(provider, tool, title);
        this.table.setDisabled(true);
    }

    public void addSelectedTags() {
        if (this.function == null) {
            return;
        }
        List<FunctionTag> selectedTags = this.getSelectedTags();
        for (FunctionTag tag : selectedTags) {
            Object cmd;
            if (tag instanceof FunctionTagTemp) {
                cmd = new CreateFunctionTagCmd(tag.getName(), tag.getComment());
                this.tool.execute((Command)cmd, (DomainObject)this.program);
            }
            cmd = new AddFunctionTagCmd(tag.getName(), this.function.getEntryPoint());
            this.tool.execute((Command)cmd, (DomainObject)this.program);
        }
    }

    @Override
    public void refresh(Function function) {
        this.model.clear();
        this.function = function;
        try {
            this.tempTags = new ArrayList<FunctionTag>(this.tempTagsCache);
            List<? extends FunctionTag> dbTags = this.getAllTagsFromDatabase();
            for (FunctionTag functionTag : dbTags) {
                this.model.addTag(functionTag);
            }
            Iterator<FunctionTag> iter = this.tempTags.iterator();
            while (iter.hasNext()) {
                FunctionTag functionTag = iter.next();
                Optional<FunctionTag> foundTag = dbTags.stream().filter(t -> t.getName().equals(tag.getName())).findAny();
                if (foundTag.isPresent()) {
                    iter.remove();
                    continue;
                }
                this.model.addTag(functionTag);
            }
            this.model.reload();
            this.applyFilter();
            this.table.setFunction(function);
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)"Error retrieving tags", (Throwable)e);
        }
    }

    public boolean isSelectionEnabled() {
        List<FunctionTag> selectedTags = this.getSelectedTags();
        List<FunctionTag> assignedTags = this.getAssignedTags(this.function);
        return !assignedTags.containsAll(selectedTags);
    }

    private List<? extends FunctionTag> getAllTagsFromDatabase() throws IOException {
        if (this.program == null) {
            return Collections.emptyList();
        }
        FunctionManagerDB functionManagerDB = (FunctionManagerDB)this.program.getFunctionManager();
        return functionManagerDB.getFunctionTagManager().getAllFunctionTags();
    }

    private List<FunctionTag> loadTags() {
        return FunctionTagLoader.loadTags(TAG_FILE);
    }
}

