/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function.tags;

import docking.widgets.table.AbstractDynamicTableColumnStub;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.TableColumnDescriptor;
import docking.widgets.table.threaded.ThreadedTableModel;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.FunctionTag;
import ghidra.program.model.listing.Program;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class FunctionTagTableModel
extends ThreadedTableModel<FunctionTag, List<FunctionTag>> {
    private List<FunctionTag> tags = new ArrayList<FunctionTag>();
    private Program program;

    protected FunctionTagTableModel(String modelName, ServiceProvider serviceProvider) {
        super(modelName, serviceProvider);
    }

    public void setProgram(Program program) {
        this.program = program;
    }

    protected void doLoad(Accumulator<FunctionTag> accumulator, TaskMonitor monitor) throws CancelledException {
        accumulator.addAll(this.tags);
        this.fireTableDataChanged();
    }

    protected TableColumnDescriptor<FunctionTag> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new FunctionTagNameColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new FunctionTagCountColumn());
        return descriptor;
    }

    public List<FunctionTag> getDataSource() {
        return this.tags;
    }

    public void addTag(FunctionTag tag) {
        Optional<FunctionTag> existingTag = this.tags.stream().filter(t -> t.getName().equals(tag.getName())).findAny();
        if (existingTag.isPresent()) {
            this.tags.remove(existingTag.get());
        }
        this.tags.add(tag);
        this.fireTableDataChanged();
    }

    public void clear() {
        this.tags.clear();
        this.fireTableDataChanged();
    }

    public List<FunctionTag> getTags() {
        return this.tags;
    }

    public FunctionTag getTag(String name) {
        Optional<FunctionTag> tag = this.tags.stream().filter(t -> t.getName().equals(name)).findAny();
        if (tag.isPresent()) {
            return tag.get();
        }
        return null;
    }

    public boolean isTagInModel(String name) {
        Optional<FunctionTag> tag = this.tags.stream().filter(t -> t.getName().equals(name)).findAny();
        return tag.isPresent();
    }

    private class FunctionTagNameColumn
    extends AbstractDynamicTableColumnStub<FunctionTag, String> {
        private FunctionTagNameColumn() {
        }

        public String getColumnName() {
            return "Name";
        }

        public String getValue(FunctionTag rowObject, Settings settings, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getName();
        }
    }

    private class FunctionTagCountColumn
    extends AbstractDynamicTableColumnStub<FunctionTag, Integer> {
        private FunctionTagCountColumn() {
        }

        public String getColumnDisplayName(Settings settings) {
            return " ";
        }

        public String getColumnName() {
            return "Count";
        }

        public int getColumnPreferredWidth() {
            return 30;
        }

        public Integer getValue(FunctionTag rowObject, Settings settings, ServiceProvider serviceProvider) throws IllegalArgumentException {
            int count = 0;
            if (FunctionTagTableModel.this.program == null) {
                return 0;
            }
            FunctionIterator iter = FunctionTagTableModel.this.program.getFunctionManager().getFunctions(true);
            while (iter.hasNext()) {
                Function f = (Function)iter.next();
                Optional<FunctionTag> foundTag = f.getTags().stream().filter(t -> t.getName().equals(rowObject.getName())).findAny();
                if (!foundTag.isPresent()) continue;
                ++count;
            }
            return count;
        }
    }
}

