/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function.tags;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DiscoverableTableUtils;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.FunctionTag;
import ghidra.program.model.listing.Program;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.AddressBasedTableModel;
import ghidra.util.table.field.AddressTableColumn;
import ghidra.util.table.field.FunctionTagTableColumn;
import ghidra.util.table.field.LabelTableColumn;
import ghidra.util.task.TaskMonitor;
import java.util.List;

class FunctionTableModel
extends AddressBasedTableModel<Function> {
    private List<FunctionTag> tags;

    public FunctionTableModel(String title, ServiceProvider serviceProvider, Program program, TaskMonitor monitor) {
        super(title, serviceProvider, program, monitor);
    }

    @Override
    public Address getAddress(int row) {
        Function rowObject = (Function)this.getRowObject(row);
        return rowObject.getEntryPoint();
    }

    @Override
    protected TableColumnDescriptor<Function> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new LabelTableColumn()));
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new AddressTableColumn()), 1, true);
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new FunctionTagTableColumn()));
        return descriptor;
    }

    protected void doLoad(Accumulator<Function> accumulator, TaskMonitor monitor) throws CancelledException {
        if (this.program == null) {
            return;
        }
        if (this.tags == null) {
            return;
        }
        FunctionIterator iter = this.program.getFunctionManager().getFunctions(true);
        monitor.initialize((long)this.program.getFunctionManager().getFunctionCount());
        while (iter.hasNext()) {
            monitor.incrementProgress(1L);
            monitor.checkCanceled();
            Function f = (Function)iter.next();
            boolean hasTag = f.getTags().stream().anyMatch(t -> this.tags.contains(t));
            if (!hasTag) continue;
            accumulator.add((Object)f);
        }
    }

    public void setSelectedTags(List<FunctionTag> tags) {
        this.tags = tags;
        this.reload();
    }

    public List<Function> getFunctions() {
        return this.getAllData();
    }
}

