/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.equate;

import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import ghidra.app.cmd.equate.ClearEquateCmd;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.equate.ConvertToBinaryAction;
import ghidra.app.plugin.core.equate.ConvertToCharAction;
import ghidra.app.plugin.core.equate.ConvertToDoubleAction;
import ghidra.app.plugin.core.equate.ConvertToFloatAction;
import ghidra.app.plugin.core.equate.ConvertToOctalAction;
import ghidra.app.plugin.core.equate.ConvertToSignedDecimalAction;
import ghidra.app.plugin.core.equate.ConvertToSignedHexAction;
import ghidra.app.plugin.core.equate.ConvertToUnsignedDecimalAction;
import ghidra.app.plugin.core.equate.ConvertToUnsignedHexAction;
import ghidra.app.plugin.core.equate.CreateEnumEquateCommand;
import ghidra.app.plugin.core.equate.CreateEquateCmd;
import ghidra.app.plugin.core.equate.RenameEquateCmd;
import ghidra.app.util.bean.SetEquateDialog;
import ghidra.app.util.datatype.ApplyEnumDialog;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.cmd.Command;
import ghidra.framework.cmd.CompoundBackgroundCommand;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.Equate;
import ghidra.program.model.symbol.EquateTable;
import ghidra.program.util.OperandFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Add, rename, and delete equates", description="This provides actions for adding, renaming, and deleting equates on operand values.")
public class EquatePlugin
extends Plugin {
    private static final String GROUP_NAME = "equate";
    private static final String[] SET_MENUPATH = new String[]{"Set Equate..."};
    private static final String[] RENAME_MENUPATH = new String[]{"Rename Equate..."};
    private static final String[] REMOVE_MENUPATH = new String[]{"Remove Equate"};
    private static final String[] APPLYENUM_MENUPATH = new String[]{"Apply Enum..."};
    private DockingAction setAction;
    private DockingAction renameAction;
    private DockingAction removeAction;
    private DockingAction applyEnumAction;
    private SetEquateDialog setEquateDialog;
    private ApplyEnumDialog applyEnumDialog;

    public EquatePlugin(PluginTool tool) {
        super(tool);
        this.createActions();
    }

    private SetEquateDialog createEquateDialog(ListingActionContext context, Scalar scalar) {
        if (this.setEquateDialog != null) {
            this.setEquateDialog.close();
        }
        InitializeDialogTask task = new InitializeDialogTask(context.getProgram(), scalar);
        TaskLauncher.launch((Task)task);
        this.setEquateDialog = task.getDialog();
        this.setEquateDialog.setHelpLocation(new HelpLocation(this.getName(), "Set_Equate"));
        return this.setEquateDialog;
    }

    private ApplyEnumDialog applyEnumDialog(ListingActionContext context) {
        ProgramBasedDataTypeManager dtm = context.getProgram().getDataTypeManager();
        if (this.applyEnumDialog != null) {
            this.applyEnumDialog.close();
        }
        this.applyEnumDialog = new ApplyEnumDialog(this.tool, (DataTypeManager)dtm);
        this.applyEnumDialog.setHelpLocation(new HelpLocation(this.getName(), "Apply_Enum"));
        this.tool.showDialog((DialogComponentProvider)this.applyEnumDialog);
        return this.applyEnumDialog;
    }

    private void dispose(SetEquateDialog dialog) {
        if (this.setEquateDialog == dialog) {
            this.setEquateDialog.dispose();
            this.setEquateDialog = null;
        }
    }

    protected boolean isEquatePermitted(ListingActionContext context) {
        Equate equate;
        Scalar scalar = this.getScalar(context);
        if (scalar == null) {
            return false;
        }
        CodeUnit cu = this.getCodeUnit(context);
        if (cu instanceof Data) {
            Data data = (Data)cu;
            if (!data.isDefined()) {
                return false;
            }
            DataType dataType = data.getBaseDataType();
            if (!(dataType instanceof AbstractIntegerDataType)) {
                return false;
            }
        }
        if ((equate = this.getEquate(context)) == null) {
            return true;
        }
        return !this.isEquateEqualScalar(equate, scalar);
    }

    private void setEquate(ListingActionContext context) {
        Scalar curScalar = this.getScalar(context);
        if (curScalar == null) {
            return;
        }
        this.createEquateDialog(context, curScalar);
        this.setEquateDialog.setHasSelection(context);
        if (this.setEquateDialog.showSetDialog() == 0) {
            return;
        }
        CodeUnitIterator iter = null;
        Listing listing = context.getProgram().getListing();
        SetEquateDialog.SelectionType selectionType = this.setEquateDialog.getSelectionType();
        if (selectionType == SetEquateDialog.SelectionType.CURRENT_ADDRESS) {
            AddressSet addrSet = new AddressSet(context.getAddress());
            iter = listing.getCodeUnits((AddressSetView)addrSet, false);
        } else if (selectionType == SetEquateDialog.SelectionType.SELECTION) {
            iter = listing.getCodeUnits((AddressSetView)context.getSelection(), true);
        } else if (selectionType == SetEquateDialog.SelectionType.ENTIRE_PROGRAM) {
            iter = listing.getCodeUnits((AddressSetView)context.getProgram().getMemory(), true);
        }
        CreateEquateCmd cmd = this.setEquateDialog.getEnumDataType() != null ? new CreateEquateCmd(curScalar, iter, this.setEquateDialog.getEnumDataType(), this.setEquateDialog.getOverwriteExisting(), context) : new CreateEquateCmd(curScalar, iter, this.setEquateDialog.getEquateName(), this.setEquateDialog.getOverwriteExisting(), context);
        this.tool.executeBackgroundCommand((BackgroundCommand)cmd, (UndoableDomainObject)context.getProgram());
        this.dispose(this.setEquateDialog);
    }

    private void applyEnum(ListingActionContext context) {
        this.applyEnumDialog = this.applyEnumDialog(context);
        DataType dataType = this.applyEnumDialog.getUserChosenDataType();
        if (dataType == null) {
            return;
        }
        if (!(dataType instanceof Enum)) {
            Msg.showError((Object)((Object)this), null, (String)"Input Error", (Object)"Data Type must be an enum");
            return;
        }
        boolean shouldDoOnSubOps = this.applyEnumDialog.shouldApplyOnSubOps();
        ProgramSelection addresses = context.getSelection();
        if (addresses.isEmpty()) {
            addresses = new AddressSet(context.getAddress());
        }
        Program program = context.getProgram();
        CreateEnumEquateCommand cmd = new CreateEnumEquateCommand(program, addresses, (Enum)dataType, shouldDoOnSubOps);
        this.tool.executeBackgroundCommand((BackgroundCommand)cmd, (UndoableDomainObject)program);
    }

    private void renameEquate(ListingActionContext context) {
        Scalar curScalar = this.getScalar(context);
        if (curScalar == null) {
            return;
        }
        Equate equate = this.getEquate(context);
        Listing listing = context.getProgram().getListing();
        this.createEquateDialog(context, curScalar);
        this.setEquateDialog.setHasSelection(context);
        int result = this.setEquateDialog.showRenameDialog();
        if (result == 0) {
            return;
        }
        String equateName = this.setEquateDialog.getEquateName();
        CodeUnitIterator iter = null;
        SetEquateDialog.SelectionType selectionType = this.setEquateDialog.getSelectionType();
        if (selectionType == SetEquateDialog.SelectionType.CURRENT_ADDRESS) {
            AddressSet addrSet = new AddressSet(context.getAddress());
            iter = listing.getCodeUnits((AddressSetView)addrSet, false);
        } else if (selectionType == SetEquateDialog.SelectionType.SELECTION) {
            iter = listing.getCodeUnits((AddressSetView)context.getSelection(), true);
        } else if (selectionType == SetEquateDialog.SelectionType.ENTIRE_PROGRAM) {
            iter = listing.getCodeUnits((AddressSetView)context.getProgram().getMemory(), true);
        }
        if (equateName == null) {
            this.removeEquateOverRange(context, equate, iter);
        } else {
            this.renameEquate(context, equate, equateName, iter);
        }
        this.dispose(this.setEquateDialog);
    }

    private Equate getEquate(ListingActionContext context) {
        EquateTable equateTable = context.getProgram().getEquateTable();
        Scalar s = this.getScalar(context);
        if (s == null) {
            return null;
        }
        return equateTable.getEquate(context.getAddress(), this.getOperandIndex(context), s.getValue());
    }

    private void renameEquate(ListingActionContext context, Equate oldEquate, String newEquateName, CodeUnitIterator iter) {
        String oldEquateName = oldEquate.getName();
        if (oldEquateName.equals(newEquateName)) {
            return;
        }
        CompoundBackgroundCommand bckCmd = new CompoundBackgroundCommand("Rename Equates in Selection", false, true);
        while (iter.hasNext()) {
            CodeUnit cu = iter.next();
            this.renameEquateForCodeUnit(context, oldEquate, newEquateName, oldEquateName, bckCmd, cu);
        }
        this.tool.executeBackgroundCommand((BackgroundCommand)bckCmd, (UndoableDomainObject)context.getProgram());
    }

    private void renameEquateForCodeUnit(ListingActionContext context, Equate equate, String newName, String oldName, CompoundBackgroundCommand bgCmd, CodeUnit cu) {
        Data data;
        if (cu instanceof Instruction) {
            Instruction inst = (Instruction)cu;
            Program program = context.getProgram();
            List<Integer> opIndices = this.getInstructionMatches(program, inst, equate);
            Address addr = inst.getAddress();
            for (Integer opIndice : opIndices) {
                bgCmd.add((Command)this.createRenameCmd(oldName, newName, addr, opIndice));
            }
        } else if (cu instanceof Data && this.isDataMatch(data = (Data)cu, context, equate)) {
            Address addr = data.getAddress();
            bgCmd.add((Command)this.createRenameCmd(oldName, newName, addr, this.getOperandIndex(context)));
        }
    }

    private RenameEquateCmd createRenameCmd(String oldName, String newName, Address addr, int opIndex) {
        Enum enoom = this.getEnumDataType();
        if (enoom != null) {
            return new RenameEquateCmd(oldName, enoom, addr, opIndex);
        }
        return new RenameEquateCmd(oldName, newName, addr, opIndex);
    }

    public Enum getEnumDataType() {
        return this.setEquateDialog.getEnumDataType();
    }

    private void removeEquateOverRange(ListingActionContext context, Equate equate, CodeUnitIterator iter) {
        CompoundBackgroundCommand bckCmd = new CompoundBackgroundCommand("Remove Equates in Selection", false, true);
        while (iter.hasNext()) {
            CodeUnit cu = iter.next();
            this.removeEquateForCodeUnit(context, equate, bckCmd, cu);
        }
        this.tool.executeBackgroundCommand((BackgroundCommand)bckCmd, (UndoableDomainObject)context.getProgram());
    }

    private void removeEquateForCodeUnit(ListingActionContext context, Equate equate, CompoundBackgroundCommand bckCmd, CodeUnit cu) {
        Data data;
        if (cu instanceof Instruction) {
            Instruction instr = (Instruction)cu;
            Program program = context.getProgram();
            List<Integer> opIndexes = this.getInstructionMatches(program, instr, equate);
            for (Integer opIndexe : opIndexes) {
                bckCmd.add((Command)new ClearEquateCmd(equate.getName(), instr.getAddress(), opIndexe));
            }
        } else if (cu instanceof Data && this.isDataMatch(data = (Data)cu, context, equate)) {
            bckCmd.add((Command)new ClearEquateCmd(equate.getName(), data.getAddress(), this.getOperandIndex(context)));
        }
    }

    private List<Integer> getInstructionMatches(Program program, Instruction instruction, Equate equate) {
        ArrayList<Integer> matches = new ArrayList<Integer>();
        int numOperands = instruction.getNumOperands();
        for (int opIndex = 0; opIndex <= numOperands; ++opIndex) {
            Object[] opObjs;
            for (Object opObj : opObjs = instruction.getOpObjects(opIndex)) {
                if (!(opObj instanceof Scalar)) continue;
                Scalar scalar = (Scalar)opObj;
                EquateTable equateTable = program.getEquateTable();
                Address address = instruction.getAddress();
                List equates = equateTable.getEquates(address, opIndex);
                for (Equate eq : equates) {
                    if (!eq.getName().equals(equate.getName()) || !this.isEquateEqualScalar(equate, scalar)) continue;
                    matches.add(opIndex);
                }
            }
        }
        return matches;
    }

    private boolean isDataMatch(Data data, ListingActionContext context, Equate equate) {
        if (!data.isDefined()) {
            return false;
        }
        Object val = data.getValue();
        if (val == null || !(val instanceof Scalar)) {
            return false;
        }
        Scalar scalar = (Scalar)val;
        int opIndex = this.getOperandIndex(context);
        Program program = context.getProgram();
        EquateTable equateTable = program.getEquateTable();
        Address address = data.getAddress();
        List equates = equateTable.getEquates(address, opIndex);
        for (Equate eq : equates) {
            if (!eq.getName().equals(equate.getName()) || !this.isEquateEqualScalar(equate, scalar)) continue;
            return true;
        }
        return false;
    }

    private void removeSelectedEquates(ListingActionContext context) {
        Equate equate = this.getEquate(context);
        CodeUnitIterator iter = null;
        ProgramSelection selection = context.getSelection();
        if (!selection.isEmpty()) {
            String title = "Remove Equate?";
            String msg = "This will remove all equates with the name '" + equate.getDisplayName() + "' in the selection.";
            int option = OptionDialog.showOptionDialog((Component)this.getTool().getActiveWindow(), (String)title, (String)msg, (String)"Remove", (int)3);
            if (option == 0) {
                return;
            }
            iter = context.getProgram().getListing().getCodeUnits((AddressSetView)context.getSelection(), true);
        } else {
            AddressSet addrSet = new AddressSet(context.getAddress());
            iter = context.getProgram().getListing().getCodeUnits((AddressSetView)addrSet, false);
        }
        this.removeEquateOverRange(context, equate, iter);
    }

    CodeUnit getCodeUnit(ListingActionContext context) {
        Address address = context.getAddress();
        if (address != null) {
            return context.getProgram().getListing().getCodeUnitContaining(address);
        }
        return null;
    }

    int getOperandIndex(ListingActionContext context) {
        ProgramLocation location = context.getLocation();
        if (location instanceof OperandFieldLocation) {
            return ((OperandFieldLocation)location).getOperandIndex();
        }
        return -1;
    }

    int getSubOperandIndex(ListingActionContext context) {
        ProgramLocation location = context.getLocation();
        if (location instanceof OperandFieldLocation) {
            return ((OperandFieldLocation)location).getSubOperandIndex();
        }
        return -1;
    }

    Scalar getScalar(ListingActionContext context) {
        CodeUnit cu = this.getCodeUnit(context);
        Scalar scalar = this.getScalar(cu, context);
        return scalar;
    }

    private Scalar getScalar(CodeUnit cu, ListingActionContext context) {
        int opIndex = this.getOperandIndex(context);
        int subOpIndex = this.getSubOperandIndex(context);
        Scalar scalar = this.getScalar(cu, opIndex, subOpIndex);
        return scalar;
    }

    private Scalar getScalar(CodeUnit cu, int opIndex, int subOpIndex) {
        Object[] opObjects;
        Object object;
        int repIndex;
        if (cu == null) {
            return null;
        }
        if (cu instanceof Data) {
            return cu.getScalar(opIndex);
        }
        if (subOpIndex < 0) {
            return null;
        }
        Instruction instruction = (Instruction)cu;
        List list = instruction.getDefaultOperandRepresentationList(opIndex);
        if (list == null) {
            return null;
        }
        int numSubOps = list.size();
        Scalar currentScalar = null;
        for (repIndex = subOpIndex; repIndex < numSubOps; ++repIndex) {
            object = list.get(repIndex);
            if (!(object instanceof Scalar)) continue;
            currentScalar = (Scalar)object;
            break;
        }
        if (currentScalar == null) {
            for (repIndex = subOpIndex - 1; repIndex >= 0; --repIndex) {
                object = list.get(repIndex);
                if (!(object instanceof Scalar)) continue;
                currentScalar = (Scalar)object;
                break;
            }
        }
        if (currentScalar == null) {
            return null;
        }
        for (Object object2 : opObjects = instruction.getOpObjects(opIndex)) {
            if (!(object2 instanceof Scalar) || !currentScalar.equals(object2)) continue;
            return currentScalar;
        }
        return null;
    }

    private void createActions() {
        this.tool.setMenuGroup(new String[]{"Convert"}, GROUP_NAME);
        this.tool.addAction((DockingActionIf)new ConvertToUnsignedHexAction(this));
        this.tool.addAction((DockingActionIf)new ConvertToUnsignedDecimalAction(this));
        this.tool.addAction((DockingActionIf)new ConvertToOctalAction(this));
        this.tool.addAction((DockingActionIf)new ConvertToSignedHexAction(this));
        this.tool.addAction((DockingActionIf)new ConvertToSignedDecimalAction(this));
        this.tool.addAction((DockingActionIf)new ConvertToCharAction(this));
        this.tool.addAction((DockingActionIf)new ConvertToBinaryAction(this));
        this.tool.addAction((DockingActionIf)new ConvertToFloatAction(this));
        this.tool.addAction((DockingActionIf)new ConvertToDoubleAction(this));
        this.setAction = new ListingContextAction("Set Equate", this.getName()){

            @Override
            protected void actionPerformed(ListingActionContext context) {
                EquatePlugin.this.setEquate(context);
            }

            @Override
            protected boolean isEnabledForContext(ListingActionContext context) {
                return EquatePlugin.this.isEquatePermitted(context);
            }
        };
        this.setAction.setPopupMenuData(new MenuData(SET_MENUPATH, null, GROUP_NAME));
        this.setAction.setKeyBindingData(new KeyBindingData(69, 0));
        this.renameAction = new ListingContextAction("Rename Equate", this.getName()){

            @Override
            protected void actionPerformed(ListingActionContext context) {
                EquatePlugin.this.renameEquate(context);
            }

            @Override
            protected boolean isEnabledForContext(ListingActionContext context) {
                Scalar scalar = EquatePlugin.this.getScalar(context);
                if (scalar == null) {
                    return false;
                }
                Equate equate = EquatePlugin.this.getEquate(context);
                if (equate == null) {
                    return false;
                }
                return EquatePlugin.this.isEquateEqualScalar(equate, scalar);
            }
        };
        this.renameAction.setHelpLocation(new HelpLocation("EquatePlugin", "Set_Equate"));
        this.renameAction.setPopupMenuData(new MenuData(RENAME_MENUPATH, null, GROUP_NAME));
        this.renameAction.setKeyBindingData(new KeyBindingData(69, 0));
        this.removeAction = new ListingContextAction("Remove Equate", this.getName()){

            @Override
            protected void actionPerformed(ListingActionContext context) {
                EquatePlugin.this.removeSelectedEquates(context);
            }

            @Override
            protected boolean isEnabledForContext(ListingActionContext context) {
                return EquatePlugin.this.getEquate(context) != null;
            }
        };
        this.removeAction.setPopupMenuData(new MenuData(REMOVE_MENUPATH, null, GROUP_NAME));
        this.removeAction.setKeyBindingData(new KeyBindingData(127, 0));
        this.applyEnumAction = new ListingContextAction("Apply Enum", this.getName()){

            @Override
            protected void actionPerformed(ListingActionContext context) {
                EquatePlugin.this.applyEnum(context);
            }

            @Override
            protected boolean isEnabledForContext(ListingActionContext context) {
                return context.hasSelection();
            }
        };
        this.applyEnumAction.setHelpLocation(new HelpLocation("EquatePlugin", "Apply_Enum"));
        this.applyEnumAction.setPopupMenuData(new MenuData(APPLYENUM_MENUPATH, null, GROUP_NAME));
        this.tool.addAction((DockingActionIf)this.setAction);
        this.tool.addAction((DockingActionIf)this.renameAction);
        this.tool.addAction((DockingActionIf)this.removeAction);
        this.tool.addAction((DockingActionIf)this.applyEnumAction);
    }

    protected boolean isEquateEqualScalar(Equate equate, Scalar scalar) {
        return equate.getValue() == scalar.getUnsignedValue() || equate.getValue() == scalar.getSignedValue();
    }

    private class InitializeDialogTask
    extends Task {
        private SetEquateDialog dialog;
        private Program program;
        private Scalar scalar;

        public InitializeDialogTask(Program program, Scalar scalar) {
            super("Initializing Set Equate Dialog", false, false, true);
            this.program = program;
            this.scalar = scalar;
        }

        public void run(TaskMonitor monitor) {
            this.dialog = new SetEquateDialog(EquatePlugin.this.tool, this.program, this.scalar);
        }

        SetEquateDialog getDialog() {
            return this.dialog;
        }
    }
}

