/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.util;

import docking.widgets.OptionDialog;
import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.datamgr.DataTypeSyncInfo;
import ghidra.app.plugin.core.datamgr.DataTypeSynchronizer;
import ghidra.app.plugin.core.datamgr.archive.Archive;
import ghidra.app.plugin.core.datamgr.archive.ProgramArchive;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.CategoryNode;
import ghidra.app.plugin.core.datamgr.tree.DataTypeNode;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.BuiltInDataType;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeDependencyException;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.MissingBuiltInDataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.SourceArchive;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.UniversalID;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;

public class DataTypeTreeCopyMoveTask
extends Task {
    private GTreeNode destinationNode;
    private List<GTreeNode> droppedNodeList;
    private ActionType actionType;
    private Archive destinationArchive;
    private Component component;
    private DataTypeConflictHandler conflictHandler;

    public DataTypeTreeCopyMoveTask(GTreeNode destinationNode, List<GTreeNode> droppedNodeList, ActionType actionType, Component component, DataTypeConflictHandler conflictHandler) {
        super("Drag/Drop", true, true, true);
        this.destinationNode = destinationNode;
        this.droppedNodeList = droppedNodeList;
        this.actionType = actionType;
        this.component = component;
        this.destinationArchive = this.findArchive(destinationNode);
        this.conflictHandler = conflictHandler;
    }

    private Archive findArchive(GTreeNode node) {
        while (node != null) {
            if (node instanceof ArchiveNode) {
                return ((ArchiveNode)node).getArchive();
            }
            node = node.getParent();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TaskMonitor monitor) {
        monitor.setMessage("Drag/Drop Categories/Data Types");
        monitor.initialize((long)this.droppedNodeList.size());
        this.droppedNodeList = this.filterList(this.droppedNodeList);
        GTreeNode firstNode = this.droppedNodeList.get(0);
        Archive sourceArchive = this.findArchive(firstNode);
        for (GTreeNode node : this.droppedNodeList) {
            if (sourceArchive == this.findArchive(node)) continue;
            Msg.showError((Object)((Object)this), (Component)this.component, (String)"Copy Failed", (Object)"All dragged data types must be from the same archive!");
            return;
        }
        if (sourceArchive != this.destinationArchive && !(this.destinationArchive instanceof ProgramArchive) && sourceArchive instanceof ProgramArchive && sourceArchive.isModifiable()) {
            try {
                this.associateDataTypes(sourceArchive, this.destinationArchive.getDataTypeManager().getLocalSourceArchive());
            }
            catch (CancelledException e) {
                return;
            }
        }
        int transactionID = this.destinationArchive.getDataTypeManager().startTransaction("Copy/Move Category/DataType");
        try {
            if (this.destinationNode instanceof DataTypeNode) {
                this.dragNodeToDataType(monitor);
            } else {
                this.dragNodesToCategory(monitor);
            }
        }
        finally {
            this.destinationArchive.getDataTypeManager().endTransaction(transactionID, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void associateDataTypes(Archive archive, SourceArchive source) throws CancelledException {
        DataTypeManager dtm = archive.getDataTypeManager();
        int transactionID = dtm.startTransaction("Associate DataTypes");
        try {
            DataTypeAssociationConfirmation confirmation = new DataTypeAssociationConfirmation();
            for (GTreeNode node : this.droppedNodeList) {
                if (node instanceof DataTypeNode) {
                    DataType replacementDataType = ((DataTypeNode)node).getDataType();
                    if (!this.isLocal(replacementDataType)) continue;
                    if (!confirmation.isConfirmed()) {
                        return;
                    }
                    dtm.associateDataTypeWithArchive(replacementDataType, source);
                    continue;
                }
                if (!(node instanceof CategoryNode)) continue;
                Category cat = ((CategoryNode)node).getCategory();
                this.associateDataTypes(cat, dtm, source, confirmation);
                if (!confirmation.haveAskedUser() || confirmation.isConfirmed()) continue;
                return;
            }
        }
        finally {
            archive.getDataTypeManager().endTransaction(transactionID, true);
        }
    }

    private void associateDataTypes(Category cat, DataTypeManager dtm, SourceArchive source, DataTypeAssociationConfirmation confirmation) throws CancelledException {
        Category[] categories;
        DataType[] dataTypes;
        for (DataType dataType : dataTypes = cat.getDataTypes()) {
            if (!this.isLocal(dataType)) continue;
            if (!confirmation.isConfirmed()) {
                return;
            }
            dtm.associateDataTypeWithArchive(dataType, source);
        }
        for (Category category : categories = cat.getCategories()) {
            this.associateDataTypes(category, dtm, source, confirmation);
            if (!confirmation.haveAskedUser() || confirmation.isConfirmed()) continue;
            return;
        }
    }

    private void dragNodesToCategory(TaskMonitor monitor) {
        int count = 0;
        Category destinationCategory = this.getCategory(this.destinationNode);
        Archive sourceArchive = this.findArchive(this.droppedNodeList.get(0));
        for (GTreeNode node : this.droppedNodeList) {
            monitor.setProgress((long)count++);
            if (monitor.isCancelled()) break;
            monitor.setMessage("Adding " + node.getName());
            if (this.actionType == ActionType.COPY || sourceArchive != this.destinationArchive) {
                this.copyNode(destinationCategory, node, monitor);
                continue;
            }
            this.moveNode(destinationCategory, node, monitor);
        }
    }

    private void copyNode(Category destinationCategory, GTreeNode node, TaskMonitor monitor) {
        if (node instanceof DataTypeNode) {
            DataType resolvedDT;
            DataType dataType;
            DataType nodeDt = ((DataTypeNode)node).getDataType();
            DataTypeManager dtm = destinationCategory.getDataTypeManager();
            boolean withinDataTypeManager = dtm == nodeDt.getDataTypeManager();
            DataType dataType2 = dataType = !withinDataTypeManager ? nodeDt.clone(nodeDt.getDataTypeManager()) : nodeDt.copy(nodeDt.getDataTypeManager());
            if (withinDataTypeManager && dataType.getCategoryPath().equals((Object)destinationCategory.getCategoryPath())) {
                this.renameAsCopy(destinationCategory, dataType);
            }
            if ((resolvedDT = destinationCategory.addDataType(dataType, this.conflictHandler)) instanceof Pointer || resolvedDT instanceof Array || resolvedDT instanceof BuiltInDataType || resolvedDT instanceof MissingBuiltInDataType) {
                return;
            }
            if (!resolvedDT.getCategoryPath().equals((Object)destinationCategory.getCategoryPath())) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String msg = "Another copy of this data-type already exists at " + resolvedDT.getPathName();
                        Msg.showInfo(this.getClass(), (Component)DataTypeTreeCopyMoveTask.this.component, (String)"DataType copy failed!", (Object)msg);
                    }
                });
            }
        } else if (node instanceof CategoryNode) {
            Category category = ((CategoryNode)node).getCategory();
            this.copyCategory(destinationCategory, category, monitor);
        }
    }

    private void renameAsCopy(Category destinationCategory, DataType dataType) {
        int indexOf;
        String baseName = dataType.getName();
        String prefix = "Copy_";
        String suffix = "of_";
        if (baseName.startsWith(prefix) && (indexOf = baseName.indexOf(suffix)) > 4) {
            if (indexOf == 5) {
                baseName = baseName.substring(indexOf + 3);
            } else if (indexOf > 5 && baseName.charAt(indexOf - 1) == '_') {
                String copyNumber = baseName.substring(5, indexOf - 1);
                try {
                    Integer.parseInt(copyNumber);
                    baseName = baseName.substring(indexOf + 3);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        String copyName = this.getNextCopyName(destinationCategory, baseName);
        try {
            dataType.setName(copyName);
        }
        catch (InvalidNameException e) {
            Msg.error((Object)((Object)this), (Object)("Problem creating copy of " + baseName), (Throwable)e);
        }
        catch (DuplicateNameException e) {
            Msg.error((Object)((Object)this), (Object)("Problem creating copy of " + baseName), (Throwable)e);
        }
    }

    private String getNextCopyName(Category destinationCategory, String baseName) {
        String prefix = "Copy_";
        String suffix = "of_";
        String copyName = prefix + suffix + baseName;
        if (destinationCategory.getDataType(copyName) == null) {
            return copyName;
        }
        for (int i = 2; i < Integer.MAX_VALUE; ++i) {
            copyName = prefix + i + "_" + suffix + baseName;
            if (destinationCategory.getDataType(copyName) != null) continue;
            return copyName;
        }
        return baseName;
    }

    private void moveNode(Category destinationCategory, GTreeNode node, TaskMonitor monitor) {
        if (node instanceof DataTypeNode) {
            DataType dataType = ((DataTypeNode)node).getDataType();
            this.moveDataType(destinationCategory, dataType);
        } else if (node instanceof CategoryNode) {
            Category category = ((CategoryNode)node).getCategory();
            this.moveCategory(destinationCategory, category, monitor);
        }
    }

    private void moveCategory(Category destinationCategory, Category category, TaskMonitor monitor) {
        if (category.getParent() == destinationCategory) {
            return;
        }
        try {
            CategoryPath path = destinationCategory.getCategoryPath();
            if (path.isAncestorOrSelf(category.getCategoryPath())) {
                Msg.showError((Object)((Object)this), (Component)this.component, (String)"Move Failed", (Object)"Cannot move a parent node onto a child node");
                return;
            }
            destinationCategory.moveCategory(category, monitor);
        }
        catch (DuplicateNameException e) {
            Msg.showError((Object)((Object)this), (Component)this.component, (String)"Move Failed", (Object)("Move failed due to duplicate name:\n" + e.getMessage()));
        }
    }

    private void moveDataType(Category destinationCategory, DataType dataType) {
        if (dataType.getCategoryPath().equals((Object)destinationCategory.getCategoryPath())) {
            Msg.showError((Object)((Object)this), (Component)this.component, (String)"Move Failed", (Object)"DataType is already in this category.");
            return;
        }
        try {
            destinationCategory.moveDataType(dataType, this.conflictHandler);
        }
        catch (DataTypeDependencyException e) {
            Msg.showError((Object)((Object)this), (Component)this.component, (String)"Move Failed", (Object)e.getMessage());
        }
    }

    private void copyCategory(Category destinationCategory, Category category, TaskMonitor monitor) {
        boolean withinSameDataTypeManager;
        CategoryPath destinationPath = destinationCategory.getCategoryPath();
        boolean bl = withinSameDataTypeManager = destinationCategory.getDataTypeManager() == category.getDataTypeManager();
        if (withinSameDataTypeManager && destinationPath.isAncestorOrSelf(category.getCategoryPath())) {
            Msg.showError((Object)((Object)this), (Component)this.component, (String)"Copy Failed", (Object)"Cannot copy a parent node onto a child node");
            return;
        }
        destinationCategory.copyCategory(category, this.conflictHandler, monitor);
    }

    private Category getCategory(GTreeNode node) {
        if (node instanceof ArchiveNode) {
            return ((ArchiveNode)node).getArchive().getDataTypeManager().getRootCategory();
        }
        if (node instanceof CategoryNode) {
            return ((CategoryNode)node).getCategory();
        }
        throw new AssertException("Expected node to be either an ArchiveNode or CategoryNode but was " + node.getClass());
    }

    private boolean isAssociatedEitherWay(DataType dataType1, DataType dataType2) {
        return this.isAssociated(dataType1, dataType2) || this.isAssociated(dataType2, dataType1);
    }

    private boolean isAssociated(DataType sourceDataType, DataType destinationDataType) {
        UniversalID destinationID = destinationDataType.getUniversalID();
        if (destinationID == null || !destinationID.equals((Object)sourceDataType.getUniversalID())) {
            return false;
        }
        if (!destinationDataType.getSourceArchive().getSourceArchiveID().equals((Object)sourceDataType.getSourceArchive().getSourceArchiveID())) {
            return false;
        }
        return this.isLocal(sourceDataType);
    }

    private boolean isLocal(DataType dataType) {
        return dataType.getSourceArchive().getSourceArchiveID().equals((Object)dataType.getDataTypeManager().getUniversalID());
    }

    private void dragNodeToDataType(TaskMonitor monitor) {
        DataType destinationDataType = ((DataTypeNode)this.destinationNode).getDataType();
        GTreeNode node = this.droppedNodeList.get(0);
        DataType replacementDataType = ((DataTypeNode)node).getDataType();
        Archive sourceArchive = this.findArchive(node);
        if (sourceArchive != this.destinationArchive) {
            if (this.isAssociatedEitherWay(replacementDataType, destinationDataType)) {
                if (this.isLocal(destinationDataType)) {
                    DataTypeSyncInfo syncInfo = new DataTypeSyncInfo(replacementDataType, destinationDataType.getDataTypeManager());
                    if (!syncInfo.canCommit()) {
                        Msg.showInfo(((Object)((Object)this)).getClass(), (Component)this.component, (String)"Commit Data Type", (Object)"No changes to commit");
                    } else if (this.confirmCommit()) {
                        DataTypeSynchronizer.commit(destinationDataType.getDataTypeManager(), replacementDataType);
                    }
                } else {
                    DataTypeSyncInfo syncInfo = new DataTypeSyncInfo(destinationDataType, replacementDataType.getDataTypeManager());
                    if (!syncInfo.canUpdate()) {
                        Msg.showInfo(((Object)((Object)this)).getClass(), (Component)this.component, (String)"Update Data Type", (Object)"No changes to copy");
                    } else if (this.confirmUpdate()) {
                        DataTypeSynchronizer.update(destinationDataType.getDataTypeManager(), replacementDataType);
                    }
                }
                return;
            }
            this.actionType = ActionType.COPY;
            replacementDataType = replacementDataType.clone(replacementDataType.getDataTypeManager());
        } else if (this.actionType == ActionType.COPY) {
            replacementDataType = replacementDataType.copy(replacementDataType.getDataTypeManager());
        }
        this.replaceDataType(destinationDataType, replacementDataType);
    }

    private boolean confirmCommit() {
        return this.confirm("Commit Data Type?", "Do you want to commit the changes to this data type back to the source Archive? \n(Warning: any changes in the source archive will be overwritten.)");
    }

    private boolean confirmUpdate() {
        return this.confirm("Update Data Type?", "Do you want to update this data type with the changes in the source Archive?\n(Warning: any local changes will be overwritten.)");
    }

    private boolean confirm(final String title, final String message) {
        final BooleanResultsContainer results = new BooleanResultsContainer();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    int selectedOption = OptionDialog.showYesNoDialog((Component)DataTypeTreeCopyMoveTask.this.component, (String)title, (String)message);
                    results.value = selectedOption == 1;
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            Msg.error((Object)((Object)this), (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
        return results.value;
    }

    private int askToAssociateDataTypes() {
        final IntResultsContainer results = new IntResultsContainer();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    results.value = OptionDialog.showYesNoCancelDialog((Component)DataTypeTreeCopyMoveTask.this.component, (String)"Associate DataTypes?", (String)"Do you want to associate local datatypes with the target archive?");
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            Msg.error((Object)((Object)this), (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
        return results.value;
    }

    private void replaceDataType(final DataType existingDT, final DataType replacementDT) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    int selectedOption = OptionDialog.showYesNoDialog((Component)DataTypeTreeCopyMoveTask.this.component, (String)"Replace Data Type?", (String)("Replace " + existingDT.getPathName() + "\nwith " + replacementDT.getPathName() + "?"));
                    if (selectedOption == 1) {
                        try {
                            DataTypeManager dtMgr = existingDT.getDataTypeManager();
                            dtMgr.replaceDataType(existingDT, replacementDT, true);
                        }
                        catch (DataTypeDependencyException e) {
                            Msg.showError((Object)this, (Component)DataTypeTreeCopyMoveTask.this.component, (String)"Replace Failed", (Object)e.getMessage());
                        }
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            Msg.error((Object)((Object)this), (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
    }

    private List<GTreeNode> filterList(List<GTreeNode> nodeList) {
        HashSet<GTreeNode> nodeSet = new HashSet<GTreeNode>(nodeList);
        ArrayList<GTreeNode> filteredList = new ArrayList<GTreeNode>();
        for (GTreeNode node : nodeSet) {
            if (this.containsAncestor(nodeSet, node)) continue;
            filteredList.add(node);
        }
        return filteredList;
    }

    private boolean containsAncestor(Set<GTreeNode> nodeSet, GTreeNode node) {
        GTreeNode parent = node.getParent();
        if (parent == null) {
            return false;
        }
        if (nodeSet.contains(parent)) {
            return true;
        }
        return this.containsAncestor(nodeSet, parent);
    }

    class IntResultsContainer {
        public int value;

        IntResultsContainer() {
        }
    }

    class BooleanResultsContainer {
        public boolean value;

        BooleanResultsContainer() {
        }
    }

    private class DataTypeAssociationConfirmation {
        Boolean confirmed = null;

        private DataTypeAssociationConfirmation() {
        }

        boolean isConfirmed() throws CancelledException {
            if (this.confirmed == null) {
                int result = DataTypeTreeCopyMoveTask.this.askToAssociateDataTypes();
                if (result == 2) {
                    this.confirmed = false;
                } else if (result == 1) {
                    this.confirmed = true;
                } else {
                    throw new CancelledException();
                }
            }
            return this.confirmed;
        }

        boolean haveAskedUser() {
            return this.confirmed != null;
        }
    }

    public static enum ActionType {
        COPY,
        MOVE;

    }
}

