/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.dialogs.NumberInputDialog;
import docking.widgets.tree.GTree;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.tree.DataTypeNode;
import ghidra.app.plugin.core.datamgr.tree.DataTypeTreeNode;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Structure;
import ghidra.util.Msg;
import ghidra.util.exception.InvalidInputException;
import javax.swing.tree.TreePath;

public class PackSizeDataTypeAction
extends DockingAction {
    private DataTypeManagerPlugin plugin;

    public PackSizeDataTypeAction(DataTypeManagerPlugin plugin) {
        super("Pack Size Data Type", plugin.getName());
        this.plugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Pack for Size..."}, "Edit"));
    }

    public boolean isEnabledForContext(ActionContext context) {
        Object contextObject = context.getContextObject();
        if (!(contextObject instanceof GTree)) {
            return false;
        }
        GTree gTree = (GTree)contextObject;
        TreePath[] selectionPaths = gTree.getSelectionPaths();
        if (selectionPaths.length != 1) {
            return false;
        }
        DataTypeTreeNode node = (DataTypeTreeNode)((Object)selectionPaths[0].getLastPathComponent());
        if (!(node instanceof DataTypeNode)) {
            return false;
        }
        this.setEnabled(node.isModifiable());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionContext context) {
        GTree gTree = (GTree)context.getContextObject();
        TreePath[] selectionPaths = gTree.getSelectionPaths();
        TreePath treePath = selectionPaths[0];
        DataTypeNode dataTypeNode = (DataTypeNode)((Object)treePath.getLastPathComponent());
        DataType dataType = dataTypeNode.getDataType();
        DataTypeManager dataTypeManager = dataType.getDataTypeManager();
        if (dataTypeManager == null) {
            Msg.error((Object)((Object)this), (Object)("Can't pack data type " + dataType.getName() + " without a data type manager."));
            return;
        }
        NumberInputDialog numberInputDialog = new NumberInputDialog("pack alignment", 0, 0, 16);
        if (!numberInputDialog.show()) {
            return;
        }
        int packSize = numberInputDialog.getValue();
        int transactionID = -1;
        boolean commit = false;
        try {
            transactionID = dataTypeManager.startTransaction("pack(" + packSize + ") of " + dataType.getName());
            this.packDataType(dataType, packSize);
            commit = true;
        }
        catch (InvalidInputException iie) {
            iie.printStackTrace();
        }
        finally {
            dataTypeManager.endTransaction(transactionID, commit);
        }
    }

    private void packDataType(DataType dataType, int packSize) throws InvalidInputException {
        if (!(dataType instanceof Structure)) {
            Msg.error((Object)((Object)this), (Object)("Can't pack data type " + dataType.getName() + ". It's not a structure."));
            return;
        }
        ((Structure)dataType).pack(packSize);
    }
}

