/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.DialogComponentProvider;
import docking.widgets.combobox.GhidraComboBox;
import ghidra.program.model.data.AnnotationHandler;
import ghidra.util.HelpLocation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;

class AnnotationHandlerDialog
extends DialogComponentProvider {
    private GhidraComboBox<AnnotationHandler> handlerComboBox;
    private List<AnnotationHandler> handlerList;
    private AnnotationHandler handler;
    private boolean success;

    AnnotationHandlerDialog(List<AnnotationHandler> handlerList) {
        super("Export Format");
        this.handlerList = handlerList;
        this.addWorkPanel(this.create());
        this.addOKButton();
        this.addCancelButton();
        this.setOkEnabled(true);
        this.setHelpLocation(new HelpLocation("DataManagerPlugin", "Export_To"));
        this.setRememberSize(false);
    }

    protected void cancelCallback() {
        this.close();
    }

    protected void okCallback() {
        Object[] objs = this.handlerComboBox.getSelectedObjects();
        if (objs != null && objs.length > 0) {
            this.handler = (AnnotationHandler)objs[0];
        }
        this.success = true;
        this.close();
    }

    JPanel create() {
        JPanel outerPanel = new JPanel(new BorderLayout());
        this.handlerComboBox = new GhidraComboBox(new Vector<AnnotationHandler>(this.handlerList));
        this.handlerComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnnotationHandlerDialog.this.okCallback();
            }
        });
        outerPanel.add((Component)this.handlerComboBox, "North");
        return outerPanel;
    }

    public AnnotationHandler getHandler() {
        return this.handler;
    }

    public boolean wasSuccessful() {
        return this.success;
    }
}

