/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr;

import docking.ComponentProvider;
import docking.widgets.tree.GTreeNode;
import ghidra.app.context.ProgramActionContext;
import ghidra.app.plugin.core.datamgr.DataTypesProvider;
import ghidra.app.plugin.core.datamgr.archive.ProjectArchive;
import ghidra.app.plugin.core.datamgr.tree.DataTypeArchiveGTree;
import ghidra.app.plugin.core.datamgr.tree.ProjectArchiveNode;
import ghidra.framework.main.datatable.DomainFileContext;
import ghidra.framework.model.DomainFile;
import ghidra.program.model.listing.Program;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreePath;

public class DataTypesActionContext
extends ProgramActionContext
implements DomainFileContext {
    private final GTreeNode clickedNode;
    private final boolean isToolbarAction;
    private DataTypeArchiveGTree archiveGTree;
    private List<DomainFile> domainFiles;

    public DataTypesActionContext(DataTypesProvider provider, Program program, DataTypeArchiveGTree archiveGTree, GTreeNode clickedNode) {
        this(provider, program, archiveGTree, clickedNode, false);
    }

    public DataTypesActionContext(DataTypesProvider provider, Program program, DataTypeArchiveGTree archiveGTree, GTreeNode clickedNode, boolean isToolbarAction) {
        super((ComponentProvider)provider, program, (Component)((Object)archiveGTree));
        this.archiveGTree = archiveGTree;
        this.clickedNode = clickedNode;
        this.isToolbarAction = isToolbarAction;
    }

    public boolean isToolbarAction() {
        return this.isToolbarAction;
    }

    public GTreeNode getSelectedNode() {
        return this.clickedNode;
    }

    public List<DomainFile> getSelectedFiles() {
        if (this.domainFiles == null) {
            TreePath[] selectionPaths = this.archiveGTree.getSelectionPaths();
            this.domainFiles = new ArrayList<DomainFile>();
            for (TreePath path : selectionPaths) {
                Object lastPathComponent = path.getLastPathComponent();
                if (!(lastPathComponent instanceof ProjectArchiveNode)) continue;
                ProjectArchiveNode node = (ProjectArchiveNode)((Object)lastPathComponent);
                ProjectArchive archive = (ProjectArchive)node.getArchive();
                DomainFile originalDomainFile = archive.getDomainFile();
                this.domainFiles.add(originalDomainFile);
            }
        }
        return this.domainFiles;
    }

    public int getFileCount() {
        return this.getSelectedFiles().size();
    }

    public boolean isInActiveProject() {
        return true;
    }
}

