/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.data;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import ghidra.app.cmd.data.CreateDataBackgroundCmd;
import ghidra.app.cmd.data.CreateDataCmd;
import ghidra.app.cmd.data.CreateDataInStructureBackgroundCmd;
import ghidra.app.cmd.data.CreateDataInStructureCmd;
import ghidra.app.context.ListingActionContext;
import ghidra.app.plugin.core.data.ChooseDataTypeAction;
import ghidra.app.plugin.core.data.CreateArrayAction;
import ghidra.app.plugin.core.data.CreateStructureAction;
import ghidra.app.plugin.core.data.CycleGroupAction;
import ghidra.app.plugin.core.data.DataAction;
import ghidra.app.plugin.core.data.DataSettingsDialog;
import ghidra.app.plugin.core.data.PointerDataAction;
import ghidra.app.plugin.core.data.RecentlyUsedAction;
import ghidra.app.plugin.core.data.RenameDataFieldAction;
import ghidra.app.services.DataService;
import ghidra.app.services.DataTypeManagerService;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.CycleGroup;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeInstance;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypeManagerChangeListener;
import ghidra.program.model.data.DataTypeManagerChangeListenerAdapter;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.util.CodeUnitLocation;
import ghidra.program.util.InteriorSelection;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.SwingUpdateManager;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Create Data in listing", description="Provides many actions for setting, changing and deleting data in the listing display.", servicesRequired={DataTypeManagerService.class}, servicesProvided={DataService.class})
public class DataPlugin
extends Plugin
implements DataService {
    static final int BACKGROUND_SELECTION_THRESHOLD = 2048;
    static final DataType POINTER_DATA_TYPE = new PointerDataType();
    private static final String BASIC_DATA_GROUP = "BasicData";
    private static final String DATA_MENU_POPUP_PATH = "Data";
    private static final String[] EDIT_DATA_TYPE_POPUP_PATH = new String[]{"Data", "Edit Data Type..."};
    private static final String[] DATA_SETTINGS_POPUP_PATH = new String[]{"Data", "Settings..."};
    private static final String[] DEFAULT_DATA_SETTINGS_POPUP_PATH = new String[]{"Data", "Default Settings..."};
    private static final String[] CHOOSE_DATA_TYPE_POPUP_PATH = new String[]{"Data", "Choose Data Type..."};
    private DataTypeManagerService dtmService;
    private DockingAction settingsAction;
    private DockingAction defaultSettingsAction;
    private DataAction pointerAction;
    private DataAction recentlyUsedAction;
    private DockingAction editDataTypeAction;
    private CreateStructureAction createStructureAction;
    private CreateArrayAction createArrayAction;
    private RenameDataFieldAction renameDataFieldAction;
    private List<DataAction> favoriteActions = new ArrayList<DataAction>();
    private ChooseDataTypeAction chooseDataTypeAction;
    private DataTypeManagerChangeListenerAdapter adapter;
    private SwingUpdateManager favoritesUpdateManager;

    public DataPlugin(PluginTool tool) {
        super(tool);
        this.addActions();
        this.favoritesUpdateManager = new SwingUpdateManager(1000, 30000, () -> this.updateFavoriteActions());
    }

    protected void init() {
        this.initializeServices();
        this.addCycleGroupActions();
        this.updateFavoriteActions();
    }

    private void addActions() {
        this.recentlyUsedAction = new RecentlyUsedAction(this);
        this.recentlyUsedAction.setEnabled(false);
        this.tool.addAction((DockingActionIf)this.recentlyUsedAction);
        this.createStructureAction = new CreateStructureAction(this);
        this.tool.addAction((DockingActionIf)this.createStructureAction);
        this.createArrayAction = new CreateArrayAction(this);
        this.tool.addAction((DockingActionIf)this.createArrayAction);
        this.renameDataFieldAction = new RenameDataFieldAction(this);
        this.tool.addAction((DockingActionIf)this.renameDataFieldAction);
        this.pointerAction = new PointerDataAction(this);
        this.tool.addAction((DockingActionIf)this.pointerAction);
        this.settingsAction = new DockingAction("Data Settings", this.getName()){

            public void actionPerformed(ActionContext context) {
                DataPlugin.this.dataSettingsCallback((ListingActionContext)context.getContextObject());
            }

            public boolean isEnabledForContext(ActionContext context) {
                Object contextObject = context.getContextObject();
                if (contextObject instanceof ListingActionContext) {
                    return DataPlugin.this.isDataTypeSettingsAllowed((ListingActionContext)context, false);
                }
                return false;
            }
        };
        this.settingsAction.setPopupMenuData(new MenuData(DATA_SETTINGS_POPUP_PATH, null, "Settings"));
        this.settingsAction.setEnabled(true);
        this.tool.addAction((DockingActionIf)this.settingsAction);
        this.defaultSettingsAction = new DockingAction("Default Data Settings", this.getName()){

            public void actionPerformed(ActionContext context) {
                DataPlugin.this.defaultDataSettingsCallback((ListingActionContext)context.getContextObject());
            }

            public boolean isEnabledForContext(ActionContext context) {
                Object contextObject = context.getContextObject();
                if (contextObject instanceof ListingActionContext) {
                    return DataPlugin.this.isDataTypeSettingsAllowed((ListingActionContext)context, true);
                }
                return false;
            }
        };
        this.defaultSettingsAction.setPopupMenuData(new MenuData(DEFAULT_DATA_SETTINGS_POPUP_PATH, null, "Settings"));
        this.defaultSettingsAction.setEnabled(true);
        this.tool.addAction((DockingActionIf)this.defaultSettingsAction);
        this.editDataTypeAction = new DockingAction("Edit Data Type", this.getName()){

            public void actionPerformed(ActionContext context) {
                DataPlugin.this.editDataTypeCallback((ListingActionContext)context.getContextObject());
            }

            public boolean isEnabledForContext(ActionContext context) {
                DataType editableDt;
                Object contextObject = context.getContextObject();
                if (contextObject instanceof ListingActionContext && (editableDt = DataPlugin.this.getEditableDataTypeFromContext((ListingActionContext)contextObject)) != null) {
                    DataPlugin.this.editDataTypeAction.setHelpLocation(DataPlugin.this.dtmService.getEditorHelpLocation(editableDt));
                    return true;
                }
                return false;
            }
        };
        this.editDataTypeAction.setPopupMenuData(new MenuData(EDIT_DATA_TYPE_POPUP_PATH, null, BASIC_DATA_GROUP));
        this.editDataTypeAction.setEnabled(true);
        this.editDataTypeAction.setHelpLocation(new HelpLocation("DataTypeEditors", "Structure_Editor"));
        this.tool.addAction((DockingActionIf)this.editDataTypeAction);
        this.chooseDataTypeAction = new ChooseDataTypeAction(this);
        this.chooseDataTypeAction.setEnabled(false);
        this.chooseDataTypeAction.setPopupMenuData(new MenuData(CHOOSE_DATA_TYPE_POPUP_PATH, BASIC_DATA_GROUP));
        this.chooseDataTypeAction.setEnabled(true);
        this.chooseDataTypeAction.setHelpLocation(new HelpLocation("DataTypeEditors", "DataTypeSelectionDialog"));
        this.tool.addAction((DockingActionIf)this.chooseDataTypeAction);
    }

    private void initializeServices() {
        this.dtmService = (DataTypeManagerService)this.tool.getService(DataTypeManagerService.class);
        if (this.dtmService == null) {
            throw new AssertException("DataTypeManagerService was not found!");
        }
        this.adapter = new DataTypeManagerChangeListenerAdapter(){

            public void favoritesChanged(DataTypeManager dtm, DataTypePath path, boolean isFavorite) {
                DataPlugin.this.favoritesUpdateManager.update();
            }
        };
        this.dtmService.addDataTypeManagerChangeListener((DataTypeManagerChangeListener)this.adapter);
    }

    boolean isEditDataTypeAllowed(ListingActionContext context) {
        Data data = this.getDataUnit(context);
        if (data == null || this.dtmService == null) {
            return false;
        }
        if (this.dtmService.isEditable(data.getBaseDataType())) {
            return true;
        }
        Data pdata = data.getParent();
        return pdata != null && this.dtmService.isEditable(pdata.getBaseDataType());
    }

    DataType getEditableDataTypeFromContext(ListingActionContext context) {
        ProgramSelection currentSelection = context.getSelection();
        Program currentProgram = context.getProgram();
        DataType editableDataType = null;
        Data data = null;
        if (currentSelection != null && !currentSelection.isEmpty()) {
            boolean isDataOnly;
            Listing listing = currentProgram.getListing();
            boolean bl = isDataOnly = !listing.getInstructions((AddressSetView)currentSelection, true).hasNext();
            if (isDataOnly) {
                data = this.getDataUnit(context);
            }
        } else {
            data = this.getDataUnit(context);
        }
        if (data != null && this.dtmService != null) {
            DataType baseDt = data.getBaseDataType();
            if (this.dtmService.isEditable(baseDt)) {
                editableDataType = baseDt;
            } else {
                Data pdata = data.getParent();
                if (pdata != null && this.dtmService.isEditable(baseDt = pdata.getBaseDataType())) {
                    editableDataType = baseDt;
                }
            }
        }
        return editableDataType;
    }

    @Override
    public boolean createData(DataType dt, ListingActionContext context, boolean enableConflictHandling) {
        ProgramLocation location = context.getLocation();
        if (!(location instanceof CodeUnitLocation)) {
            return false;
        }
        return this.doCreateData(context, dt);
    }

    boolean doCreateData(ListingActionContext context, DataType dt) {
        ProgramSelection selection = context.getSelection();
        ProgramLocation location = context.getLocation();
        Program program = context.getProgram();
        dt = dt.clone((DataTypeManager)program.getDataTypeManager());
        boolean didCreateData = true;
        if (selection != null && !selection.isEmpty()) {
            didCreateData = this.createDataForSelection(program, dt, selection);
        } else if (location != null) {
            didCreateData = this.createDataAtLocation(program, dt, location);
        }
        this.updateRecentlyUsed(dt);
        return didCreateData;
    }

    private boolean createDataAtLocation(Program program, DataType dt, ProgramLocation location) {
        Object cmd;
        Address start = location.getAddress();
        int[] startPath = location.getComponentPath();
        if (startPath != null && startPath.length != 0) {
            cmd = new CreateDataInStructureCmd(start, startPath, dt, true);
        } else {
            if (!this.checkEnoughSpace(program, start, dt, true)) {
                return false;
            }
            cmd = new CreateDataCmd(start, true, true, dt);
        }
        return this.getTool().execute((Command)cmd, (DomainObject)program);
    }

    private boolean createDataForSelection(Program program, DataType dt, ProgramSelection selection) {
        BackgroundCommand cmd;
        Address start = selection.getMinAddress();
        InteriorSelection interSel = selection.getInteriorSelection();
        if (interSel != null) {
            int[] startPath = interSel.getFrom().getComponentPath();
            int length = (int)selection.getNumAddresses();
            cmd = new CreateDataInStructureBackgroundCmd(start, startPath, length, dt, true);
        } else {
            cmd = new CreateDataBackgroundCmd(selection, dt, true);
        }
        boolean didCreateData = false;
        if (selection.getNumAddresses() < 2048L) {
            didCreateData = this.getTool().execute((Command)cmd, (DomainObject)program);
        } else {
            this.getTool().executeBackgroundCommand(cmd, (UndoableDomainObject)program);
        }
        return didCreateData;
    }

    private boolean checkEnoughSpace(Program program, Address start, DataType dataType, boolean convertPointers) {
        Listing listing = program.getListing();
        Data data = listing.getDataAt(start);
        if (data == null) {
            this.tool.setStatusInfo("Invalid data location");
            return false;
        }
        if (this.canConvertPointer(dataType, data, convertPointers)) {
            return true;
        }
        int newSize = this.getDataTypeSize(program, dataType, start);
        if (newSize == 1) {
            return true;
        }
        Address end = null;
        try {
            end = start.addNoWrap((long)(newSize - 1));
        }
        catch (AddressOverflowException e) {
            return false;
        }
        if (this.intstrutionExists(listing, dataType, start, end)) {
            return false;
        }
        MemoryBlock memBlock = program.getMemory().getBlock(start);
        Address blockMaxAddress = memBlock.getEnd();
        if (blockMaxAddress.compareTo((Object)end) < 0) {
            this.tool.setStatusInfo("Create " + dataType.getName() + " failed: Not enough room in memory block containing address " + start + " which ends at " + blockMaxAddress + ".");
            return false;
        }
        Data definedData = DataUtilities.getNextNonUndefinedDataAfter((Program)program, (Address)start, (Address)blockMaxAddress);
        return !this.dataExists(program, dataType, definedData, start, end);
    }

    private boolean canConvertPointer(DataType dataType, Data existingData, boolean convertPointers) {
        if (!convertPointers) {
            return false;
        }
        if (!existingData.isDefined()) {
            return false;
        }
        if (dataType instanceof FactoryDataType) {
            return false;
        }
        if (dataType instanceof Pointer) {
            return false;
        }
        DataType existingDT = existingData.getDataType();
        return existingDT instanceof Pointer;
    }

    private boolean dataExists(Program program, DataType dataType, Data definedData, Address start, Address end) {
        if (definedData == null) {
            return false;
        }
        if (definedData.getMinAddress().compareTo((Object)end) > 0) {
            return false;
        }
        int resp = OptionDialog.showYesNoCancelDialog((Component)this.tool.getActiveWindow(), (String)"Data Conflict", (String)("Data applied from " + start + " to " + end + "\nconflicts with existing defined data!\n\nClear conflicting data?"));
        if (resp != 1) {
            this.tool.setStatusInfo("Create " + dataType.getName() + " failed: Data exists at address " + definedData.getMinAddress() + " to " + definedData.getMaxAddress());
            return true;
        }
        return false;
    }

    private boolean intstrutionExists(Listing listing, DataType dataType, Address start, Address end) {
        Instruction instruction = listing.getInstructionAfter(start);
        if (instruction == null) {
            return false;
        }
        String dtName = dataType.getName();
        Address minAddress = instruction.getMinAddress();
        if (minAddress.compareTo((Object)end) <= 0) {
            this.tool.setStatusInfo("Create " + dtName + " failed: Instruction exists at address " + minAddress + " to " + instruction.getMaxAddress());
            return true;
        }
        return false;
    }

    private int getDataTypeSize(Program program, DataType dataType, Address start) {
        MemoryBlock block;
        int newSize = dataType.getLength();
        if (newSize >= 0) {
            return newSize;
        }
        if (!(!(dataType instanceof Dynamic) && !(dataType instanceof FactoryDataType) || (block = program.getMemory().getBlock(start)) != null && block.isInitialized())) {
            this.tool.setStatusInfo(dataType.getName() + " may only be applied on initialized memory");
            return -1;
        }
        DataTypeInstance dataTypeInstance = DataTypeInstance.getDataTypeInstance((DataType)dataType, (MemBuffer)new DumbMemBufferImpl(program.getMemory(), start));
        if (dataTypeInstance == null) {
            this.tool.setStatusInfo("Unallowed data type at " + start + ": " + dataType.getName());
            return -1;
        }
        return dataTypeInstance.getLength();
    }

    boolean doCreateData(Program program, ProgramLocation loc, ProgramSelection sel, DataType dt) {
        return this.doCreateData(program, loc, sel, dt, true);
    }

    boolean doCreateData(Program program, ProgramLocation loc, ProgramSelection sel, DataType dt, boolean convertPointers) {
        boolean rc = true;
        if (sel != null && !sel.isEmpty()) {
            BackgroundCommand cmd;
            Address start = sel.getMinAddress();
            InteriorSelection interSel = sel.getInteriorSelection();
            if (interSel != null) {
                int[] startPath = interSel.getFrom().getComponentPath();
                int length = (int)sel.getNumAddresses();
                cmd = new CreateDataInStructureBackgroundCmd(start, startPath, length, dt, convertPointers);
            } else {
                cmd = new CreateDataBackgroundCmd(sel, dt, convertPointers);
            }
            if (sel.getNumAddresses() < 2048L) {
                rc = this.tool.execute((Command)cmd, (DomainObject)program);
            } else {
                this.getPluginTool().executeBackgroundCommand(cmd, (UndoableDomainObject)program);
            }
        } else if (loc != null) {
            Object cmd;
            Address start = loc.getAddress();
            int[] startPath = loc.getComponentPath();
            if (startPath != null && startPath.length != 0) {
                cmd = new CreateDataInStructureCmd(start, startPath, dt, convertPointers);
            } else {
                if (!this.checkEnoughSpace(program, start, dt, convertPointers)) {
                    return false;
                }
                cmd = new CreateDataCmd(start, dt, false, convertPointers);
            }
            rc = this.getPluginTool().execute((Command)cmd, (DomainObject)program);
        }
        this.updateRecentlyUsed(dt);
        return rc;
    }

    PluginTool getPluginTool() {
        return this.tool;
    }

    private void clearActions(List<DataAction> actions) {
        for (DockingAction dockingAction : actions) {
            this.tool.removeAction((DockingActionIf)dockingAction);
            dockingAction.dispose();
        }
        actions.clear();
    }

    private void addCycleGroupActions() {
        if (this.dtmService == null) {
            return;
        }
        for (CycleGroup group : CycleGroup.ALL_CYCLE_GROUPS) {
            CycleGroupAction action = new CycleGroupAction(group, this);
            action.setEnabled(false);
            this.tool.addAction((DockingActionIf)action);
        }
    }

    private void updateFavoriteActions() {
        if (this.dtmService == null) {
            return;
        }
        this.clearActions(this.favoriteActions);
        List<DataType> favoritesList = this.dtmService.getFavorites();
        for (DataType dataType : favoritesList) {
            if (dataType.isEquivalent(POINTER_DATA_TYPE)) continue;
            DataAction action = new DataAction(dataType, this);
            this.tool.addAction((DockingActionIf)action);
            this.favoriteActions.add(action);
        }
    }

    void updateRecentlyUsed(DataType dt) {
        if (this.dtmService != null) {
            this.dtmService.setRecentlyUsed(dt);
        }
    }

    private boolean isSelectionJustSingleDataInstance(ProgramSelection selection, Data data) {
        if (selection != null && data != null) {
            AddressSet dataAS = new AddressSet(data.getAddress(), data.getMaxAddress());
            return dataAS.hasSameAddresses((AddressSetView)selection);
        }
        return false;
    }

    private void dataSettingsCallback(ListingActionContext context) {
        DataSettingsDialog dialog;
        Data data = this.getDataUnit(context);
        ProgramSelection selection = context.getSelection();
        if (selection != null && !selection.isEmpty() && !this.isSelectionJustSingleDataInstance(selection, data)) {
            try {
                dialog = new DataSettingsDialog(context.getProgram(), selection);
            }
            catch (CancelledException e) {
                return;
            }
            if (!dialog.hasSettings()) {
                Msg.showError((Object)this, (Component)this.tool.getActiveWindow(), (String)"No Settings Found", (Object)"Common data settings were not found across selection");
                return;
            }
        } else {
            if (data == null) {
                return;
            }
            dialog = new DataSettingsDialog(context.getProgram(), data);
        }
        this.tool.showDialog((DialogComponentProvider)dialog);
        dialog.dispose();
    }

    boolean isDataTypeSettingsAllowed(ListingActionContext context, boolean editDefaults) {
        ProgramSelection selection = context.getSelection();
        Data data = this.getDataUnit(context);
        if (selection != null && !selection.isEmpty() && !this.isSelectionJustSingleDataInstance(selection, data)) {
            return !editDefaults;
        }
        if (data == null) {
            return false;
        }
        return data.getDataType().getSettingsDefinitions().length != 0;
    }

    private void defaultDataSettingsCallback(ListingActionContext context) {
        Data data = this.getDataUnit(context);
        if (data == null) {
            return;
        }
        DataSettingsDialog dialog = null;
        Program program = context.getProgram();
        Data parent = data.getParent();
        if (parent != null) {
            DataType parentDT = parent.getDataType();
            if (parentDT instanceof Composite) {
                int[] path = context.getLocation().getComponentPath();
                dialog = new DataSettingsDialog(program, ((Composite)parentDT).getComponent(path[path.length - 1]));
            } else {
                dialog = new DataSettingsDialog(program, data.getDataType());
            }
        } else {
            dialog = new DataSettingsDialog(program, data.getDataType());
        }
        this.tool.showDialog((DialogComponentProvider)dialog);
        dialog.dispose();
        dialog = null;
    }

    private void editDataTypeCallback(ListingActionContext context) {
        Data data = this.getDataUnit(context);
        if (data == null) {
            return;
        }
        DataType dataType = data.getBaseDataType();
        if (this.dtmService.isEditable(dataType)) {
            this.dtmService.edit(dataType);
        } else if ((data = data.getParent()) != null && this.dtmService.isEditable(dataType = data.getBaseDataType())) {
            this.dtmService.edit(dataType);
        }
    }

    public void dispose() {
        this.favoritesUpdateManager.dispose();
        if (this.dtmService != null) {
            this.dtmService.removeDataTypeManagerChangeListener((DataTypeManagerChangeListener)this.adapter);
        }
        super.dispose();
        this.favoriteActions.clear();
        this.createStructureAction.dispose();
    }

    Data getDataUnit(ListingActionContext context) {
        ProgramLocation location = context.getLocation();
        ProgramSelection selection = context.getSelection();
        Program program = context.getProgram();
        if (!(location instanceof CodeUnitLocation)) {
            return null;
        }
        Address start = location.getAddress();
        if (selection != null && !selection.isEmpty()) {
            start = selection.getMinAddress();
            if (selection.getInteriorSelection() != null) {
                location = selection.getInteriorSelection().getFrom();
            }
        }
        return DataPlugin.getDataUnit(program, start, location.getComponentPath());
    }

    static Data getDataUnit(Program program, Address start, int[] componentPath) {
        if (start == null) {
            return null;
        }
        Data data = program.getListing().getDataContaining(start);
        if (data == null) {
            return null;
        }
        if (data.getNumComponents() <= 0) {
            return data;
        }
        if (componentPath == null || componentPath.length <= 0) {
            return data;
        }
        Data compData = data.getComponent(componentPath);
        return compData == null ? data : compData;
    }

    @Override
    public boolean isCreateDataAllowed(ListingActionContext context) {
        ProgramLocation location = context.getLocation();
        if (!(location instanceof CodeUnitLocation)) {
            return false;
        }
        Data data = this.getDataUnit(context);
        if (data == null) {
            return false;
        }
        Data pdata = data.getParent();
        return pdata == null || !pdata.isArray();
    }
}

