/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.widgets.OptionDialog;
import docking.widgets.button.GRadioButton;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.fieldpanel.support.FieldSelection;
import docking.widgets.label.GDLabel;
import ghidra.app.plugin.core.compositeeditor.BitFieldPlacementComponent;
import ghidra.app.plugin.core.compositeeditor.CompEditorModel;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorModelAdapter;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorPanel;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeViewerModel;
import ghidra.app.plugin.core.compositeeditor.StructureEditorModel;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.layout.PairLayout;
import ghidra.util.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class CompEditorPanel
extends CompositeEditorPanel {
    private static final String NO_PACKING_STRING = "";
    protected static final Insets LEFT_INSETS = new Insets(2, 3, 1, 0);
    protected static final Insets VERTICAL_INSETS = new Insets(2, 0, 1, 0);
    protected GridBagLayout gridBagLayout;
    protected JPanel infoPanel;
    protected JLabel nameLabel;
    protected JTextField nameTextField;
    protected JLabel descriptionLabel;
    protected JTextField descriptionTextField;
    protected JLabel categoryLabel;
    protected JTextField categoryStatusTextField;
    protected JLabel sizeLabel;
    protected JTextField sizeStatusTextField;
    protected JCheckBox internalAlignmentCheckBox;
    protected JPanel minimumAlignmentPanel;
    protected JRadioButton defaultMinAlignButton;
    protected JRadioButton machineMinAlignButton;
    protected JRadioButton byValueMinAlignButton;
    protected JTextField minAlignValueTextField;
    protected JPanel packingPanel;
    protected JRadioButton noPackingButton;
    protected JRadioButton byValuePackingButton;
    protected JTextField packingValueTextField;
    protected JLabel actualAlignmentLabel;
    protected JTextField actualAlignmentValueTextField;
    private BitFieldPlacementComponent bitViewComponent;
    private DocumentListener fieldDocListener;
    private ActionListener fieldActionListener;
    private FocusListener fieldFocusListener;
    private boolean updatingSize;

    public CompEditorPanel(CompEditorModel model, CompositeEditorProvider provider) {
        super(model, provider);
        this.setInternallyAligned(model.viewComposite.isInternallyAligned());
    }

    @Override
    public void dispose() {
        this.removeFieldListeners();
        super.dispose();
    }

    @Override
    public void componentDataChanged() {
        this.refreshGUIActualAlignmentValue();
        this.setCompositeSize(this.model.getLength());
    }

    @Override
    public void compositeInfoChanged() {
        this.adjustCompositeInfo();
    }

    @Override
    protected void adjustCompositeInfo() {
        this.setCompositeName(this.model.getCompositeName());
        this.setDescription(this.model.getDescription());
        Category c = this.model.getOriginalCategory();
        if (c != null) {
            this.setCategoryName(c.toString());
        }
        this.setInternallyAligned(((CompEditorModel)this.model).isAligned());
        this.refreshGUIMinimumAlignmentType();
        this.refreshGUIMinimumAlignmentValue();
        this.refreshGUIActualAlignmentValue();
        this.setCompositeSize(this.model.getLength());
        this.refreshGUIPackingValue();
    }

    private void refreshGUIMinimumAlignmentType() {
        Composite.AlignmentType minimumAlignmentType = ((CompEditorModel)this.model).getMinimumAlignmentType();
        if (minimumAlignmentType == Composite.AlignmentType.DEFAULT_ALIGNED) {
            this.defaultMinAlignButton.setSelected(true);
        } else if (minimumAlignmentType == Composite.AlignmentType.MACHINE_ALIGNED) {
            this.machineMinAlignButton.setSelected(true);
        } else {
            this.byValueMinAlignButton.setSelected(true);
        }
    }

    @Override
    protected JPanel createBitViewerPanel() {
        this.bitViewComponent = new BitFieldPlacementComponent(this.model.viewComposite, false);
        this.model.addCompositeViewerModelListener(new CompositeEditorModelAdapter(){

            @Override
            public void selectionChanged() {
                this.update(false);
            }

            @Override
            public void componentDataChanged() {
                this.update(true);
            }

            private void update(boolean dataChanged) {
                Rectangle selectedRectangle;
                int length;
                if (!CompEditorPanel.this.model.isLoaded()) {
                    CompEditorPanel.this.bitViewComponent.setComposite(null);
                    return;
                }
                if (CompEditorPanel.this.bitViewComponent.getComposite() != CompEditorPanel.this.model.viewComposite) {
                    CompEditorPanel.this.bitViewComponent.setComposite(CompEditorPanel.this.model.viewComposite);
                }
                if ((length = CompEditorPanel.this.model.viewComposite.getLength()) != CompEditorPanel.this.bitViewComponent.getAllocationByteSize()) {
                    CompEditorPanel.this.bitViewComponent.updateAllocation(length, 0);
                }
                DataTypeComponent dtc = null;
                if (CompEditorPanel.this.model.isSingleComponentRowSelection()) {
                    dtc = CompEditorPanel.this.model.getComponent(CompEditorPanel.this.model.getSelectedRows()[0]);
                }
                if ((selectedRectangle = CompEditorPanel.this.bitViewComponent.getComponentRectangle(dtc)) != null) {
                    CompEditorPanel.this.bitViewComponent.scrollRectToVisible(selectedRectangle);
                    CompEditorPanel.this.validate();
                }
                CompEditorPanel.this.bitViewComponent.init(dtc);
            }
        });
        this.bitViewComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Point p = e.getPoint();
                BitFieldPlacementComponent.BitAttributes attrs = CompEditorPanel.this.bitViewComponent.getBitAttributes(p);
                if (attrs == null) {
                    return;
                }
                DataTypeComponent dtc = attrs.getDataTypeComponent(false);
                if (dtc != null) {
                    CompEditorPanel.this.model.setSelection(new int[]{dtc.getOrdinal()});
                    CompEditorPanel.this.table.scrollToSelectedRow();
                } else {
                    CompEditorPanel.this.model.setSelection(new FieldSelection());
                }
            }
        });
        JPanel bitViewPanel = new JPanel((LayoutManager)new PairLayout(0, 5));
        JPanel labelPanel = new JPanel((LayoutManager)new VerticalLayout(7));
        labelPanel.setBorder(BorderFactory.createEmptyBorder(7, 5, 0, 0));
        JLabel byteOffsetLabel = new JLabel("Byte Offset:", 4);
        labelPanel.add(byteOffsetLabel);
        labelPanel.add(new JLabel("Component Bits:", 4));
        bitViewPanel.add(labelPanel);
        JScrollPane bitViewScrollPane = new JScrollPane(this.bitViewComponent, 21, 30);
        bitViewScrollPane.getViewport().setBackground(this.getBackground());
        bitViewScrollPane.setBorder(null);
        Dimension bitViewerDefaultSize = new Dimension(800, this.bitViewComponent.getPreferredHeight());
        bitViewScrollPane.setPreferredSize(bitViewerDefaultSize);
        bitViewPanel.add(bitViewScrollPane);
        return bitViewPanel;
    }

    @Override
    protected JPanel createInfoPanel() {
        this.gridBagLayout = new GridBagLayout();
        this.infoPanel = new JPanel(this.gridBagLayout);
        this.setBorder(BEVELED_BORDER);
        this.setupName();
        this.setupDescription();
        this.setupCategory();
        this.setupSize();
        this.setupActualAlignment();
        this.setupInternallyAligned();
        this.setupMinimumAlignment();
        this.setupPacking();
        this.addFieldListeners();
        this.infoPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        return this.infoPanel;
    }

    private void setupName() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.nameLabel = new GDLabel("Name:");
        gridBagConstraints.insets = LEFT_INSETS;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.infoPanel.add((Component)this.nameLabel, gridBagConstraints);
        this.nameTextField = new JTextField(NO_PACKING_STRING);
        this.nameTextField.setToolTipText("Structure Name");
        this.nameTextField.setEditable(true);
        gridBagConstraints.insets = VERTICAL_INSETS;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        this.infoPanel.add((Component)this.nameTextField, gridBagConstraints);
        if (helpManager != null) {
            helpManager.registerHelp((Object)this.nameTextField, new HelpLocation(this.provider.getHelpTopic(), this.provider.getHelpName() + "_Name"));
        }
    }

    private void setupDescription() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.descriptionLabel = new GDLabel("Description:");
        gridBagConstraints.insets = LEFT_INSETS;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.infoPanel.add((Component)this.descriptionLabel, gridBagConstraints);
        this.descriptionTextField = new JTextField(NO_PACKING_STRING);
        this.descriptionTextField.setToolTipText("Structure Description");
        this.descriptionTextField.setEditable(true);
        gridBagConstraints.insets = VERTICAL_INSETS;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        this.infoPanel.add((Component)this.descriptionTextField, gridBagConstraints);
        if (helpManager != null) {
            helpManager.registerHelp((Object)this.descriptionTextField, new HelpLocation(this.provider.getHelpTopic(), this.provider.getHelpName() + "_Description"));
        }
    }

    private void setupCategory() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.categoryLabel = new GDLabel("Category:");
        gridBagConstraints.insets = LEFT_INSETS;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.infoPanel.add((Component)this.categoryLabel, gridBagConstraints);
        this.categoryStatusTextField = new JTextField(" ");
        this.categoryStatusTextField.setEditable(false);
        this.categoryStatusTextField.setToolTipText("Category of this composite data type.");
        gridBagConstraints.insets = VERTICAL_INSETS;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        this.infoPanel.add((Component)this.categoryStatusTextField, gridBagConstraints);
    }

    private void setupInternallyAligned() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.internalAlignmentCheckBox = new GCheckBox("Align");
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        this.internalAlignmentCheckBox.setSelected(this.model.viewComposite.isInternallyAligned());
        this.internalAlignmentCheckBox.setToolTipText("Whether or not the internal components of this structure are aligned.");
        this.internalAlignmentCheckBox.setEnabled(true);
        if (helpManager != null) {
            helpManager.registerHelp((Object)this.internalAlignmentCheckBox, new HelpLocation(this.provider.getHelpTopic(), this.provider.getHelpName() + "_InternallyAligned"));
        }
        this.internalAlignmentCheckBox.setName("Internally Aligned");
        this.internalAlignmentCheckBox.addItemListener(e -> this.adjustInternalAlignment());
        this.infoPanel.add((Component)this.internalAlignmentCheckBox, gridBagConstraints);
    }

    protected void adjustInternalAlignment() {
        boolean aligned = this.internalAlignmentCheckBox.isSelected();
        ((CompEditorModel)this.model).setAligned(aligned);
        if (aligned) {
            this.showMinimumAlignment();
        } else {
            this.hideMinimumAlignment();
        }
        this.packingValueTextField.setEditable(aligned);
        if (aligned) {
            this.showPacking();
        } else {
            this.hidePacking();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        if (this.minimumAlignmentPanel.isShowing()) {
            return preferredSize;
        }
        Dimension alignmentPanelPreferredSize = this.minimumAlignmentPanel.getPreferredSize();
        preferredSize.width += alignmentPanelPreferredSize.width;
        Dimension packingPanelPreferredSize = this.packingPanel.getPreferredSize();
        preferredSize.width += packingPanelPreferredSize.width;
        return preferredSize;
    }

    private void setupMinimumAlignment() {
        this.defaultMinAlignButton = new GRadioButton("none           ");
        this.machineMinAlignButton = new GRadioButton("machine      ");
        this.byValueMinAlignButton = new GRadioButton();
        this.minAlignValueTextField = new JTextField();
        this.setupDefaultMinAlignButton();
        this.setupMachineMinAlignButton();
        this.setupByValueMinAlignButton();
        ButtonGroup minAlignGroup = new ButtonGroup();
        minAlignGroup.add(this.defaultMinAlignButton);
        minAlignGroup.add(this.machineMinAlignButton);
        minAlignGroup.add(this.byValueMinAlignButton);
        this.refreshGUIMinimumAlignmentType();
        this.minimumAlignmentPanel = new JPanel(new GridBagLayout());
        this.minimumAlignmentPanel.setBorder(BorderFactory.createTitledBorder("align( minimum )"));
        if (helpManager != null) {
            helpManager.registerHelp((Object)this.minimumAlignmentPanel, new HelpLocation(this.provider.getHelpTopic(), this.provider.getHelpName() + "_AlignMinimum"));
        }
        String alignmentToolTip = "<HTML>The minimum alignment to be used when<BR>aligning this data type inside another data type.<BR><BR>Align this data type <BR>... in the <B>default</B> way based only on its components with <B>no</B> minimum,<BR>... to a multiple of the <B>machine</B> alignment,<BR>... to a multiple of the <B>specified value</B> in the text field.</HTML>";
        this.minimumAlignmentPanel.setToolTipText(alignmentToolTip);
        this.addMinimumAlignmentComponents();
    }

    private void addMinimumAlignmentComponents() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        this.minimumAlignmentPanel.add((Component)this.defaultMinAlignButton, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        this.minimumAlignmentPanel.add((Component)this.machineMinAlignButton, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        this.minimumAlignmentPanel.add((Component)this.byValueMinAlignButton, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        this.minimumAlignmentPanel.add((Component)this.minAlignValueTextField, gridBagConstraints);
    }

    private void setupDefaultMinAlignButton() {
        this.defaultMinAlignButton.setName("Default Minimum Alignment");
        String alignmentToolTip = "<HTML>Sets this data type to have <B>no</B> minimum alignment<BR>when aligning this data type inside another data type.<BR>Align this data type based only on its components.</HTML>";
        this.defaultMinAlignButton.setToolTipText(alignmentToolTip);
        if (helpManager != null) {
            helpManager.registerHelp((Object)this.defaultMinAlignButton, new HelpLocation(this.provider.getHelpTopic(), this.provider.getHelpName() + "_AlignMinimum"));
        }
    }

    private void setupMachineMinAlignButton() {
        this.machineMinAlignButton.setName("Machine Minimum Alignment");
        String alignmentToolTip = "<HTML>Sets this data type to have a minimum alignment<BR>that is a multiple of the <B>machine</B> alignment<BR>when aligning this data type inside another data type.</HTML>";
        this.machineMinAlignButton.setToolTipText(alignmentToolTip);
        if (helpManager != null) {
            helpManager.registerHelp((Object)this.machineMinAlignButton, new HelpLocation(this.provider.getHelpTopic(), this.provider.getHelpName() + "_AlignMinimum"));
        }
    }

    private void setupByValueMinAlignButton() {
        this.byValueMinAlignButton.setName("By Value Minimum Alignment");
        String alignmentToolTip = "<HTML>Sets this data type to have a minimum alignment<BR>that is a multiple of the <B>specified value</B><BR>when aligning this data type inside another data type.</HTML>";
        this.byValueMinAlignButton.setToolTipText(alignmentToolTip);
        if (helpManager != null) {
            helpManager.registerHelp((Object)this.byValueMinAlignButton, new HelpLocation(this.provider.getHelpTopic(), this.provider.getHelpName() + "_AlignMinimum"));
        }
        this.minAlignValueTextField.setName("Minimum Alignment Value");
        this.minAlignValueTextField.setEditable(true);
        this.minAlignValueTextField.setToolTipText(alignmentToolTip);
        if (helpManager != null) {
            helpManager.registerHelp((Object)this.minAlignValueTextField, new HelpLocation(this.provider.getHelpTopic(), this.provider.getHelpName() + "_AlignMinimum"));
        }
        this.refreshGUIMinimumAlignmentValue();
    }

    private void showMinimumAlignment() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 4;
        this.infoPanel.add((Component)this.minimumAlignmentPanel, gridBagConstraints);
        this.infoPanel.invalidate();
        this.validate();
    }

    private void hideMinimumAlignment() {
        this.infoPanel.remove(this.minimumAlignmentPanel);
        this.infoPanel.invalidate();
        this.validate();
    }

    protected void adjustMinimumAlignmentValue() {
        String value = this.minAlignValueTextField.getText();
        try {
            int minAlignment = Integer.decode(value);
            try {
                ((CompEditorModel)this.model).setAlignment(minAlignment);
                this.adjustCompositeInfo();
            }
            catch (InvalidInputException e1) {
                this.refreshGUIMinimumAlignmentValue();
                String message = "\"" + value + "\" is not a valid minimum alignment value.";
                this.setStatus(message);
            }
        }
        catch (NumberFormatException e1) {
            this.refreshGUIMinimumAlignmentValue();
            String message = "\"" + value + "\" is not a valid minimum alignment value.";
            this.setStatus(message);
        }
    }

    private void setupActualAlignment() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        String actualAlignmentToolTip = "<HTML>The actual alignment to be used when<BR>aligning this data type inside another data type.</HTML>";
        JPanel actualAlignmentPanel = new JPanel(new BorderLayout());
        this.actualAlignmentLabel = new GDLabel("Alignment:");
        gridBagConstraints.insets = new Insets(2, 7, 2, 2);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        this.actualAlignmentLabel.setToolTipText(actualAlignmentToolTip);
        actualAlignmentPanel.add((Component)this.actualAlignmentLabel, "East");
        this.infoPanel.add((Component)actualAlignmentPanel, gridBagConstraints);
        this.actualAlignmentValueTextField = new JTextField(8);
        this.actualAlignmentValueTextField.setText(NO_PACKING_STRING + ((CompEditorModel)this.model).getMinimumAlignment());
        this.actualAlignmentValueTextField.setToolTipText(actualAlignmentToolTip);
        this.actualAlignmentValueTextField.setEditable(false);
        if (helpManager != null) {
            helpManager.registerHelp((Object)this.actualAlignmentValueTextField, new HelpLocation(this.provider.getHelpTopic(), this.provider.getHelpName() + "_ActualAlignment"));
        }
        this.actualAlignmentValueTextField.setName("Actual Alignment Value");
        gridBagConstraints.insets = VERTICAL_INSETS;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        this.infoPanel.add((Component)this.actualAlignmentValueTextField, gridBagConstraints);
    }

    private void setupPacking() {
        this.noPackingButton = new GRadioButton("none           ");
        this.byValuePackingButton = new GRadioButton();
        this.packingValueTextField = new JTextField();
        this.setupNoPackingButton();
        this.setupByValuePackingButton();
        ButtonGroup packingGroup = new ButtonGroup();
        packingGroup.add(this.noPackingButton);
        packingGroup.add(this.byValuePackingButton);
        this.packingPanel = new JPanel(new GridBagLayout());
        this.packingPanel.setBorder(BorderFactory.createTitledBorder("pack( maximum )"));
        if (helpManager != null) {
            helpManager.registerHelp((Object)this.packingPanel, new HelpLocation(this.provider.getHelpTopic(), this.provider.getHelpName() + "_PackMaximum"));
        }
        String packingToolTipText = "<HTML>\"none\" indicates components are not being packed.<BR>Otherwise, the value indicates the maximum alignment to use when packing any component.<BR>Note: An individual data type's alignment may override this value.</HTML>";
        this.packingPanel.setToolTipText(packingToolTipText);
        this.addPackingComponents();
        this.refreshGUIPackingValue();
    }

    private void addPackingComponents() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        this.packingPanel.add((Component)this.noPackingButton, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        this.packingPanel.add((Component)this.byValuePackingButton, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        this.packingPanel.add((Component)this.packingValueTextField, gridBagConstraints);
    }

    private void setupNoPackingButton() {
        this.noPackingButton.setName("No Packing");
        String packingToolTipText = "<HTML>\"none\" indicates components are not being packed.<BR>Otherwise, the value indicates the maximum alignment to use when packing any component.<BR>Note: An individual data type's alignment may override this value.</HTML>";
        this.noPackingButton.addActionListener(e -> ((CompEditorModel)this.model).setPackingValue(0));
        this.noPackingButton.setToolTipText(packingToolTipText);
        if (helpManager != null) {
            helpManager.registerHelp((Object)this.noPackingButton, new HelpLocation(this.provider.getHelpTopic(), this.provider.getHelpName() + "_PackMaximum"));
        }
    }

    private void setupByValuePackingButton() {
        this.byValuePackingButton.setName("By Value Packing");
        String packingToolTipText = "<HTML>\"none\" indicates components are not being packed.<BR>Otherwise, the value indicates the maximum alignment to use when packing any component.<BR>Note: An individual data type's alignment may override this value.</HTML>";
        this.byValuePackingButton.addActionListener(e -> this.chooseByValuePacking());
        this.byValuePackingButton.setToolTipText(packingToolTipText);
        if (helpManager != null) {
            helpManager.registerHelp((Object)this.byValuePackingButton, new HelpLocation(this.provider.getHelpTopic(), this.provider.getHelpName() + "_PackMaximum"));
        }
        this.packingValueTextField.setName("Packing Value");
        this.packingValueTextField.setEditable(true);
        this.packingValueTextField.addActionListener(e -> this.adjustPackingValue());
        this.packingValueTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (CompEditorPanel.this.byValuePackingButton.isSelected()) {
                    return;
                }
                CompEditorPanel.this.byValuePackingButton.setSelected(true);
                CompEditorPanel.this.chooseByValuePacking();
            }

            @Override
            public void focusLost(FocusEvent e) {
                CompEditorPanel.this.adjustPackingValue();
            }
        });
        this.packingValueTextField.setToolTipText(packingToolTipText);
        if (helpManager != null) {
            helpManager.registerHelp((Object)this.packingValueTextField, new HelpLocation(this.provider.getHelpTopic(), this.provider.getHelpName() + "_PackMaximum"));
        }
    }

    protected void chooseByValuePacking() {
        ((CompEditorModel)this.model).setPackingValue(1);
        this.packingValueTextField.selectAll();
        this.packingValueTextField.requestFocus();
    }

    protected void adjustPackingValue() {
        if (!this.packingValueTextField.isShowing()) {
            return;
        }
        String value = this.packingValueTextField.getText();
        try {
            int packingAlignment = 0;
            if (!value.toLowerCase().equals(NO_PACKING_STRING)) {
                packingAlignment = Integer.decode(value);
            }
            ((CompEditorModel)this.model).setPackingValue(packingAlignment);
            this.adjustCompositeInfo();
        }
        catch (NumberFormatException e1) {
            this.refreshGUIPackingValue();
            this.setStatus(value + " is not a valid packing value.");
        }
    }

    private void showPacking() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 4;
        this.infoPanel.add((Component)this.packingPanel, gridBagConstraints);
        this.infoPanel.invalidate();
        this.validate();
    }

    private void hidePacking() {
        this.infoPanel.remove(this.packingPanel);
        this.infoPanel.invalidate();
        this.validate();
    }

    public void refreshGUIPackingValue() {
        boolean isPacking;
        int packingValue = ((CompEditorModel)this.model).getPackingValue();
        boolean bl = isPacking = packingValue != 0;
        if (isPacking) {
            this.byValuePackingButton.setSelected(true);
        } else {
            this.noPackingButton.setSelected(true);
        }
        String packingString = isPacking ? (this.model.showHexNumbers ? CompositeViewerModel.getHexString(packingValue, true) : Integer.toString(packingValue)) : NO_PACKING_STRING;
        this.packingValueTextField.setText(packingString);
    }

    protected void setupSize() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.sizeLabel = new GDLabel("Size:");
        this.sizeLabel.setToolTipText("The current size in bytes.");
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.infoPanel.add((Component)this.sizeLabel, gridBagConstraints);
        this.sizeStatusTextField = new JTextField(10);
        this.sizeStatusTextField.setName("Total Length");
        this.sizeStatusTextField.setEditable(false);
        this.sizeStatusTextField.setToolTipText("The current size in bytes.");
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        this.infoPanel.add((Component)this.sizeStatusTextField, gridBagConstraints);
        this.sizeStatusTextField.addActionListener(e -> this.updatedStructureSize());
        this.sizeStatusTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (CompEditorPanel.this.sizeStatusTextField.isEditable()) {
                    CompEditorPanel.this.updatedStructureSize();
                }
            }
        });
    }

    protected void setSizeEditable(boolean editable) {
        this.sizeStatusTextField.setEditable(editable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatedStructureSize() {
        if (this.updatingSize) {
            return;
        }
        if (!this.sizeStatusTextField.isShowing()) {
            return;
        }
        if (!((CompEditorModel)this.model).isSizeEditable()) {
            return;
        }
        String valueStr = this.sizeStatusTextField.getText();
        try {
            this.updatingSize = true;
            Integer value = Integer.decode(valueStr);
            int structureSize = value;
            if (structureSize < 0) {
                this.model.setStatus("Structure size cannot be negative.", true);
            } else {
                if (structureSize < this.model.getLength()) {
                    String question = "The size field was changed to " + structureSize + " bytes.\nDo you really want to truncate " + this.model.getCompositeName() + "?";
                    String title = "Truncate " + this.model.getTypeName() + " In Editor?";
                    int response = OptionDialog.showYesNoDialogWithNoAsDefaultButton((Component)this, (String)title, (String)question);
                    if (response != 1) {
                        this.compositeInfoChanged();
                        return;
                    }
                }
                ((StructureEditorModel)this.model).setStructureSize(structureSize);
            }
        }
        catch (NumberFormatException e1) {
            this.model.setStatus("Invalid structure size \"" + valueStr + "\".", true);
        }
        finally {
            this.updatingSize = false;
        }
        this.compositeInfoChanged();
    }

    private void addFieldListeners() {
        this.fieldDocListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changed(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changed(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.changed(e);
            }

            private void changed(DocumentEvent e) {
                Document doc = e.getDocument();
                if (doc.equals(CompEditorPanel.this.nameTextField.getDocument())) {
                    CompEditorPanel.this.model.clearStatus();
                    String name = CompEditorPanel.this.nameTextField.getText().trim();
                    if (name.length() == 0) {
                        return;
                    }
                    try {
                        CompEditorPanel.this.model.setName(name);
                    }
                    catch (DuplicateNameException dne) {
                        CompEditorPanel.this.model.setStatus("A data type named " + name + " already exists.");
                    }
                    catch (InvalidNameException ine) {
                        CompEditorPanel.this.model.setStatus(name + " is not a valid name.");
                    }
                } else if (doc.equals(CompEditorPanel.this.descriptionTextField.getDocument())) {
                    CompEditorPanel.this.model.clearStatus();
                    CompEditorPanel.this.model.setDescription(CompEditorPanel.this.descriptionTextField.getText().trim());
                }
            }
        };
        this.nameTextField.getDocument().addDocumentListener(this.fieldDocListener);
        this.descriptionTextField.getDocument().addDocumentListener(this.fieldDocListener);
        this.fieldActionListener = e -> {
            Object source = e.getSource();
            if (source == this.nameTextField) {
                this.updatedName();
            } else if (source == this.descriptionTextField) {
                this.updatedDescription();
            } else if (source == this.defaultMinAlignButton) {
                this.chooseDefaultMinAlign();
            } else if (source == this.machineMinAlignButton) {
                this.chooseMachineMinAlign();
            } else if (source == this.byValueMinAlignButton) {
                this.chooseByValueMinAlign();
            } else if (source == this.minAlignValueTextField) {
                this.updatedMinAlignValue();
            }
        };
        this.nameTextField.addActionListener(this.fieldActionListener);
        this.descriptionTextField.addActionListener(this.fieldActionListener);
        this.defaultMinAlignButton.addActionListener(this.fieldActionListener);
        this.machineMinAlignButton.addActionListener(this.fieldActionListener);
        this.byValueMinAlignButton.addActionListener(this.fieldActionListener);
        this.minAlignValueTextField.addActionListener(this.fieldActionListener);
        this.fieldFocusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                Object source = e.getSource();
                if (source == CompEditorPanel.this.minAlignValueTextField) {
                    if (CompEditorPanel.this.byValueMinAlignButton.isSelected()) {
                        return;
                    }
                    CompEditorPanel.this.byValueMinAlignButton.setSelected(true);
                    CompEditorPanel.this.chooseByValueMinAlign();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                Object source = e.getSource();
                if (source == CompEditorPanel.this.nameTextField) {
                    CompEditorPanel.this.updatedName();
                } else if (source == CompEditorPanel.this.descriptionTextField) {
                    CompEditorPanel.this.updatedDescription();
                } else if (source == CompEditorPanel.this.minAlignValueTextField) {
                    CompEditorPanel.this.updatedMinAlignValue();
                }
            }
        };
        this.nameTextField.addFocusListener(this.fieldFocusListener);
        this.descriptionTextField.addFocusListener(this.fieldFocusListener);
        this.minAlignValueTextField.addFocusListener(this.fieldFocusListener);
    }

    protected void chooseDefaultMinAlign() {
        ((CompEditorModel)this.model).setAlignmentType(Composite.AlignmentType.DEFAULT_ALIGNED);
    }

    protected void chooseMachineMinAlign() {
        ((CompEditorModel)this.model).setAlignmentType(Composite.AlignmentType.MACHINE_ALIGNED);
    }

    protected void chooseByValueMinAlign() {
        ((CompEditorModel)this.model).setAlignmentType(Composite.AlignmentType.ALIGNED_BY_VALUE);
        this.minAlignValueTextField.selectAll();
        this.minAlignValueTextField.requestFocus();
    }

    protected void updatedMinAlignValue() {
        this.adjustMinimumAlignmentValue();
    }

    private void removeFieldListeners() {
        this.nameTextField.getDocument().removeDocumentListener(this.fieldDocListener);
        this.nameTextField.removeActionListener(this.fieldActionListener);
        this.nameTextField.removeFocusListener(this.fieldFocusListener);
        this.descriptionTextField.getDocument().removeDocumentListener(this.fieldDocListener);
        this.descriptionTextField.removeActionListener(this.fieldActionListener);
        this.descriptionTextField.removeFocusListener(this.fieldFocusListener);
        this.defaultMinAlignButton.addActionListener(this.fieldActionListener);
        this.machineMinAlignButton.addActionListener(this.fieldActionListener);
        this.byValueMinAlignButton.addActionListener(this.fieldActionListener);
        this.minAlignValueTextField.addActionListener(this.fieldActionListener);
        this.minAlignValueTextField.removeFocusListener(this.fieldFocusListener);
    }

    protected void updatedName() {
        if (!this.nameTextField.isShowing()) {
            return;
        }
        String nameText = this.nameTextField.getText();
        String newName = nameText.trim();
        if (!DataUtilities.isValidDataTypeName((String)newName)) {
            if (newName.length() == 0) {
                this.model.setStatus("Name is required.");
            } else {
                this.model.setStatus(newName + " is not a valid name.");
            }
            return;
        }
        String originalDtName = this.model.getOriginalDataTypeName();
        if (!newName.equals(originalDtName) && newName.length() == 0) {
            this.nameTextField.setText(originalDtName);
            this.model.setStatus("Name is required. So original name has been restored.");
            return;
        }
        if (!newName.equals(nameText)) {
            this.nameTextField.setText(newName);
        }
        if (!newName.equals(this.model.getCompositeName())) {
            try {
                this.model.setName(newName);
            }
            catch (DuplicateNameException e) {
                this.model.setStatus("Can't duplicate name \"" + newName + "\".");
            }
            catch (InvalidNameException e) {
                this.model.setStatus("\"" + newName + "\" isn't a valid name.");
            }
        }
    }

    protected void updatedDescription() {
        if (!this.descriptionTextField.isShowing()) {
            return;
        }
        String newValue = this.descriptionTextField.getText().trim();
        if (!newValue.equals(this.model.getDescription())) {
            this.model.setDescription(newValue);
        }
    }

    public String getCategoryName() {
        return this.categoryStatusTextField.getText();
    }

    public void setCategoryName(String name) {
        this.categoryStatusTextField.setText(name);
    }

    public String getCompositeName() {
        return this.nameTextField.getText().trim();
    }

    public void setCompositeName(String name) {
        String original = this.getCompositeName();
        if (name.equals(original)) {
            return;
        }
        Document doc = this.nameTextField.getDocument();
        doc.removeDocumentListener(this.fieldDocListener);
        this.nameTextField.setText(name);
        doc.addDocumentListener(this.fieldDocListener);
    }

    public String getDescription() {
        return this.descriptionTextField.getText().trim();
    }

    public void setDescription(String description) {
        this.descriptionTextField.setText(description);
    }

    public boolean isInternallyAlignedInGui() {
        return this.internalAlignmentCheckBox.isSelected();
    }

    public void setInternallyAligned(boolean aligned) {
        boolean alignedInGui = this.internalAlignmentCheckBox.isSelected();
        if (alignedInGui != aligned) {
            this.internalAlignmentCheckBox.setSelected(aligned);
        }
        this.adjustInternalAlignment();
    }

    public void refreshGUIMinimumAlignmentValue() {
        boolean notByValue;
        int minimumAlignment = ((CompEditorModel)this.model).getMinimumAlignment();
        String value = this.minAlignValueTextField.getText();
        boolean emptyValue = value.length() == 0;
        boolean bl = notByValue = ((CompEditorModel)this.model).viewComposite.isDefaultAligned() || ((CompEditorModel)this.model).viewComposite.isMachineAligned();
        if (notByValue) {
            if (!emptyValue) {
                this.minAlignValueTextField.setText(NO_PACKING_STRING);
            }
            return;
        }
        String minimumAlignmentStr = this.model.showHexNumbers ? CompositeViewerModel.getHexString(minimumAlignment, true) : Integer.toString(minimumAlignment);
        this.minAlignValueTextField.setText(minimumAlignmentStr);
    }

    public void refreshGUIActualAlignmentValue() {
        int actualAlignment = ((CompEditorModel)this.model).viewDTM.getDataOrganization().getAlignment((DataType)((CompEditorModel)this.model).viewComposite, ((CompEditorModel)this.model).getLength());
        String alignmentStr = this.model.showHexNumbers ? CompositeViewerModel.getHexString(actualAlignment, true) : Integer.toString(actualAlignment);
        this.actualAlignmentValueTextField.setText(alignmentStr);
    }

    public int getCompositeSize() {
        return Integer.decode(this.sizeStatusTextField.getText());
    }

    public void setCompositeSize(int size) {
        boolean sizeIsEditable = ((CompEditorModel)this.model).isSizeEditable();
        if (this.sizeStatusTextField.isEditable() != sizeIsEditable) {
            this.sizeStatusTextField.setEditable(sizeIsEditable);
        }
        String sizeStr = this.model.showHexNumbers ? CompositeViewerModel.getHexString(size, true) : Integer.toString(size);
        this.sizeStatusTextField.setText(sizeStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dragUnderFeedback(boolean ok, DropTargetDragEvent e) {
        CompositeEditorPanel.CompositeTable compositeTable = this.table;
        synchronized (compositeTable) {
            int dropAction = e.getDropAction();
            boolean actionChanged = false;
            if (dropAction != this.lastDndAction) {
                actionChanged = true;
                this.lastDndAction = dropAction;
            }
            if (this.table.isEditing()) {
                this.table.editingCanceled(null);
            }
            boolean inserting = false;
            if (dropAction == 1) {
                inserting = true;
            }
            this.dndTableCellRenderer.selectRange(inserting);
            this.dndDtiCellRenderer.selectRange(inserting);
            Point p = e.getLocation();
            int row = this.table.rowAtPoint(p);
            boolean setRow = this.dndTableCellRenderer.setRowForFeedback(row);
            boolean setDtiRow = this.dndDtiCellRenderer.setRowForFeedback(row);
            if (actionChanged || setRow || setDtiRow) {
                this.table.repaint();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undoDragUnderFeedback() {
        CompositeEditorPanel.CompositeTable compositeTable = this.table;
        synchronized (compositeTable) {
            this.dndTableCellRenderer.setRowForFeedback(-1);
            this.dndDtiCellRenderer.setRowForFeedback(-1);
            this.table.repaint();
        }
    }

    @Override
    public void showUndefinedStateChanged(boolean showUndefinedBytes) {
    }
}

