/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.comments;

import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.cmd.comments.SetCommentCmd;
import ghidra.app.cmd.comments.SetCommentsCmd;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.comments.CommentHistoryDialog;
import ghidra.app.plugin.core.comments.CommentsActionFactory;
import ghidra.app.plugin.core.comments.CommentsDialog;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Program;
import ghidra.program.util.CommentFieldLocation;
import ghidra.program.util.CommentType;
import ghidra.program.util.FunctionRepeatableCommentFieldLocation;
import ghidra.program.util.PlateFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Add/edit comments", description="Provides actions for adding, editing and removing all types of comments (EOL, POST, PRE, PLATE).")
public class CommentsPlugin
extends Plugin
implements OptionsChangeListener {
    private static final String[] DELETE_MENUPATH = new String[]{"Comments", "Delete"};
    private static final String[] HISTORY_MENUPATH = new String[]{"Comments", "Show History..."};
    private static final String OPTION_NAME = "Enter accepts comment";
    private DockingAction editAction;
    private DockingAction deleteAction;
    private DockingAction historyAction;
    private CommentsDialog dialog = new CommentsDialog(this);
    private CommentHistoryDialog historyDialog;
    private DockingAction preCommentEditAction;
    private DockingAction postCommentEditAction;
    private DockingAction plateCommentEditAction;
    private DockingAction eolCommentEditAction;
    private DockingAction repeatableCommentEditAction;

    public CommentsPlugin(PluginTool tool) {
        super(tool);
        this.createActions();
        this.initializeOptions(tool.getOptions("Comments"));
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        this.setOptions((Options)options);
    }

    private void initializeOptions(ToolOptions options) {
        HelpLocation helpLocation = new HelpLocation(this.getName(), "Comments_Option");
        options.setOptionsHelpLocation(helpLocation);
        options.registerOption(OPTION_NAME, (Object)this.dialog.getEnterMode(), helpLocation, "Toggle for whether pressing the <Enter> key causes the comment to be entered, versus adding a new line character in the comment.");
        this.setOptions((Options)options);
        options.addOptionsChangeListener((OptionsChangeListener)this);
    }

    private void setOptions(Options options) {
        this.dialog.setEnterMode(options.getBoolean(OPTION_NAME, this.dialog.getEnterMode()));
    }

    public void updateOptions() {
        ToolOptions options = this.tool.getOptions("Comments");
        options.setBoolean(OPTION_NAME, this.dialog.getEnterMode());
    }

    void updateComments(CodeUnit cu, String preComment, String postComment, String eolComment, String plateComment, String repeatableComment) {
        preComment = preComment.length() == 0 ? null : preComment;
        postComment = postComment.length() == 0 ? null : postComment;
        eolComment = eolComment.length() == 0 ? null : eolComment;
        plateComment = plateComment.length() == 0 ? null : plateComment;
        repeatableComment = repeatableComment.length() == 0 ? null : repeatableComment;
        SetCommentsCmd cmd = new SetCommentsCmd(cu.getMinAddress(), preComment, postComment, eolComment, plateComment, repeatableComment);
        this.tool.execute((Command)cmd, (DomainObject)cu.getProgram());
    }

    void deleteComments(Program program, ProgramLocation loc) {
        int commentType = CommentType.getCommentType(null, (ProgramLocation)loc, (int)0);
        SetCommentCmd cmd = new SetCommentCmd(loc.getByteAddress(), commentType, null);
        this.tool.execute((Command)cmd, (DomainObject)program);
    }

    private boolean hasComment(CodeUnit codeUnit, ProgramLocation loc) {
        if (codeUnit == null) {
            return false;
        }
        int commentType = CommentType.getCommentType(null, (ProgramLocation)loc, (int)-1);
        return commentType != -1 && codeUnit.getComment(commentType) != null;
    }

    private void createActions() {
        String pluginName = this.getName();
        this.editAction = CommentsActionFactory.getEditCommentsAction(this.dialog, this.name);
        this.tool.addAction((DockingActionIf)this.editAction);
        this.preCommentEditAction = CommentsActionFactory.getSetCommentsAction(this.dialog, this.name, "Set Pre Comment", 1);
        this.tool.addAction((DockingActionIf)this.preCommentEditAction);
        this.postCommentEditAction = CommentsActionFactory.getSetCommentsAction(this.dialog, this.name, "Set Post Comment", 2);
        this.tool.addAction((DockingActionIf)this.postCommentEditAction);
        this.plateCommentEditAction = CommentsActionFactory.getSetCommentsAction(this.dialog, this.name, "Set Plate Comment", 3);
        this.tool.addAction((DockingActionIf)this.plateCommentEditAction);
        this.eolCommentEditAction = CommentsActionFactory.getSetCommentsAction(this.dialog, this.name, "Set EOL Comment", 0);
        this.tool.addAction((DockingActionIf)this.eolCommentEditAction);
        this.repeatableCommentEditAction = CommentsActionFactory.getSetCommentsAction(this.dialog, this.name, "Set Repeatable Comment", 4);
        this.tool.addAction((DockingActionIf)this.repeatableCommentEditAction);
        this.deleteAction = new ListingContextAction("Delete Comments", pluginName){

            @Override
            protected void actionPerformed(ListingActionContext context) {
                CommentsPlugin.this.deleteComments(context.getProgram(), context.getLocation());
            }

            @Override
            public boolean isEnabledForContext(ListingActionContext context) {
                ProgramLocation loc = context.getLocation();
                if (!CommentsActionFactory.isCommentSupported(loc)) {
                    return false;
                }
                if (loc instanceof CommentFieldLocation || loc instanceof FunctionRepeatableCommentFieldLocation) {
                    CommentsPlugin.this.updatePopupPath(CommentsPlugin.this.deleteAction, "Delete", loc);
                    return CommentsPlugin.this.hasComment(context.getCodeUnit(), loc);
                }
                this.getPopupMenuData().setMenuPath(new String[]{"Comments", "Delete"});
                return false;
            }
        };
        this.deleteAction.setPopupMenuData(new MenuData(DELETE_MENUPATH, null, "comments"));
        this.deleteAction.setKeyBindingData(new KeyBindingData(127, 0));
        this.tool.addAction((DockingActionIf)this.deleteAction);
        this.historyAction = new ListingContextAction("Show Comment History", pluginName){

            @Override
            protected void actionPerformed(ListingActionContext context) {
                CommentsPlugin.this.showCommentHistory(context);
            }

            @Override
            public boolean isEnabledForContext(ListingActionContext context) {
                ProgramLocation loc = context.getLocation();
                if (!CommentsActionFactory.isCommentSupported(loc)) {
                    return false;
                }
                if (loc instanceof CommentFieldLocation || loc instanceof FunctionRepeatableCommentFieldLocation) {
                    CommentsPlugin.this.updatePopupPath(CommentsPlugin.this.historyAction, "Show History for", loc);
                } else {
                    CommentsPlugin.this.historyAction.getPopupMenuData().setMenuPath(HISTORY_MENUPATH);
                }
                CommentsPlugin.this.historyAction.setEnabled(CommentType.isCommentAllowed((CodeUnit)context.getCodeUnit(), (ProgramLocation)loc));
                return true;
            }
        };
        this.historyAction.setPopupMenuData(new MenuData(HISTORY_MENUPATH, null, "comments"));
        this.tool.addAction((DockingActionIf)this.historyAction);
    }

    private void showCommentHistory(ListingActionContext context) {
        CodeUnit cu = context.getCodeUnit();
        ProgramLocation loc = context.getLocation();
        if (this.historyDialog == null) {
            this.historyDialog = new CommentHistoryDialog();
        }
        this.historyDialog.showDialog(cu, CommentType.getCommentType(null, (ProgramLocation)loc, (int)0), this.tool, context);
    }

    private void updatePopupPath(DockingAction action, String actionString, ProgramLocation loc) {
        String endString = "";
        if (action == this.historyAction) {
            endString = "...";
        }
        if (loc instanceof FunctionRepeatableCommentFieldLocation) {
            action.getPopupMenuData().setMenuPath(new String[]{"Comments", actionString + " Repeatable Comment" + endString});
            return;
        }
        if (loc instanceof PlateFieldLocation) {
            action.getPopupMenuData().setMenuPath(new String[]{"Comments", actionString + " Plate Comment" + endString});
            return;
        }
        CommentFieldLocation cfLoc = (CommentFieldLocation)loc;
        int type = cfLoc.getCommentType();
        switch (type) {
            case 1: {
                action.getPopupMenuData().setMenuPath(new String[]{"Comments", actionString + " Pre-Comment" + endString});
                break;
            }
            case 2: {
                action.getPopupMenuData().setMenuPath(new String[]{"Comments", actionString + " Post-Comment" + endString});
                break;
            }
            case 0: {
                action.getPopupMenuData().setMenuPath(new String[]{"Comments", actionString + " EOL Comment" + endString});
                break;
            }
            case 4: {
                action.getPopupMenuData().setMenuPath(new String[]{"Comments", actionString + " Repeatable Comment" + endString});
            }
        }
    }
}

