/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.clear;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.clear.ClearCmd;
import ghidra.app.plugin.core.clear.ClearDialog;
import ghidra.app.plugin.core.clear.ClearFlowAndRepairCmd;
import ghidra.app.plugin.core.clear.ClearFlowDialog;
import ghidra.app.plugin.core.clear.ClearOptions;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.Union;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.util.CodeUnitLocation;
import ghidra.program.util.InteriorSelection;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Clear Code and Program Annotations", description="This plugin clears instructions and provides options to clear other program annotations, such as comments, labels, etc.")
public class ClearPlugin
extends Plugin {
    private static final String CLEAR_CODE_BYTES_NAME = "Clear Code Bytes";
    private static final String CLEAR_FLOW_AND_REPAIR = "Clear Flow and Repair";
    private DockingAction clearAllAction;
    private DockingAction clearAction;
    private DockingAction clearAndRepairAction;
    private ClearDialog clearDialog;
    private ClearFlowDialog clearFlowDialog;

    public ClearPlugin(PluginTool tool) {
        super(tool);
        this.createActions();
    }

    void clearFlowAndRepair(ListingActionContext context, boolean clearSymbols, boolean clearData, boolean repair) {
        ProgramSelection selection = context.getSelection();
        ProgramLocation location = context.getLocation();
        ClearFlowAndRepairCmd cmd = selection == null || selection.isEmpty() ? new ClearFlowAndRepairCmd(location.getAddress(), clearData, clearSymbols, repair) : new ClearFlowAndRepairCmd(selection, clearData, clearSymbols, repair);
        this.tool.executeBackgroundCommand((BackgroundCommand)cmd, (UndoableDomainObject)context.getProgram());
    }

    void clear(ClearOptions options, ListingActionContext context) {
        if (!options.clearAny()) {
            return;
        }
        if (!this.scheduleClear(options, context)) {
            return;
        }
        AddressSet set = new AddressSet((AddressSetView)context.getSelection());
        ClearCmd cmd = new ClearCmd((AddressSetView)set, options);
        this.tool.executeBackgroundCommand((BackgroundCommand)cmd, (UndoableDomainObject)context.getProgram());
    }

    private boolean scheduleClear(ClearOptions options, ListingActionContext context) {
        ProgramSelection selection = context.getSelection();
        ProgramLocation location = context.getLocation();
        Program program = context.getProgram();
        if (selection == null || selection.isEmpty()) {
            this.clearWhenNoSelection(options, location, program);
            return false;
        }
        InteriorSelection interSel = selection.getInteriorSelection();
        if (interSel != null) {
            this.clearStructure(program, interSel.getFrom(), interSel.getTo());
            return false;
        }
        return true;
    }

    private void clearWhenNoSelection(ClearOptions options, ProgramLocation location, Program program) {
        if (location == null) {
            return;
        }
        int[] compPath = location.getComponentPath();
        if (compPath != null && compPath.length > 0) {
            this.clearStructure(program, location, null);
            return;
        }
        CodeUnit cu = program.getListing().getCodeUnitContaining(location.getAddress());
        ClearCmd cmd = new ClearCmd(cu, options);
        this.tool.execute((Command)cmd, (DomainObject)program);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean clearStructure(Program program, ProgramLocation start, ProgramLocation end) {
        boolean commit = false;
        int id = program.startTransaction("Clear Structure");
        try {
            Address dataAddr = start.getByteAddress();
            Data data = program.getListing().getDefinedDataContaining(dataAddr);
            if (data == null) {
                boolean bl = false;
                return bl;
            }
            Data compData = data.getComponent(start.getComponentPath());
            if (compData == null) {
                boolean bl = false;
                return bl;
            }
            DataType dataType = compData.getParent().getBaseDataType();
            if (!(dataType instanceof Composite)) {
                boolean bl = false;
                return bl;
            }
            if (dataType instanceof Union && ((Composite)dataType).getNumComponents() <= 1) {
                boolean bl = false;
                return bl;
            }
            int index = compData.getComponentIndex();
            if (dataType instanceof Union) {
                ((Union)dataType).delete(index);
            } else {
                int endOrdinal;
                Address startAddress = start.getByteAddress();
                Address endAddress = end != null ? end.getByteAddress() : startAddress;
                Data parent = compData.getParent();
                Address parentAddress = parent.getAddress();
                int startOffset = (int)startAddress.subtract(parentAddress);
                int endOffset = (int)endAddress.subtract(parentAddress);
                Structure structure = (Structure)dataType;
                int startOrdinal = this.getOrdinalAtOrBefore(structure, startOffset);
                for (int ordinal = endOrdinal = this.getOrdinalAtOrBefore(structure, endOffset); ordinal >= 0 && ordinal >= startOrdinal; --ordinal) {
                    structure.clearComponent(ordinal);
                }
            }
            commit = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            program.endTransaction(id, commit);
        }
        return commit;
    }

    private int getOrdinalAtOrBefore(Structure structure, int offset) {
        DataTypeComponent component = structure.getComponentAt(offset);
        for (int adjustedOffset = offset; component == null && adjustedOffset >= 0; --adjustedOffset) {
            component = structure.getComponentAt(offset);
        }
        if (component == null) {
            return -1;
        }
        return component.getOrdinal();
    }

    private void createActions() {
        this.clearAction = new ListingContextAction(CLEAR_CODE_BYTES_NAME, this.getName()){

            @Override
            public void actionPerformed(ListingActionContext context) {
                ClearOptions opts = new ClearOptions();
                opts.setClearCode(true);
                opts.setClearSymbols(false);
                opts.setClearComments(false);
                opts.setClearProperties(false);
                opts.setClearFunctions(false);
                opts.setClearRegisters(false);
                opts.setClearEquates(false);
                opts.setClearUserReferences(true);
                opts.setClearAnalysisReferences(true);
                opts.setClearImportReferences(true);
                opts.setClearDefaultReferences(false);
                opts.setClearBookmarks(false);
                if (this.clearWithContext(context, opts)) {
                    return;
                }
            }

            private boolean clearWithContext(ListingActionContext context, ClearOptions opts) {
                ClearPlugin.this.clear(opts, context);
                return true;
            }

            @Override
            public boolean isAddToPopup(ListingActionContext context) {
                return true;
            }

            @Override
            public boolean isEnabledForContext(ListingActionContext context) {
                ProgramLocation loc = context.getLocation();
                ProgramSelection currentSelection = context.getSelection();
                if (currentSelection != null && !currentSelection.isEmpty()) {
                    return true;
                }
                return loc != null && loc.getAddress() != null && loc instanceof CodeUnitLocation;
            }
        };
        int menuOrdinal = 1;
        MenuData menuData = new MenuData(new String[]{"&Edit", CLEAR_CODE_BYTES_NAME}, null, CLEAR_CODE_BYTES_NAME);
        menuData.setMenuSubGroup(Integer.toString(menuOrdinal));
        this.clearAction.setMenuBarData(menuData);
        MenuData popupMenuData = new MenuData(new String[]{CLEAR_CODE_BYTES_NAME}, null, CLEAR_CODE_BYTES_NAME);
        popupMenuData.setMenuSubGroup(Integer.toString(menuOrdinal));
        this.clearAction.setPopupMenuData(popupMenuData);
        this.clearAction.setKeyBindingData(new KeyBindingData(67, 0));
        String clearWithOptionsName = "Clear With Options";
        this.clearAllAction = new DockingAction(clearWithOptionsName, this.getName()){

            public void actionPerformed(ActionContext context) {
                ClearPlugin.this.showClearAllDialog((ListingActionContext)context.getContextObject());
            }

            public boolean isEnabledForContext(ActionContext context) {
                return context.getContextObject() instanceof ListingActionContext;
            }
        };
        menuData = new MenuData(new String[]{"&Edit", clearWithOptionsName + "..."}, null, CLEAR_CODE_BYTES_NAME);
        menuData.setMenuSubGroup(Integer.toString(++menuOrdinal));
        this.clearAllAction.setMenuBarData(menuData);
        popupMenuData = new MenuData(new String[]{clearWithOptionsName + "..."}, null, CLEAR_CODE_BYTES_NAME);
        popupMenuData.setMenuSubGroup(Integer.toString(menuOrdinal));
        this.clearAllAction.setPopupMenuData(popupMenuData);
        this.clearAndRepairAction = new DockingAction(CLEAR_FLOW_AND_REPAIR, this.getName()){

            public void actionPerformed(ActionContext context) {
                ClearPlugin.this.showClearFlowDialog((ListingActionContext)context.getContextObject());
            }

            public boolean isEnabledForContext(ActionContext context) {
                return context.getContextObject() instanceof ListingActionContext;
            }
        };
        menuData = new MenuData(new String[]{"&Edit", CLEAR_FLOW_AND_REPAIR}, null, CLEAR_CODE_BYTES_NAME);
        menuData.setMenuSubGroup(Integer.toString(++menuOrdinal));
        this.clearAndRepairAction.setMenuBarData(menuData);
        popupMenuData = new MenuData(new String[]{"Clear Flow and Repair..."}, null, CLEAR_CODE_BYTES_NAME);
        popupMenuData.setMenuSubGroup(Integer.toString(menuOrdinal));
        this.clearAndRepairAction.setPopupMenuData(popupMenuData);
        this.tool.addAction((DockingActionIf)this.clearAction);
        this.tool.addAction((DockingActionIf)this.clearAllAction);
        this.tool.addAction((DockingActionIf)this.clearAndRepairAction);
    }

    private void showClearAllDialog(ListingActionContext programActionContext) {
        if (this.clearDialog == null) {
            this.clearDialog = new ClearDialog(this);
        }
        this.clearDialog.setProgramActionContext(programActionContext);
        this.tool.showDialog((DialogComponentProvider)this.clearDialog);
    }

    private void showClearFlowDialog(ListingActionContext context) {
        if (this.clearFlowDialog == null) {
            this.clearFlowDialog = new ClearFlowDialog(this);
        }
        this.clearFlowDialog.setProgramActionContext(context);
        this.tool.showDialog((DialogComponentProvider)this.clearFlowDialog);
    }
}

