/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.assembler;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DockingUtils;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.autocomplete.AutocompletionEvent;
import docking.widgets.autocomplete.AutocompletionListener;
import docking.widgets.autocomplete.TextFieldAutocompleter;
import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.fieldpanel.FieldPanelOverLayoutListener;
import docking.widgets.fieldpanel.FieldPanelOverLayoutManager;
import docking.widgets.fieldpanel.Layout;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.context.ListingActionContext;
import ghidra.app.plugin.assembler.Assembler;
import ghidra.app.plugin.assembler.Assemblers;
import ghidra.app.plugin.core.assembler.AssemblyDualTextField;
import ghidra.app.plugin.core.codebrowser.CodeViewerProvider;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.listingpanel.ListingModelAdapter;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.database.util.ProgramTransaction;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Language;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.task.CachingSwingWorker;
import ghidra.util.task.TaskMonitor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.KeyStroke;
import org.apache.commons.collections4.map.DefaultedMap;
import org.apache.commons.collections4.map.LazyMap;

public class AssembleDockingAction
extends DockingAction {
    private static final String ASSEMBLY_RATING = "assemblyRating";
    private static final String ASSEMBLY_MESSAGE = "assemblyMessage";
    private static final KeyStroke KEYBIND_ASSEMBLE = KeyStroke.getKeyStroke(71, DockingUtils.CONTROL_KEY_MODIFIER_MASK | 0x40);
    private FieldPanelOverLayoutManager fieldLayoutManager;
    private CodeViewerProvider cv;
    private FieldPanel codepane;
    private ListingPanel listpane;
    private Map<Language, CachingSwingWorker<Assembler>> cache = LazyMap.lazyMap(new HashMap(), lang -> new AssemblerConstructorWorker((Language)lang));
    private Map<Language, Boolean> shownWarning = DefaultedMap.defaultedMap(new HashMap(), (Object)false);
    private final AssemblyDualTextField input = new AssemblyDualTextField();
    private Program prog;
    private Address addr;
    private Language lang;
    private Assembler assembler;
    private final MyListener listener = new MyListener();
    private PluginTool tool;
    private FieldPanelOverLayoutListener autoCompleteMover = ev -> {
        TextFieldAutocompleter<AssemblyDualTextField.AssemblyCompletion> autocompleter = this.input.getAutocompleter();
        if (autocompleter.isCompletionListVisible()) {
            autocompleter.updateDisplayLocation();
        }
    };

    public AssembleDockingAction(PluginTool tool, String name, String owner) {
        this(name, owner);
        this.tool = tool;
    }

    public void dispose() {
        super.dispose();
        this.input.dispose();
    }

    protected void onFirstInvocation() {
        ComponentProvider prov = this.tool.getComponentProvider("Listing");
        this.cv = (CodeViewerProvider)prov;
        this.listpane = this.cv.getListingPanel();
        this.codepane = this.listpane.getFieldPanel();
        this.fieldLayoutManager = new FieldPanelOverLayoutManager(this.codepane);
        this.codepane.setLayout((LayoutManager)this.fieldLayoutManager);
        this.input.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                AssembleDockingAction.this.cancel();
            }
        });
        this.input.getMnemonicField().setBorder(BorderFactory.createLineBorder(Color.RED, 2));
        this.input.getOperandsField().setBorder(BorderFactory.createLineBorder(Color.RED, 2));
        this.input.getAssemblyField().setBorder(BorderFactory.createLineBorder(Color.RED, 2));
        this.input.getAutocompleter().addAutocompletionListener((AutocompletionListener)this.listener);
        this.input.addKeyListener(this.listener);
        this.fieldLayoutManager.addLayoutListener(this.autoCompleteMover);
    }

    public void cancel() {
        this.codepane.removeAll();
        this.fieldLayoutManager.layoutContainer((Container)this.codepane);
        this.codepane.requestFocusInWindow();
    }

    private AssembleDockingAction(String name, String owner) {
        super(name, owner);
        String group = "Disassembly";
        this.setPopupMenuData(new MenuData(new String[]{"Patch Instruction"}, group));
        this.setKeyBindingData(new KeyBindingData(KEYBIND_ASSEMBLE));
        this.setHelpLocation(new HelpLocation("AssemblerPlugin", "AssembleAction"));
    }

    protected FieldLocation findFieldLocation(Address addr, String fieldName) {
        Layout layout = this.listpane.getLayout(addr);
        ListingModelAdapter adapter = (ListingModelAdapter)this.codepane.getLayoutModel();
        BigInteger index = adapter.getAddressIndexMap().getIndex(addr);
        int count = layout.getNumFields();
        for (int i = 0; i < count; ++i) {
            ListingField field = (ListingField)layout.getField(i);
            if (!field.getFieldFactory().getFieldName().equals(fieldName)) continue;
            return new FieldLocation(index, i);
        }
        return null;
    }

    public void actionPerformed(ActionContext context) {
        if (this.cv == null) {
            this.onFirstInvocation();
        }
        ProgramLocation cur = this.cv.getLocation();
        this.prog = cur.getProgram();
        this.addr = cur.getAddress();
        this.lang = this.prog.getLanguage();
        AssemblyRating rating = AssemblyRating.valueOf(this.lang.getProperty("assemblyRating:" + this.lang.getLanguageID(), AssemblyRating.UNRATED.name()));
        if (AssemblyRating.PLATINUM != rating) {
            String message = this.lang.getProperty("assemblyMessage:" + this.lang.getLanguageID(), rating.message);
            if (!this.shownWarning.get(this.lang).booleanValue()) {
                Msg.showWarn((Object)((Object)this), (Component)this.cv.getComponent(), (String)"Assembler Rating", (Object)("<html><body><p style='width: 300px;'>" + message + "</p></body></html>"));
                this.shownWarning.put(this.lang, true);
            }
        }
        this.cache.get(this.lang).get(null);
        this.assembler = Assemblers.getAssembler((Program)this.prog);
        this.input.setProgramLocation(cur);
        FieldLocation locMnem = this.findFieldLocation(this.addr, "Mnemonic");
        if (null == locMnem) {
            Msg.showError((Object)((Object)this), (Component)this.codepane, (String)"Assemble", (Object)"The mnemonic field must be present to assemble");
            return;
        }
        FieldLocation locOpns = this.findFieldLocation(this.addr, "Operands");
        this.codepane.removeAll();
        if (null == locOpns) {
            this.codepane.add((Component)this.input.getAssemblyField(), (Object)locMnem);
            this.input.setVisible(AssemblyDualTextField.VisibilityMode.SINGLE_VISIBLE);
        } else {
            this.codepane.add((Component)this.input.getMnemonicField(), (Object)locMnem);
            this.codepane.add((Component)this.input.getOperandsField(), (Object)locOpns);
            this.input.setVisible(AssemblyDualTextField.VisibilityMode.DUAL_VISIBLE);
        }
        CodeUnit cu = this.prog.getListing().getCodeUnitAt(this.addr);
        if (cu instanceof Instruction) {
            Instruction ins = (Instruction)cu;
            String instr = ins.toString();
            if (ins.isInDelaySlot()) {
                assert (instr.startsWith("_"));
                instr = instr.substring(1).trim();
            }
            this.input.setText(instr);
            this.input.setCaretPosition(instr.length());
            if (null == locOpns) {
                this.input.getAssemblyField().grabFocus();
            } else if (instr.contains(" ")) {
                this.input.getOperandsField().grabFocus();
            } else {
                this.input.getMnemonicField().grabFocus();
            }
        } else {
            this.input.setText("");
            this.input.setCaretPosition(0);
            if (null == locOpns) {
                this.input.getAssemblyField().grabFocus();
            } else {
                this.input.getMnemonicField().grabFocus();
            }
        }
        this.fieldLayoutManager.layoutContainer((Container)this.codepane);
    }

    public boolean isAddToPopup(ActionContext context) {
        Object obj = context.getContextObject();
        return obj instanceof ListingActionContext;
    }

    static enum AssemblyRating {
        UNRATED("This processor has not been tested with the assembler. If you are really lucky, the assembler will work on this language. Please contact the Ghidra team if you'd like us to test, rate, and/or improve this language."),
        POOR("This processor received a rating of POOR during testing. Please contact the Ghidra team if you'd like to assemble for this language. Until then, we DO NOT recommend trying to assemble."),
        BRONZE("This processor received a rating of BRONZE during testing. Please contact the Ghidra team if you'd like to assemble for this language. A fair number of instruction may assemble, but we DO NOT recommend trying to assemble."),
        SILVER("This processor received a rating of SILVER during testing. Most instruction should work, but you will likely encounter a few errors. Please contact the Ghidra team if you'd like certain instruction improved."),
        GOLD("This processor received a rating of GOLD during testing. You should rarely encounter an error, but please let us know if you do."),
        PLATINUM("This processor received a rating of PLATINUM during testing.");

        final String message;

        private AssemblyRating(String message) {
            this.message = message;
        }
    }

    private class MyListener
    implements AutocompletionListener<AssemblyDualTextField.AssemblyCompletion>,
    KeyListener {
        private MyListener() {
        }

        public void completionActivated(AutocompletionEvent<AssemblyDualTextField.AssemblyCompletion> ev) {
            if (ev.getSelection() instanceof AssemblyDualTextField.AssemblyInstruction) {
                AssemblyDualTextField.AssemblyInstruction ins = (AssemblyDualTextField.AssemblyInstruction)ev.getSelection();
                try (ProgramTransaction trans = ProgramTransaction.open((Program)AssembleDockingAction.this.prog, (String)("Assemble @" + AssembleDockingAction.this.addr + ": " + AssembleDockingAction.this.input.getText()));){
                    AssembleDockingAction.this.assembler.patchProgram(ins.getData(), AssembleDockingAction.this.addr);
                    trans.commit();
                    AssembleDockingAction.this.cancel();
                    return;
                }
                catch (MemoryAccessException e) {
                    Msg.showError((Object)AssembleDockingAction.this.assembler, (Component)AssembleDockingAction.this.input.getMnemonicField().getRootPane(), (String)"Assemble", (Object)"Could not patch selected instruction", (Throwable)e);
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.isConsumed()) {
                return;
            }
            if (e.getKeyCode() == 27) {
                AssembleDockingAction.this.cancel();
                e.consume();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }

    private static class AssemblerConstructorWorker
    extends CachingSwingWorker<Assembler> {
        private Language lang;

        public AssemblerConstructorWorker(Language lang) {
            super("Assemble", false);
            this.lang = lang;
        }

        protected Assembler runInBackground(TaskMonitor monitor) {
            monitor.setMessage("Constructing assembler for " + this.lang);
            return Assemblers.getAssembler((Language)this.lang);
        }
    }
}

