/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.plugin.core.clear.ClearFlowAndRepairCmd;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.tablechooser.AddressableRowObject;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.block.CodeBlockReference;
import ghidra.program.model.block.CodeBlockReferenceIterator;
import ghidra.program.model.block.SimpleBlockModel;
import ghidra.program.model.lang.Language;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.FlowOverride;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.util.HelpLocation;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class FindNoReturnFunctionsAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "Non-Returning Functions - Discovered";
    protected static final String DESCRIPTION = "As code is disassembled, discovers indications that functions do not return.  When a threshold of evidence is crossed, functions are marked non-returning.The one-shot analysis action can be used if functions were created while this analyzer was disabled or not present.";
    private static final String OPTION_FUNCTION_NONRETURN_THRESHOLD = "Function Non-return Threshold";
    private static final String OPTION_DESCRIPTION_FUNCTION_NONRETURN_THRESHOLD = "Enter the number of indications for a given function before it is considered non-returning.";
    private static final int OPTION_DEFAULT_EVIDENCE_THRESHOLD = 3;
    private int evidenceThresholdFunctions = 3;
    private static final String OPTION_NAME_REPAIR_DAMAGE = "Repair Flow Damage";
    private static final String OPTION_DESCRIPTION_REPAIR_DAMAGE = "Signals to repair any flow after a call to found non-returning functions.";
    private static final boolean OPTION_DEFAULT_REPAIR_DAMAGE_ENABLED = true;
    private static final String OPTION_NAME_CREATE_BOOKMARKS = "Create Analysis Bookmarks";
    private static final String OPTION_DESCRIPTION_CREATE_BOOKMARKS = "Signals to create an analysis bookmark on each function marked as non-returning.";
    private static final boolean OPTION_DEFAULT_CREATE_BOOKMARKS_ENABLED = true;
    private boolean repairDamageEnabled = true;
    private boolean createBookmarksEnabled = true;
    private Program program;
    private TaskMonitor monitor;
    private List<NoReturnLocations> reasonList = null;
    private Address lastGetNextFuncAddress = null;
    private Address nextFunction = null;

    public FindNoReturnFunctionsAnalyzer() {
        this(NAME, DESCRIPTION, AnalyzerType.INSTRUCTION_ANALYZER);
    }

    public FindNoReturnFunctionsAnalyzer(String name, String description, AnalyzerType analyzerType) {
        super(name, description, analyzerType);
        this.setPriority(AnalysisPriority.DISASSEMBLY.after());
        this.setSupportsOneTimeAnalysis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean added(Program prog, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        try {
            this.program = prog;
            this.monitor = monitor;
            this.reasonList = new ArrayList<NoReturnLocations>();
            this.lastGetNextFuncAddress = null;
            monitor.setMessage("NoReturn - Finding non-returning functions");
            AddressSet noReturnSet = new AddressSet();
            boolean hadOtherSuspiciousFunctions = this.detectNoReturn(this.program, noReturnSet, set);
            if (hadOtherSuspiciousFunctions) {
                this.detectNoReturn(this.program, noReturnSet, set);
            }
            AddressIterator noreturns = noReturnSet.getAddresses(true);
            for (Address address : noreturns) {
                monitor.checkCanceled();
                this.setFunctionNonReturning(this.program, address);
                monitor.setMessage("NoReturn - Clearing fallthrough at: " + address);
                this.setNoFallThru(this.program, address);
                monitor.setMessage("NoReturn - Fixup function bodies for: " + address);
                this.fixCallingFunctionBody(this.program, address);
            }
            if (this.repairDamageEnabled) {
                AddressSet clearInstSet = new AddressSet();
                noreturns = noReturnSet.getAddresses(true);
                for (Address address : noreturns) {
                    clearInstSet.add((AddressSetView)this.findPotentialDamagedLocations(this.program, address));
                }
                this.repairDamagedLocations(monitor, clearInstSet);
            }
        }
        finally {
            this.program = null;
            this.monitor = null;
            this.reasonList = null;
        }
        return true;
    }

    private void repairDamagedLocations(TaskMonitor taskMonitor, AddressSet clearInstSet) {
        if (clearInstSet == null || clearInstSet.isEmpty()) {
            return;
        }
        AutoAnalysisManager analysisManager = AutoAnalysisManager.getAnalysisManager(this.program);
        AddressSetView protectedSet = analysisManager.getProtectedLocations();
        ClearFlowAndRepairCmd cmd = new ClearFlowAndRepairCmd((AddressSetView)clearInstSet, protectedSet, true, false, true);
        cmd.applyTo((DomainObject)this.program, taskMonitor);
    }

    private void setFunctionNonReturning(Program cp, Address entry) {
        Function func = cp.getFunctionManager().getFunctionAt(entry);
        if (func == null) {
            CreateFunctionCmd createFunctionCmd = new CreateFunctionCmd(entry);
            createFunctionCmd.applyTo((DomainObject)cp);
            func = cp.getFunctionManager().getFunctionAt(entry);
            if (func == null) {
                return;
            }
        }
        func.setNoReturn(true);
    }

    protected void setNoFallThru(Program cp, Address entry) {
        ReferenceIterator refIter = this.program.getReferenceManager().getReferencesTo(entry);
        while (refIter.hasNext()) {
            Address fallthruAddr;
            Reference ref = refIter.next();
            if (!ref.getReferenceType().isCall()) continue;
            Address fromAddr = ref.getFromAddress();
            Instruction instr = this.program.getListing().getInstructionAt(fromAddr);
            if (instr == null || (fallthruAddr = instr.getFallThrough()) == null) continue;
            instr.setFlowOverride(FlowOverride.CALL_RETURN);
        }
    }

    private AddressSet findPotentialDamagedLocations(Program prog, Address entry) {
        String name = entry.toString();
        Function func = prog.getFunctionManager().getFunctionAt(entry);
        if (func != null) {
            name = func.getName();
        }
        try {
            this.monitor.setMessage("NoReturn - Clearing and repairing flows for: " + name);
            return this.findRepairLocations(prog, entry);
        }
        catch (CancelledException cancelledException) {
            return new AddressSet();
        }
    }

    protected AddressSet findRepairLocations(Program cp, Address entry) throws CancelledException {
        AddressSet clearInstSet = new AddressSet();
        AddressSet clearDataSet = new AddressSet();
        ReferenceIterator refIter = this.program.getReferenceManager().getReferencesTo(entry);
        while (refIter.hasNext()) {
            Reference ref = refIter.next();
            if (!ref.getReferenceType().isCall()) continue;
            Address fromAddr = ref.getFromAddress();
            Instruction instr = this.program.getListing().getInstructionAt(fromAddr);
            if (instr == null) continue;
            Address fallthruAddr = instr.getFallThrough();
            if (fallthruAddr == null) {
                try {
                    fallthruAddr = instr.getMinAddress().addNoWrap((long)instr.getDefaultFallThroughOffset());
                }
                catch (AddressOverflowException addressOverflowException) {
                    // empty catch block
                }
            }
            if (fallthruAddr == null) continue;
            Address checkAddr = this.skipNOPS(fallthruAddr);
            if (this.program.getSymbolTable().isExternalEntryPoint(checkAddr) || this.program.getSymbolTable().isExternalEntryPoint(fallthruAddr) || this.hasFlowRefInto(fallthruAddr) || this.hasFlowRefInto(checkAddr)) continue;
            Instruction inst = this.program.getListing().getInstructionAt(fallthruAddr);
            if (inst != null) {
                clearInstSet.add(fallthruAddr);
                continue;
            }
            clearDataSet.add(fallthruAddr);
        }
        if (!clearDataSet.isEmpty()) {
            ClearFlowAndRepairCmd.clearBadBookmarks(this.program, (AddressSetView)clearDataSet, this.monitor);
        }
        return clearInstSet;
    }

    private boolean detectNoReturn(Program cp, AddressSet noReturnSet, AddressSetView checkSet) throws CancelledException {
        AddressSet checkedSet = new AddressSet();
        boolean hadSuspiciousFunctions = false;
        AddressIterator refIter = cp.getReferenceManager().getReferenceSourceIterator(checkSet, true);
        for (Address address : refIter) {
            Address[] flows;
            this.monitor.checkCanceled();
            if (checkedSet.contains(address)) continue;
            checkedSet.add(address);
            Instruction inst = cp.getListing().getInstructionAt(address);
            if (inst == null || !inst.getFlowType().isCall() || !inst.getFlowType().hasFallthrough() || !this.checkNonReturningIndicators(inst, noReturnSet)) continue;
            for (Address target : flows = inst.getFlows()) {
                int count = 1;
                ReferenceIterator refsTo = cp.getReferenceManager().getReferencesTo(target);
                for (Reference reference : refsTo) {
                    Instruction oinst;
                    Address fromAddress;
                    if (!reference.getReferenceType().isCall() || checkedSet.contains(fromAddress = reference.getFromAddress())) continue;
                    checkedSet.add(fromAddress);
                    if (noReturnSet.contains(target) || (oinst = cp.getListing().getInstructionAt(fromAddress)) == null || !this.checkNonReturningIndicators(oinst, noReturnSet) || ++count < this.evidenceThresholdFunctions) continue;
                    noReturnSet.add(target);
                    break;
                }
                if (count >= this.evidenceThresholdFunctions) continue;
                if (this.targetOnlyCallsNoReturn(cp, target, noReturnSet)) {
                    NoReturnLocations location = new NoReturnLocations(target, null, "Calls only non-returing function");
                    this.reasonList.add(location);
                    noReturnSet.add(target);
                    continue;
                }
                hadSuspiciousFunctions = true;
            }
        }
        return hadSuspiciousFunctions;
    }

    private boolean targetOnlyCallsNoReturn(Program cp, Address target, AddressSet noReturnSet) throws CancelledException {
        SimpleBlockModel model = new SimpleBlockModel(cp);
        Stack<Address> todo = new Stack<Address>();
        todo.push(target);
        AddressSet visited = new AddressSet();
        boolean hitNoReturn = false;
        while (!todo.isEmpty()) {
            Address blockAddr = (Address)todo.pop();
            CodeBlock block = model.getCodeBlockAt(blockAddr, this.monitor);
            if (block == null) {
                return false;
            }
            if (visited.contains(blockAddr)) continue;
            visited.add(blockAddr);
            FlowType flowType = block.getFlowType();
            if (flowType.isTerminal() && !flowType.isCall()) {
                return false;
            }
            CodeBlockReferenceIterator destinations = block.getDestinations(this.monitor);
            if (!destinations.hasNext()) {
                return false;
            }
            while (destinations.hasNext()) {
                CodeBlockReference destRef = destinations.next();
                Address destAddr = destRef.getReference();
                FlowType destFlowType = destRef.getFlowType();
                if (destFlowType.isCall() || destFlowType.isJump()) {
                    if (noReturnSet.contains(destAddr)) {
                        hitNoReturn = true;
                        continue;
                    }
                    Function func = cp.getFunctionManager().getFunctionAt(destAddr);
                    if (func != null && func.hasNoReturn()) {
                        hitNoReturn = true;
                        continue;
                    }
                    if (flowType.isTerminal() && (destFlowType.isCall() || func != null)) {
                        return false;
                    }
                }
                if (destFlowType.isCall() || destFlowType.isIndirect()) continue;
                todo.push(destAddr);
            }
        }
        return hitNoReturn;
    }

    private boolean checkNonReturningIndicators(Instruction callInst, AddressSet noReturnFunctions) throws CancelledException {
        Address fallThru = callInst.getFallThrough();
        FunctionManager funcManager = this.program.getFunctionManager();
        Function callingFunc = funcManager.getFunctionContaining(callInst.getMinAddress());
        Address target = null;
        Address[] flows = callInst.getFlows();
        if (flows != null && flows.length > 0) {
            target = flows[0];
        }
        Address nextFuncAddr = this.getFunctionAfter(fallThru);
        Listing listing = this.program.getListing();
        while (fallThru != null) {
            if (nextFuncAddr != null && nextFuncAddr.equals((Object)fallThru)) {
                NoReturnLocations location = new NoReturnLocations(target, fallThru, "Function defined after call");
                this.reasonList.add(location);
                return true;
            }
            CodeUnit cu = listing.getCodeUnitAt(fallThru);
            if (cu == null || cu instanceof Data) {
                NoReturnLocations location = new NoReturnLocations(target, callInst.getMinAddress(), "Falls into data after call");
                this.reasonList.add(location);
                return true;
            }
            Instruction instr = (Instruction)cu;
            if (nextFuncAddr != null && cu.contains(nextFuncAddr)) {
                NoReturnLocations location = new NoReturnLocations(target, fallThru, "Function defined in instruction after call");
                this.reasonList.add(location);
                return true;
            }
            if (this.hasInconsistentRefsTo(fallThru, funcManager, callingFunc, target)) {
                return true;
            }
            Data data = listing.getDefinedDataAt(fallThru);
            if (data != null) {
                NoReturnLocations location = new NoReturnLocations(target, fallThru, "Data after call");
                this.reasonList.add(location);
                return true;
            }
            fallThru = null;
            if (!instr.getFlowType().isFallthrough()) continue;
            fallThru = instr.getFallThrough();
        }
        return false;
    }

    private boolean hasInconsistentRefsTo(Address addr, FunctionManager funcManager, Function callingFunc, Address calledAddr) {
        if (this.program.getReferenceManager().hasReferencesTo(addr)) {
            ReferenceIterator refIterTo = this.program.getReferenceManager().getReferencesTo(addr);
            while (refIterTo.hasNext()) {
                NoReturnLocations location;
                Reference reference = refIterTo.next();
                RefType refType = reference.getReferenceType();
                if (refType.isRead() || refType.isWrite()) {
                    if (callingFunc != null) {
                        Function function = funcManager.getFunctionContaining(reference.getFromAddress());
                        if (callingFunc.equals(function)) {
                            NoReturnLocations location2 = new NoReturnLocations(calledAddr, reference.getToAddress(), "Data Reference from same function after call");
                            this.reasonList.add(location2);
                            return true;
                        }
                    } else {
                        location = new NoReturnLocations(calledAddr, reference.getToAddress(), "Data Reference after call");
                        this.reasonList.add(location);
                        return true;
                    }
                }
                if (!refType.isCall()) continue;
                location = new NoReturnLocations(calledAddr, reference.getToAddress(), "Call Reference after call");
                this.reasonList.add(location);
                return true;
            }
        }
        return false;
    }

    private Address getFunctionAfter(Address addr) {
        if (addr == null) {
            return null;
        }
        if (this.lastGetNextFuncAddress != null && addr.compareTo((Object)this.lastGetNextFuncAddress) >= 0 && (this.nextFunction == null || addr.compareTo((Object)this.nextFunction) <= 0)) {
            return this.nextFunction;
        }
        FunctionIterator functions = this.program.getFunctionManager().getFunctions(addr, true);
        this.nextFunction = null;
        this.lastGetNextFuncAddress = addr;
        if (functions.hasNext()) {
            this.nextFunction = ((Function)functions.next()).getEntryPoint();
        }
        return this.nextFunction;
    }

    protected void fixCallingFunctionBody(Program cp, Address entry) throws CancelledException {
        if (this.createBookmarksEnabled) {
            cp.getBookmarkManager().setBookmark(entry, "Analysis", "Non-Returning Function", "Non-Returning Function Found");
        }
        AddressSet fixedSet = new AddressSet();
        ReferenceIterator refIter = cp.getReferenceManager().getReferencesTo(entry);
        while (refIter.hasNext()) {
            AddressSetView newBody;
            Function fixFunc;
            Address fromAddr;
            Reference ref = refIter.next();
            if (!ref.getReferenceType().isCall() || fixedSet.contains(fromAddr = ref.getFromAddress()) || (fixFunc = cp.getFunctionManager().getFunctionContaining(fromAddr)) == null) continue;
            AddressSetView oldBody = fixFunc.getBody();
            if (oldBody.equals(newBody = CreateFunctionCmd.getFunctionBody(cp, fixFunc.getEntryPoint()))) {
                fixedSet.add(newBody);
                continue;
            }
            CreateFunctionCmd.fixupFunctionBody(cp, fixFunc, this.monitor);
            Function newFunc = cp.getFunctionManager().getFunctionContaining(fromAddr);
            if (newFunc == null) continue;
            newBody = newFunc.getBody();
            fixedSet.add(newBody);
        }
    }

    private boolean hasFlowRefInto(Address addr) {
        if (addr == null) {
            return false;
        }
        ReferenceIterator refs = this.program.getReferenceManager().getReferencesTo(addr);
        while (refs.hasNext()) {
            Reference ref = refs.next();
            RefType refType = ref.getReferenceType();
            if (!refType.isFlow()) continue;
            return true;
        }
        return false;
    }

    private Address skipNOPS(Address addr) {
        for (int count = 0; addr != null && count < 16; ++count) {
            Instruction instructionAt = this.program.getListing().getInstructionAt(addr);
            if (instructionAt == null) {
                return addr;
            }
            if (!instructionAt.getFlowType().isFallthrough()) {
                return addr;
            }
            PcodeOp[] pcode = instructionAt.getPcode();
            if (pcode != null && pcode.length != 0) {
                for (PcodeOp pCode : pcode) {
                    int opcode = pCode.getOpcode();
                    switch (opcode) {
                        case 2: 
                        case 3: 
                        case 9: 
                        case 67: {
                            return addr;
                        }
                    }
                    Varnode output = pCode.getOutput();
                    if (output == null || output.isUnique()) continue;
                    return addr;
                }
            }
            if ((addr = instructionAt.getFallThrough()) != null) continue;
            return instructionAt.getMinAddress();
        }
        return addr;
    }

    @Override
    public boolean getDefaultEnablement(Program prog) {
        Language language = prog.getLanguage();
        boolean noReturnEnabled = language.getPropertyAsBoolean("enableNoReturnAnalysis", true);
        return noReturnEnabled;
    }

    @Override
    public void registerOptions(Options options, Program prog) {
        HelpLocation helpLocation = new HelpLocation("AutoAnalysisPlugin", "Auto_Analysis_Option_Instructions");
        options.registerOption(OPTION_FUNCTION_NONRETURN_THRESHOLD, (Object)3, helpLocation, OPTION_DESCRIPTION_FUNCTION_NONRETURN_THRESHOLD);
        options.registerOption(OPTION_NAME_REPAIR_DAMAGE, (Object)this.repairDamageEnabled, null, OPTION_DESCRIPTION_REPAIR_DAMAGE);
        options.registerOption(OPTION_NAME_CREATE_BOOKMARKS, (Object)this.createBookmarksEnabled, null, OPTION_DESCRIPTION_CREATE_BOOKMARKS);
    }

    @Override
    public void optionsChanged(Options options, Program prog) {
        this.evidenceThresholdFunctions = options.getInt(OPTION_FUNCTION_NONRETURN_THRESHOLD, 3);
        this.repairDamageEnabled = options.getBoolean(OPTION_NAME_REPAIR_DAMAGE, this.repairDamageEnabled);
        this.createBookmarksEnabled = options.getBoolean(OPTION_NAME_CREATE_BOOKMARKS, this.createBookmarksEnabled);
    }

    class NoReturnLocations
    implements AddressableRowObject {
        private Address addr;
        private Address whyAddr;
        private String explanation;

        NoReturnLocations(Address suspectNoRetAddr, Address whyAddr, String explanation) {
            this.addr = suspectNoRetAddr;
            this.whyAddr = whyAddr;
            this.explanation = explanation;
        }

        @Override
        public Address getAddress() {
            return this.getNoReturnAddr();
        }

        public Address getNoReturnAddr() {
            return this.addr;
        }

        public Address getWhyAddr() {
            return this.whyAddr;
        }

        public String getExplanation() {
            return this.explanation;
        }

        public String toString() {
            return "NoReturn At:" + this.getAddress() + "  because: " + this.getExplanation() + (String)(this.whyAddr != null ? " at " + this.whyAddr : "");
        }
    }
}

