/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.DemangledObject;
import ghidra.app.util.demangler.DemanglerOptions;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Library;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public abstract class AbstractDemanglerAnalyzer
extends AbstractAnalyzer {
    public AbstractDemanglerAnalyzer(String name, String description) {
        super(name, description, AnalyzerType.BYTE_ANALYZER);
        this.setPriority(AnalysisPriority.DATA_TYPE_PROPOGATION.before().before().before());
        this.setSupportsOneTimeAnalysis();
    }

    @Override
    public boolean canAnalyze(Program program) {
        return true;
    }

    @Override
    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        DemanglerOptions options = this.getOptions();
        if (!this.validateOptions(options, log)) {
            log.appendMsg(this.getName(), "Invalid demangler options--cannot demangle");
            return false;
        }
        monitor.initialize(100L);
        SymbolTable symbolTable = program.getSymbolTable();
        SymbolIterator it = symbolTable.getPrimarySymbolIterator(set, true);
        while (it.hasNext()) {
            monitor.checkCanceled();
            Symbol symbol = it.next();
            if (this.skipSymbol(symbol)) continue;
            Address address = symbol.getAddress();
            String mangled = this.cleanSymbol(address, symbol.getName());
            DemangledObject demangled = this.demangle(mangled, address, options, log);
            if (demangled != null) {
                this.apply(program, address, demangled, options, log, monitor);
            }
            Address min = set.getMinAddress();
            Address max = set.getMaxAddress();
            int distance = (int)(address.getOffset() - min.getOffset());
            int percent = (int)((long)distance / max.getOffset() * 100L);
            monitor.setProgress((long)percent);
        }
        return true;
    }

    protected abstract DemangledObject doDemangle(String var1, DemanglerOptions var2, MessageLog var3) throws DemangledException;

    protected boolean validateOptions(DemanglerOptions options, MessageLog log) {
        return true;
    }

    protected boolean skipSymbol(Symbol symbol) {
        Function function;
        if (symbol.getSource() == SourceType.DEFAULT) {
            return true;
        }
        Namespace parentNamespace = symbol.getParentNamespace();
        if (symbol.isExternal() ? !(parentNamespace instanceof Library) : !parentNamespace.isGlobal()) {
            return true;
        }
        return symbol.getSymbolType() == SymbolType.FUNCTION && (function = (Function)symbol.getObject()).getSignatureSource().isHigherPriorityThan(SourceType.ANALYSIS);
    }

    protected DemanglerOptions getOptions() {
        DemanglerOptions options = new DemanglerOptions();
        options.setApplySignature(true);
        options.setDoDisassembly(true);
        options.setDemangleOnlyKnownPatterns(false);
        return options;
    }

    protected DemangledObject demangle(String mangled, Address address, DemanglerOptions options, MessageLog log) {
        DemangledObject demangled = null;
        try {
            demangled = this.doDemangle(mangled, options, log);
        }
        catch (Throwable e) {
            if (e instanceof DemangledException && ((DemangledException)e).isInvalidMangledName()) {
                return null;
            }
            log.appendMsg(this.getName(), "Unable to demangle symbol: " + mangled + " at " + address + ".  Message: " + e.getMessage());
            return null;
        }
        return demangled;
    }

    protected void apply(Program program, Address address, DemangledObject demangled, DemanglerOptions options, MessageLog log, TaskMonitor monitor) {
        String errorMessage = null;
        try {
            if (demangled.applyTo(program, address, options, monitor)) {
                return;
            }
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null) {
                message = "";
            }
            errorMessage = "\n" + e.getClass().getSimpleName() + " " + message;
        }
        String failMessage = " (" + this.getName() + "/" + demangled.getClass().getName() + ")";
        if (errorMessage != null) {
            failMessage = failMessage + errorMessage;
        }
        log.appendMsg(this.getName(), "Failed to apply mangled symbol at " + address + "; name:  " + demangled.getMangledString() + failMessage);
    }

    protected String cleanSymbol(Address address, String name) {
        return SymbolUtilities.getCleanSymbolName((String)name, (Address)address);
    }
}

