/*
 * Decompiled with CFR 0.152.
 */
package functioncalls.graph.view;

import com.google.common.base.Function;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import functioncalls.graph.FcgEdge;
import functioncalls.graph.FcgVertex;
import functioncalls.graph.FunctionCallGraph;
import functioncalls.graph.renderer.FcgEdgePaintTransformer;
import functioncalls.graph.renderer.FcgVertexPaintTransformer;
import generic.theme.GColor;
import ghidra.graph.VisualGraph;
import ghidra.graph.viewer.GraphComponent;
import ghidra.graph.viewer.GraphViewer;
import ghidra.graph.viewer.SatelliteGraphViewer;
import ghidra.graph.viewer.VisualGraphViewUpdater;
import ghidra.graph.viewer.edge.VisualEdgeRenderer;
import ghidra.graph.viewer.layout.VisualGraphLayout;
import ghidra.graph.viewer.renderer.VisualVertexSatelliteRenderer;
import ghidra.graph.viewer.vertex.VisualVertexRenderer;
import java.awt.Color;

public class FcgComponent
extends GraphComponent<FcgVertex, FcgEdge, FunctionCallGraph> {
    private FunctionCallGraph fcGraph;
    private FcgVertexPaintTransformer vertexPaintTransformer = new FcgVertexPaintTransformer(FcgVertex.DEFAULT_VERTEX_SHAPE_COLOR);
    private FcgEdgePaintTransformer edgePaintTransformer = new FcgEdgePaintTransformer((Color)new GColor("color.bg.plugin.fcg.edge.primary.direct"), (Color)new GColor("color.bg.plugin.fcg.edge.primary.indirect"));
    private FcgEdgePaintTransformer selectedEdgePaintTransformer = new FcgEdgePaintTransformer((Color)new GColor("color.bg.plugin.fcg.edge.primary.direct.selected"), (Color)new GColor("color.bg.plugin.fcg.edge.primary.indirect.selected"));
    private FcgEdgePaintTransformer satelliteEdgePaintTransformer = new FcgEdgePaintTransformer((Color)new GColor("color.bg.plugin.fcg.edge.satellite.direct"), (Color)new GColor("color.bg.plugin.fcg.edge.satellite.indirect"));

    FcgComponent(FunctionCallGraph g) {
        this.setGraph((VisualGraph)g);
        this.build();
    }

    protected FcgVertex getInitialVertex() {
        return this.fcGraph.getSource();
    }

    protected void decoratePrimaryViewer(GraphViewer<FcgVertex, FcgEdge> viewer, VisualGraphLayout<FcgVertex, FcgEdge> layout) {
        super.decoratePrimaryViewer(viewer, layout);
        Renderer renderer = viewer.getRenderer();
        VisualVertexRenderer vertexRenderer = (VisualVertexRenderer)renderer.getVertexRenderer();
        vertexRenderer.setVertexFillPaintTransformer((Function)this.vertexPaintTransformer);
        VisualEdgeRenderer edgeRenderer = (VisualEdgeRenderer)renderer.getEdgeRenderer();
        edgeRenderer.setDrawColorTransformer((Function)this.edgePaintTransformer);
        edgeRenderer.setSelectedColorTransformer((Function)this.selectedEdgePaintTransformer);
    }

    protected void decorateSatelliteViewer(SatelliteGraphViewer<FcgVertex, FcgEdge> viewer, VisualGraphLayout<FcgVertex, FcgEdge> layout) {
        super.decorateSatelliteViewer(viewer, layout);
        Renderer renderer = viewer.getRenderer();
        VisualVertexSatelliteRenderer vertexRenderer = (VisualVertexSatelliteRenderer)renderer.getVertexRenderer();
        vertexRenderer.setVertexFillPaintTransformer((Function)this.vertexPaintTransformer);
        VisualEdgeRenderer edgeRenderer = (VisualEdgeRenderer)renderer.getEdgeRenderer();
        edgeRenderer.setDrawColorTransformer((Function)this.satelliteEdgePaintTransformer);
    }

    public void dispose() {
        this.fcGraph = null;
        super.dispose();
    }

    public VisualGraphViewUpdater<FcgVertex, FcgEdge> getViewUpdater() {
        return super.getViewUpdater();
    }
}

