/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.manager.cmd;

import agent.lldb.manager.LldbEvent;
import agent.lldb.manager.cmd.AbstractLldbCommand;
import agent.lldb.manager.cmd.LldbPendingCommand;
import agent.lldb.manager.evt.AbstractLldbCompletedCommandEvent;
import agent.lldb.manager.evt.LldbConsoleOutputEvent;
import agent.lldb.manager.impl.LldbManagerImpl;

public class LldbConsoleExecCommand
extends AbstractLldbCommand<String> {
    private String command;
    private Output to;

    public LldbConsoleExecCommand(LldbManagerImpl manager, String command, Output to) {
        super(manager);
        this.command = command;
        this.to = to;
    }

    @Override
    public boolean handle(LldbEvent<?> evt, LldbPendingCommand<?> pending) {
        if (evt instanceof AbstractLldbCompletedCommandEvent && pending.getCommand().equals(this)) {
            return true;
        }
        if (evt instanceof LldbConsoleOutputEvent && this.to == Output.CAPTURE) {
            pending.steal(evt);
        }
        return false;
    }

    @Override
    public String complete(LldbPendingCommand<?> pending) {
        if (this.to == Output.CONSOLE) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (LldbConsoleOutputEvent out : pending.findAllOf(LldbConsoleOutputEvent.class)) {
            builder.append(out.getOutput());
        }
        return builder.toString();
    }

    @Override
    public void invoke() {
        this.manager.getClient().execute(this.command);
    }

    public static enum Output {
        CONSOLE,
        CAPTURE;

    }
}

