/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.fbpk;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderWrapper;
import ghidra.file.formats.android.fbpk.FBPK;
import ghidra.file.formats.android.fbpk.FBPK_Factory;
import ghidra.file.formats.android.fbpk.FBPK_Partition;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileImpl;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.GFileSystemBase;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.factory.GFileSystemBaseFactory;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.CryptoException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@FileSystemInfo(type="androidbootloaderfbpk", description="Android Boot Loader Image (FBPK)", factory=GFileSystemBaseFactory.class)
public class FBPK_FileSystem
extends GFileSystemBase {
    private List<GFileImpl> fileList = new ArrayList<GFileImpl>();
    private Map<GFileImpl, FBPK_Partition> map = new HashMap<GFileImpl, FBPK_Partition>();

    public FBPK_FileSystem(String fileSystemName, ByteProvider provider) {
        super(fileSystemName, provider);
    }

    public boolean isValid(TaskMonitor monitor) throws IOException {
        byte[] bytes = this.provider.readBytes(0L, (long)"FBPK".length());
        return "FBPK".equals(new String(bytes).trim());
    }

    public void open(TaskMonitor monitor) throws IOException, CryptoException, CancelledException {
        BinaryReader reader = new BinaryReader(this.provider, true);
        FBPK header = FBPK_Factory.getFBPK(reader);
        List<FBPK_Partition> partitions = header.getPartitions();
        for (FBPK_Partition partition : partitions) {
            if (!partition.isFile()) continue;
            GFileImpl file = GFileImpl.fromFilename((GFileSystem)this, (GFile)this.root, (String)partition.getName(), (boolean)false, (long)partition.getDataSize(), null);
            this.fileList.add(file);
            this.map.put(file, partition);
        }
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        return new ArrayList<GFileImpl>(this.fileList);
    }

    public ByteProvider getByteProvider(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        FBPK_Partition partition = this.map.get(file);
        if (partition != null) {
            return new ByteProviderWrapper(this.provider, partition.getDataStartOffset(), Integer.toUnsignedLong(partition.getDataSize()), file.getFSRL());
        }
        return null;
    }
}

