/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.util;

import ghidra.file.formats.android.dex.format.DexHeader;
import ghidra.file.formats.android.dex.format.PrototypesIDItem;
import ghidra.file.formats.android.dex.format.StringIDItem;
import ghidra.file.formats.android.dex.format.TypeIDItem;
import ghidra.file.formats.android.dex.format.TypeItem;
import ghidra.file.formats.android.dex.format.TypeList;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.BooleanDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.CharDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DoubleDataType;
import ghidra.program.model.data.FloatDataType;
import ghidra.program.model.data.IntegerDataType;
import ghidra.program.model.data.LongDataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.ShortDataType;
import ghidra.program.model.data.SignedByteDataType;
import ghidra.program.model.data.Undefined4DataType;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.util.StringTokenizer;

public final class DexUtil {
    public static final long METHOD_ADDRESS = 0x50000000L;
    public static final long LOOKUP_ADDRESS = 0xE0000000L;
    public static final long MAX_METHOD_LENGTH = 524288L;
    public static final String CLASSDEF_NAME = "__classdef__";
    public static final String CATEGORY_PATH = "classes/";
    public static final String HANDLE_PATH = "/handles/";

    public static Address toLookupAddress(Program program, int methodIndex) {
        int pointerSize = program.getLanguage().getDefaultSpace().getPointerSize();
        AddressFactory addressFactory = program.getAddressFactory();
        AddressSpace defaultAddressSpace = addressFactory.getDefaultAddressSpace();
        return defaultAddressSpace.getAddress(0xE0000000L + (long)(methodIndex * pointerSize));
    }

    public static Namespace getOrCreateNameSpace(Program program, String name) {
        Namespace parent;
        SymbolTable symbolTable = program.getSymbolTable();
        Namespace namespace = symbolTable.getNamespace(name, parent = program.getGlobalNamespace());
        if (namespace != null) {
            return namespace;
        }
        try {
            return symbolTable.createNameSpace(parent, name, SourceType.ANALYSIS);
        }
        catch (Exception e) {
            return program.getGlobalNamespace();
        }
    }

    public static Namespace createNameSpaceFromMangledClassName(Program program, String className) throws InvalidInputException {
        Namespace namespace = program.getGlobalNamespace();
        return DexUtil.createNameSpaceFromMangledClassName(program, namespace, className);
    }

    public static Namespace createNameSpaceFromMangledClassName(Program program, Namespace parentNamespace, String className) throws InvalidInputException {
        SymbolTable symbolTable = program.getSymbolTable();
        if (className.startsWith("L") && className.endsWith(";")) {
            String str = className.substring(1, className.length() - 1);
            StringTokenizer tokenizer = new StringTokenizer(str, "/");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                Namespace ns = symbolTable.getNamespace(token, parentNamespace);
                if (ns != null) {
                    parentNamespace = ns;
                    continue;
                }
                try {
                    if (tokenizer.hasMoreElements()) {
                        parentNamespace = symbolTable.createNameSpace(parentNamespace, token, SourceType.ANALYSIS);
                        continue;
                    }
                    parentNamespace = symbolTable.createClass(parentNamespace, token, SourceType.ANALYSIS);
                }
                catch (DuplicateNameException e) {
                    return null;
                }
            }
        }
        return parentNamespace;
    }

    public static String convertTypeIndexToString(DexHeader header, short typeIndex) {
        return DexUtil.convertTypeIndexToString(header, typeIndex & 0xFFFF);
    }

    public static String convertTypeIndexToString(DexHeader header, int typeIndex) {
        if (typeIndex == -1) {
            return "<none>";
        }
        TypeIDItem typeItem = header.getTypes().get(typeIndex);
        return DexUtil.convertToString(header, typeItem.getDescriptorIndex());
    }

    public static String convertToString(DexHeader header, int stringIndex) {
        StringIDItem stringItem = header.getStrings().get(stringIndex);
        if (stringItem == null || stringItem.getStringDataItem() == null) {
            return "INVALID STRING 0x" + Integer.toHexString(stringIndex);
        }
        return stringItem.getStringDataItem().getString();
    }

    public static String convertPrototypeIndexToString(DexHeader header, short prototypeIndex) {
        PrototypesIDItem prototype = header.getPrototypes().get(prototypeIndex & 0xFFFF);
        StringBuilder builder = new StringBuilder();
        builder.append(DexUtil.convertTypeIndexToString(header, prototype.getReturnTypeIndex()));
        builder.append("( ");
        TypeList parameters = prototype.getParameters();
        if (parameters != null) {
            for (TypeItem parameter : parameters.getItems()) {
                builder.append(DexUtil.convertTypeIndexToString(header, parameter.getType()));
                builder.append("\n\t");
            }
        }
        builder.append(" )");
        return builder.toString();
    }

    public static String[] convertClassStringToPathArray(String prefix, String classString) {
        int len = classString.length();
        if (len == 0) {
            return null;
        }
        if (classString.charAt(0) != 'L') {
            return null;
        }
        if (classString.charAt(len - 1) != ';') {
            return null;
        }
        return (prefix + classString.substring(1, len - 1)).split("/");
    }

    public static DataType toDataType(DataTypeManager dtm, String dataTypeString) {
        if (dataTypeString.length() == 0) {
            return null;
        }
        switch (dataTypeString.charAt(0)) {
            case 'B': {
                return SignedByteDataType.dataType;
            }
            case 'C': {
                return CharDataType.dataType;
            }
            case 'D': {
                return DoubleDataType.dataType;
            }
            case 'F': {
                return FloatDataType.dataType;
            }
            case 'I': {
                return IntegerDataType.dataType;
            }
            case 'J': {
                return new LongDataType(dtm);
            }
            case 'S': {
                return ShortDataType.dataType;
            }
            case 'Z': {
                return BooleanDataType.dataType;
            }
            case 'V': {
                return VoidDataType.dataType;
            }
            case 'L': {
                String[] path = DexUtil.convertClassStringToPathArray(CATEGORY_PATH, dataTypeString);
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < path.length - 1; ++i) {
                    builder.append('/').append(path[i]);
                }
                CategoryPath catPath = new CategoryPath(builder.toString());
                DataType exist = dtm.getDataType(catPath, path[path.length - 1]);
                if (exist == null) {
                    exist = Undefined4DataType.dataType;
                }
                return new PointerDataType(exist, dtm);
            }
            case '[': {
                DataType subDataType = DexUtil.toDataType(dtm, dataTypeString.substring(1));
                return new PointerDataType(subDataType, dtm);
            }
        }
        return null;
    }

    public static int adjustOffset(int offset, DexHeader header) {
        if (header.isDataOffsetRelative()) {
            return offset + header.getDataOffset();
        }
        return offset;
    }

    public static long adjustOffset(long offset, DexHeader header) {
        if (header.isDataOffsetRelative()) {
            return offset + Integer.toUnsignedLong(header.getDataOffset());
        }
        return offset;
    }
}

