/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.byteviewer;

import generic.theme.Gui;
import ghidra.util.table.GhidraTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.HashMap;
import javax.swing.JSeparator;
import javax.swing.Scrollable;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

class ByteViewerHeader
extends JTableHeader
implements Scrollable {
    private static final String FONT_ID = "font.byteviewer.header";
    private TableColumnModel columnModel;
    private Component container;
    private int separatorWidth;
    private HashMap<Component, TableColumn> components;

    ByteViewerHeader(Component container) {
        this.container = container;
        this.components = new HashMap();
        Gui.registerFont((Component)this, (String)FONT_ID);
        this.setResizingAllowed(false);
        this.table = new GhidraTable();
        this.setTable(this.table);
        this.table.setTableHeader(this);
        this.columnModel = this.getColumnModel();
        this.columnModel.setColumnMargin(0);
        JSeparator s = new JSeparator(1);
        this.separatorWidth = s.getPreferredSize().width;
    }

    public void addColumn(String name, Component c) {
        TableColumn col = new TableColumn(this.components.size());
        col.setHeaderValue(name);
        col.setIdentifier(c);
        this.columnModel.addColumn(col);
        this.components.put(c, col);
        this.resizeAndRepaint();
    }

    public void removeColumn(Component c) {
        TableColumn col = this.components.get(c);
        if (col != null) {
            this.columnModel.removeColumn(col);
            this.components.remove(c);
            this.setSize(this.getPreferredSize());
            this.resizeAndRepaint();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        d.height += 4;
        return d;
    }

    public void setColumnName(Component c, String name) {
        TableColumn col = this.components.get(c);
        if (col != null) {
            col.setHeaderValue(name);
            this.recomputeColumnHeaders();
            this.resizeAndRepaint();
        }
    }

    public void addColumnModelListener(TableColumnModelListener l) {
        this.columnModel.addColumnModelListener(l);
    }

    public void removeColumnModelListener(TableColumnModelListener l) {
        this.columnModel.removeColumnModelListener(l);
    }

    @Override
    public void paint(Graphics g) {
        this.recomputeColumnHeaders();
        super.paint(g);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 1;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 1;
    }

    private void recomputeColumnHeaders() {
        for (Component c : this.components.keySet()) {
            TableColumn col = this.components.get(c);
            int width = c.getPreferredSize().width;
            int index = this.columnModel.getColumnIndex(col.getIdentifier());
            width = index == 0 ? (width += this.separatorWidth / 2) : (index == this.components.size() - 1 ? (width += this.separatorWidth / 2) : (width += this.separatorWidth));
            col.setMinWidth(width);
            col.setMaxWidth(width);
            col.setPreferredWidth(width);
        }
    }
}

