/*
 * Decompiled with CFR 0.152.
 */
package ghidra.formats.gfilesystem;

import ghidra.app.util.bin.ByteProvider;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemRefManager;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileHashProvider;
import ghidra.formats.gfilesystem.GFileLocal;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.LocalFileSystem;
import ghidra.formats.gfilesystem.fileinfo.FileAttributes;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class LocalFileSystemSub
implements GFileSystem,
GFileHashProvider {
    private final FSRLRoot fsFSRL;
    private final LocalFileSystem rootFS;
    private File localfsRootDir;
    private FileSystemRefManager refManager = new FileSystemRefManager(this);
    private GFileLocal rootGFile;

    public LocalFileSystemSub(File rootDir, LocalFileSystem rootFS) throws IOException {
        this.rootFS = rootFS;
        this.localfsRootDir = rootDir.getCanonicalFile();
        FSRL containerFSRL = rootFS.getLocalFSRL(this.localfsRootDir);
        this.fsFSRL = FSRLRoot.nestedFS(containerFSRL, rootFS.getFSRL().getProtocol());
        this.rootGFile = new GFileLocal(this.localfsRootDir, "/", containerFSRL, this, null);
    }

    @Override
    public String getType() {
        return this.rootFS.getType();
    }

    @Override
    public String getDescription() {
        return "Local filesystem subdirectory";
    }

    @Override
    public void close() {
        this.refManager.onClose();
        this.localfsRootDir = null;
    }

    @Override
    public boolean isClosed() {
        return this.localfsRootDir == null;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    private File getFileFromGFile(GFile gf) throws IOException {
        if (gf == null) {
            return this.localfsRootDir;
        }
        if (!(gf instanceof GFileLocal)) {
            throw new IOException("Unexpected GFile class: " + gf.getClass());
        }
        return ((GFileLocal)gf).getLocalFile();
    }

    @Override
    public List<GFile> getListing(GFile directory) throws IOException {
        if (directory == null) {
            directory = this.rootGFile;
        }
        if (!directory.isDirectory()) {
            return List.of();
        }
        File localDir = this.getFileFromGFile(directory);
        if (Files.isSymbolicLink(localDir.toPath())) {
            return List.of();
        }
        File[] localFiles = localDir.listFiles();
        if (localFiles == null) {
            return List.of();
        }
        ArrayList<GFile> tmp = new ArrayList<GFile>(localFiles.length);
        FSRL dirFSRL = directory.getFSRL();
        String relPath = FSUtilities.normalizeNativePath(directory.getPath());
        for (File f : localFiles) {
            if (!f.isFile() && !f.isDirectory()) continue;
            String name = f.getName();
            GFileLocal gf = new GFileLocal(f, FSUtilities.appendPath(relPath, name), dirFSRL.appendPath(name), this, directory);
            tmp.add(gf);
        }
        return tmp;
    }

    @Override
    public FileAttributes getFileAttributes(GFile file, TaskMonitor monitor) {
        try {
            File localFile = this.getFileFromGFile(file);
            return this.rootFS.getFileAttributes(localFile);
        }
        catch (IOException iOException) {
            return FileAttributes.EMPTY;
        }
    }

    @Override
    public String getName() {
        return "Subdir " + this.localfsRootDir.getPath();
    }

    @Override
    public FSRLRoot getFSRL() {
        return this.fsFSRL;
    }

    @Override
    public GFile lookup(String path) throws IOException {
        String[] parts;
        path = StringUtils.defaultString((String)path, (String)"/");
        File curFile = this.localfsRootDir;
        GFileLocal result = this.rootGFile;
        for (String name : parts = path.split("/")) {
            if (name.isEmpty()) continue;
            curFile = new File(curFile, name);
            FSRL fsrl = result.getFSRL().appendPath(name);
            String relPath = FSUtilities.appendPath(result.getPath(), name);
            result = new GFileLocal(curFile, relPath, fsrl, this, result);
        }
        return result;
    }

    @Override
    public InputStream getInputStream(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        return this.rootFS.getInputStream(file.getFSRL(), monitor);
    }

    @Override
    public FileSystemRefManager getRefManager() {
        return this.refManager;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public ByteProvider getByteProvider(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        return this.rootFS.getByteProvider(file.getFSRL(), monitor);
    }

    @Override
    public String getMD5Hash(GFile file, boolean required, TaskMonitor monitor) throws CancelledException, IOException {
        return this.rootFS.getMD5Hash(file.getFSRL(), required, monitor);
    }
}

