/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.Option;
import ghidra.app.util.OptionUtils;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.FileByteProvider;
import ghidra.app.util.importer.LibrarySearchPathManager;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.AbstractProgramLoader;
import ghidra.app.util.opinion.LoadException;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loaded;
import ghidra.app.util.opinion.LoaderTier;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectData;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.nio.file.AccessMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import utilities.util.FileUtilities;

public abstract class AbstractLibrarySupportLoader
extends AbstractProgramLoader {
    public static final String LINK_EXISTING_OPTION_NAME = "Link Existing Project Libraries";
    static final boolean LINK_EXISTING_OPTION_DEFAULT = true;
    public static final String LINK_SEARCH_FOLDER_OPTION_NAME = "Project Library Search Folder";
    static final String LINK_SEARCH_FOLDER_OPTION_DEFAULT = "";
    public static final String LOCAL_LIBRARY_OPTION_NAME = "Load Local Libraries From Disk";
    static final boolean LOCAL_LIBRARY_OPTION_DEFAULT = false;
    public static final String SYSTEM_LIBRARY_OPTION_NAME = "Load System Libraries From Disk";
    static final boolean SYSTEM_LIBRARY_OPTION_DEFAULT = false;
    public static final String DEPTH_OPTION_NAME = "Recursive Library Load Depth";
    static final int DEPTH_OPTION_DEFAULT = 1;
    public static final String LIBRARY_DEST_FOLDER_OPTION_NAME = "Library Destination Folder";
    static final String LIBRARY_DEST_FOLDER_OPTION_DEFAULT = "";

    protected abstract void load(ByteProvider var1, LoadSpec var2, List<Option> var3, Program var4, TaskMonitor var5, MessageLog var6) throws CancelledException, IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<Loaded<Program>> loadProgram(ByteProvider provider, String loadedName, Project project, String projectFolderPath, LoadSpec loadSpec, List<Option> options, MessageLog log, Object consumer, TaskMonitor monitor) throws CancelledException, IOException {
        ArrayList<Loaded<Program>> loadedProgramList = new ArrayList<Loaded<Program>>();
        ArrayList<String> libraryNameList = new ArrayList<String>();
        boolean success = false;
        try {
            Program program = this.doLoad(provider, loadedName, loadSpec, libraryNameList, options, consumer, log, monitor);
            loadedProgramList.add(new Loaded<Program>(program, loadedName, projectFolderPath));
            List<Loaded<Program>> libraries = this.loadLibraries(provider, program, project, projectFolderPath, loadSpec, options, log, consumer, libraryNameList, monitor);
            loadedProgramList.addAll(libraries);
            success = true;
            ArrayList<Loaded<Program>> arrayList = loadedProgramList;
            return arrayList;
        }
        finally {
            if (!success) {
                this.release(loadedProgramList, consumer);
            }
        }
    }

    @Override
    protected void loadProgramInto(ByteProvider provider, LoadSpec loadSpec, List<Option> options, MessageLog log, Program program, TaskMonitor monitor) throws CancelledException, LoadException, IOException {
        LanguageCompilerSpecPair pair = loadSpec.getLanguageCompilerSpec();
        LanguageID languageID = program.getLanguageID();
        CompilerSpecID compilerSpecID = program.getCompilerSpec().getCompilerSpecID();
        if (!pair.languageID.equals((Object)languageID) || !pair.compilerSpecID.equals((Object)compilerSpecID)) {
            String message = provider.getAbsolutePath() + " does not have the same language/compiler spec as program " + program.getName();
            log.appendMsg(message);
            throw new LoadException(message);
        }
        log.appendMsg("----- Loading " + provider.getAbsolutePath() + " -----");
        this.load(provider, loadSpec, options, program, monitor, log);
    }

    @Override
    protected void postLoadProgramFixups(List<Loaded<Program>> loadedPrograms, Project project, List<Option> options, MessageLog messageLog, TaskMonitor monitor) throws CancelledException, IOException {
        if (loadedPrograms.isEmpty()) {
            return;
        }
        if (this.isLinkExistingLibraries(options) || this.isLoadLocalLibraries(options) || this.isLoadSystemLibraries(options)) {
            String projectFolderPath = loadedPrograms.get(0).getProjectFolderPath();
            ArrayList<DomainFolder> searchFolders = new ArrayList<DomainFolder>();
            String destPath = this.getLibraryDestinationFolderPath(project, projectFolderPath, options);
            DomainFolder destSearchFolder = this.getLibraryDestinationSearchFolder(project, destPath, options);
            DomainFolder linkSearchFolder = this.getLinkSearchFolder(project, projectFolderPath, options);
            if (destSearchFolder != null) {
                searchFolders.add(destSearchFolder);
            }
            if (linkSearchFolder != null) {
                searchFolders.add(linkSearchFolder);
            }
            this.fixupExternalLibraries(loadedPrograms, searchFolders, messageLog, monitor);
        }
    }

    @Override
    public LoaderTier getTier() {
        return LoaderTier.GENERIC_TARGET_LOADER;
    }

    @Override
    public int getTierPriority() {
        return 50;
    }

    @Override
    public List<Option> getDefaultOptions(ByteProvider provider, LoadSpec loadSpec, DomainObject domainObject, boolean loadIntoProgram) {
        List<Option> list = super.getDefaultOptions(provider, loadSpec, domainObject, loadIntoProgram);
        list.add(new Option(LINK_EXISTING_OPTION_NAME, true, Boolean.class, "-loader-linkExistingProjectLibraries"));
        list.add(new Option(LINK_SEARCH_FOLDER_OPTION_NAME, "", String.class, "-loader-projectLibrarySearchFolder"));
        list.add(new Option(LOCAL_LIBRARY_OPTION_NAME, false, Boolean.class, "-loader-loadLocalLibraries"));
        list.add(new Option(SYSTEM_LIBRARY_OPTION_NAME, false, Boolean.class, "-loader-loadSystemLibraries"));
        list.add(new Option(DEPTH_OPTION_NAME, 1, Integer.class, "-loader-libraryLoadDepth"));
        list.add(new Option(LIBRARY_DEST_FOLDER_OPTION_NAME, "", String.class, "-loader-libraryDestinationFolder"));
        return list;
    }

    @Override
    public String validateOptions(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program) {
        if (options != null) {
            for (Option option : options) {
                String name = option.getName();
                if (name.equals(LINK_EXISTING_OPTION_NAME) || name.equals(LOCAL_LIBRARY_OPTION_NAME) || name.equals(SYSTEM_LIBRARY_OPTION_NAME)) {
                    if (Boolean.class.isAssignableFrom(option.getValueClass())) continue;
                    return "Invalid type for option: " + name + " - " + option.getValueClass();
                }
                if (name.equals(DEPTH_OPTION_NAME)) {
                    if (Integer.class.isAssignableFrom(option.getValueClass())) continue;
                    return "Invalid type for option: " + name + " - " + option.getValueClass();
                }
                if (!name.equals(LINK_SEARCH_FOLDER_OPTION_NAME) && !name.equals(LIBRARY_DEST_FOLDER_OPTION_NAME)) continue;
                if (!String.class.isAssignableFrom(option.getValueClass())) {
                    return "Invalid type for option: " + name + " - " + option.getValueClass();
                }
                String value = (String)option.getValue();
                if (value.isEmpty() || value.startsWith("/")) continue;
                return "Invalid absolute project path for option: " + name;
            }
        }
        return super.validateOptions(provider, loadSpec, options, program);
    }

    protected boolean isLinkExistingLibraries(List<Option> options) {
        return OptionUtils.getOption(LINK_EXISTING_OPTION_NAME, options, true);
    }

    protected DomainFolder getLinkSearchFolder(Project project, String projectFolderPath, List<Option> options) {
        if (!this.shouldSearchAllPaths(options) && !this.isLinkExistingLibraries(options)) {
            return null;
        }
        if (project == null) {
            return null;
        }
        String linkSearchFolderPath = OptionUtils.getOption(LINK_SEARCH_FOLDER_OPTION_NAME, options, "");
        ProjectData projectData = project.getProjectData();
        if (linkSearchFolderPath.isBlank()) {
            if (projectFolderPath == null) {
                return null;
            }
            return projectData.getFolder(projectFolderPath);
        }
        return projectData.getFolder(FilenameUtils.separatorsToUnix((String)linkSearchFolderPath));
    }

    protected boolean isLoadLocalLibraries(List<Option> options) {
        return OptionUtils.getOption(LOCAL_LIBRARY_OPTION_NAME, options, false);
    }

    protected boolean isLoadSystemLibraries(List<Option> options) {
        return OptionUtils.getOption(SYSTEM_LIBRARY_OPTION_NAME, options, false);
    }

    protected int getLibraryLoadDepth(List<Option> options) {
        return OptionUtils.getOption(DEPTH_OPTION_NAME, options, 1);
    }

    protected String getLibraryDestinationFolderPath(Project project, String projectFolderPath, List<Option> options) {
        if (project == null) {
            return null;
        }
        String libraryDestinationFolderPath = OptionUtils.getOption(LIBRARY_DEST_FOLDER_OPTION_NAME, options, "");
        if (libraryDestinationFolderPath.isBlank()) {
            return projectFolderPath;
        }
        return FilenameUtils.separatorsToUnix((String)libraryDestinationFolderPath);
    }

    protected DomainFolder getLibraryDestinationSearchFolder(Project project, String libraryDestinationFolderPath, List<Option> options) {
        if (project == null || libraryDestinationFolderPath == null) {
            return null;
        }
        if (!this.isLoadLocalLibraries(options) && !this.isLoadSystemLibraries(options)) {
            return null;
        }
        return project.getProjectData().getFolder(libraryDestinationFolderPath);
    }

    protected boolean shouldSearchAllPaths(List<Option> options) {
        return false;
    }

    protected boolean isCaseInsensitiveLibraryFilenames() {
        return false;
    }

    protected boolean isOptionalLibraryFilenameExtensions() {
        return false;
    }

    protected ByteProvider createLibraryByteProvider(File libFile, LoadSpec loadSpec, MessageLog log) throws IOException {
        return new FileByteProvider(libFile, FileSystemService.getInstance().getLocalFSRL(libFile), AccessMode.READ);
    }

    protected boolean shouldLoadLibrary(String libraryName, File libraryFile, ByteProvider provider, LoadSpec desiredLoadSpec, MessageLog log) throws IOException {
        if (this.matchSupportedLoadSpec(desiredLoadSpec, provider) == null) {
            log.appendMsg("Skipping library which is the wrong architecture: " + libraryFile);
            return false;
        }
        return true;
    }

    protected void processLibrary(Program library, String libraryName, File libraryFile, ByteProvider provider, LoadSpec loadSpec, List<Option> options, MessageLog log, TaskMonitor monitor) throws IOException, CancelledException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Loaded<Program>> loadLibraries(ByteProvider provider, Program program, Project project, String projectFolderPath, LoadSpec desiredLoadSpec, List<Option> options, MessageLog log, Object consumer, List<String> libraryNameList, TaskMonitor monitor) throws CancelledException, IOException {
        ArrayList<Loaded<Program>> loadedPrograms = new ArrayList<Loaded<Program>>();
        TreeSet<String> processed = new TreeSet<String>(this.getLibraryNameComparator());
        Queue<UnprocessedLibrary> unprocessed = this.createUnprocessedQueue(libraryNameList, this.getLibraryLoadDepth(options));
        boolean loadLocalLibraries = this.isLoadLocalLibraries(options);
        boolean loadSystemLibraries = this.isLoadSystemLibraries(options);
        List<String> localSearchPaths = this.getLocalLibrarySearchPaths(provider, options);
        List<String> systemSearchPaths = this.getSystemLibrarySearchPaths(provider, options);
        DomainFolder linkSearchFolder = this.getLinkSearchFolder(project, projectFolderPath, options);
        String libraryDestFolderPath = this.getLibraryDestinationFolderPath(project, projectFolderPath, options);
        DomainFolder libraryDestFolder = this.getLibraryDestinationSearchFolder(project, libraryDestFolderPath, options);
        boolean success = false;
        try {
            while (!unprocessed.isEmpty()) {
                Loaded<Program> loadedLibrary;
                monitor.checkCancelled();
                UnprocessedLibrary unprocessedLibrary = unprocessed.remove();
                String libraryName = unprocessedLibrary.name();
                int depth = unprocessedLibrary.depth();
                if (depth == 0 || processed.contains(libraryName)) continue;
                processed.add(libraryName);
                if (libraryDestFolder != null && this.findLibrary(libraryName, libraryDestFolder) != null) {
                    log.appendMsg("Library " + libraryName + ": Already loaded ");
                    continue;
                }
                if (linkSearchFolder != null && this.findLibrary(libraryName, linkSearchFolder) != null) {
                    log.appendMsg("Library " + libraryName + ": Already loaded ");
                    continue;
                }
                boolean loadedLocal = false;
                if (!localSearchPaths.isEmpty() && (loadedLibrary = this.loadLibraryFromSearchPaths(libraryName, provider, localSearchPaths, libraryDestFolderPath, unprocessed, depth, desiredLoadSpec, options, log, consumer, monitor)) != null) {
                    if (loadLocalLibraries) {
                        loadedPrograms.add(loadedLibrary);
                        loadedLocal = true;
                    } else {
                        loadedLibrary.release(consumer);
                    }
                }
                if (loadedLocal || systemSearchPaths.isEmpty() || (loadedLibrary = this.loadLibraryFromSearchPaths(libraryName, provider, systemSearchPaths, libraryDestFolderPath, unprocessed, depth, desiredLoadSpec, options, log, consumer, monitor)) == null) continue;
                if (loadSystemLibraries) {
                    loadedPrograms.add(loadedLibrary);
                    continue;
                }
                loadedLibrary.release(consumer);
            }
            success = true;
            ArrayList<Loaded<Program>> arrayList = loadedPrograms;
            return arrayList;
        }
        finally {
            if (!success) {
                this.release(loadedPrograms, consumer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Loaded<Program> loadLibraryFromSearchPaths(String libraryName, ByteProvider provider, List<String> searchPaths, String libraryDestFolderPath, Queue<UnprocessedLibrary> unprocessed, int depth, LoadSpec desiredLoadSpec, List<Option> options, MessageLog log, Object consumer, TaskMonitor monitor) throws CancelledException, IOException {
        Program library = null;
        String simpleLibraryName = FilenameUtils.getName((String)libraryName);
        List<File> candidateLibraryFiles = this.findLibrary(FilenameUtils.separatorsToUnix((String)libraryName), searchPaths);
        boolean success = false;
        try {
            for (File candidateLibraryFile : candidateLibraryFiles) {
                monitor.checkCancelled();
                ArrayList<String> newLibraryList = new ArrayList<String>();
                library = this.loadLibrary(simpleLibraryName, candidateLibraryFile, desiredLoadSpec, newLibraryList, options, consumer, log, monitor);
                for (String newLibraryName : newLibraryList) {
                    unprocessed.add(new UnprocessedLibrary(newLibraryName, depth - 1));
                }
                if (library == null) continue;
                log.appendMsg("Library " + libraryName + ": Examining " + candidateLibraryFile);
                this.processLibrary(library, libraryName, candidateLibraryFile, provider, desiredLoadSpec, options, log, monitor);
                success = true;
                Loaded<Program> loaded = new Loaded<Program>(library, simpleLibraryName, libraryDestFolderPath);
                return loaded;
            }
            log.appendMsg("Library " + libraryName + ": Not found");
            Iterator<File> iterator = null;
            return iterator;
        }
        finally {
            if (!success && library != null) {
                library.release(consumer);
            }
        }
    }

    private DomainFile findLibrary(String libraryPath, DomainFolder folder) {
        if (folder == null) {
            return null;
        }
        String projectPath = this.concatenatePaths(folder.getPathname(), libraryPath);
        DomainFile ret = folder.getProjectData().getFile(FilenameUtils.separatorsToUnix((String)projectPath));
        if (ret != null) {
            return ret;
        }
        String libraryName = FilenameUtils.getName((String)libraryPath);
        ret = folder.getFile(libraryName);
        if (ret != null) {
            return ret;
        }
        boolean noExtension = FilenameUtils.getExtension((String)libraryName).equals("");
        Comparator<String> comparator = this.getLibraryNameComparator();
        for (DomainFile file : folder.getFiles()) {
            String candidateName = file.getName();
            if (this.isOptionalLibraryFilenameExtensions() && noExtension) {
                candidateName = FilenameUtils.getBaseName((String)candidateName);
            }
            if (comparator.compare(candidateName, libraryName) != 0) continue;
            return file;
        }
        return null;
    }

    private List<File> findLibrary(String libraryPath, List<String> searchPaths) {
        File f;
        String libraryName = FilenameUtils.getName((String)libraryPath);
        ArrayList<File> results = new ArrayList<File>();
        for (String searchPath : searchPaths) {
            File searchDir;
            if ((searchPath = FilenameUtils.normalizeNoEndSeparator((String)searchPath)) == null || searchPath.isEmpty() || !(searchDir = new File(searchPath)).isAbsolute() || !searchDir.isDirectory()) continue;
            String candidatePath = FilenameUtils.separatorsToSystem((String)this.concatenatePaths(searchPath, libraryPath));
            File f2 = this.resolveLibraryFile(new File(candidatePath));
            if (f2 == null || !f2.isFile()) {
                f2 = this.resolveLibraryFile(new File(searchDir, libraryName));
            }
            if (f2 == null || !f2.isFile() || results.contains(f2)) continue;
            results.add(f2);
        }
        if (FilenameUtils.getPrefixLength((String)libraryPath) > 0 && (f = this.resolveLibraryFile(new File(libraryPath))) != null && f.isAbsolute() && f.isFile() && !results.contains(f)) {
            results.add(f);
        }
        return results;
    }

    private Program loadLibrary(String libraryName, File libraryFile, LoadSpec desiredLoadSpec, List<String> libraryNameList, List<Option> options, Object consumer, MessageLog log, TaskMonitor monitor) throws CancelledException, IOException {
        try (ByteProvider provider = this.createLibraryByteProvider(libraryFile, desiredLoadSpec, log);){
            if (!this.shouldLoadLibrary(libraryName, libraryFile, provider, desiredLoadSpec, log)) {
                Program program = null;
                return program;
            }
            LoadSpec libLoadSpec = this.matchSupportedLoadSpec(desiredLoadSpec, provider);
            if (libLoadSpec == null) {
                log.appendMsg("Skipping library which is the wrong architecture: " + libraryFile);
                Program program = null;
                return program;
            }
            Program library = this.doLoad(provider, libraryName, libLoadSpec, libraryNameList, options, consumer, log, monitor);
            if (library == null) {
                log.appendMsg("Library " + libraryFile + " failed to load for some reason");
                Program program = null;
                return program;
            }
            Program program = library;
            return program;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Program doLoad(ByteProvider provider, String programName, LoadSpec loadSpec, List<String> libraryNameList, List<Option> options, Object consumer, MessageLog log, TaskMonitor monitor) throws CancelledException, IOException {
        LanguageCompilerSpecPair pair = loadSpec.getLanguageCompilerSpec();
        Language language = this.getLanguageService().getLanguage(pair.languageID);
        CompilerSpec compilerSpec = language.getCompilerSpecByID(pair.compilerSpecID);
        monitor.setMessage(provider.getName());
        Address imageBaseAddr = language.getAddressFactory().getDefaultAddressSpace().getAddress(loadSpec.getDesiredImageBase());
        Program program = this.createProgram(provider, programName, imageBaseAddr, this.getName(), language, compilerSpec, consumer);
        int transactionID = program.startTransaction("Loading");
        boolean success = false;
        try {
            log.appendMsg("----- Loading " + provider.getAbsolutePath() + " -----");
            this.load(provider, loadSpec, options, program, monitor, log);
            this.createDefaultMemoryBlocks(program, language, log);
            ExternalManager extMgr = program.getExternalManager();
            Program externalNames = extMgr.getExternalLibraryNames();
            Comparator<String> comparator = this.getLibraryNameComparator();
            Arrays.sort(externalNames, comparator);
            for (String name : externalNames) {
                if (comparator.compare(name, provider.getName()) == 0 || comparator.compare(name, program.getName()) == 0 || "<EXTERNAL>".equals(name)) continue;
                libraryNameList.add(name);
            }
            success = true;
            Program program2 = program;
            return program2;
        }
        finally {
            program.endTransaction(transactionID, true);
            if (!success) {
                program.release(consumer);
                program = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixupExternalLibraries(List<Loaded<Program>> loadedPrograms, List<DomainFolder> searchFolders, MessageLog messageLog, TaskMonitor monitor) throws CancelledException, IOException {
        Map<String, Loaded<Program>> loadedByName = loadedPrograms.stream().collect(Collectors.toMap(loaded -> loaded.getName(), loaded -> loaded));
        monitor.initialize((long)loadedByName.size());
        for (Loaded loadedProgram : loadedByName.values()) {
            monitor.incrementProgress(1L);
            monitor.checkCancelled();
            Program program = (Program)loadedProgram.getDomainObject();
            ExternalManager extManager = program.getExternalManager();
            String[] extLibNames = extManager.getExternalLibraryNames();
            if (extLibNames.length == 0 || extLibNames.length == 1 && "<EXTERNAL>".equals(extLibNames[0])) continue;
            monitor.setMessage("Resolving..." + program.getName());
            int id = program.startTransaction("Resolving external references");
            try {
                this.resolveExternalLibraries(program, loadedByName, searchFolders, monitor, messageLog);
            }
            finally {
                program.endTransaction(id, true);
            }
        }
    }

    private void resolveExternalLibraries(Program program, Map<String, Loaded<Program>> loadedByName, List<DomainFolder> searchFolders, TaskMonitor monitor, MessageLog messageLog) throws CancelledException {
        ExternalManager extManager = program.getExternalManager();
        String[] extLibNames = extManager.getExternalLibraryNames();
        messageLog.appendMsg("Linking external programs to " + program.getName() + "...");
        for (String externalLibName : extLibNames) {
            if ("<EXTERNAL>".equals(externalLibName)) continue;
            monitor.checkCancelled();
            try {
                String externalFileName = FilenameUtils.getName((String)externalLibName);
                Loaded<Program> matchingExtProgram = this.findLibrary(loadedByName, externalFileName);
                if (matchingExtProgram != null) {
                    String path = matchingExtProgram.getProjectFolderPath() + matchingExtProgram.getName();
                    extManager.setExternalPath(externalLibName, path, false);
                    messageLog.appendMsg("  [" + externalLibName + "] -> [" + path + "]");
                    continue;
                }
                boolean found = false;
                for (DomainFolder searchFolder : searchFolders) {
                    DomainFile alreadyImportedLib = this.findLibrary(externalLibName, searchFolder);
                    if (alreadyImportedLib == null) continue;
                    extManager.setExternalPath(externalLibName, alreadyImportedLib.getPathname(), false);
                    messageLog.appendMsg("  [" + externalLibName + "] -> [" + alreadyImportedLib.getPathname() + "] (previously imported)");
                    found = true;
                    break;
                }
                if (found) continue;
                messageLog.appendMsg("  [" + externalLibName + "] -> not found");
            }
            catch (InvalidInputException e) {
                Msg.error((Object)this, (Object)("Bad library name: " + externalLibName), (Throwable)e);
            }
        }
    }

    private Queue<UnprocessedLibrary> createUnprocessedQueue(List<String> libraryNames, int depth) {
        return libraryNames.stream().map(name -> new UnprocessedLibrary((String)name, depth)).collect(Collectors.toCollection(LinkedList::new));
    }

    private List<String> getLocalLibrarySearchPaths(ByteProvider provider, List<Option> options) {
        String parent;
        ArrayList<String> paths = new ArrayList<String>();
        if ((this.isLoadLocalLibraries(options) || this.shouldSearchAllPaths(options)) && (parent = this.getProviderFilePath(provider)) != null) {
            paths.add(parent);
        }
        return paths;
    }

    private List<String> getSystemLibrarySearchPaths(ByteProvider provider, List<Option> options) {
        ArrayList<String> paths = new ArrayList<String>();
        if (this.isLoadSystemLibraries(options) || this.shouldSearchAllPaths(options)) {
            paths.addAll(LibrarySearchPathManager.getLibraryPathsList());
        }
        return paths;
    }

    private Loaded<Program> findLibrary(Map<String, Loaded<Program>> loadedByName, String libraryName) {
        Comparator<String> comparator = this.getLibraryNameComparator();
        boolean noExtension = FilenameUtils.getExtension((String)libraryName).equals("");
        Iterator<String> iterator = loadedByName.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            String candidateName = key = iterator.next();
            if (this.isOptionalLibraryFilenameExtensions() && noExtension) {
                candidateName = FilenameUtils.getBaseName((String)candidateName);
            }
            if (comparator.compare(candidateName, libraryName) != 0) continue;
            return loadedByName.get(key);
        }
        return null;
    }

    protected LoadSpec matchSupportedLoadSpec(LoadSpec desiredLoadSpec, ByteProvider provider) throws IOException {
        LanguageCompilerSpecPair desiredPair = desiredLoadSpec.getLanguageCompilerSpec();
        Collection<LoadSpec> supportedLoadSpecs = this.findSupportedLoadSpecs(provider);
        if (supportedLoadSpecs != null) {
            for (LoadSpec supportedLoadSpec : supportedLoadSpecs) {
                if (!desiredPair.equals((Object)supportedLoadSpec.getLanguageCompilerSpec())) continue;
                return supportedLoadSpec;
            }
        }
        return null;
    }

    private File resolveLibraryFile(File libraryFile) {
        File[] files;
        File ret = libraryFile;
        if (this.isCaseInsensitiveLibraryFilenames()) {
            ret = FileUtilities.resolveFileCaseInsensitive((File)libraryFile);
        }
        if (ret.exists()) {
            return ret;
        }
        if (this.isOptionalLibraryFilenameExtensions() && FilenameUtils.getExtension((String)libraryFile.toString()).equals("") && (files = libraryFile.getParentFile().listFiles()) != null) {
            Comparator<String> libNameComparator = this.getLibraryNameComparator();
            for (File file : files) {
                String baseName = FilenameUtils.getBaseName((String)file.toString());
                if (libNameComparator.compare(libraryFile.getName(), baseName) != 0) continue;
                return file;
            }
        }
        return null;
    }

    private String getProviderFilePath(ByteProvider provider) {
        FSRL fsrl = provider.getFSRL();
        if (fsrl != null && !fsrl.getFS().hasContainer()) {
            return FilenameUtils.getFullPathNoEndSeparator((String)fsrl.getPath());
        }
        File f = provider.getFile();
        return f != null ? f.getParent() : null;
    }

    private Comparator<String> getLibraryNameComparator() {
        return this.isCaseInsensitiveLibraryFilenames() ? String.CASE_INSENSITIVE_ORDER : (s1, s2) -> s1.compareTo((String)s2);
    }

    private record UnprocessedLibrary(String name, int depth) {
    }
}

