/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.app.util.bin.format.macho.commands.LoadCommandString;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class RunPathCommand
extends LoadCommand {
    private LoadCommandString path;

    RunPathCommand(BinaryReader reader) throws IOException {
        super(reader);
        this.path = new LoadCommandString(reader, this);
    }

    public LoadCommandString getPath() {
        return this.path;
    }

    @Override
    public String getCommandName() {
        return "rpath_command";
    }

    @Override
    public void markup(MachHeader header, FlatProgramAPI api, Address baseAddress, boolean isBinary, ProgramModule parentModule, TaskMonitor monitor, MessageLog log) {
        this.updateMonitor(monitor);
        try {
            if (isBinary) {
                this.createFragment(api, baseAddress, parentModule);
                Address address = baseAddress.getNewAddress(this.getStartIndex());
                api.createData(address, this.toDataType());
                int length = this.getCommandSize() - this.path.getOffset();
                api.createAsciiString(address.add((long)this.path.getOffset()), length);
            }
        }
        catch (Exception e) {
            log.appendMsg("Unable to create " + this.getCommandName());
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getCommandName(), 0);
        struct.add(DWORD, "cmd", null);
        struct.add(DWORD, "cmdsize", null);
        struct.add(this.path.toDataType(), "path", null);
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }
}

