/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang;

import ghidra.app.util.bin.format.dwarf4.next.DWARFDataTypeConflictHandler;
import ghidra.app.util.bin.format.dwarf4.next.DWARFFunction;
import ghidra.app.util.bin.format.dwarf4.next.DWARFVariable;
import ghidra.app.util.bin.format.golang.GoParamStorageAllocator;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.lang.Register;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GoFunctionMultiReturn {
    public static final String MULTIVALUE_RETURNTYPE_SUFFIX = "_multivalue_return_type";
    private static final String ORDINAL_PREFIX = "ordinal: ";
    private static final Pattern ORDINAL_REGEX = Pattern.compile(".*ordinal: ([\\d]+)[^\\d]*");
    private Structure struct;
    private List<DataTypeComponent> normalStorageComponents = new ArrayList<DataTypeComponent>();
    private List<DataTypeComponent> stackStorageComponents = new ArrayList<DataTypeComponent>();

    public static boolean isMultiReturnDataType(DataType dt) {
        return dt instanceof Structure && dt.getName().endsWith(MULTIVALUE_RETURNTYPE_SUFFIX);
    }

    public static GoFunctionMultiReturn fromStructure(DataType dt, DataTypeManager dtm, GoParamStorageAllocator storageAllocator) {
        return GoFunctionMultiReturn.isMultiReturnDataType(dt) ? new GoFunctionMultiReturn((Structure)dt, dtm, storageAllocator) : null;
    }

    public GoFunctionMultiReturn(List<DWARFVariable> returnParams, DWARFFunction dfunc, DataTypeManager dtm, GoParamStorageAllocator storageAllocator) {
        Structure newStruct = GoFunctionMultiReturn.mkStruct(dfunc.name.getParentCP(), dfunc.name.getName(), dtm);
        int ordinalNum = 0;
        for (DWARFVariable dvar : returnParams) {
            newStruct.add(dvar.type, dvar.name.getName(), ORDINAL_PREFIX + ordinalNum);
            ++ordinalNum;
        }
        this.regenerateMultireturnStruct(newStruct, dtm, storageAllocator);
    }

    public GoFunctionMultiReturn(CategoryPath categoryPath, String funcName, List<DataType> types, DataTypeManager dtm, GoParamStorageAllocator storageAllocator) {
        Structure newStruct = GoFunctionMultiReturn.mkStruct(categoryPath, funcName, dtm);
        int ordinalNum = 0;
        for (DataType dt : types) {
            newStruct.add(dt, "~r%d".formatted(ordinalNum), ORDINAL_PREFIX + ordinalNum);
            ++ordinalNum;
        }
        this.regenerateMultireturnStruct(newStruct, dtm, storageAllocator);
    }

    private static Structure mkStruct(CategoryPath cp, String baseName, DataTypeManager dtm) {
        String structName = baseName + MULTIVALUE_RETURNTYPE_SUFFIX;
        StructureDataType newStruct = new StructureDataType(cp, structName, 0, dtm);
        newStruct.setPackingEnabled(true);
        newStruct.setExplicitPackingValue(1);
        newStruct.setDescription("Artificial data type to hold a function's return values");
        return newStruct;
    }

    public GoFunctionMultiReturn(Structure struct, DataTypeManager dtm, GoParamStorageAllocator storageAllocator) {
        this.regenerateMultireturnStruct(struct, dtm, storageAllocator);
    }

    public Structure getStruct() {
        return this.struct;
    }

    public List<DataTypeComponent> getNormalStorageComponents() {
        return this.normalStorageComponents;
    }

    public List<DataTypeComponent> getStackStorageComponents() {
        return this.stackStorageComponents;
    }

    private void regenerateMultireturnStruct(Structure struct, DataTypeManager dtm, GoParamStorageAllocator storageAllocator) {
        if (storageAllocator == null) {
            this.struct = struct;
            for (DataTypeComponent dtc : GoFunctionMultiReturn.getComponentsInOriginalOrder(struct)) {
                this.stackStorageComponents.add(dtc);
            }
            return;
        }
        StructureDataType adjustedStruct = new StructureDataType(struct.getCategoryPath(), GoFunctionMultiReturn.getBasename(struct.getName()) + "_multivalue_return_type_" + storageAllocator.getArchDescription(), 0, dtm);
        adjustedStruct.setPackingEnabled(true);
        adjustedStruct.setExplicitPackingValue(1);
        storageAllocator = storageAllocator.clone();
        ArrayList<StackComponentInfo> stackResults = new ArrayList<StackComponentInfo>();
        int compNum = 0;
        for (DataTypeComponent dtc : GoFunctionMultiReturn.getComponentsInOriginalOrder(struct)) {
            List<Register> regs = storageAllocator.getRegistersFor(dtc.getDataType());
            if (regs == null || regs.isEmpty()) {
                long stackOffset = storageAllocator.getStackAllocation(dtc.getDataType());
                String comment = "stack[%d] %s%d".formatted(stackOffset, ORDINAL_PREFIX, compNum);
                stackResults.add(new StackComponentInfo(dtc, compNum, comment));
            } else {
                String comment = "%s %s%d".formatted(regs, ORDINAL_PREFIX, compNum);
                DataTypeComponent newDTC = adjustedStruct.add(dtc.getDataType(), dtc.getFieldName(), comment);
                this.normalStorageComponents.add(newDTC);
            }
            ++compNum;
        }
        for (int i = 0; i < stackResults.size(); ++i) {
            StackComponentInfo sci = (StackComponentInfo)stackResults.get(i);
            DataTypeComponent dtc = sci.dtc;
            DataTypeComponent newDTC = storageAllocator.isBigEndian() ? adjustedStruct.add(dtc.getDataType(), dtc.getFieldName(), sci.comment) : adjustedStruct.insert(i, dtc.getDataType(), -1, dtc.getFieldName(), sci.comment);
            this.stackStorageComponents.add(newDTC);
        }
        boolean isEquiv = DWARFDataTypeConflictHandler.INSTANCE.resolveConflict((DataType)adjustedStruct, (DataType)struct) == DataTypeConflictHandler.ConflictResult.USE_EXISTING;
        this.struct = isEquiv ? struct : adjustedStruct;
    }

    private static String getBasename(String structName) {
        int i = structName.indexOf(MULTIVALUE_RETURNTYPE_SUFFIX);
        return i > 0 ? structName.substring(0, i) : structName;
    }

    private static int getOrdinalNumber(DataTypeComponent dtc) {
        String comment = Objects.requireNonNullElse(dtc.getComment(), "");
        Matcher m = ORDINAL_REGEX.matcher(comment);
        try {
            return m.matches() ? Integer.parseInt(m.group(1)) : -1;
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    private static List<DataTypeComponent> getComponentsInOriginalOrder(Structure struct) {
        ArrayList<DataTypeComponent> dtcs = new ArrayList<DataTypeComponent>(List.of(struct.getDefinedComponents()));
        Collections.sort(dtcs, (dtc1, dtc2) -> Integer.compare(GoFunctionMultiReturn.getOrdinalNumber(dtc1), GoFunctionMultiReturn.getOrdinalNumber(dtc2)));
        return dtcs;
    }

    private record StackComponentInfo(DataTypeComponent dtc, int ordinal, String comment) {
    }
}

