/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf;

import ghidra.app.cmd.refs.RemoveReferenceCmd;
import ghidra.app.util.PseudoDisassembler;
import ghidra.app.util.bin.format.elf.ElfDynamicTable;
import ghidra.app.util.bin.format.elf.ElfDynamicType;
import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.ElfProgramHeader;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfRelocationTable;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.ElfSymbolTable;
import ghidra.framework.model.DomainObject;
import ghidra.program.disassemble.Disassembler;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Pointer32DataType;
import ghidra.program.model.data.Pointer64DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

public class ElfDefaultGotPltMarkup {
    private static final String PLT_HEAD_SYMBOL_NAME = "__PLT_HEAD";
    private ElfLoadHelper elfLoadHelper;
    private ElfHeader elf;
    private Program program;
    private Listing listing;
    private Memory memory;
    private static final int MAX_SUPPORTED_PLT_ENTRY_SIZE = 32;
    private static final int MIN_SUPPORTED_PLT_ENTRY_SIZE = 8;
    private static final int PLT_SYMBOL_SAMPLE_COUNT_THRESHOLD = 10;

    public ElfDefaultGotPltMarkup(ElfLoadHelper elfLoadHelper) {
        this.elfLoadHelper = elfLoadHelper;
        this.elf = elfLoadHelper.getElfHeader();
        this.program = elfLoadHelper.getProgram();
        this.listing = this.program.getListing();
        this.memory = this.program.getMemory();
    }

    private void log(String msg) {
        this.elfLoadHelper.log(msg);
    }

    public void process(TaskMonitor monitor) throws CancelledException {
        if (this.elf.getSectionHeaderCount() == 0) {
            this.processDynamicPLTGOT(ElfDynamicType.DT_PLTGOT, ElfDynamicType.DT_JMPREL, monitor);
        } else {
            this.processGOTSections(monitor);
            this.processPLTSection(monitor);
        }
    }

    private void processGOTSections(TaskMonitor monitor) throws CancelledException {
        MemoryBlock[] blocks;
        for (MemoryBlock gotBlock : blocks = this.memory.getBlocks()) {
            monitor.checkCancelled();
            if (!gotBlock.getName().startsWith(".got")) continue;
            gotBlock.setWrite(false);
            this.processGOT(gotBlock.getStart(), gotBlock.getEnd(), monitor);
        }
    }

    private void processDynamicPLTGOT(ElfDynamicType pltGotType, ElfDynamicType pltGotRelType, TaskMonitor monitor) throws CancelledException {
        ElfDynamicTable dynamicTable = this.elf.getDynamicTable();
        if (dynamicTable == null || !dynamicTable.containsDynamicValue(pltGotType) || !dynamicTable.containsDynamicValue(pltGotRelType)) {
            return;
        }
        AddressSpace defaultSpace = this.program.getAddressFactory().getDefaultAddressSpace();
        long imageBaseAdj = this.elfLoadHelper.getImageBaseWordAdjustmentOffset();
        try {
            long symbolSearchSpacing;
            Address minSymbolSearchAddress;
            long relocTableAddr = this.elf.adjustAddressForPrelink(dynamicTable.getDynamicValue(pltGotRelType));
            ElfProgramHeader relocTableLoadHeader = this.elf.getProgramLoadHeaderContaining(relocTableAddr);
            if (relocTableLoadHeader == null || relocTableLoadHeader.isInvalidOffset()) {
                return;
            }
            long relocTableOffset = relocTableLoadHeader.getOffset(relocTableAddr);
            ElfRelocationTable relocationTable = this.elf.getRelocationTableAtOffset(relocTableOffset);
            if (relocationTable == null) {
                return;
            }
            long pltgot = this.elf.adjustAddressForPrelink(dynamicTable.getDynamicValue(pltGotType));
            Address gotStart = defaultSpace.getAddress(pltgot + imageBaseAdj);
            ElfRelocation[] relocations = relocationTable.getRelocations();
            ElfSymbolTable associatedSymbolTable = relocationTable.getAssociatedSymbolTable();
            if (associatedSymbolTable == null) {
                return;
            }
            ElfSymbol[] symbols = associatedSymbolTable.getSymbols();
            ArrayList<PltGotSymbol> pltGotSymbols = new ArrayList<PltGotSymbol>();
            for (ElfRelocation reloc : relocations) {
                pltGotSymbols.add(new PltGotSymbol(symbols[reloc.getSymbolIndex()], reloc.getOffset()));
            }
            Collections.sort(pltGotSymbols);
            long maxGotOffset = ((PltGotSymbol)pltGotSymbols.get((int)(pltGotSymbols.size() - 1))).offset;
            Address gotEnd = defaultSpace.getAddress(maxGotOffset + imageBaseAdj);
            this.processGOT(gotStart, gotEnd, monitor);
            long pltEntryCount = pltGotSymbols.size();
            Address pltAddr1 = null;
            Address pltAddr2 = null;
            for (PltGotSymbol pltGotSym : pltGotSymbols) {
                Address gotEntryAddr = defaultSpace.getAddress(pltGotSym.offset + imageBaseAdj);
                long originalGotEntry = this.elfLoadHelper.getOriginalValue(gotEntryAddr, true);
                if (originalGotEntry == 0L) {
                    return;
                }
                if (pltAddr1 == null) {
                    pltAddr1 = defaultSpace.getAddress(originalGotEntry + imageBaseAdj);
                    continue;
                }
                pltAddr2 = defaultSpace.getAddress(originalGotEntry + imageBaseAdj);
                break;
            }
            if (pltAddr2 == null) {
                return;
            }
            long pltSpacing = pltAddr2.subtract(pltAddr1);
            if (pltSpacing < 0L || pltSpacing > 32L || pltSpacing % 2L != 0L) {
                return;
            }
            Address firstPltEntryAddr = null;
            if (pltSpacing == 0L) {
                Function pltHeadFunc = this.elfLoadHelper.createOneByteFunction(null, pltAddr1, false);
                if (pltHeadFunc.getSymbol().getSource() == SourceType.DEFAULT) {
                    try {
                        pltHeadFunc.setName(PLT_HEAD_SYMBOL_NAME, SourceType.ANALYSIS);
                    }
                    catch (DuplicateNameException | InvalidInputException throwable) {
                        // empty catch block
                    }
                }
                minSymbolSearchAddress = pltAddr1.next();
                symbolSearchSpacing = 8L;
            } else {
                firstPltEntryAddr = pltAddr1;
                minSymbolSearchAddress = pltAddr1.subtract(pltSpacing - 1L);
                symbolSearchSpacing = pltSpacing;
            }
            Address maxSymbolSearchAddress = minSymbolSearchAddress.add(pltEntryCount * symbolSearchSpacing);
            Symbol firstSymbol = null;
            Symbol lastSymbol = null;
            long discoveredPltSpacing = Long.MAX_VALUE;
            HashMap<Long, Integer> spacingCounts = new HashMap<Long, Integer>();
            for (Symbol sym : this.elfLoadHelper.getProgram().getSymbolTable().getSymbolIterator(minSymbolSearchAddress, true)) {
                if (sym.getSource() == SourceType.DEFAULT) continue;
                Address addr = sym.getAddress();
                if (addr.compareTo((Object)maxSymbolSearchAddress) > 0) break;
                if (firstSymbol == null) {
                    firstSymbol = sym;
                }
                if (pltSpacing != 0L) continue;
                if (lastSymbol != null) {
                    long spacing = addr.subtract(lastSymbol.getAddress());
                    if (spacing > 32L) {
                        lastSymbol = null;
                        continue;
                    }
                    int count = spacingCounts.compute(spacing, (k, v) -> v == null ? 1 : v + 1);
                    discoveredPltSpacing = Math.min(discoveredPltSpacing, spacing);
                    if (count == 10) break;
                }
                lastSymbol = sym;
            }
            if (pltSpacing == 0L) {
                if (discoveredPltSpacing == Long.MAX_VALUE || (Integer)spacingCounts.get(discoveredPltSpacing) == 1) {
                    return;
                }
                pltSpacing = discoveredPltSpacing;
            }
            if (firstSymbol != null) {
                int firstSymbolEntryIndex = -1;
                Address firstSymbolAddr = firstSymbol.getAddress();
                int entryIndex = 0;
                for (PltGotSymbol entrySymbol : pltGotSymbols) {
                    if (firstSymbolAddr.equals((Object)this.elfLoadHelper.getElfSymbolAddress(entrySymbol.elfSymbol))) {
                        firstSymbolEntryIndex = entryIndex;
                        break;
                    }
                    ++entryIndex;
                }
                if (firstSymbolEntryIndex >= 0) {
                    firstPltEntryAddr = firstSymbolAddr;
                    if (firstSymbolEntryIndex > 0) {
                        firstPltEntryAddr = firstPltEntryAddr.subtract((long)firstSymbolEntryIndex * pltSpacing);
                    }
                }
            }
            if (firstPltEntryAddr == null) {
                return;
            }
            Address pltEnd = firstPltEntryAddr.add(pltSpacing * (pltEntryCount - 1L));
            this.processLinkageTable("PLT", firstPltEntryAddr, pltEnd, monitor);
        }
        catch (Exception e) {
            String msg = "Failed to process " + pltGotType + ": " + e.getMessage();
            this.log(msg);
            Msg.error((Object)this, (Object)msg, (Throwable)e);
        }
    }

    private void processGOT(Address gotStart, Address gotEnd, TaskMonitor monitor) throws CancelledException {
        MemoryBlock block = this.memory.getBlock(gotStart);
        if (block == null || !block.isInitialized()) {
            return;
        }
        Data data = this.program.getListing().getDataAt(gotStart);
        if (data == null || !Undefined.isUndefined((DataType)data.getDataType())) {
            return;
        }
        ElfDynamicTable dynamicTable = this.elf.getDynamicTable();
        long imageBaseAdj = this.elfLoadHelper.getImageBaseWordAdjustmentOffset();
        if (dynamicTable != null && imageBaseAdj != 0L) {
            try {
                long entry1Value = this.elfLoadHelper.getOriginalValue(gotStart, false);
                if (entry1Value == dynamicTable.getAddressOffset()) {
                    entry1Value += imageBaseAdj;
                    if (this.elf.is64Bit()) {
                        this.elfLoadHelper.addArtificialRelocTableEntry(gotStart, 8);
                        this.memory.setLong(gotStart, entry1Value);
                    } else {
                        this.elfLoadHelper.addArtificialRelocTableEntry(gotStart, 4);
                        this.memory.setInt(gotStart, (int)entry1Value);
                    }
                }
            }
            catch (Exception e) {
                String msg = "Failed to process first GOT entry at " + gotStart + ": " + e.getMessage();
                this.log(msg);
                Msg.error((Object)this, (Object)msg, (Throwable)e);
            }
        }
        boolean imageBaseAlreadySet = this.elf.isPreLinked();
        try {
            Address newImageBase = null;
            Address nextGotAddr = gotStart;
            while (nextGotAddr.compareTo((Object)gotEnd) <= 0 && (data = this.createPointer(nextGotAddr, true)) != null) {
                try {
                    nextGotAddr = data.getMaxAddress().add(1L);
                }
                catch (AddressOutOfBoundsException e) {
                    break;
                }
                newImageBase = this.UglyImageBaseCheck(data, newImageBase);
            }
            if (newImageBase != null) {
                this.log("Invalid Address found in .got table.  Suspect Prelinked shared object file");
                if (imageBaseAlreadySet) {
                    this.log("ERROR: Unable to adjust image base for pre-link - retaining existing image base of " + this.program.getImageBase());
                } else {
                    this.program.setImageBase(newImageBase, true);
                    this.log("Setting Image base to: " + newImageBase);
                    imageBaseAlreadySet = true;
                }
            }
        }
        catch (Exception e) {
            String msg = "Failed to process GOT at " + gotStart + ": " + e.getMessage();
            this.log(msg);
            Msg.error((Object)this, (Object)msg, (Throwable)e);
        }
    }

    private void processPLTSection(TaskMonitor monitor) throws CancelledException {
        int assumedPltHeadSize = 16;
        if (this.elf.isRelocatable()) {
            return;
        }
        MemoryBlock pltBlock = this.memory.getBlock(".plt");
        if (pltBlock == null || !pltBlock.isExecute() || pltBlock.getSize() <= (long)assumedPltHeadSize) {
            return;
        }
        int skipPointers = assumedPltHeadSize;
        if (this.elf.e_machine() == 40 || this.elf.e_machine() == 183) {
            skipPointers = 0;
        }
        Address minAddress = pltBlock.getStart().add((long)skipPointers);
        Address maxAddress = pltBlock.getEnd();
        this.processLinkageTable(".plt", minAddress, maxAddress, monitor);
    }

    public void processLinkageTable(String pltName, Address minAddress, Address maxAddress, TaskMonitor monitor) throws CancelledException {
        try {
            int count;
            if (!PseudoDisassembler.hasLowBitCodeModeInAddrValues((Program)this.program)) {
                this.disassemble(minAddress, maxAddress, this.program, monitor);
            }
            if ((count = this.convertSymbolsToExternalFunctions(minAddress, maxAddress)) > 0) {
                this.log("Converted " + count + " " + pltName + " section symbols to external thunks");
            }
        }
        catch (Exception e) {
            String msg = "Failed to process " + pltName + " at " + minAddress + ": " + e.getMessage();
            this.log(msg);
            Msg.error((Object)this, (Object)msg, (Throwable)e);
        }
    }

    private int convertSymbolsToExternalFunctions(Address minAddress, Address maxAddress) {
        Symbol s;
        Address symAddr;
        AddressSet set = new AddressSet();
        SymbolTable symbolTable = this.program.getSymbolTable();
        Iterator iterator = symbolTable.getPrimarySymbolIterator(minAddress, true).iterator();
        while (iterator.hasNext() && (symAddr = (s = (Symbol)iterator.next()).getAddress()).compareTo((Object)maxAddress) <= 0) {
            if (s.getSource() == SourceType.DEFAULT || this.listing.getDataAt(symAddr) != null) continue;
            set.add(symAddr);
        }
        if (set.isEmpty()) {
            return 0;
        }
        for (Address addr : set.getAddresses(true)) {
            Symbol s2 = symbolTable.getPrimarySymbol(addr);
            this.elfLoadHelper.createExternalFunctionLinkage(s2.getName(), addr, null);
        }
        return (int)set.getNumAddresses();
    }

    private void disassemble(Address start, Address end, Program prog, TaskMonitor monitor) throws CancelledException {
        AddressSet set = new AddressSet(start, end);
        Disassembler disassembler = Disassembler.getDisassembler((Program)prog, (TaskMonitor)monitor, m -> {});
        while (!set.isEmpty()) {
            monitor.checkCancelled();
            AddressSet disset = disassembler.disassemble(set.getMinAddress(), null, true);
            if (disset.isEmpty()) {
                prog.getBookmarkManager().removeBookmarks((AddressSetView)set, "Error", "Bad Instruction", monitor);
                break;
            }
            set.delete((AddressSetView)disset);
        }
    }

    private Data createPointer(Address addr, boolean keepRefWhenValid) throws CodeUnitInsertionException {
        MemoryBlock block = this.memory.getBlock(addr);
        if (block == null || !block.isInitialized()) {
            return null;
        }
        int pointerSize = this.program.getDataTypeManager().getDataOrganization().getPointerSize();
        Pointer pointer = PointerDataType.dataType.clone((DataTypeManager)this.program.getDataTypeManager());
        if (this.elf.is32Bit() && pointerSize != 4) {
            pointer = Pointer32DataType.dataType;
        } else if (this.elf.is64Bit() && pointerSize != 8) {
            pointer = Pointer64DataType.dataType;
        }
        Data data = this.listing.getDataAt(addr);
        if (data == null || !pointer.isEquivalent(data.getDataType())) {
            if (data != null) {
                this.listing.clearCodeUnits(addr, addr.add((long)(pointerSize - 1)), false);
            }
            data = this.listing.createData(addr, (DataType)pointer);
        }
        if (keepRefWhenValid && ElfDefaultGotPltMarkup.isValidPointer(data)) {
            ElfDefaultGotPltMarkup.setConstant(data);
        } else {
            this.removeMemRefs(data);
        }
        return data;
    }

    public static void setConstant(Data data) {
        if (data == null) {
            return;
        }
        Memory memory = data.getProgram().getMemory();
        MemoryBlock block = memory.getBlock(data.getAddress());
        if (!block.isWrite() || block.getName().startsWith(".got")) {
            return;
        }
        data.setLong("mutability", 2L);
    }

    public static boolean isValidPointer(Data pointerData) {
        Address refAddr;
        Program program = pointerData.getProgram();
        Memory memory = program.getMemory();
        if (memory.contains(refAddr = (Address)pointerData.getValue())) {
            return true;
        }
        Symbol primary = program.getSymbolTable().getPrimarySymbol(refAddr);
        return primary != null && primary.getSource() != SourceType.DEFAULT;
    }

    private void removeMemRefs(Data data) {
        if (data != null) {
            Reference[] refs;
            for (Reference ref : refs = data.getValueReferences()) {
                RemoveReferenceCmd cmd = new RemoveReferenceCmd(ref);
                cmd.applyTo((DomainObject)data.getProgram());
            }
        }
    }

    private Address UglyImageBaseCheck(Data data, Address imageBase) {
        if (this.elf.e_machine() != 40) {
            return null;
        }
        if (!this.elf.isSharedObject()) {
            return null;
        }
        if (imageBase != null) {
            return imageBase;
        }
        Object dValue = data.getValue();
        if (dValue == null || !(dValue instanceof Address)) {
            return null;
        }
        Address daddr = (Address)dValue;
        if (this.memory.contains(daddr)) {
            return null;
        }
        if (daddr.getOffset() < 4L) {
            return null;
        }
        if (this.program.getImageBase().getOffset() != 0L) {
            return null;
        }
        if (this.program.getRelocationTable().hasRelocation(data.getAddress())) {
            return null;
        }
        MemoryBlock tBlock = this.memory.getBlock(".text");
        if (tBlock == null) {
            return null;
        }
        Address topAddr = tBlock.getEnd();
        long byteMask = -1L;
        for (long topVal = topAddr.getOffset(); topVal != 0L; topVal >>>= 8) {
            byteMask <<= 8;
        }
        long newBase = daddr.getOffset() & byteMask;
        if (newBase == 0L) {
            return null;
        }
        return daddr.getNewAddress(newBase);
    }

    private static class PltGotSymbol
    implements Comparable<PltGotSymbol> {
        final ElfSymbol elfSymbol;
        final long offset;

        PltGotSymbol(ElfSymbol elfSymbol, long offset) {
            this.elfSymbol = elfSymbol;
            this.offset = offset;
        }

        @Override
        public int compareTo(PltGotSymbol o) {
            return Long.compareUnsigned(this.offset, o.offset);
        }
    }
}

