/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4.attribs;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.dwarf4.DWARFCompilationUnit;
import ghidra.app.util.bin.format.dwarf4.DWARFUtil;
import ghidra.app.util.bin.format.dwarf4.attribs.DWARFAttributeValue;
import ghidra.app.util.bin.format.dwarf4.attribs.DWARFBlobAttribute;
import ghidra.app.util.bin.format.dwarf4.attribs.DWARFBooleanAttribute;
import ghidra.app.util.bin.format.dwarf4.attribs.DWARFDeferredStringAttribute;
import ghidra.app.util.bin.format.dwarf4.attribs.DWARFIndirectAttribute;
import ghidra.app.util.bin.format.dwarf4.attribs.DWARFNumericAttribute;
import ghidra.app.util.bin.format.dwarf4.attribs.DWARFStringAttribute;
import ghidra.app.util.bin.format.dwarf4.encoding.DWARFForm;
import ghidra.app.util.bin.format.dwarf4.next.DWARFProgram;
import ghidra.app.util.bin.format.dwarf4.next.StringTable;
import ghidra.program.model.data.LEB128;
import java.io.IOException;

public class DWARFAttributeFactory {
    public static final int MAX_BLOCK4_SIZE = 0x100000;
    private DWARFProgram prog;

    public DWARFAttributeFactory(DWARFProgram prog) {
        this.prog = prog;
    }

    public DWARFAttributeValue read(BinaryReader reader, DWARFCompilationUnit unit, DWARFForm form) throws IOException {
        StringTable debugStrings = this.prog.getDebugStrings();
        switch (form) {
            case DW_FORM_addr: {
                return new DWARFNumericAttribute(reader.readNextUnsignedValue(unit.getPointerSize()));
            }
            case DW_FORM_ref1: {
                long uoffset = reader.readNextUnsignedValue(1);
                return new DWARFNumericAttribute(uoffset + unit.getStartOffset());
            }
            case DW_FORM_ref2: {
                long uoffset = reader.readNextUnsignedValue(2);
                return new DWARFNumericAttribute(uoffset + unit.getStartOffset());
            }
            case DW_FORM_ref4: {
                long uoffset = reader.readNextUnsignedValue(4);
                return new DWARFNumericAttribute(uoffset + unit.getStartOffset());
            }
            case DW_FORM_ref8: {
                long uoffset = reader.readNextUnsignedValue(8);
                return new DWARFNumericAttribute(uoffset + unit.getStartOffset());
            }
            case DW_FORM_ref_udata: {
                long uoffset = reader.readNext(LEB128::unsigned);
                return new DWARFNumericAttribute(uoffset + unit.getStartOffset());
            }
            case DW_FORM_ref_addr: {
                return new DWARFNumericAttribute(DWARFUtil.readOffsetByDWARFformat(reader, unit.getFormat()));
            }
            case DW_FORM_sec_offset: {
                return new DWARFNumericAttribute(DWARFUtil.readOffsetByDWARFformat(reader, unit.getFormat()));
            }
            case DW_FORM_block1: {
                int length = DWARFUtil.readVarSizedUInt(reader, 1);
                return new DWARFBlobAttribute(reader.readNextByteArray(length));
            }
            case DW_FORM_block2: {
                int length = DWARFUtil.readVarSizedUInt(reader, 2);
                return new DWARFBlobAttribute(reader.readNextByteArray(length));
            }
            case DW_FORM_block4: {
                int length = DWARFUtil.readVarSizedUInt(reader, 4);
                if (length < 0 || length > 0x100000) {
                    throw new IOException("Invalid/bad dw_form_block4 size: " + length);
                }
                return new DWARFBlobAttribute(reader.readNextByteArray(length));
            }
            case DW_FORM_block: {
                int length = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
                if (length < 0 || length > 0x100000) {
                    throw new IOException("Invalid/bad dw_form_block size: " + length);
                }
                return new DWARFBlobAttribute(reader.readNextByteArray(length));
            }
            case DW_FORM_data1: {
                return new DWARFNumericAttribute(8, reader.readNextByte(), true, true);
            }
            case DW_FORM_data2: {
                return new DWARFNumericAttribute(16, reader.readNextShort(), true, true);
            }
            case DW_FORM_data4: {
                return new DWARFNumericAttribute(32, reader.readNextInt(), true, true);
            }
            case DW_FORM_data8: {
                return new DWARFNumericAttribute(64, reader.readNextLong(), true, true);
            }
            case DW_FORM_sdata: {
                return new DWARFNumericAttribute(64, reader.readNext(LEB128::signed), true);
            }
            case DW_FORM_udata: {
                return new DWARFNumericAttribute(64, reader.readNext(LEB128::unsigned), false);
            }
            case DW_FORM_exprloc: {
                int length = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
                if (length < 0 || length > 0x100000) {
                    throw new IOException("Invalid/bad dw_form_exprloc size: " + length);
                }
                return new DWARFBlobAttribute(reader.readNextByteArray(length));
            }
            case DW_FORM_flag: {
                return DWARFBooleanAttribute.get(reader.readNextByte() != 0);
            }
            case DW_FORM_flag_present: {
                return DWARFBooleanAttribute.TRUE;
            }
            case DW_FORM_string: {
                return new DWARFStringAttribute(reader.readNextUtf8String());
            }
            case DW_FORM_strp: {
                long stringOffset = DWARFUtil.readOffsetByDWARFformat(reader, unit.getFormat());
                if (!debugStrings.isValid(stringOffset)) {
                    throw new IOException("Bad string offset " + Long.toHexString(stringOffset));
                }
                return new DWARFDeferredStringAttribute(stringOffset);
            }
            case DW_FORM_ref_sig8: {
                throw new UnsupportedOperationException("DW_FORM_ref_sig8 is currently not implemented");
            }
            case DW_FORM_indirect: {
                DWARFForm formValue = DWARFForm.find(reader.readNextUnsignedVarIntExact(LEB128::unsigned));
                DWARFAttributeValue value = this.read(reader, unit, formValue);
                return new DWARFIndirectAttribute(value, formValue);
            }
        }
        throw new IllegalArgumentException("Unknown DWARF Form: " + form.toString());
    }
}

