/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.script;

import generic.jar.ResourceFile;
import ghidra.app.plugin.core.osgi.BundleHost;
import ghidra.app.plugin.core.osgi.GhidraBundleException;
import ghidra.app.plugin.core.osgi.GhidraSourceBundle;
import ghidra.app.script.GhidraScript;
import ghidra.app.script.GhidraScriptLoadException;
import ghidra.app.script.GhidraScriptProvider;
import ghidra.app.script.GhidraScriptUtil;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.regex.Pattern;
import org.osgi.framework.Bundle;

public class JavaScriptProvider
extends GhidraScriptProvider {
    private static final Pattern BLOCK_COMMENT_START = Pattern.compile("/\\*");
    private static final Pattern BLOCK_COMMENT_END = Pattern.compile("\\*/");
    private final BundleHost bundleHost = GhidraScriptUtil.getBundleHost();

    public GhidraSourceBundle getBundleForSource(ResourceFile sourceFile) {
        ResourceFile sourceDir = GhidraScriptUtil.findSourceDirectoryContaining(sourceFile);
        if (sourceDir == null) {
            return null;
        }
        return (GhidraSourceBundle)this.bundleHost.getExistingGhidraBundle(sourceDir);
    }

    @Override
    public String getDescription() {
        return "Java";
    }

    @Override
    public String getExtension() {
        return ".java";
    }

    @Override
    public boolean deleteScript(ResourceFile sourceFile) {
        try {
            Bundle osgiBundle = this.getBundleForSource(sourceFile).getOSGiBundle();
            if (osgiBundle != null) {
                this.bundleHost.deactivateSynchronously(osgiBundle);
            }
        }
        catch (GhidraBundleException e) {
            Msg.error((Object)this, (Object)"Error while deactivating bundle for delete", (Throwable)((Object)e));
            return false;
        }
        return super.deleteScript(sourceFile);
    }

    @Override
    public GhidraScript getScriptInstance(ResourceFile sourceFile, PrintWriter writer) throws GhidraScriptLoadException {
        try {
            Class<?> clazz = this.loadClass(sourceFile, writer);
            if (GhidraScript.class.isAssignableFrom(clazz)) {
                GhidraScript script = (GhidraScript)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                script.setSourceFile(sourceFile);
                return script;
            }
            throw new GhidraScriptLoadException("Ghidra scripts in Java must extend " + GhidraScript.class.getName() + ". " + sourceFile.getName() + " does not.");
        }
        catch (ClassNotFoundException e) {
            throw new GhidraScriptLoadException("The class could not be found. It must be the public class of the .java file: " + e.getMessage(), e);
        }
        catch (NoClassDefFoundError e) {
            throw new GhidraScriptLoadException("The class could not be found or loaded, perhaps due to a previous initialization error: " + e.getMessage(), e);
        }
        catch (ExceptionInInitializerError e) {
            throw new GhidraScriptLoadException("Error during class initialization: " + e.getException(), e.getException());
        }
        catch (InvocationTargetException e) {
            throw new GhidraScriptLoadException("Error during class construction: " + e.getTargetException(), e.getTargetException());
        }
        catch (NoSuchMethodException e) {
            throw new GhidraScriptLoadException("The default constructor does not exist: " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new GhidraScriptLoadException("The class or its default constructor is not accessible: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new GhidraScriptLoadException("Unexpected error: " + e);
        }
    }

    public Class<?> loadClass(ResourceFile sourceFile, PrintWriter writer) throws Exception {
        GhidraSourceBundle bundle = this.getBundleForSource(sourceFile);
        if (bundle == null) {
            throw new ClassNotFoundException("Failed to find source bundle containing script: " + sourceFile.toString());
        }
        this.bundleHost.activateAll(Collections.singletonList(bundle), TaskMonitor.DUMMY, writer);
        String classname = bundle.classNameForScript(sourceFile);
        Bundle osgiBundle = bundle.getOSGiBundle();
        if (osgiBundle == null) {
            throw new ClassNotFoundException("Failed to get OSGi bundle containing script: " + sourceFile.toString());
        }
        Class clazz = osgiBundle.loadClass(classname);
        return clazz;
    }

    @Override
    public void createNewScript(ResourceFile newScript, String category) throws IOException {
        String scriptName;
        String className = scriptName = newScript.getName();
        int dotpos = scriptName.lastIndexOf(46);
        if (dotpos >= 0) {
            className = scriptName.substring(0, dotpos);
        }
        PrintWriter writer = new PrintWriter(new FileWriter(newScript.getFile(false)));
        this.writeHeader(writer, category);
        writer.println("import ghidra.app.script.GhidraScript;");
        for (Package pkg : Package.getPackages()) {
            if (!pkg.getName().startsWith("ghidra.program.model.")) continue;
            writer.println("import " + pkg.getName() + ".*;");
        }
        writer.println("");
        writer.println("public class " + className + " extends GhidraScript {");
        writer.println("");
        writer.println("    public void run() throws Exception {");
        this.writeBody(writer);
        writer.println("    }");
        writer.println("");
        writer.println("}");
        writer.close();
    }

    @Override
    public Pattern getBlockCommentStart() {
        return BLOCK_COMMENT_START;
    }

    @Override
    public Pattern getBlockCommentEnd() {
        return BLOCK_COMMENT_END;
    }

    @Override
    public String getCommentCharacter() {
        return "//";
    }

    @Override
    protected String getCertifyHeaderStart() {
        return "/* ###";
    }

    @Override
    protected String getCertifyHeaderEnd() {
        return "*/";
    }

    @Override
    protected String getCertificationBodyPrefix() {
        return "*";
    }

    @Override
    protected String fixupName(String scriptName) {
        String path = (scriptName = scriptName.substring(0, scriptName.length() - 5)).replace('.', '/');
        int innerClassIndex = path.indexOf(36);
        if (innerClassIndex != -1) {
            path = path.substring(0, innerClassIndex);
        }
        return path + ".java";
    }
}

