/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.exceptionhandlers.gcc;

import ghidra.app.plugin.exceptionhandlers.gcc.DwarfDecodeContext;
import ghidra.app.plugin.exceptionhandlers.gcc.DwarfEHDataApplicationMode;
import ghidra.app.plugin.exceptionhandlers.gcc.DwarfEHDecoder;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.QWordDataType;
import ghidra.program.model.data.WordDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.util.AddressTranslationException;

abstract class AbstractDwarfEHDecoder
implements DwarfEHDecoder {
    protected static ByteDataType BYTE_DATA_TYPE = ByteDataType.dataType;
    protected static WordDataType WORD_DATA_TYPE = WordDataType.dataType;
    protected static DWordDataType DWORD_DATA_TYPE = DWordDataType.dataType;
    protected static QWordDataType QWORD_DATA_TYPE = QWordDataType.dataType;
    protected final DwarfEHDataApplicationMode appMode;
    protected final boolean isIndirect;

    public AbstractDwarfEHDecoder(DwarfEHDataApplicationMode mode, boolean isIndirect) {
        if (mode == null) {
            mode = DwarfEHDataApplicationMode.DW_EH_PE_absptr;
        }
        this.appMode = mode;
        this.isIndirect = isIndirect;
    }

    @Override
    public DwarfEHDataApplicationMode getDataApplicationMode() {
        return this.appMode;
    }

    public String toString() {
        String repr = this.getDataFormat() + " | " + this.getDataApplicationMode();
        if (this.isIndirect) {
            repr = repr + " | " + DwarfEHDataApplicationMode.DW_EH_PE_indirect;
        }
        return repr;
    }

    protected long ptrval(Program program, Address addr) throws MemoryAccessException {
        switch (addr.getPointerSize()) {
            case 2: {
                return AbstractDwarfEHDecoder.readWord(program, addr);
            }
            case 4: {
                return AbstractDwarfEHDecoder.readDWord(program, addr);
            }
            case 8: {
                long base = AbstractDwarfEHDecoder.readDWord(program, addr);
                return base;
            }
        }
        throw new AddressTranslationException("Don't know how to make a " + addr.getPointerSize() + "-byte pointer");
    }

    protected long ptrval(MemBuffer buf, int ptrSize) throws MemoryAccessException {
        switch (ptrSize) {
            case 2: {
                return AbstractDwarfEHDecoder.readWord(buf);
            }
            case 4: {
                return AbstractDwarfEHDecoder.readDWord(buf);
            }
            case 8: {
                return AbstractDwarfEHDecoder.readQWord(buf);
            }
        }
        throw new AddressTranslationException("Don't know how to make a " + ptrSize + "-byte pointer");
    }

    protected static long readByte(Program program, Address addr) throws MemoryAccessException {
        return program.getMemory().getByte(addr);
    }

    protected static long readByte(MemBuffer buf, int length) throws MemoryAccessException {
        return buf.getByte(0);
    }

    protected static long readWord(Program program, Address addr) throws MemoryAccessException {
        return program.getMemory().getShort(addr);
    }

    protected static long readWord(MemBuffer buf) throws MemoryAccessException {
        return buf.getShort(0);
    }

    protected static long readDWord(Program program, Address addr) throws MemoryAccessException {
        return program.getMemory().getInt(addr);
    }

    protected static long readDWord(MemBuffer buf) throws MemoryAccessException {
        return buf.getInt(0);
    }

    protected static long readQWord(Program program, Address addr) throws MemoryAccessException {
        return program.getMemory().getLong(addr);
    }

    protected static long readQWord(MemBuffer buf) throws MemoryAccessException {
        return buf.getLong(0);
    }

    protected static void readBytes(Program program, Address addr, byte[] buffer) throws MemoryAccessException {
        program.getMemory().getBytes(addr, buffer);
    }

    protected static int readBytes(MemBuffer buf, byte[] buffer) throws MemoryAccessException {
        return buf.getBytes(buffer, 0);
    }

    @Override
    public Address decodeAddress(DwarfDecodeContext context) throws MemoryAccessException {
        Program prog = context.getProgram();
        AddressFactory addrFactory = prog.getAddressFactory();
        AddressSpace ram = addrFactory.getDefaultAddressSpace();
        long offset = this.decode(context);
        return addrFactory.getAddress(ram.getSpaceID(), offset);
    }

    @Override
    public final long decode(DwarfDecodeContext context) throws MemoryAccessException {
        long val = this.doDecode(context);
        return this.resolveRelativeOffset(val, context);
    }

    private long resolveRelativeOffset(long val, DwarfDecodeContext context) throws MemoryAccessException {
        Program prog = context.getProgram();
        Address addr = context.getAddress();
        AddressSpace ram = prog.getAddressFactory().getDefaultAddressSpace();
        if ((val == 0L || val == addr.getOffset()) && this.isIndirect) {
            return val;
        }
        switch (this.appMode) {
            case DW_EH_PE_absptr: {
                break;
            }
            case DW_EH_PE_aligned: {
                break;
            }
            case DW_EH_PE_datarel: {
                val = context.getEhBlock().getStart().add(val).getOffset();
                break;
            }
            case DW_EH_PE_funcrel: {
                val = context.getFunctionEntryPoint().add(val).getOffset();
                break;
            }
            case DW_EH_PE_pcrel: {
                val = addr.add(val).getOffset();
                break;
            }
            case DW_EH_PE_texrel: {
                MemoryBlock txt = prog.getMemory().getBlock(".text");
                val = txt.getStart().add(val).getOffset();
                break;
            }
        }
        if (this.isIndirect) {
            Address toDeref = prog.getAddressFactory().getAddress(ram.getSpaceID(), val);
            val = this.ptrval(prog, toDeref);
        }
        return val;
    }

    public abstract long doDecode(DwarfDecodeContext var1) throws MemoryAccessException;
}

